/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ClassDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ConstructorDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.PropertyDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.TypeParameterDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.JetScope;
import kotlin.reflect.jvm.internal.impl.storage.LockBasedStorageManager;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.TypeCapability;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorSimpleFunctionDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.utils.Printer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorUtils {
    private static final ModuleDescriptor ERROR_MODULE = new ModuleDescriptorImpl(Name.special("<ERROR MODULE>"), LockBasedStorageManager.NO_LOCKS, ModuleParameters.Empty.INSTANCE$);
    private static final ErrorClassDescriptor ERROR_CLASS = new ErrorClassDescriptor(null);
    private static final JetType ERROR_PROPERTY_TYPE = ErrorUtils.createErrorType("<ERROR PROPERTY TYPE>");
    private static final VariableDescriptor ERROR_PROPERTY = ErrorUtils.createErrorProperty();
    private static final Set<VariableDescriptor> ERROR_PROPERTY_GROUP = Collections.singleton(ERROR_PROPERTY);

    public static boolean containsErrorType(@NotNull FunctionDescriptor function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "containsErrorType"));
        }
        if (ErrorUtils.containsErrorType(function.getReturnType())) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameter = function.getExtensionReceiverParameter();
        if (receiverParameter != null && ErrorUtils.containsErrorType(receiverParameter.getType())) {
            return true;
        }
        for (ValueParameterDescriptor valueParameterDescriptor : function.getValueParameters()) {
            if (!ErrorUtils.containsErrorType(valueParameterDescriptor.getType())) continue;
            return true;
        }
        for (TypeParameterDescriptor typeParameterDescriptor : function.getTypeParameters()) {
            for (JetType upperBound : typeParameterDescriptor.getUpperBounds()) {
                if (!ErrorUtils.containsErrorType(upperBound)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static ClassDescriptor createErrorClass(@NotNull String debugMessage) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorClass"));
        }
        ErrorClassDescriptor errorClassDescriptor = new ErrorClassDescriptor(debugMessage);
        if (errorClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorClass"));
        }
        return errorClassDescriptor;
    }

    @NotNull
    public static JetScope createErrorScope(@NotNull String debugMessage) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorScope"));
        }
        JetScope jetScope = ErrorUtils.createErrorScope(debugMessage, false);
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorScope"));
        }
        return jetScope;
    }

    @NotNull
    public static JetScope createErrorScope(@NotNull String debugMessage, boolean throwExceptions) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorScope"));
        }
        if (throwExceptions) {
            ThrowingScope throwingScope = new ThrowingScope(debugMessage);
            if (throwingScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorScope"));
            }
            return throwingScope;
        }
        ErrorScope errorScope = new ErrorScope(debugMessage);
        if (errorScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorScope"));
        }
        return errorScope;
    }

    @NotNull
    private static PropertyDescriptorImpl createErrorProperty() {
        PropertyDescriptorImpl descriptor2 = PropertyDescriptorImpl.create(ERROR_CLASS, Annotations.EMPTY, Modality.OPEN, Visibilities.INTERNAL, true, Name.special("<ERROR PROPERTY>"), CallableMemberDescriptor.Kind.DECLARATION, SourceElement.NO_SOURCE);
        descriptor2.setType(ERROR_PROPERTY_TYPE, Collections.emptyList(), ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, (JetType)null);
        PropertyDescriptorImpl propertyDescriptorImpl = descriptor2;
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorProperty"));
        }
        return propertyDescriptorImpl;
    }

    @NotNull
    private static SimpleFunctionDescriptor createErrorFunction(@NotNull ErrorScope ownerScope) {
        if (ownerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerScope", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorFunction"));
        }
        ErrorSimpleFunctionDescriptorImpl function = new ErrorSimpleFunctionDescriptorImpl(ERROR_CLASS, ownerScope);
        function.initialize((JetType)null, ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, Collections.emptyList(), Collections.emptyList(), ErrorUtils.createErrorType("<ERROR FUNCTION RETURN TYPE>"), Modality.OPEN, Visibilities.INTERNAL);
        ErrorSimpleFunctionDescriptorImpl errorSimpleFunctionDescriptorImpl = function;
        if (errorSimpleFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorFunction"));
        }
        return errorSimpleFunctionDescriptorImpl;
    }

    @NotNull
    public static JetType createErrorType(@NotNull String debugMessage) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorType"));
        }
        JetType jetType = ErrorUtils.createErrorTypeWithArguments(debugMessage, Collections.<TypeProjection>emptyList());
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorType"));
        }
        return jetType;
    }

    @NotNull
    public static JetType createErrorTypeWithCustomDebugName(@NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorTypeWithCustomDebugName"));
        }
        ErrorTypeImpl errorTypeImpl = new ErrorTypeImpl(ErrorUtils.createErrorTypeConstructorWithCustomDebugName(debugName), ErrorUtils.createErrorScope(debugName));
        if (errorTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorTypeWithCustomDebugName"));
        }
        return errorTypeImpl;
    }

    @NotNull
    public static JetType createErrorTypeWithArguments(@NotNull String debugMessage, @NotNull List<TypeProjection> arguments2) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorTypeWithArguments"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorTypeWithArguments"));
        }
        ErrorTypeImpl errorTypeImpl = new ErrorTypeImpl(ErrorUtils.createErrorTypeConstructor(debugMessage), ErrorUtils.createErrorScope(debugMessage), arguments2);
        if (errorTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorTypeWithArguments"));
        }
        return errorTypeImpl;
    }

    @NotNull
    public static TypeConstructor createErrorTypeConstructor(@NotNull String debugMessage) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorTypeConstructor"));
        }
        TypeConstructor typeConstructor2 = ErrorUtils.createErrorTypeConstructorWithCustomDebugName("[ERROR : " + debugMessage + "]");
        if (typeConstructor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorTypeConstructor"));
        }
        return typeConstructor2;
    }

    @NotNull
    private static TypeConstructor createErrorTypeConstructorWithCustomDebugName(@NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorTypeConstructorWithCustomDebugName"));
        }
        TypeConstructorImpl typeConstructorImpl = TypeConstructorImpl.createForClass(ERROR_CLASS, Annotations.EMPTY, false, debugName, Collections.emptyList(), Collections.singleton(KotlinBuiltIns.getInstance().getAnyType()));
        if (typeConstructorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorTypeConstructorWithCustomDebugName"));
        }
        return typeConstructorImpl;
    }

    public static boolean containsErrorType(@Nullable JetType type2) {
        if (type2 == null) {
            return false;
        }
        if (type2.isError()) {
            return true;
        }
        for (TypeProjection projection : type2.getArguments()) {
            if (projection.isStarProjection() || !ErrorUtils.containsErrorType(projection.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isError(@NotNull DeclarationDescriptor candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "isError"));
        }
        return ErrorUtils.isErrorClass(candidate) || ErrorUtils.isErrorClass(candidate.getContainingDeclaration()) || candidate == ERROR_MODULE;
    }

    private static boolean isErrorClass(@Nullable DeclarationDescriptor candidate) {
        return candidate instanceof ErrorClassDescriptor;
    }

    @NotNull
    public static TypeParameterDescriptor createErrorTypeParameter(int index2, @NotNull String debugMessage) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorTypeParameter"));
        }
        TypeParameterDescriptor typeParameterDescriptor = TypeParameterDescriptorImpl.createWithDefaultBound(ERROR_CLASS, Annotations.EMPTY, false, Variance.INVARIANT, Name.special("<ERROR: " + debugMessage + ">"), index2);
        if (typeParameterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createErrorTypeParameter"));
        }
        return typeParameterDescriptor;
    }

    @NotNull
    public static ModuleDescriptor getErrorModule() {
        ModuleDescriptor moduleDescriptor = ERROR_MODULE;
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "getErrorModule"));
        }
        return moduleDescriptor;
    }

    public static boolean isUninferredParameter(@Nullable JetType type2) {
        return type2 != null && type2.getConstructor() instanceof UninferredParameterTypeConstructor;
    }

    public static boolean containsUninferredParameter(@Nullable JetType type2) {
        return TypeUtils.containsSpecialType(type2, new Function1<JetType, Boolean>(){

            @Override
            public Boolean invoke(JetType argumentType) {
                return ErrorUtils.isUninferredParameter(argumentType);
            }
        });
    }

    @NotNull
    public static JetType createUninferredParameterType(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createUninferredParameterType"));
        }
        ErrorTypeImpl errorTypeImpl = new ErrorTypeImpl((TypeConstructor)new UninferredParameterTypeConstructor(typeParameterDescriptor), ErrorUtils.createErrorScope("Scope for error type for not inferred parameter: " + typeParameterDescriptor.getName()));
        if (errorTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createUninferredParameterType"));
        }
        return errorTypeImpl;
    }

    public static boolean isFunctionPlaceholder(@Nullable JetType type2) {
        return type2 != null && type2.getConstructor() instanceof FunctionPlaceholderTypeConstructor;
    }

    @NotNull
    public static JetType createFunctionPlaceholderType(@NotNull List<JetType> argumentTypes, boolean hasDeclaredArguments) {
        if (argumentTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypes", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createFunctionPlaceholderType"));
        }
        ErrorTypeImpl errorTypeImpl = new ErrorTypeImpl((TypeConstructor)new FunctionPlaceholderTypeConstructor(argumentTypes, hasDeclaredArguments), ErrorUtils.createErrorScope("Scope for function placeholder type"));
        if (errorTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils", "createFunctionPlaceholderType"));
        }
        return errorTypeImpl;
    }

    private ErrorUtils() {
    }

    public static class FunctionPlaceholderTypeConstructor
    implements TypeConstructor {
        private final TypeConstructor errorTypeConstructor;
        private final List<JetType> argumentTypes;
        private final boolean hasDeclaredArguments;

        private FunctionPlaceholderTypeConstructor(@NotNull List<JetType> argumentTypes, boolean hasDeclaredArguments) {
            if (argumentTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypes", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$FunctionPlaceholderTypeConstructor", "<init>"));
            }
            this.errorTypeConstructor = ErrorUtils.createErrorTypeConstructorWithCustomDebugName("PLACEHOLDER_FUNCTION_TYPE" + argumentTypes);
            this.argumentTypes = argumentTypes;
            this.hasDeclaredArguments = hasDeclaredArguments;
        }

        @NotNull
        public List<JetType> getArgumentTypes() {
            List<JetType> list = this.argumentTypes;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$FunctionPlaceholderTypeConstructor", "getArgumentTypes"));
            }
            return list;
        }

        public boolean hasDeclaredArguments() {
            return this.hasDeclaredArguments;
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            List<TypeParameterDescriptor> list = this.errorTypeConstructor.getParameters();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$FunctionPlaceholderTypeConstructor", "getParameters"));
            }
            return list;
        }

        @Override
        @NotNull
        public Collection<JetType> getSupertypes() {
            Collection<JetType> collection = this.errorTypeConstructor.getSupertypes();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$FunctionPlaceholderTypeConstructor", "getSupertypes"));
            }
            return collection;
        }

        @Override
        public boolean isFinal() {
            return this.errorTypeConstructor.isFinal();
        }

        @Override
        public boolean isDenotable() {
            return this.errorTypeConstructor.isDenotable();
        }

        @Override
        @Nullable
        public ClassifierDescriptor getDeclarationDescriptor() {
            return this.errorTypeConstructor.getDeclarationDescriptor();
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            Annotations annotations2 = this.errorTypeConstructor.getAnnotations();
            if (annotations2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$FunctionPlaceholderTypeConstructor", "getAnnotations"));
            }
            return annotations2;
        }

        public String toString() {
            return this.errorTypeConstructor.toString();
        }
    }

    public static class UninferredParameterTypeConstructor
    implements TypeConstructor {
        private final TypeParameterDescriptor typeParameterDescriptor;
        private final TypeConstructor errorTypeConstructor;

        private UninferredParameterTypeConstructor(@NotNull TypeParameterDescriptor descriptor2) {
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$UninferredParameterTypeConstructor", "<init>"));
            }
            this.typeParameterDescriptor = descriptor2;
            this.errorTypeConstructor = ErrorUtils.createErrorTypeConstructorWithCustomDebugName("CANT_INFER_TYPE_PARAMETER: " + descriptor2.getName());
        }

        @NotNull
        public TypeParameterDescriptor getTypeParameterDescriptor() {
            TypeParameterDescriptor typeParameterDescriptor = this.typeParameterDescriptor;
            if (typeParameterDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$UninferredParameterTypeConstructor", "getTypeParameterDescriptor"));
            }
            return typeParameterDescriptor;
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            List<TypeParameterDescriptor> list = this.errorTypeConstructor.getParameters();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$UninferredParameterTypeConstructor", "getParameters"));
            }
            return list;
        }

        @Override
        @NotNull
        public Collection<JetType> getSupertypes() {
            Collection<JetType> collection = this.errorTypeConstructor.getSupertypes();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$UninferredParameterTypeConstructor", "getSupertypes"));
            }
            return collection;
        }

        @Override
        public boolean isFinal() {
            return this.errorTypeConstructor.isFinal();
        }

        @Override
        public boolean isDenotable() {
            return this.errorTypeConstructor.isDenotable();
        }

        @Override
        @Nullable
        public ClassifierDescriptor getDeclarationDescriptor() {
            return this.errorTypeConstructor.getDeclarationDescriptor();
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            Annotations annotations2 = this.errorTypeConstructor.getAnnotations();
            if (annotations2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$UninferredParameterTypeConstructor", "getAnnotations"));
            }
            return annotations2;
        }
    }

    private static class ErrorTypeImpl
    implements JetType {
        private final TypeConstructor constructor;
        private final JetScope memberScope;
        private final List<TypeProjection> arguments;

        private ErrorTypeImpl(@NotNull TypeConstructor constructor2, @NotNull JetScope memberScope2, @NotNull List<TypeProjection> arguments2) {
            if (constructor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorTypeImpl", "<init>"));
            }
            if (memberScope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberScope", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorTypeImpl", "<init>"));
            }
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorTypeImpl", "<init>"));
            }
            this.constructor = constructor2;
            this.memberScope = memberScope2;
            this.arguments = arguments2;
        }

        private ErrorTypeImpl(@NotNull TypeConstructor constructor2, @NotNull JetScope memberScope2) {
            if (constructor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorTypeImpl", "<init>"));
            }
            if (memberScope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberScope", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorTypeImpl", "<init>"));
            }
            this(constructor2, memberScope2, Collections.emptyList());
        }

        @Override
        @NotNull
        public TypeConstructor getConstructor() {
            TypeConstructor typeConstructor2 = this.constructor;
            if (typeConstructor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorTypeImpl", "getConstructor"));
            }
            return typeConstructor2;
        }

        @Override
        @NotNull
        public List<TypeProjection> getArguments() {
            List<TypeProjection> list = this.arguments;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorTypeImpl", "getArguments"));
            }
            return list;
        }

        @Override
        public boolean isMarkedNullable() {
            return false;
        }

        @Override
        @NotNull
        public JetScope getMemberScope() {
            JetScope jetScope = this.memberScope;
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorTypeImpl", "getMemberScope"));
            }
            return jetScope;
        }

        @Override
        public boolean isError() {
            return true;
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            Annotations annotations2 = Annotations.EMPTY;
            if (annotations2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorTypeImpl", "getAnnotations"));
            }
            return annotations2;
        }

        @Override
        @Nullable
        public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
            if (capabilityClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capabilityClass", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorTypeImpl", "getCapability"));
            }
            return null;
        }

        public String toString() {
            return this.constructor.toString() + (this.arguments.isEmpty() ? "" : KotlinPackage.joinToString(this.arguments, ", ", "<", ">", -1, "...", null));
        }
    }

    private static class ErrorClassDescriptor
    extends ClassDescriptorImpl {
        public ErrorClassDescriptor(@Nullable String name) {
            super(ErrorUtils.getErrorModule(), Name.special(name == null ? "<ERROR CLASS>" : "<ERROR CLASS: " + name + ">"), Modality.OPEN, Collections.<JetType>emptyList(), SourceElement.NO_SOURCE);
            ConstructorDescriptorImpl errorConstructor = ConstructorDescriptorImpl.create(this, Annotations.EMPTY, true, SourceElement.NO_SOURCE);
            errorConstructor.initialize(Collections.<TypeParameterDescriptor>emptyList(), Collections.<ValueParameterDescriptor>emptyList(), Visibilities.INTERNAL);
            JetScope memberScope2 = ErrorUtils.createErrorScope(this.getName().asString());
            errorConstructor.setReturnType(new ErrorTypeImpl((TypeConstructor)TypeConstructorImpl.createForClass(this, Annotations.EMPTY, false, this.getName().asString(), Collections.emptyList(), Collections.singleton(KotlinBuiltIns.getInstance().getAnyType())), memberScope2));
            this.initialize(memberScope2, Collections.singleton(errorConstructor), errorConstructor);
        }

        @Override
        @NotNull
        public ClassDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
            if (substitutor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorClassDescriptor", "substitute"));
            }
            ErrorClassDescriptor errorClassDescriptor = this;
            if (errorClassDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorClassDescriptor", "substitute"));
            }
            return errorClassDescriptor;
        }

        @Override
        public String toString() {
            return this.getName().asString();
        }

        @Override
        @NotNull
        public JetScope getMemberScope(@NotNull List<? extends TypeProjection> typeArguments) {
            if (typeArguments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorClassDescriptor", "getMemberScope"));
            }
            JetScope jetScope = ErrorUtils.createErrorScope("Error scope for class " + this.getName() + " with arguments: " + typeArguments);
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorClassDescriptor", "getMemberScope"));
            }
            return jetScope;
        }
    }

    private static class ThrowingScope
    implements JetScope {
        private final String debugMessage;

        private ThrowingScope(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ThrowingScope", "<init>"));
            }
            this.debugMessage = message;
        }

        @Override
        @Nullable
        public ClassifierDescriptor getClassifier(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ThrowingScope", "getClassifier"));
            }
            throw new IllegalStateException();
        }

        @Override
        @Nullable
        public PackageViewDescriptor getPackage(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ThrowingScope", "getPackage"));
            }
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getProperties(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ThrowingScope", "getProperties"));
            }
            throw new IllegalStateException();
        }

        @Override
        @Nullable
        public VariableDescriptor getLocalVariable(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ThrowingScope", "getLocalVariable"));
            }
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ThrowingScope", "getFunctions"));
            }
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public DeclarationDescriptor getContainingDeclaration() {
            ModuleDescriptor moduleDescriptor = ERROR_MODULE;
            if (moduleDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ThrowingScope", "getContainingDeclaration"));
            }
            return moduleDescriptor;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull Name labelName) {
            if (labelName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ThrowingScope", "getDeclarationsByLabel"));
            }
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, ? extends Boolean> nameFilter) {
            if (kindFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kindFilter", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ThrowingScope", "getDescriptors"));
            }
            if (nameFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameFilter", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ThrowingScope", "getDescriptors"));
            }
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getAllDescriptors() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
            throw new IllegalStateException();
        }

        public String toString() {
            return "ThrowingScope{" + this.debugMessage + '}';
        }

        @Override
        public void printScopeStructure(@NotNull Printer p) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ThrowingScope", "printScopeStructure"));
            }
            p.println(this.getClass().getSimpleName(), ": ", this.debugMessage);
        }
    }

    public static class ErrorScope
    implements JetScope {
        private final String debugMessage;

        private ErrorScope(@NotNull String debugMessage) {
            if (debugMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorScope", "<init>"));
            }
            this.debugMessage = debugMessage;
        }

        @Override
        public ClassifierDescriptor getClassifier(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorScope", "getClassifier"));
            }
            return ErrorUtils.createErrorClass(name.asString());
        }

        @NotNull
        public Set<VariableDescriptor> getProperties(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorScope", "getProperties"));
            }
            Set set = ERROR_PROPERTY_GROUP;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorScope", "getProperties"));
            }
            return set;
        }

        @Override
        public VariableDescriptor getLocalVariable(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorScope", "getLocalVariable"));
            }
            return ERROR_PROPERTY;
        }

        @Override
        public PackageViewDescriptor getPackage(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorScope", "getPackage"));
            }
            return null;
        }

        @Override
        @NotNull
        public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
            List<ReceiverParameterDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorScope", "getImplicitReceiversHierarchy"));
            }
            return list;
        }

        @NotNull
        public Set<FunctionDescriptor> getFunctions(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorScope", "getFunctions"));
            }
            Set<FunctionDescriptor> set = Collections.singleton(ErrorUtils.createErrorFunction(this));
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorScope", "getFunctions"));
            }
            return set;
        }

        @Override
        @NotNull
        public DeclarationDescriptor getContainingDeclaration() {
            ModuleDescriptor moduleDescriptor = ERROR_MODULE;
            if (moduleDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorScope", "getContainingDeclaration"));
            }
            return moduleDescriptor;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull Name labelName) {
            if (labelName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorScope", "getDeclarationsByLabel"));
            }
            List<DeclarationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorScope", "getDeclarationsByLabel"));
            }
            return list;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, ? extends Boolean> nameFilter) {
            if (kindFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kindFilter", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorScope", "getDescriptors"));
            }
            if (nameFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameFilter", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorScope", "getDescriptors"));
            }
            List<DeclarationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorScope", "getDescriptors"));
            }
            return list;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getAllDescriptors() {
            List<DeclarationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorScope", "getAllDescriptors"));
            }
            return list;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
            List<DeclarationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorScope", "getOwnDeclaredDescriptors"));
            }
            return list;
        }

        public String toString() {
            return "ErrorScope{" + this.debugMessage + '}';
        }

        @Override
        public void printScopeStructure(@NotNull Printer p) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "kotlin/reflect/jvm/internal/impl/types/ErrorUtils$ErrorScope", "printScopeStructure"));
            }
            p.println(this.getClass().getSimpleName(), ": ", this.debugMessage);
        }
    }
}

