/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.test;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;

public abstract class JSTester {
    @Nullable
    private JsBlock block = null;
    @Nullable
    private TranslationContext context = null;

    public abstract void constructTestMethodInvocation(@NotNull JsExpression var1, @NotNull JsStringLiteral var2);

    @NotNull
    protected JsBlock getBlock() {
        assert (this.block != null) : "Call initialize before using tester.";
        JsBlock jsBlock = this.block;
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/test/JSTester", "getBlock"));
        }
        return jsBlock;
    }

    @NotNull
    protected TranslationContext getContext() {
        assert (this.context != null) : "Call initialize before using tester.";
        TranslationContext translationContext = this.context;
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/test/JSTester", "getContext"));
        }
        return translationContext;
    }

    public void initialize(@NotNull TranslationContext context2, @NotNull JsBlock block) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/test/JSTester", "initialize"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/js/translate/test/JSTester", "initialize"));
        }
        this.block = block;
        this.context = context2;
    }

    public void deinitialize() {
        this.block = null;
        this.context = null;
    }
}

