/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.bindingContextUtil;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilPackage$BindingContextUtils$4caaea7c;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryPackage$TypeInfoFactory$6d8522e8;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class BindingContextUtilPackage$BindingContextUtils$4caaea7c {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FunctionDescriptor getTargetFunctionDescriptor(@JetValueParameter(name="$receiver") JetReturnExpression $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        void $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        JetSimpleNameExpression targetLabel = $receiver.getTargetLabel();
        if (targetLabel != null) {
            SimpleFunctionDescriptor simpleFunctionDescriptor;
            PsiElement psiElement = (PsiElement)context2.get(BindingContext.LABEL_TARGET, targetLabel);
            if (psiElement != null) {
                PsiElement $receiver3 = psiElement;
                PsiElement it2 = $receiver3;
                simpleFunctionDescriptor = (SimpleFunctionDescriptor)context2.get(BindingContext.FUNCTION, it2);
            } else {
                simpleFunctionDescriptor = null;
            }
            return simpleFunctionDescriptor;
        }
        PsiElement it2 = $receiver;
        ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
        BindingContext bindingContext = context2;
        JetDeclarationWithBody jetDeclarationWithBody = PsiTreeUtil.getParentOfType((PsiElement)$receiver2, JetDeclarationWithBody.class, false);
        DeclarationDescriptor declarationDescriptor = bindingContext.get(readOnlySlice, jetDeclarationWithBody);
        FunctionDescriptor containingFunctionDescriptor = DescriptorUtils.getParentOfType(declarationDescriptor, FunctionDescriptor.class, false);
        if (containingFunctionDescriptor == null) {
            return null;
        }
        return KotlinPackage.firstOrNull(KotlinPackage.dropWhile(KotlinPackage.sequence(containingFunctionDescriptor, (Function1)getTargetFunctionDescriptor.2.INSTANCE$), (Function1)getTargetFunctionDescriptor.3.INSTANCE$));
    }

    @Nullable
    public static final JetCallableDeclaration getTargetFunction(@JetValueParameter(name="$receiver") JetReturnExpression $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        JetCallableDeclaration jetCallableDeclaration;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        FunctionDescriptor functionDescriptor = BindingContextUtilPackage$BindingContextUtils$4caaea7c.getTargetFunctionDescriptor($receiver, context2);
        if (functionDescriptor != null) {
            FunctionDescriptor $receiver2 = functionDescriptor;
            FunctionDescriptor it2 = $receiver2;
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(it2);
            if (!(psiElement instanceof JetCallableDeclaration)) {
                psiElement = null;
            }
            jetCallableDeclaration = (JetCallableDeclaration)psiElement;
        } else {
            jetCallableDeclaration = null;
        }
        return jetCallableDeclaration;
    }

    public static final boolean isUsedAsExpression(@JetValueParameter(name="$receiver") JetExpression $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Object v = context2.get(BindingContext.USED_AS_EXPRESSION, $receiver);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    public static final boolean isUsedAsStatement(@JetValueParameter(name="$receiver") JetExpression $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        return !BindingContextUtilPackage$BindingContextUtils$4caaea7c.isUsedAsExpression($receiver, context2);
    }

    public static final <C extends ResolutionContext<C>> void recordScopeAndDataFlowInfo(@JetValueParameter(name="$receiver") ResolutionContext<C> $receiver, @JetValueParameter(name="expression", type="?") @Nullable JetExpression expression) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (expression == null) {
            return;
        }
        $receiver.trace.record(BindingContext.RESOLUTION_SCOPE, expression, $receiver.scope);
        JetTypeInfo typeInfo = (JetTypeInfo)$receiver.trace.get(BindingContext.EXPRESSION_TYPE_INFO, expression);
        if (typeInfo != null) {
            BindingTrace bindingTrace = $receiver.trace;
            DataFlowInfo dataFlowInfo = $receiver.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression, typeInfo.replaceDataFlowInfo(dataFlowInfo));
        } else if (Intrinsics.areEqual($receiver.dataFlowInfo, DataFlowInfo.EMPTY) ^ true) {
            BindingTrace bindingTrace = $receiver.trace;
            DataFlowInfo dataFlowInfo = $receiver.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression, TypeInfoFactoryPackage$TypeInfoFactory$6d8522e8.noTypeInfo(dataFlowInfo));
        }
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfo(@JetValueParameter(name="$receiver") BindingContext $receiver, @JetValueParameter(name="expression", type="?") @Nullable JetExpression expression) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                object = expression;
                if (object == null) break block2;
                JetExpression $receiver2 = object;
                JetExpression it2 = $receiver2;
                JetTypeInfo jetTypeInfo = (JetTypeInfo)$receiver.get(BindingContext.EXPRESSION_TYPE_INFO, it2);
                object = jetTypeInfo != null ? jetTypeInfo.getDataFlowInfo() : null;
                if (object != null) break block3;
            }
            object = DataFlowInfo.EMPTY;
        }
        return object;
    }

    public static final boolean isUnreachableCode(@JetValueParameter(name="$receiver") JetExpression $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Object v = context2.get(BindingContext.UNREACHABLE_CODE, $receiver);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Collection<DeclarationDescriptor> getReferenceTargets(@JetValueParameter(name="$receiver") JetExpression $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        DeclarationDescriptor targetDescriptor = $receiver instanceof JetReferenceExpression ? (DeclarationDescriptor)context2.get(BindingContext.REFERENCE_TARGET, $receiver) : (DeclarationDescriptor)null;
        List<DeclarationDescriptor> list = targetDescriptor;
        if (list != null) {
            DeclarationDescriptor $receiver2 = list;
            DeclarationDescriptor it2 = $receiver2;
            list = KotlinPackage.listOf(it2);
            if (list != null) {
                collection = list;
                return collection;
            }
        }
        collection = KotlinPackage.orEmpty((Collection)context2.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, $receiver));
        return collection;
    }
}

