/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLock;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StubBase<T extends PsiElement>
extends ObjectStubBase<StubElement>
implements StubElement<T> {
    private SmartList<StubElement> myChildren = null;
    private final IStubElementType myElementType;
    private volatile T myPsi;

    protected StubBase(StubElement parent, IStubElementType elementType) {
        super(parent);
        this.myElementType = elementType;
        if (parent != null) {
            if (((StubBase)parent).myChildren == null) {
                ((StubBase)parent).myChildren = new SmartList();
            }
            ((StubBase)parent).myChildren.add(this);
        }
    }

    @Override
    public StubElement getParentStub() {
        return (StubElement)this.myParent;
    }

    @Override
    public List<StubElement> getChildrenStubs() {
        if (this.myChildren == null) {
            return Collections.emptyList();
        }
        return this.myChildren;
    }

    @Override
    @Nullable
    public <P extends PsiElement> StubElement<P> findChildStubByType(IStubElementType<?, P> elementType) {
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int size = childrenStubs.size();
        for (int i = 0; i < size; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (childStub.getStubType() != elementType) continue;
            return childStub;
        }
        return null;
    }

    public void setPsi(@NotNull T psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/psi/stubs/StubBase", "setPsi"));
        }
        this.myPsi = psi;
    }

    public T getCachedPsi() {
        return this.myPsi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getPsi() {
        Object psi = this.myPsi;
        if (psi != null) {
            return psi;
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            psi = this.myPsi;
            if (psi != null) {
                return psi;
            }
            this.myPsi = psi = this.getStubType().createPsi(this);
        }
        return psi;
    }

    @Override
    public <E extends PsiElement> E[] getChildrenByType(IElementType elementType, E[] array) {
        int count = this.countChildren(elementType);
        array = (PsiElement[])ArrayUtil.ensureExactSize(count, array);
        if (count == 0) {
            return array;
        }
        this.fillFilteredChildren(elementType, (PsiElement[])array);
        return array;
    }

    @Override
    public <E extends PsiElement> E[] getChildrenByType(TokenSet filter, E[] array) {
        int count = this.countChildren(filter);
        array = (PsiElement[])ArrayUtil.ensureExactSize(count, array);
        if (count == 0) {
            return array;
        }
        this.fillFilteredChildren(filter, (PsiElement[])array);
        return array;
    }

    @Override
    public <E extends PsiElement> E[] getChildrenByType(IElementType elementType, ArrayFactory<E> f) {
        int count = this.countChildren(elementType);
        PsiElement[] result2 = (PsiElement[])f.create(count);
        if (count > 0) {
            this.fillFilteredChildren(elementType, result2);
        }
        return result2;
    }

    private int countChildren(IElementType elementType) {
        int count = 0;
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (childStub.getStubType() != elementType) continue;
            ++count;
        }
        return count;
    }

    private int countChildren(TokenSet types) {
        int count = 0;
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (!types.contains(childStub.getStubType())) continue;
            ++count;
        }
        return count;
    }

    private <E extends PsiElement> void fillFilteredChildren(IElementType type2, E[] result2) {
        int count = 0;
        for (StubElement childStub : this.getChildrenStubs()) {
            if (childStub.getStubType() != type2) continue;
            result2[count++] = childStub.getPsi();
        }
        assert (count == result2.length);
    }

    private <E extends PsiElement> void fillFilteredChildren(TokenSet set, E[] result2) {
        int count = 0;
        for (StubElement childStub : this.getChildrenStubs()) {
            if (!set.contains(childStub.getStubType())) continue;
            result2[count++] = childStub.getPsi();
        }
        assert (count == result2.length);
    }

    @Override
    public <E extends PsiElement> E[] getChildrenByType(TokenSet filter, ArrayFactory<E> f) {
        int count = this.countChildren(filter);
        PsiElement[] array = (PsiElement[])f.create(count);
        if (count == 0) {
            return array;
        }
        this.fillFilteredChildren(filter, array);
        return array;
    }

    @Override
    @Nullable
    public <E extends PsiElement> E getParentStubOfType(Class<E> parentClass) {
        for (StubElement parent = (StubElement)this.myParent; parent != null; parent = parent.getParentStub()) {
            Object psi = parent.getPsi();
            if (!parentClass.isInstance(psi)) continue;
            return (E)psi;
        }
        return null;
    }

    @Override
    public IStubElementType getStubType() {
        return this.myElementType;
    }

    public Project getProject() {
        return this.getPsi().getProject();
    }

    public String printTree() {
        StringBuilder builder = new StringBuilder();
        this.printTree(builder, 0);
        return builder.toString();
    }

    private void printTree(StringBuilder builder, int nestingLevel) {
        for (int i = 0; i < nestingLevel; ++i) {
            builder.append("  ");
        }
        builder.append(this.toString()).append('\n');
        for (StubElement child : this.getChildrenStubs()) {
            ((StubBase)child).printTree(builder, nestingLevel + 1);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

