/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinLightClassForExplicitDeclaration;
import org.jetbrains.kotlin.asJava.KotlinLightClassForPackage;
import org.jetbrains.kotlin.asJava.LightClassConstructionContext;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.CodeAnalyzerInitializer;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.kotlin.resolve.lazy.ResolveSessionUtils;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;
import org.jetbrains.kotlin.utils.UtilsPackage;

public class CliLightClassGenerationSupport
extends LightClassGenerationSupport
implements CodeAnalyzerInitializer {
    private final PsiManager psiManager;
    private BindingContext bindingContext;
    private ModuleDescriptor module;

    public CliLightClassGenerationSupport(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "<init>"));
        }
        this.bindingContext = null;
        this.module = null;
        this.psiManager = PsiManager.getInstance(project);
    }

    @Override
    public void initialize(@NotNull BindingTrace trace, @NotNull ModuleDescriptor module, @Nullable KotlinCodeAnalyzer analyzer) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "initialize"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "initialize"));
        }
        this.bindingContext = trace.getBindingContext();
        this.module = module;
        if (!(trace instanceof CliBindingTrace)) {
            throw new IllegalArgumentException("Shared trace is expected to be subclass of " + CliBindingTrace.class.getSimpleName() + " class");
        }
        ((CliBindingTrace)trace).setKotlinCodeAnalyzer(analyzer);
    }

    @NotNull
    private BindingContext getBindingContext() {
        assert (this.bindingContext != null) : "Call initialize() first";
        BindingContext bindingContext = this.bindingContext;
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "getBindingContext"));
        }
        return bindingContext;
    }

    @NotNull
    private ModuleDescriptor getModule() {
        assert (this.module != null) : "Call initialize() first";
        ModuleDescriptor moduleDescriptor = this.module;
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "getModule"));
        }
        return moduleDescriptor;
    }

    @Override
    @NotNull
    public LightClassConstructionContext getContextForPackage(@NotNull Collection<JetFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "getContextForPackage"));
        }
        LightClassConstructionContext lightClassConstructionContext = this.getContext();
        if (lightClassConstructionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "getContextForPackage"));
        }
        return lightClassConstructionContext;
    }

    @Override
    @NotNull
    public LightClassConstructionContext getContextForClassOrObject(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "getContextForClassOrObject"));
        }
        LightClassConstructionContext lightClassConstructionContext = this.getContext();
        if (lightClassConstructionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "getContextForClassOrObject"));
        }
        return lightClassConstructionContext;
    }

    @NotNull
    private LightClassConstructionContext getContext() {
        LightClassConstructionContext lightClassConstructionContext = new LightClassConstructionContext(this.bindingContext, this.getModule());
        if (lightClassConstructionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "getContext"));
        }
        return lightClassConstructionContext;
    }

    @Override
    @NotNull
    public Collection<JetClassOrObject> findClassOrObjectDeclarations(@NotNull FqName fqName2, final @NotNull GlobalSearchScope searchScope) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "findClassOrObjectDeclarations"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "findClassOrObjectDeclarations"));
        }
        Collection<ClassDescriptor> classDescriptors2 = ResolveSessionUtils.getClassDescriptorsByFqName(this.getModule(), fqName2);
        List<JetClassOrObject> list = ContainerUtil.mapNotNull(classDescriptors2, new Function<ClassDescriptor, JetClassOrObject>(){

            @Override
            public JetClassOrObject fun(ClassDescriptor descriptor) {
                PsiElement element = DescriptorToSourceUtils.getSourceFromDescriptor(descriptor);
                if (element instanceof JetClassOrObject && PsiSearchScopeUtil.isInScope(searchScope, element)) {
                    return (JetClassOrObject)element;
                }
                return null;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "findClassOrObjectDeclarations"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<JetFile> findFilesForPackage(@NotNull FqName fqName2, final @NotNull GlobalSearchScope searchScope) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "findFilesForPackage"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "findFilesForPackage"));
        }
        Collection<JetFile> files = this.getBindingContext().get(BindingContext.PACKAGE_TO_FILES, fqName2);
        if (files != null) {
            Collection<JetFile> collection = Collections2.filter(files, new Predicate<JetFile>(){

                @Override
                public boolean apply(JetFile input) {
                    return PsiSearchScopeUtil.isInScope(searchScope, (PsiElement)input);
                }
            });
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "findFilesForPackage"));
            }
            return collection;
        }
        List<JetFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "findFilesForPackage"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<JetClassOrObject> findClassOrObjectDeclarationsInPackage(@NotNull FqName packageFqName, @NotNull GlobalSearchScope searchScope) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "findClassOrObjectDeclarationsInPackage"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "findClassOrObjectDeclarationsInPackage"));
        }
        Collection<JetFile> files = this.findFilesForPackage(packageFqName, searchScope);
        SmartList<JetClassOrObject> result2 = new SmartList<JetClassOrObject>();
        for (JetFile file : files) {
            for (JetDeclaration declaration : file.getDeclarations()) {
                if (!(declaration instanceof JetClassOrObject)) continue;
                result2.add((JetClassOrObject)declaration);
            }
        }
        SmartList<JetClassOrObject> smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "findClassOrObjectDeclarationsInPackage"));
        }
        return smartList;
    }

    @Override
    public boolean packageExists(@NotNull FqName fqName2, @NotNull GlobalSearchScope scope2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "packageExists"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "packageExists"));
        }
        return this.getModule().getPackage(fqName2) != null;
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackages(@NotNull FqName fqn, @NotNull GlobalSearchScope scope2) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "getSubPackages"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "getSubPackages"));
        }
        PackageViewDescriptor packageView = this.getModule().getPackage(fqn);
        if (packageView == null) {
            List<FqName> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "getSubPackages"));
            }
            return list;
        }
        Collection<DeclarationDescriptor> members = packageView.getMemberScope().getDescriptors(DescriptorKindFilter.PACKAGES, JetScope.ALL_NAME_FILTER);
        List<FqName> list = ContainerUtil.mapNotNull(members, new Function<DeclarationDescriptor, FqName>(){

            @Override
            public FqName fun(DeclarationDescriptor member) {
                if (member instanceof PackageViewDescriptor) {
                    return ((PackageViewDescriptor)member).getFqName();
                }
                return null;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "getSubPackages"));
        }
        return list;
    }

    @Override
    @Nullable
    public PsiClass getPsiClass(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "getPsiClass"));
        }
        return KotlinLightClassForExplicitDeclaration.create(this.psiManager, classOrObject);
    }

    @Override
    @NotNull
    public Collection<PsiClass> getPackageClasses(@NotNull FqName packageFqName, @NotNull GlobalSearchScope scope2) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "getPackageClasses"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "getPackageClasses"));
        }
        Collection<JetFile> filesInPackage = this.findFilesForPackage(packageFqName, scope2);
        List<JetFile> filesWithCallables = PackagePartClassUtils.getPackageFilesWithCallables(filesInPackage);
        if (filesWithCallables.isEmpty()) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "getPackageClasses"));
            }
            return list;
        }
        List<PsiClass> list = UtilsPackage.emptyOrSingletonList(KotlinLightClassForPackage.Factory.create(this.psiManager, packageFqName, scope2, filesWithCallables));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "getPackageClasses"));
        }
        return list;
    }

    @Override
    @NotNull
    public BindingTraceContext createTrace() {
        NoScopeRecordCliBindingTrace noScopeRecordCliBindingTrace = new NoScopeRecordCliBindingTrace();
        if (noScopeRecordCliBindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CliLightClassGenerationSupport", "createTrace"));
        }
        return noScopeRecordCliBindingTrace;
    }

    public static class CliBindingTrace
    extends BindingTraceContext {
        private KotlinCodeAnalyzer kotlinCodeAnalyzer;

        public String toString() {
            return CliBindingTrace.class.getName();
        }

        public void setKotlinCodeAnalyzer(KotlinCodeAnalyzer kotlinCodeAnalyzer) {
            this.kotlinCodeAnalyzer = kotlinCodeAnalyzer;
        }

        @Override
        public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
            V value = super.get(slice, key);
            if (value == null) {
                JetDeclaration jetDeclaration;
                if ((BindingContext.FUNCTION == slice || BindingContext.VARIABLE == slice) && key instanceof JetDeclaration && !JetPsiUtil.isLocal(jetDeclaration = (JetDeclaration)key)) {
                    this.kotlinCodeAnalyzer.resolveToDescriptor(jetDeclaration);
                }
                return super.get(slice, key);
            }
            return value;
        }
    }

    public static class NoScopeRecordCliBindingTrace
    extends CliBindingTrace {
        @Override
        public <K, V> void record(WritableSlice<K, V> slice, K key, V value) {
            if (slice == BindingContext.RESOLUTION_SCOPE || slice == BindingContext.TYPE_RESOLUTION_SCOPE) {
                return;
            }
            super.record(slice, key, value);
        }

        @Override
        public String toString() {
            return NoScopeRecordCliBindingTrace.class.getName();
        }
    }
}

