/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetTypeProjection;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.ResolvePackage;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallResolverUtil;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.InferencePackage;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryPackage;

public class ArgumentTypeResolver {
    private TypeResolver typeResolver;
    private ExpressionTypingServices expressionTypingServices;
    private KotlinBuiltIns builtIns;

    @Inject
    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        if (typeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeResolver", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "setTypeResolver"));
        }
        this.typeResolver = typeResolver;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setBuiltIns(@NotNull KotlinBuiltIns builtIns) {
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "setBuiltIns"));
        }
        this.builtIns = builtIns;
    }

    public static boolean isSubtypeOfForArgumentType(@NotNull JetType actualType, @NotNull JetType expectedType) {
        if (actualType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualType", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "isSubtypeOfForArgumentType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "isSubtypeOfForArgumentType"));
        }
        if (ErrorUtils.isFunctionPlaceholder(actualType)) {
            JetType functionType = InferencePackage.createCorrespondingFunctionTypeForFunctionPlaceholder(actualType, expectedType);
            return JetTypeChecker.DEFAULT.isSubtypeOf(functionType, expectedType);
        }
        return JetTypeChecker.DEFAULT.isSubtypeOf(actualType, expectedType);
    }

    public void checkTypesWithNoCallee(@NotNull CallResolutionContext<?> context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "checkTypesWithNoCallee"));
        }
        this.checkTypesWithNoCallee(context2, CallResolverUtil.ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
    }

    public void checkTypesWithNoCallee(@NotNull CallResolutionContext<?> context2, @NotNull CallResolverUtil.ResolveArgumentsMode resolveFunctionArgumentBodies) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "checkTypesWithNoCallee"));
        }
        if (resolveFunctionArgumentBodies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveFunctionArgumentBodies", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "checkTypesWithNoCallee"));
        }
        if (context2.checkArguments == CheckValueArgumentsMode.DISABLED) {
            return;
        }
        for (ValueArgument valueArgument : context2.call.getValueArguments()) {
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || argumentExpression instanceof JetFunctionLiteralExpression) continue;
            this.checkArgumentTypeWithNoCallee(context2, argumentExpression);
        }
        if (resolveFunctionArgumentBodies == CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS) {
            this.checkTypesForFunctionArgumentsWithNoCallee(context2);
        }
        for (JetTypeProjection jetTypeProjection : context2.call.getTypeArguments()) {
            JetTypeReference typeReference = jetTypeProjection.getTypeReference();
            if (typeReference == null) {
                context2.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(jetTypeProjection));
                continue;
            }
            this.typeResolver.resolveType(context2.scope, typeReference, context2.trace, true);
        }
    }

    public void checkTypesForFunctionArgumentsWithNoCallee(@NotNull CallResolutionContext<?> context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "checkTypesForFunctionArgumentsWithNoCallee"));
        }
        if (context2.checkArguments == CheckValueArgumentsMode.DISABLED) {
            return;
        }
        for (ValueArgument valueArgument : context2.call.getValueArguments()) {
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || !ArgumentTypeResolver.isFunctionLiteralArgument(argumentExpression, context2)) continue;
            this.checkArgumentTypeWithNoCallee(context2, argumentExpression);
        }
    }

    private void checkArgumentTypeWithNoCallee(CallResolutionContext<?> context2, JetExpression argumentExpression) {
        this.expressionTypingServices.getTypeInfo(argumentExpression, (ResolutionContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        ArgumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context2, argumentExpression);
    }

    public static boolean isFunctionLiteralArgument(@NotNull JetExpression expression, @NotNull ResolutionContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "isFunctionLiteralArgument"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "isFunctionLiteralArgument"));
        }
        return ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression, context2) != null;
    }

    @NotNull
    public static JetFunction getFunctionLiteralArgument(@NotNull JetExpression expression, @NotNull ResolutionContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralArgument"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralArgument"));
        }
        assert (ArgumentTypeResolver.isFunctionLiteralArgument(expression, context2));
        JetFunction jetFunction = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression, context2);
        if (jetFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralArgument"));
        }
        return jetFunction;
    }

    @Nullable
    private static JetFunction getFunctionLiteralArgumentIfAny(@NotNull JetExpression expression, @NotNull ResolutionContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralArgumentIfAny"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralArgumentIfAny"));
        }
        JetExpression deparenthesizedExpression = ArgumentTypeResolver.getLastElementDeparenthesized(expression, context2);
        if (deparenthesizedExpression instanceof JetFunctionLiteralExpression) {
            return ((JetFunctionLiteralExpression)deparenthesizedExpression).getFunctionLiteral();
        }
        if (deparenthesizedExpression instanceof JetFunction) {
            return (JetFunction)deparenthesizedExpression;
        }
        return null;
    }

    @Nullable
    public static JetExpression getLastElementDeparenthesized(@Nullable JetExpression expression, @NotNull ResolutionContext context2) {
        JetBlockExpression blockExpression;
        JetElement lastStatementInABlock;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getLastElementDeparenthesized"));
        }
        JetExpression deparenthesizedExpression = JetPsiUtil.deparenthesize(expression, false);
        if (deparenthesizedExpression instanceof JetBlockExpression && (lastStatementInABlock = ResolvePackage.getLastStatementInABlock(context2.statementFilter, blockExpression = (JetBlockExpression)deparenthesizedExpression)) instanceof JetExpression) {
            return ArgumentTypeResolver.getLastElementDeparenthesized((JetExpression)lastStatementInABlock, context2);
        }
        return deparenthesizedExpression;
    }

    @NotNull
    public JetTypeInfo getArgumentTypeInfo(@Nullable JetExpression expression, @NotNull CallResolutionContext<?> context2, @NotNull CallResolverUtil.ResolveArgumentsMode resolveArgumentsMode) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
        }
        if (resolveArgumentsMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveArgumentsMode", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
        }
        if (expression == null) {
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context2);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
            }
            return jetTypeInfo;
        }
        if (ArgumentTypeResolver.isFunctionLiteralArgument(expression, context2)) {
            JetTypeInfo jetTypeInfo = this.getFunctionLiteralTypeInfo(expression, ArgumentTypeResolver.getFunctionLiteralArgument(expression, context2), context2, resolveArgumentsMode);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo recordedTypeInfo = BindingContextUtils.getRecordedTypeInfo(expression, context2.trace.getBindingContext());
        if (recordedTypeInfo != null) {
            JetTypeInfo jetTypeInfo = recordedTypeInfo;
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
            }
            return jetTypeInfo;
        }
        Object newContext = ((CallResolutionContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.DEPENDENT);
        JetTypeInfo jetTypeInfo = this.expressionTypingServices.getTypeInfo(expression, (ResolutionContext)newContext);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo getFunctionLiteralTypeInfo(@NotNull JetExpression expression, @NotNull JetFunction functionLiteral, @NotNull CallResolutionContext<?> context2, @NotNull CallResolverUtil.ResolveArgumentsMode resolveArgumentsMode) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        if (functionLiteral == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionLiteral", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        if (resolveArgumentsMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveArgumentsMode", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        if (resolveArgumentsMode == CallResolverUtil.ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS) {
            JetType type2 = this.getShapeTypeOfFunctionLiteral(functionLiteral, context2.scope, context2.trace, true);
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.createTypeInfo(type2, context2);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = this.expressionTypingServices.getTypeInfo(expression, (ResolutionContext)context2.replaceContextDependency(ContextDependency.INDEPENDENT));
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        return jetTypeInfo;
    }

    @Nullable
    public JetType getShapeTypeOfFunctionLiteral(@NotNull JetFunction function, @NotNull JetScope scope2, @NotNull BindingTrace trace, boolean expectedTypeIsUnknown) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getShapeTypeOfFunctionLiteral"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getShapeTypeOfFunctionLiteral"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getShapeTypeOfFunctionLiteral"));
        }
        boolean isFunctionLiteral = function instanceof JetFunctionLiteral;
        if (function.getValueParameterList() == null && isFunctionLiteral) {
            return expectedTypeIsUnknown ? ErrorUtils.createFunctionPlaceholderType(Collections.<JetType>emptyList(), false) : this.builtIns.getFunctionType(Annotations.EMPTY, null, Collections.<JetType>emptyList(), TypeUtils.DONT_CARE);
        }
        List<JetParameter> valueParameters = function.getValueParameters();
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(trace, "trace to resolve function literal parameter types");
        ArrayList<JetType> parameterTypes = Lists.newArrayList();
        for (JetParameter parameter : valueParameters) {
            parameterTypes.add(this.resolveTypeRefWithDefault(parameter.getTypeReference(), scope2, temporaryTrace, TypeUtils.DONT_CARE));
        }
        JetType returnType2 = this.resolveTypeRefWithDefault(function.getTypeReference(), scope2, temporaryTrace, TypeUtils.DONT_CARE);
        assert (returnType2 != null);
        JetType receiverType = this.resolveTypeRefWithDefault(function.getReceiverTypeReference(), scope2, temporaryTrace, null);
        return expectedTypeIsUnknown && isFunctionLiteral ? ErrorUtils.createFunctionPlaceholderType(parameterTypes, true) : this.builtIns.getFunctionType(Annotations.EMPTY, receiverType, parameterTypes, returnType2);
    }

    @Nullable
    public JetType resolveTypeRefWithDefault(@Nullable JetTypeReference returnTypeRef, @NotNull JetScope scope2, @NotNull BindingTrace trace, @Nullable JetType defaultValue) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "resolveTypeRefWithDefault"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "resolveTypeRefWithDefault"));
        }
        if (returnTypeRef != null) {
            return this.typeResolver.resolveType(scope2, returnTypeRef, trace, true);
        }
        return defaultValue;
    }

    public void analyzeArgumentsAndRecordTypes(@NotNull CallResolutionContext<?> context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "analyzeArgumentsAndRecordTypes"));
        }
        MutableDataFlowInfoForArguments infoForArguments = context2.dataFlowInfoForArguments;
        Call call = context2.call;
        ReceiverValue receiver = call.getExplicitReceiver();
        DataFlowInfo initialDataFlowInfo = context2.dataFlowInfo;
        if (receiver.exists() && !(receiver instanceof QualifierReceiver)) {
            DataFlowValue receiverDataFlowValue = DataFlowValueFactory.createDataFlowValue(receiver, context2);
            if (PsiUtilPackage.isSafeCall(call)) {
                initialDataFlowInfo = initialDataFlowInfo.disequate(receiverDataFlowValue, DataFlowValue.NULL);
            }
        }
        infoForArguments.setInitialDataFlowInfo(initialDataFlowInfo);
        for (ValueArgument valueArgument : call.getValueArguments()) {
            JetExpression expression = valueArgument.getArgumentExpression();
            if (expression == null) continue;
            CallResolutionContext newContext = (CallResolutionContext)context2.replaceDataFlowInfo(infoForArguments.getInfo(valueArgument));
            JetTypeInfo typeInfoForCall = this.getArgumentTypeInfo(expression, newContext, CallResolverUtil.ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
            infoForArguments.updateInfo(valueArgument, typeInfoForCall.getDataFlowInfo());
        }
    }

    @Nullable
    public static JetType updateResultArgumentTypeIfNotDenotable(@NotNull ResolutionContext context2, @NotNull JetExpression expression) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "updateResultArgumentTypeIfNotDenotable"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "updateResultArgumentTypeIfNotDenotable"));
        }
        JetType type2 = context2.trace.getType(expression);
        if (type2 != null && !type2.getConstructor().isDenotable() && type2.getConstructor() instanceof IntegerValueTypeConstructor) {
            IntegerValueTypeConstructor constructor2 = (IntegerValueTypeConstructor)type2.getConstructor();
            JetType primitiveType = TypeUtils.getPrimitiveNumberType(constructor2, context2.expectedType);
            ArgumentTypeResolver.updateNumberType(primitiveType, expression, context2);
            return primitiveType;
        }
        return type2;
    }

    public static void updateNumberType(@NotNull JetType numberType, @Nullable JetExpression expression, @NotNull ResolutionContext context2) {
        if (numberType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "numberType", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "updateNumberType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "updateNumberType"));
        }
        if (expression == null) {
            return;
        }
        BindingContextUtils.updateRecordedType(numberType, expression, context2.trace, false);
        if (!(expression instanceof JetConstantExpression)) {
            JetExpression deparenthesized = ArgumentTypeResolver.getLastElementDeparenthesized(expression, context2);
            if (deparenthesized != expression) {
                ArgumentTypeResolver.updateNumberType(numberType, deparenthesized, context2);
            }
            return;
        }
        ConstantExpressionEvaluator.evaluate(expression, context2.trace, numberType);
    }
}

