/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.validation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetCallableReferenceExpression;
import org.jetbrains.kotlin.psi.JetDelegatorToSuperCall;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetStubbedPsiUtil;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"M\f)IB)\u001a9sK\u000e\fG/\u001a3Ts6\u0014w\u000e\u001c,bY&$\u0017\r^8s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'b\u0002:fg>dg/\u001a\u0006\u000bm\u0006d\u0017\u000eZ1uS>t'\u0002F*z[\n|G.V:bO\u00164\u0016\r\\5eCR|'O\u0003\u0004=S:LGO\u0010\u0006\u0010\u0015\u00063\u0016i\u0018#F!J+5)\u0011+F\t*1a)\u001d(b[\u0016TAA\\1nK*9\u0002KU(Q\u000bJ#\u0016lX*F)~{\u0005+\u0012*B)&{ej\u0015\u0006\t)>\\WM\\*fi*\u00191m\\7\u000b\u0011%tG/\u001a7mS*T1\u0001]:j\u0015\u0011!(/Z3\u000b\u000f9{GOT;mY*Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015]Yw\u000e\u001e7j]:Rg/\u001c\u0018QY\u0006$hm\u001c:n)f\u0004XMC\u000ede\u0016\fG/\u001a#faJ,7-\u0019;j_:$\u0015.Y4o_N$\u0018n\u0019\u0006\bK2,W.\u001a8u\u0015)\u00016/[#mK6,g\u000e\u001e\u0006\u000bI\u0016\u001c8M]5qi>\u0014(\"\u0006#fG2\f'/\u0019;j_:$Um]2sSB$xN\u001d\u0006\fI\u0016\u001c8M]5qi>\u00148O\u0003\u0006eKB\u0014XmY1uK\u0012TA#\u00118o_R\fG/[8o\t\u0016\u001c8M]5qi>\u0014(B\u0003#jC\u001etwn\u001d;jG*YA-[1h]>\u001cH/[2t\u0015\t:W\r^'fgN\fw-\u001a$s_6\feN\\8uCRLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;pe*11\u000b\u001e:j]\u001eTAA[1wC*!A.\u00198h\u0015a\u0001(o\u001c9feRLx)\u001a;uKJ<vN]6be>,h\u000e\u001a\u0006\u0013aJ|\u0007/\u001a:us\u0012+7o\u0019:jaR|'O\u0003\nQe>\u0004XM\u001d;z\t\u0016\u001c8M]5qi>\u0014(\"\u0002;sC\u000e,'\u0002\u0004\"j]\u0012Lgn\u001a+sC\u000e,'BC3yaJ,7o]5p]*!QK\\5u\u001511\u0018\r\\5eCR,7)\u00197m\u0015A!\u0018M]4fi\u0012+7o\u0019:jaR|'O\u0003\nDC2d\u0017M\u00197f\t\u0016\u001c8M]5qi>\u0014(\"\u0005<bY&$\u0017\r^3UsB,Wk]1hK*!2\t\\1tg&4\u0017.\u001a:EKN\u001c'/\u001b9u_JTqdZ3u\t\u0016\u001cG.\u0019:fI\u0012+\u0007O]3dCR,G-\u00118o_R\fG/[8o\u0015]9W\r\u001e#faJ,7-\u0019;fI\u0006sgn\u001c;bi&|gN\u0003\u0003QC&\u0014hU\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0007\u0011\u0011\u0001\u0002\u0001\u0007\u0001\u000b\r!!\u0001C\u0002\r\u0001\u0015\u0011A!\u0001\u0005\u0006\u000b\r!9\u0001#\u0003\r\u0001\u0015\u0011Aq\u0001E\u0005\u000b\u0005Ai!\u0002\u0002\u0005\u000b!9QA\u0001C\u0006\u0011\u001f)!\u0001\u0002\u0004\t\u0011\u0015\u0019AQ\u0002\u0005\u0007\u0019\u0001)!\u0001\"\u0001\t\u0013\u0015\u0019Aq\u0002E\t\u0019\u0001)!\u0001\"\u0004\t\r\u0015\u0019AA\u0002\u0005\f\u0019\u0001)!\u0001B\u0001\t\u001a\u0015\u0019A1\u0003\u0005\r\u0019\u0001)!\u0001b\u0005\t\u0013\u0015\u0019AQ\u0003E\u000e\u0019\u0001)!\u0001B\u0001\t\u001e\u0015\u0019Aq\u0003\u0005\u000f\u0019\u0001)!\u0001b\u0006\t\u001d\u0015\u0011AA\u0002\u0005\f\u000b\t!\u0019\u0002\u0003\u0007\u0006\u0005\u0011U\u00012D\u0003\u0002\u0011\u0007)1\u0001\"\b\t 1\u0001Q!\u0001\u0005\u0011\u000b\t!y\u0002#\t\u0006\u0005\u0011\u0001\u0002rD\u0003\u0004\t'A!\u0003\u0004\u0001\u0006\u0007\u0011\r\u0001b\u0005\u0007\u0001\u000b\r!i\u0002\u0003\u000b\r\u0001\u0015\u0011A1\u0003\u0005\u0013\u000b\t!\u0019\u0001C\n\u0006\u0007\u0011M\u00012\u0006\u0007\u0001\u000b\t!\u0019\u0002c\u000b\u0006\u0007\u0011M\u0001R\u0006\u0007\u0001\u000b\t!\u0019\u0002#\f\u0006\u0007\u0011u\u0001\u0002\u0007\u0007\u0001\u000b\t!i\u0002\u0003\r\u0005\u00071\u0015\u0011DA\u0003\u0002\u0011\ri3\u0002B1\u00051\u0011\t#!B\u0001\t\tU\u001bA!B\u0002\u0005\t%\t\u0001\u0012B\u0017\u0016\t\u0005$\u00014B\u0011\r\u000b\u0005Aq\u0001e\u0005\u0016\f\u0015\t\u0001b\u0002G\u0001#\u000e\tA\u0001C)\u0004\u0003\u0011AQk\u0001\u0003\u0006\u0007\u0011-\u0011\"\u0001E\t[\u0019\"\u0011\u0001\u0007\u0006\u001e\u000e\u0011\u0001\u0001RC\u0007\u0003\u000b\u0005A\u0011\u0002U\u0002\u0001;\u001b!\u0001\u0001c\u0006\u000e\u0005\u0015\t\u0001B\u0003)\u0004\u0002u5A\u0001\u0001\u0005\u000e\u001b\t)\u0011\u0001C\u0006Q\u0007\u0005\t#!B\u0001\t\u0019E\u001b\u0011\u0002\u0002\u0006\n\u0003!eQ\"\u0001\u0005\u000e\u001b\u0005AY\"D\u0001\t\u001d5\"B!\u0001\r\u0010;\u001b!\u0001\u0001c\u0006\u000e\u0005\u0015\t\u0001b\u0003)\u0004\u0001\u0005\u001aQ!\u0001\u0005\u0010\u0019\u0003\t6!\u0002\u0003\u0010\u0013\u0005A\t#D\u0001\t\u001d52C\u0001\u0001\r\u0012;\u001b!\u0001\u0001c\t\u000e\u0005\u0015\t\u0001\"\u0005)\u0004\u0001u5A\u0001\u0001E\u0013\u001b\t)\u0011\u0001c\tQ\u0007\u0003ij\u0001\u0002\u0001\t(5\u0011Q!\u0001\u0005\n!\u000e\t\u0011EA\u0003\u0002\u0011I\t6!\u0003\u0003\u0012\u0013\u0005!\u0001!D\u0001\t&5\t\u0001bE\u0007\u0002\u00115ic\u0005B\u0006\u0019*u5A\u0001\u0001\u0005\u0016\u001b\t)\u0011\u0001c\nQ\u0007\u0001ij\u0001\u0002\u0001\t&5\u0011Q!\u0001E\u0012!\u000e\u0005QT\u0002\u0003\u0001\u0011+i!!B\u0001\t\u0013A\u001b\u0011!\t\u0002\u0006\u0003!\u0011\u0012kA\u0005\u0005*%\tA\u0001A\u0007\u0002\u0011Qi\u0011\u0001C\n\u000e\u0003!iQF\n\u0003\f1Yij\u0001\u0002\u0001\t+5\u0011Q!\u0001E\u0015!\u000e\u0001QT\u0002\u0003\u0001\u0011Ki!!B\u0001\t$A\u001b\t!(\u0004\u0005\u0001!UQBA\u0003\u0002\u0011%\u00016!A\u0011\u0003\u000b\u0005A!#U\u0002\n\tYI\u0011\u0001\u0002\u0001\u000e\u0003!)R\"\u0001\u0005\u0014\u001b\u0005AQ\"l\b\u0005\u0003U\u0011Q!\u0001\u0005\u000b1]\t3!B\u0001\t\u00171\u0005\u0011kA\u0003\u0005/%\t\u0001BD\u0007\u0002\u00117i{\u0003B\u0001\u0016\u0005\u0015\t\u0001B\u0003M\u0018C-)\u0011\u0001c\u000b\n\u0007%\u0011Q!\u0001\u0005\f\u0013\rI!!B\u0001\t\u00151\u0005\u0011kA\u0003\u00050%\t\u0001BF\u0007\u0002\u00117)4\"\u0002\u0006\u0005G\u0004A:!\t\u0002\u0006\u0003!\u0015\u0011kA\u0002\u0005\b%\tA\u0001\u0001"})
public final class DeprecatedSymbolValidator
implements SymbolUsageValidator {
    public static final /* synthetic */ KClass $kotlinClass;
    private final FqName JAVA_DEPRECATED = new FqName(Deprecated.class.getName());
    private final TokenSet PROPERTY_SET_OPERATIONS = TokenSet.create(JetTokens.EQ, JetTokens.PLUSEQ, JetTokens.MINUSEQ, JetTokens.MULTEQ, JetTokens.DIVEQ, JetTokens.PERCEQ, JetTokens.PLUSPLUS, JetTokens.MINUSMINUS);

    static {
        $kotlinClass = Reflection.createKotlinClass(DeprecatedSymbolValidator.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validateCall(@JetValueParameter(name="targetDescriptor") @NotNull CallableDescriptor targetDescriptor, @JetValueParameter(name="trace") @NotNull BindingTrace trace, @JetValueParameter(name="element") @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        Pair<AnnotationDescriptor, DeclarationDescriptor> deprecated2 = this.getDeprecatedAnnotation(targetDescriptor);
        if (deprecated2 != null) {
            void annotation2;
            void target;
            Pair<AnnotationDescriptor, DeclarationDescriptor> pair = deprecated2;
            AnnotationDescriptor annotationDescriptor = pair.component1();
            DeclarationDescriptor declarationDescriptor = pair.component2();
            pair = null;
            trace.report(this.createDeprecationDiagnostic(element, (DeclarationDescriptor)target, (AnnotationDescriptor)annotation2));
        } else if (targetDescriptor instanceof PropertyDescriptor) {
            this.propertyGetterWorkaround((PropertyDescriptor)targetDescriptor, trace, element);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validateTypeUsage(@JetValueParameter(name="targetDescriptor") @NotNull ClassifierDescriptor targetDescriptor, @JetValueParameter(name="trace") @NotNull BindingTrace trace, @JetValueParameter(name="element") @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        JetAnnotationEntry annotationEntry = JetStubbedPsiUtil.getPsiOrStubParent(element, JetAnnotationEntry.class, true);
        if (annotationEntry != null && Intrinsics.areEqual(annotationEntry.getCalleeExpression().getConstructorReferenceExpression(), element)) {
            return;
        }
        JetDelegatorToSuperCall superExpression = JetStubbedPsiUtil.getPsiOrStubParent(element, JetDelegatorToSuperCall.class, true);
        if (superExpression != null && Intrinsics.areEqual(superExpression.getCalleeExpression().getConstructorReferenceExpression(), element)) {
            return;
        }
        Pair<AnnotationDescriptor, DeclarationDescriptor> deprecated2 = this.getDeprecatedAnnotation(targetDescriptor);
        if (deprecated2 != null) {
            void annotation2;
            void target;
            Pair<AnnotationDescriptor, DeclarationDescriptor> pair = deprecated2;
            AnnotationDescriptor annotationDescriptor = pair.component1();
            DeclarationDescriptor declarationDescriptor = pair.component2();
            pair = null;
            trace.report(this.createDeprecationDiagnostic(element, (DeclarationDescriptor)target, (AnnotationDescriptor)annotation2));
        }
    }

    private final Pair<AnnotationDescriptor, DeclarationDescriptor> getDeprecatedAnnotation(@JetValueParameter(name="$receiver") DeclarationDescriptor $receiver) {
        DeclarationDescriptor propertyDescriptor;
        AnnotationDescriptor propertyAnnotation;
        AnnotationDescriptor ownAnnotation = this.getDeclaredDeprecatedAnnotation($receiver);
        if (ownAnnotation != null) {
            return KotlinPackage.to(ownAnnotation, $receiver);
        }
        DeclarationDescriptor declarationDescriptor = $receiver;
        if (declarationDescriptor instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)$receiver).getContainingDeclaration();
            AnnotationDescriptor classAnnotation = this.getDeclaredDeprecatedAnnotation(classDescriptor);
            if (classAnnotation != null) {
                return KotlinPackage.to(classAnnotation, classDescriptor);
            }
        } else if (declarationDescriptor instanceof PropertyAccessorDescriptor && (propertyAnnotation = this.getDeclaredDeprecatedAnnotation(propertyDescriptor = ((PropertyAccessorDescriptor)$receiver).getContainingDeclaration())) != null) {
            return KotlinPackage.to(propertyAnnotation, propertyDescriptor);
        }
        return null;
    }

    private final AnnotationDescriptor getDeclaredDeprecatedAnnotation(@JetValueParameter(name="$receiver") DeclarationDescriptor $receiver) {
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.deprecated;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.deprecated");
        AnnotationDescriptor annotationDescriptor = annotations2.findAnnotation(fqName2);
        if (annotationDescriptor == null) {
            annotationDescriptor = $receiver.getAnnotations().findAnnotation(this.JAVA_DEPRECATED);
        }
        return annotationDescriptor;
    }

    private final Diagnostic createDeprecationDiagnostic(@JetValueParameter(name="element") PsiElement element, @JetValueParameter(name="descriptor") DeclarationDescriptor descriptor, @JetValueParameter(name="deprecated") AnnotationDescriptor deprecated2) {
        String message = this.getMessageFromAnnotationDescriptor(deprecated2);
        return message == null ? Errors.DEPRECATED_SYMBOL.on(element, descriptor) : Errors.DEPRECATED_SYMBOL_WITH_MESSAGE.on(element, descriptor, message);
    }

    private final String getMessageFromAnnotationDescriptor(@JetValueParameter(name="descriptor") AnnotationDescriptor descriptor) {
        Name parameterName = Name.identifier("value");
        Iterator<Map.Entry<ValueParameterDescriptor, CompileTimeConstant<?>>> iterator2 = KotlinPackage.iterator(descriptor.getAllValueArguments());
        while (iterator2.hasNext()) {
            Map.Entry<ValueParameterDescriptor, CompileTimeConstant<?>> entry = iterator2.next();
            ValueParameterDescriptor parameterDescriptor = KotlinPackage.component1(entry);
            CompileTimeConstant<?> argument = KotlinPackage.component2(entry);
            if (!Intrinsics.areEqual(parameterDescriptor.getName(), parameterName)) continue;
            Object parameterValue = argument.getValue();
            if (parameterValue instanceof String) {
                return (String)parameterValue;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void propertyGetterWorkaround(@JetValueParameter(name="propertyDescriptor") @NotNull PropertyDescriptor propertyDescriptor, @JetValueParameter(name="trace") @NotNull BindingTrace trace, @JetValueParameter(name="expression") @NotNull PsiElement expression) {
        Unit unit;
        JetUnaryExpression unaryExpression;
        Object expr;
        IElementType operation;
        Intrinsics.checkParameterIsNotNull(propertyDescriptor, "propertyDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetBinaryExpression binaryExpression = PsiTreeUtil.getParentOfType(expression, JetBinaryExpression.class);
        if (binaryExpression != null) {
            JetExpression left = binaryExpression.getLeft();
            if (Intrinsics.areEqual(left, expression) && (operation = binaryExpression.getOperationToken()) != null && this.PROPERTY_SET_OPERATIONS.contains(operation)) {
                return;
            }
            JetReferenceExpression[] jetReferenceExpressions = (JetReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)left, JetReferenceExpression.class);
            if (jetReferenceExpressions != null) {
                for (int i = 0; i < jetReferenceExpressions.length; ++i) {
                    IElementType operation2;
                    expr = jetReferenceExpressions[i];
                    if (!Intrinsics.areEqual(expr, expression) || (operation2 = binaryExpression.getOperationToken()) == null || !this.PROPERTY_SET_OPERATIONS.contains(operation2)) continue;
                    return;
                }
            }
        }
        if ((unaryExpression = PsiTreeUtil.getParentOfType(expression, JetUnaryExpression.class)) != null && (operation = unaryExpression.getOperationReference().getReferencedNameElementType()) != null && this.PROPERTY_SET_OPERATIONS.contains(operation)) {
            return;
        }
        JetCallableReferenceExpression callableExpression = PsiTreeUtil.getParentOfType(expression, JetCallableReferenceExpression.class);
        if (callableExpression != null && Intrinsics.areEqual(callableExpression.getCallableReference(), expression)) {
            return;
        }
        PropertyGetterDescriptor propertyGetterDescriptor = propertyDescriptor.getGetter();
        if (propertyGetterDescriptor != null) {
            void $receiver;
            expr = propertyGetterDescriptor;
            PropertyGetterDescriptor it2 = (PropertyGetterDescriptor)$receiver;
            this.validateCall(it2, trace, expression);
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
    }
}

