/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.infos;

import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

public class CandidateInfo
implements JavaResolveResult {
    public static final CandidateInfo[] EMPTY_ARRAY = new CandidateInfo[0];
    private final PsiElement myPlace;
    private final PsiClass myAccessClass;
    @NotNull
    private final PsiElement myCandidate;
    private final boolean myStaticsProblem;
    protected final PsiSubstitutor mySubstitutor;
    private final PsiElement myCurrentFileResolveContext;
    private final boolean myPackagePrefixPackageReference;
    private Boolean myAccessible;
    @NotNull
    public static final JavaResolveResult[] RESOLVE_RESULT_FOR_PACKAGE_PREFIX_PACKAGE = new JavaResolveResult[]{new CandidateInfo(PsiUtilCore.NULL_PSI_ELEMENT, PsiSubstitutor.EMPTY, Boolean.TRUE, false, null, null, null, true)};

    private CandidateInfo(@NotNull PsiElement candidate, @NotNull PsiSubstitutor substitutor, Boolean accessible, boolean staticsProblem, PsiElement currFileContext, PsiElement place, PsiClass accessClass, boolean packagePrefixPackageReference) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/infos/CandidateInfo", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/infos/CandidateInfo", "<init>"));
        }
        this.myCandidate = candidate;
        this.myAccessible = accessible;
        this.myStaticsProblem = staticsProblem;
        this.mySubstitutor = substitutor;
        this.myCurrentFileResolveContext = currFileContext;
        this.myAccessClass = accessClass;
        this.myPlace = place;
        this.myPackagePrefixPackageReference = packagePrefixPackageReference;
    }

    public CandidateInfo(@NotNull PsiElement candidate, @NotNull PsiSubstitutor substitutor, boolean accessProblem, boolean staticsProblem, PsiElement currFileContext) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/infos/CandidateInfo", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/infos/CandidateInfo", "<init>"));
        }
        this(candidate, substitutor, !accessProblem, staticsProblem, currFileContext, null, null, false);
    }

    public CandidateInfo(@NotNull PsiElement candidate, @NotNull PsiSubstitutor substitutor, boolean accessProblem, boolean staticsProblem) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/infos/CandidateInfo", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/infos/CandidateInfo", "<init>"));
        }
        this(candidate, substitutor, accessProblem, staticsProblem, null);
    }

    public CandidateInfo(@NotNull PsiElement candidate, @NotNull PsiSubstitutor substitutor, PsiElement place, PsiClass accessClass, boolean staticsProblem, PsiElement currFileContext) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/infos/CandidateInfo", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/infos/CandidateInfo", "<init>"));
        }
        this(candidate, substitutor, null, staticsProblem, currFileContext, place, accessClass, false);
    }

    public CandidateInfo(@NotNull PsiElement candidate, @NotNull PsiSubstitutor substitutor, PsiElement place, boolean staticsProblem) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/infos/CandidateInfo", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/infos/CandidateInfo", "<init>"));
        }
        this(candidate, substitutor, place, null, staticsProblem, null);
    }

    public CandidateInfo(@NotNull PsiElement candidate, @NotNull PsiSubstitutor substitutor) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/infos/CandidateInfo", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/infos/CandidateInfo", "<init>"));
        }
        this(candidate, substitutor, null, null, false, null);
    }

    public CandidateInfo(@NotNull CandidateInfo candidate, @NotNull PsiSubstitutor newSubstitutor) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/infos/CandidateInfo", "<init>"));
        }
        if (newSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSubstitutor", "com/intellij/psi/infos/CandidateInfo", "<init>"));
        }
        this(candidate.myCandidate, newSubstitutor, candidate.myAccessible, candidate.myStaticsProblem, candidate.myCurrentFileResolveContext, candidate.myPlace, null, false);
    }

    @Override
    public boolean isValidResult() {
        return this.isAccessible() && this.isStaticsScopeCorrect();
    }

    @Override
    public boolean isPackagePrefixPackageReference() {
        return this.myPackagePrefixPackageReference;
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myCandidate;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/CandidateInfo", "getElement"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/CandidateInfo", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    @Override
    public boolean isAccessible() {
        Boolean Accessible2 = this.myAccessible;
        boolean accessible = true;
        if (Accessible2 == null) {
            if (this.myPlace != null && this.myCandidate instanceof PsiMember) {
                PsiMember member = (PsiMember)this.myCandidate;
                accessible = JavaPsiFacade.getInstance(this.myPlace.getProject()).getResolveHelper().isAccessible(member, member.getModifierList(), this.myPlace, this.myAccessClass, this.myCurrentFileResolveContext);
                if (accessible && member.hasModifierProperty("private") && this.myPlace instanceof PsiReferenceExpression && JavaVersionService.getInstance().isAtLeast(this.myPlace, JavaSdkVersion.JDK_1_7)) {
                    accessible = !this.isAccessedThroughTypeParameterBound();
                }
            }
            this.myAccessible = accessible;
        } else {
            accessible = Accessible2;
        }
        return accessible;
    }

    private boolean isAccessedThroughTypeParameterBound() {
        JavaResolveResult resolveResult;
        PsiElement element;
        PsiExpression qualifierExpression = ((PsiReferenceExpression)this.myPlace).getQualifierExpression();
        if (qualifierExpression instanceof PsiMethodCallExpression && (element = (resolveResult = ((PsiMethodCallExpression)qualifierExpression).resolveMethodGenerics()).getElement()) instanceof PsiMethod) {
            PsiType returnType2 = ((PsiMethod)element).getReturnType();
            PsiType substitutedReturnType = resolveResult.getSubstitutor().substitute(returnType2);
            if (substitutedReturnType instanceof PsiCapturedWildcardType || substitutedReturnType instanceof PsiWildcardType) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isStaticsScopeCorrect() {
        return !this.myStaticsProblem;
    }

    @Override
    public PsiElement getCurrentFileResolveScope() {
        return this.myCurrentFileResolveContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CandidateInfo that = (CandidateInfo)o;
        if (this.myPackagePrefixPackageReference != that.myPackagePrefixPackageReference) {
            return false;
        }
        if (this.myStaticsProblem != that.myStaticsProblem) {
            return false;
        }
        if (this.myAccessClass != null ? !this.myAccessClass.equals(that.myAccessClass) : that.myAccessClass != null) {
            return false;
        }
        if (this.isAccessible() != that.isAccessible()) {
            return false;
        }
        if (!this.myCandidate.equals(that.myCandidate)) {
            return false;
        }
        if (this.myCurrentFileResolveContext != null ? !this.myCurrentFileResolveContext.equals(that.myCurrentFileResolveContext) : that.myCurrentFileResolveContext != null) {
            return false;
        }
        if (this.myPlace != null ? !this.myPlace.equals(that.myPlace) : that.myPlace != null) {
            return false;
        }
        return this.mySubstitutor.equals(that.mySubstitutor);
    }

    public int hashCode() {
        int result2 = this.myPlace != null ? this.myPlace.hashCode() : 0;
        result2 = 31 * result2 + (this.myAccessClass != null ? this.myAccessClass.hashCode() : 0);
        result2 = 31 * result2 + this.myCandidate.hashCode();
        result2 = 31 * result2 + (this.isAccessible() ? 1 : 0);
        result2 = 31 * result2 + (this.myStaticsProblem ? 1 : 0);
        result2 = 31 * result2 + this.mySubstitutor.hashCode();
        result2 = 31 * result2 + (this.myCurrentFileResolveContext != null ? this.myCurrentFileResolveContext.hashCode() : 0);
        result2 = 31 * result2 + (this.myPackagePrefixPackageReference ? 1 : 0);
        return result2;
    }
}

