/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexingDataKeys;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class CoreStubTreeLoader
extends StubTreeLoader {
    @Override
    public ObjectStubTree readOrBuild(Project project, VirtualFile vFile, @Nullable PsiFile psiFile) {
        if (!this.canHaveStub(vFile)) {
            return null;
        }
        try {
            FileContentImpl fc = new FileContentImpl(vFile, vFile.contentsToByteArray());
            fc.putUserData(IndexingDataKeys.PROJECT, project);
            Stub element = StubTreeBuilder.buildStubTree(fc);
            if (element instanceof PsiFileStub) {
                return new StubTree((PsiFileStub)element);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public ObjectStubTree readFromVFile(Project project, VirtualFile vFile) {
        return null;
    }

    @Override
    public void rebuildStubTree(VirtualFile virtualFile) {
    }

    @Override
    public long getStubTreeTimestamp(VirtualFile vFile) {
        return 0L;
    }

    @Override
    public boolean canHaveStub(VirtualFile file) {
        FileType fileType = file.getFileType();
        if (fileType instanceof LanguageFileType) {
            Language l = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l);
            if (parserDefinition == null) {
                return false;
            }
            IFileElementType elementType = parserDefinition.getFileNodeType();
            return elementType instanceof IStubFileElementType && ((IStubFileElementType)elementType).shouldBuildStubFor(file);
        }
        if (fileType.isBinary()) {
            BinaryFileStubBuilder builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType);
            return builder != null && builder.acceptsFile(file);
        }
        return false;
    }

    @Override
    public String getIndexingStampDebugInfo(VirtualFile file) {
        return "";
    }
}

