/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.ReflectionFactory;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KMemberProperty;
import kotlin.reflect.KMutableMemberProperty;
import kotlin.reflect.KMutableTopLevelExtensionProperty;
import kotlin.reflect.KMutableTopLevelVariable;
import kotlin.reflect.KPackage;
import kotlin.reflect.KTopLevelExtensionProperty;
import kotlin.reflect.KTopLevelVariable;

public class Reflection {
    private static final ReflectionFactory factory;

    public static KClass createKotlinClass(Class javaClass) {
        return factory.createKotlinClass(javaClass);
    }

    public static KClass[] foreignKotlinClasses(Class[] javaClasses) {
        KClass[] kClasses = new KClass[javaClasses.length];
        for (int i = 0; i < javaClasses.length; ++i) {
            kClasses[i] = Reflection.foreignKotlinClass(javaClasses[i]);
        }
        return kClasses;
    }

    public static KPackage createKotlinPackage(Class javaClass) {
        return factory.createKotlinPackage(javaClass);
    }

    public static KClass foreignKotlinClass(Class javaClass) {
        return factory.foreignKotlinClass(javaClass);
    }

    public static KFunction function(FunctionReference f) {
        return factory.function(f);
    }

    public static KMemberProperty memberProperty(String name, KClass owner) {
        return factory.memberProperty(name, owner);
    }

    public static KMutableMemberProperty mutableMemberProperty(String name, KClass owner) {
        return factory.mutableMemberProperty(name, owner);
    }

    public static KTopLevelVariable topLevelVariable(String name, KPackage owner) {
        return factory.topLevelVariable(name, owner);
    }

    public static KMutableTopLevelVariable mutableTopLevelVariable(String name, KPackage owner) {
        return factory.mutableTopLevelVariable(name, owner);
    }

    public static KTopLevelExtensionProperty topLevelExtensionProperty(String name, KPackage owner, Class receiver) {
        return factory.topLevelExtensionProperty(name, owner, receiver);
    }

    public static KMutableTopLevelExtensionProperty mutableTopLevelExtensionProperty(String name, KPackage owner, Class receiver) {
        return factory.mutableTopLevelExtensionProperty(name, owner, receiver);
    }

    static {
        ReflectionFactory impl2;
        try {
            Class<?> implClass = Class.forName("kotlin.reflect.jvm.internal.ReflectionFactoryImpl");
            impl2 = (ReflectionFactory)implClass.newInstance();
        }
        catch (ClassCastException e) {
            impl2 = null;
        }
        catch (ClassNotFoundException e) {
            impl2 = null;
        }
        catch (InstantiationException e) {
            impl2 = null;
        }
        catch (IllegalAccessException e) {
            impl2 = null;
        }
        factory = impl2 != null ? impl2 : new ReflectionFactory();
    }
}

