/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.JetControlFlowProcessor;
import org.jetbrains.kotlin.cfg.LexicalScopeVariableInfo;
import org.jetbrains.kotlin.cfg.PseudocodeVariablesData;
import org.jetbrains.kotlin.cfg.TailRecursionDetector;
import org.jetbrains.kotlin.cfg.TailRecursionKind;
import org.jetbrains.kotlin.cfg.UnreachableCode;
import org.jetbrains.kotlin.cfg.UnreachableCodeImpl;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodePackage;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtil;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.JetElementInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.CallInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.InstructionWithValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.LoadUnitValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MergeInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.ReadValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.WriteValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.AbstractJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.JumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.NondeterministicJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ReturnNoValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ReturnValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.UnconditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.LocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.MarkInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineExitInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.VariableDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.Edges;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.PseudocodeTraverserPackage;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraversalOrder;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBreakExpression;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetContinueExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetDotQualifiedExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetMultiDeclarationEntry;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetPostfixExpression;
import org.jetbrains.kotlin.psi.JetPrimaryConstructor;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.JetThrowExpression;
import org.jetbrains.kotlin.psi.JetTryExpression;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.psi.JetVariableDeclaration;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.psi.JetWhenCondition;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilPackage;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilPackage;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

public class JetFlowInformationProvider {
    private final JetElement subroutine;
    private final Pseudocode pseudocode;
    private final BindingTrace trace;
    private PseudocodeVariablesData pseudocodeVariablesData;

    private JetFlowInformationProvider(@NotNull JetElement declaration, @NotNull BindingTrace trace, @NotNull Pseudocode pseudocode) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "<init>"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "<init>"));
        }
        if (pseudocode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pseudocode", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "<init>"));
        }
        this.subroutine = declaration;
        this.trace = trace;
        this.pseudocode = pseudocode;
    }

    public JetFlowInformationProvider(@NotNull JetElement declaration, @NotNull BindingTrace trace) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "<init>"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "<init>"));
        }
        this(declaration, trace, new JetControlFlowProcessor(trace).generatePseudocode(declaration));
    }

    public PseudocodeVariablesData getPseudocodeVariablesData() {
        if (this.pseudocodeVariablesData == null) {
            this.pseudocodeVariablesData = new PseudocodeVariablesData(this.pseudocode, this.trace.getBindingContext());
        }
        return this.pseudocodeVariablesData;
    }

    public void checkForLocalClassOrObjectMode() {
        this.recordInitializedVariables();
    }

    public void checkDeclaration() {
        this.recordInitializedVariables();
        this.checkLocalFunctions();
        this.markUninitializedVariables();
        this.markUnusedVariables();
        this.markStatements();
        this.markUnusedExpressions();
        this.markWhenWithoutElse();
    }

    public void checkFunction(@Nullable JetType expectedReturnType) {
        UnreachableCode unreachableCode = this.collectUnreachableCode();
        this.reportUnreachableCode(unreachableCode);
        if (this.subroutine instanceof JetFunctionLiteral) {
            return;
        }
        this.checkDefiniteReturn(expectedReturnType != null ? expectedReturnType : TypeUtils.NO_EXPECTED_TYPE, unreachableCode);
        this.markTailCalls();
    }

    private void collectReturnExpressions(final @NotNull Collection<JetElement> returnedExpressions) {
        if (returnedExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnedExpressions", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "collectReturnExpressions"));
        }
        final HashSet<Instruction> instructions = Sets.newHashSet(this.pseudocode.getInstructions());
        SubroutineExitInstruction exitInstruction = this.pseudocode.getExitInstruction();
        for (Instruction previousInstruction : exitInstruction.getPreviousInstructions()) {
            previousInstruction.accept(new InstructionVisitor(){

                @Override
                public void visitReturnValue(@NotNull ReturnValueInstruction instruction) {
                    if (instruction == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$1", "visitReturnValue"));
                    }
                    if (instructions.contains(instruction)) {
                        returnedExpressions.add(instruction.getElement());
                    }
                }

                @Override
                public void visitReturnNoValue(@NotNull ReturnNoValueInstruction instruction) {
                    if (instruction == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$1", "visitReturnNoValue"));
                    }
                    if (instructions.contains(instruction)) {
                        returnedExpressions.add(instruction.getElement());
                    }
                }

                @Override
                public void visitJump(@NotNull AbstractJumpInstruction instruction) {
                    if (instruction == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$1", "visitJump"));
                    }
                }

                @Override
                public void visitUnconditionalJump(@NotNull UnconditionalJumpInstruction instruction) {
                    if (instruction == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$1", "visitUnconditionalJump"));
                    }
                    this.redirectToPrevInstructions(instruction);
                }

                private void redirectToPrevInstructions(Instruction instruction) {
                    for (Instruction previousInstruction : instruction.getPreviousInstructions()) {
                        previousInstruction.accept(this);
                    }
                }

                @Override
                public void visitNondeterministicJump(@NotNull NondeterministicJumpInstruction instruction) {
                    if (instruction == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$1", "visitNondeterministicJump"));
                    }
                    this.redirectToPrevInstructions(instruction);
                }

                @Override
                public void visitMarkInstruction(@NotNull MarkInstruction instruction) {
                    if (instruction == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$1", "visitMarkInstruction"));
                    }
                    this.redirectToPrevInstructions(instruction);
                }

                @Override
                public void visitInstruction(@NotNull Instruction instruction) {
                    if (instruction == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$1", "visitInstruction"));
                    }
                    if (!(instruction instanceof JetElementInstruction)) {
                        throw new IllegalStateException(instruction + " precedes the exit point");
                    }
                    JetElementInstruction elementInstruction = (JetElementInstruction)instruction;
                    returnedExpressions.add(elementInstruction.getElement());
                }
            });
        }
    }

    private void checkLocalFunctions() {
        for (LocalFunctionDeclarationInstruction localDeclarationInstruction : this.pseudocode.getLocalDeclarations()) {
            JetElement element = localDeclarationInstruction.getElement();
            if (!(element instanceof JetDeclarationWithBody)) continue;
            JetDeclarationWithBody localDeclaration = (JetDeclarationWithBody)element;
            CallableDescriptor functionDescriptor = (CallableDescriptor)this.trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, localDeclaration);
            JetType expectedType = functionDescriptor != null ? functionDescriptor.getReturnType() : null;
            JetFlowInformationProvider providerForLocalDeclaration = new JetFlowInformationProvider(localDeclaration, this.trace, localDeclarationInstruction.getBody());
            providerForLocalDeclaration.checkFunction(expectedType);
        }
    }

    public void checkDefiniteReturn(final @NotNull JetType expectedReturnType, final @NotNull UnreachableCode unreachableCode) {
        if (expectedReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedReturnType", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "checkDefiniteReturn"));
        }
        if (unreachableCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unreachableCode", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "checkDefiniteReturn"));
        }
        assert (this.subroutine instanceof JetDeclarationWithBody);
        JetDeclarationWithBody function = (JetDeclarationWithBody)this.subroutine;
        if (!function.hasBody()) {
            return;
        }
        ArrayList<JetElement> returnedExpressions = Lists.newArrayList();
        this.collectReturnExpressions(returnedExpressions);
        final boolean blockBody = function.hasBlockBody();
        final boolean[] noReturnError = new boolean[]{false};
        for (JetElement returnedExpression : returnedExpressions) {
            returnedExpression.accept(new JetVisitorVoid(){

                @Override
                public void visitReturnExpression(@NotNull JetReturnExpression expression) {
                    if (expression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$2", "visitReturnExpression"));
                    }
                    if (!blockBody) {
                        JetFlowInformationProvider.this.trace.report(Errors.RETURN_IN_FUNCTION_WITH_EXPRESSION_BODY.on(expression));
                    }
                }

                @Override
                public void visitJetElement(@NotNull JetElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$2", "visitJetElement"));
                    }
                    if (!(element instanceof JetExpression) && !(element instanceof JetWhenCondition)) {
                        return;
                    }
                    if (blockBody && !TypeUtils.noExpectedType(expectedReturnType) && !KotlinBuiltIns.isUnit(expectedReturnType) && !unreachableCode.getElements().contains(element)) {
                        noReturnError[0] = true;
                    }
                }
            });
        }
        if (noReturnError[0]) {
            this.trace.report(Errors.NO_RETURN_IN_FUNCTION_WITH_BLOCK_BODY.on(function));
        }
    }

    private void reportUnreachableCode(@NotNull UnreachableCode unreachableCode) {
        if (unreachableCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unreachableCode", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "reportUnreachableCode"));
        }
        for (JetElement element : unreachableCode.getElements()) {
            this.trace.report(Errors.UNREACHABLE_CODE.on(element, unreachableCode.getUnreachableTextRanges(element)));
            this.trace.record(BindingContext.UNREACHABLE_CODE, element, true);
        }
    }

    @NotNull
    private UnreachableCode collectUnreachableCode() {
        HashSet<JetElement> reachableElements = Sets.newHashSet();
        HashSet<JetElement> unreachableElements = Sets.newHashSet();
        for (Instruction instruction : this.pseudocode.getInstructionsIncludingDeadCode()) {
            boolean isJumpElement;
            if (!(instruction instanceof JetElementInstruction) || instruction instanceof LoadUnitValueInstruction || instruction instanceof MergeInstruction || instruction instanceof MagicInstruction && ((MagicInstruction)instruction).getSynthetic()) continue;
            JetElement element = ((JetElementInstruction)instruction).getElement();
            if (instruction instanceof JumpInstruction && !(isJumpElement = element instanceof JetBreakExpression || element instanceof JetContinueExpression || element instanceof JetReturnExpression || element instanceof JetThrowExpression)) continue;
            if (instruction.getDead()) {
                unreachableElements.add(element);
                continue;
            }
            reachableElements.add(element);
        }
        UnreachableCodeImpl unreachableCodeImpl = new UnreachableCodeImpl(reachableElements, unreachableElements);
        if (unreachableCodeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "collectUnreachableCode"));
        }
        return unreachableCodeImpl;
    }

    public void markUninitializedVariables() {
        final HashSet varWithUninitializedErrorGenerated = Sets.newHashSet();
        final HashSet varWithValReassignErrorGenerated = Sets.newHashSet();
        final boolean processClassOrObject = this.subroutine instanceof JetClassOrObject;
        PseudocodeVariablesData pseudocodeVariablesData = this.getPseudocodeVariablesData();
        Map<Instruction, Edges<Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState>>> initializers = pseudocodeVariablesData.getVariableInitializers();
        final Set<VariableDescriptor> declaredVariables = pseudocodeVariablesData.getDeclaredVariables(this.pseudocode, true);
        final LexicalScopeVariableInfo lexicalScopeVariableInfo = pseudocodeVariablesData.getLexicalScopeVariableInfo();
        final HashMap reportedDiagnosticMap = Maps.newHashMap();
        PseudocodeTraverserPackage.traverse(this.pseudocode, TraversalOrder.FORWARD, initializers, new InstructionDataAnalyzeStrategy<Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState>>(){

            @Override
            public void execute(@NotNull Instruction instruction, @Nullable Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState> in, @Nullable Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState> out) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$3", "execute"));
                }
                assert (in != null && out != null);
                VariableInitContext ctxt = new VariableInitContext(instruction, reportedDiagnosticMap, in, out, lexicalScopeVariableInfo);
                if (ctxt.variableDescriptor == null) {
                    return;
                }
                if (instruction instanceof ReadValueInstruction) {
                    ReadValueInstruction readValueInstruction = (ReadValueInstruction)instruction;
                    JetElement element = readValueInstruction.getElement();
                    boolean error = JetFlowInformationProvider.this.checkBackingField(ctxt, element);
                    if (!error && PseudocodeUtil.isThisOrNoDispatchReceiver(readValueInstruction, JetFlowInformationProvider.this.trace.getBindingContext()) && declaredVariables.contains(ctxt.variableDescriptor)) {
                        JetFlowInformationProvider.this.checkIsInitialized(ctxt, element, varWithUninitializedErrorGenerated);
                    }
                    return;
                }
                if (!(instruction instanceof WriteValueInstruction)) {
                    return;
                }
                WriteValueInstruction writeValueInstruction = (WriteValueInstruction)instruction;
                JetElement element = writeValueInstruction.getlValue();
                boolean error = JetFlowInformationProvider.this.checkBackingField(ctxt, element);
                if (!(element instanceof JetExpression)) {
                    return;
                }
                if (!error) {
                    error = JetFlowInformationProvider.this.checkValReassignment(ctxt, (JetExpression)element, writeValueInstruction, varWithValReassignErrorGenerated);
                }
                if (!error && processClassOrObject) {
                    error = JetFlowInformationProvider.this.checkAssignmentBeforeDeclaration(ctxt, (JetExpression)element);
                }
                if (!error && processClassOrObject) {
                    JetFlowInformationProvider.this.checkInitializationUsingBackingField(ctxt, (JetExpression)element);
                }
            }
        });
    }

    public void recordInitializedVariables() {
        PseudocodeVariablesData pseudocodeVariablesData = this.getPseudocodeVariablesData();
        Pseudocode pseudocode = pseudocodeVariablesData.getPseudocode();
        Map<Instruction, Edges<Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState>>> initializers = pseudocodeVariablesData.getVariableInitializers();
        this.recordInitializedVariables(pseudocode, initializers);
        for (LocalFunctionDeclarationInstruction instruction : pseudocode.getLocalDeclarations()) {
            this.recordInitializedVariables(instruction.getBody(), initializers);
        }
    }

    private void checkIsInitialized(@NotNull VariableInitContext ctxt, @NotNull JetElement element, @NotNull Collection<VariableDescriptor> varWithUninitializedErrorGenerated) {
        if (ctxt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctxt", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "checkIsInitialized"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "checkIsInitialized"));
        }
        if (varWithUninitializedErrorGenerated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varWithUninitializedErrorGenerated", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "checkIsInitialized"));
        }
        if (!(element instanceof JetSimpleNameExpression)) {
            return;
        }
        boolean isInitialized = ctxt.exitInitState.isInitialized;
        VariableDescriptor variableDescriptor = ctxt.variableDescriptor;
        if (variableDescriptor instanceof PropertyDescriptor && !this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)variableDescriptor).booleanValue()) {
            isInitialized = true;
        }
        if (!isInitialized && !varWithUninitializedErrorGenerated.contains(variableDescriptor)) {
            if (!(variableDescriptor instanceof PropertyDescriptor)) {
                varWithUninitializedErrorGenerated.add(variableDescriptor);
            }
            if (variableDescriptor instanceof ValueParameterDescriptor) {
                this.report(Errors.UNINITIALIZED_PARAMETER.on((JetSimpleNameExpression)element, (ValueParameterDescriptor)variableDescriptor), ctxt);
            } else {
                this.report(Errors.UNINITIALIZED_VARIABLE.on((JetSimpleNameExpression)element, variableDescriptor), ctxt);
            }
        }
    }

    private boolean checkValReassignment(@NotNull VariableInitContext ctxt, @NotNull JetExpression expression, @NotNull WriteValueInstruction writeValueInstruction, @NotNull Collection<VariableDescriptor> varWithValReassignErrorGenerated) {
        if (ctxt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctxt", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "checkValReassignment"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "checkValReassignment"));
        }
        if (writeValueInstruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writeValueInstruction", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "checkValReassignment"));
        }
        if (varWithValReassignErrorGenerated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varWithValReassignErrorGenerated", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "checkValReassignment"));
        }
        VariableDescriptor variableDescriptor = ctxt.variableDescriptor;
        if (JetPsiUtil.isBackingFieldReference(expression) && variableDescriptor instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor;
            JetPropertyAccessor accessor = PsiTreeUtil.getParentOfType((PsiElement)expression, JetPropertyAccessor.class);
            if (accessor != null) {
                DeclarationDescriptor accessorDescriptor = this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, accessor);
                if (propertyDescriptor.getGetter() == accessorDescriptor) {
                    return false;
                }
            }
        }
        boolean isInitializedNotHere = ctxt.enterInitState.isInitialized;
        boolean hasBackingField = true;
        if (variableDescriptor instanceof PropertyDescriptor) {
            hasBackingField = this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)variableDescriptor);
        }
        if (variableDescriptor.isVar() && variableDescriptor instanceof PropertyDescriptor) {
            DeclarationDescriptor descriptor = BindingContextUtils.getEnclosingDescriptor(this.trace.getBindingContext(), expression);
            PropertySetterDescriptor setterDescriptor = ((PropertyDescriptor)variableDescriptor).getSetter();
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression, this.trace.getBindingContext());
            ReceiverValue receiverValue = ReceiverValue.IRRELEVANT_RECEIVER;
            if (resolvedCall != null) {
                receiverValue = ExpressionTypingUtils.normalizeReceiverValueForVisibility(resolvedCall.getDispatchReceiver(), this.trace.getBindingContext());
            }
            if (Visibilities.isVisible(receiverValue, variableDescriptor, descriptor) && setterDescriptor != null && !Visibilities.isVisible(receiverValue, setterDescriptor, descriptor)) {
                this.report(Errors.INVISIBLE_SETTER.on(expression, variableDescriptor, setterDescriptor.getVisibility(), variableDescriptor.getContainingDeclaration()), ctxt);
                return true;
            }
        }
        boolean isThisOrNoDispatchReceiver = PseudocodeUtil.isThisOrNoDispatchReceiver(writeValueInstruction, this.trace.getBindingContext());
        if (!(!isInitializedNotHere && hasBackingField && isThisOrNoDispatchReceiver || variableDescriptor.isVar())) {
            boolean hasReassignMethodReturningUnit = false;
            JetSimpleNameExpression operationReference = null;
            PsiElement parent = expression.getParent();
            if (parent instanceof JetBinaryExpression) {
                operationReference = ((JetBinaryExpression)parent).getOperationReference();
            } else if (parent instanceof JetUnaryExpression) {
                operationReference = ((JetUnaryExpression)parent).getOperationReference();
            }
            if (operationReference != null) {
                Collection<? extends DeclarationDescriptor> descriptors;
                DeclarationDescriptor descriptor = this.trace.get(BindingContext.REFERENCE_TARGET, operationReference);
                if (descriptor instanceof FunctionDescriptor && KotlinBuiltIns.isUnit(((FunctionDescriptor)descriptor).getReturnType())) {
                    hasReassignMethodReturningUnit = true;
                }
                if (descriptor == null && (descriptors = this.trace.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, operationReference)) != null) {
                    for (DeclarationDescriptor declarationDescriptor : descriptors) {
                        if (!KotlinBuiltIns.isUnit(((FunctionDescriptor)declarationDescriptor).getReturnType())) continue;
                        hasReassignMethodReturningUnit = true;
                    }
                }
            }
            if (!hasReassignMethodReturningUnit) {
                if (!isThisOrNoDispatchReceiver || !varWithValReassignErrorGenerated.contains(variableDescriptor)) {
                    this.report(Errors.VAL_REASSIGNMENT.on(expression, variableDescriptor), ctxt);
                }
                if (isThisOrNoDispatchReceiver) {
                    varWithValReassignErrorGenerated.add(variableDescriptor);
                }
                return true;
            }
        }
        return false;
    }

    private boolean checkAssignmentBeforeDeclaration(@NotNull VariableInitContext ctxt, @NotNull JetExpression expression) {
        if (ctxt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctxt", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "checkAssignmentBeforeDeclaration"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "checkAssignmentBeforeDeclaration"));
        }
        if (!ctxt.enterInitState.isDeclared && !ctxt.exitInitState.isDeclared && !ctxt.enterInitState.isInitialized && ctxt.exitInitState.isInitialized) {
            this.report(Errors.INITIALIZATION_BEFORE_DECLARATION.on(expression, ctxt.variableDescriptor), ctxt);
            return true;
        }
        return false;
    }

    private boolean checkInitializationUsingBackingField(@NotNull VariableInitContext ctxt, @NotNull JetExpression expression) {
        if (ctxt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctxt", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "checkInitializationUsingBackingField"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "checkInitializationUsingBackingField"));
        }
        VariableDescriptor variableDescriptor = ctxt.variableDescriptor;
        if (variableDescriptor instanceof PropertyDescriptor && !ctxt.enterInitState.isInitialized && ctxt.exitInitState.isInitialized) {
            JetSimpleNameExpression simpleNameExpression;
            if (!variableDescriptor.isVar()) {
                return false;
            }
            if (!this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)variableDescriptor).booleanValue()) {
                return false;
            }
            PsiElement property2 = DescriptorToSourceUtils.descriptorToDeclaration(variableDescriptor);
            assert (property2 instanceof JetProperty);
            if (((PropertyDescriptor)variableDescriptor).getModality() == Modality.FINAL && ((JetProperty)property2).getSetter() == null) {
                return false;
            }
            JetExpression variable2 = expression;
            if (expression instanceof JetDotQualifiedExpression && ((JetDotQualifiedExpression)expression).getReceiverExpression() instanceof JetThisExpression) {
                variable2 = ((JetDotQualifiedExpression)expression).getSelectorExpression();
            }
            if (variable2 instanceof JetSimpleNameExpression && (simpleNameExpression = (JetSimpleNameExpression)variable2).getReferencedNameElementType() != JetTokens.FIELD_IDENTIFIER) {
                if (((PropertyDescriptor)variableDescriptor).getModality() != Modality.FINAL) {
                    this.report(Errors.INITIALIZATION_USING_BACKING_FIELD_OPEN_SETTER.on(expression, variableDescriptor), ctxt);
                } else {
                    this.report(Errors.INITIALIZATION_USING_BACKING_FIELD_CUSTOM_SETTER.on(expression, variableDescriptor), ctxt);
                }
                return true;
            }
        }
        return false;
    }

    private boolean checkBackingField(@NotNull VariableContext cxtx, @NotNull JetElement element) {
        if (cxtx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cxtx", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "checkBackingField"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "checkBackingField"));
        }
        VariableDescriptor variableDescriptor = cxtx.variableDescriptor;
        boolean[] error = new boolean[1];
        if (!this.isCorrectBackingFieldReference(element, cxtx, error, true)) {
            return false;
        }
        if (error[0]) {
            return true;
        }
        if (!(variableDescriptor instanceof PropertyDescriptor)) {
            this.report(Errors.NOT_PROPERTY_BACKING_FIELD.on(element), cxtx);
            return true;
        }
        PsiElement property2 = DescriptorToSourceUtils.descriptorToDeclaration(variableDescriptor);
        boolean insideSelfAccessors = PsiTreeUtil.isAncestor(property2, element, false);
        if (!this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)variableDescriptor).booleanValue() && !insideSelfAccessors) {
            if (((PropertyDescriptor)variableDescriptor).getModality() == Modality.ABSTRACT) {
                this.report(Errors.NO_BACKING_FIELD_ABSTRACT_PROPERTY.on(element), cxtx);
            } else {
                this.report(Errors.NO_BACKING_FIELD_CUSTOM_ACCESSORS.on(element), cxtx);
            }
            return true;
        }
        if (insideSelfAccessors) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = BindingContextUtils.getEnclosingDescriptor(this.trace.getBindingContext(), element);
        DeclarationDescriptor containingDeclaration = variableDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor && DescriptorUtils.isAncestor(containingDeclaration, declarationDescriptor, false)) {
            return false;
        }
        this.report(Errors.INACCESSIBLE_BACKING_FIELD.on(element), cxtx);
        return true;
    }

    private boolean isCorrectBackingFieldReference(@Nullable JetElement element, VariableContext ctxt, boolean[] error, boolean reportError) {
        error[0] = false;
        if (JetPsiUtil.isBackingFieldReference(element)) {
            return true;
        }
        if (element instanceof JetDotQualifiedExpression && this.isCorrectBackingFieldReference(((JetDotQualifiedExpression)element).getSelectorExpression(), ctxt, error, false)) {
            if (((JetDotQualifiedExpression)element).getReceiverExpression() instanceof JetThisExpression) {
                return true;
            }
            error[0] = true;
            if (reportError) {
                this.report(Errors.INACCESSIBLE_BACKING_FIELD.on(element), ctxt);
            }
        }
        return false;
    }

    private void recordInitializedVariables(@NotNull Pseudocode pseudocode, @NotNull Map<Instruction, Edges<Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState>>> initializersMap) {
        if (pseudocode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pseudocode", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "recordInitializedVariables"));
        }
        if (initializersMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializersMap", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "recordInitializedVariables"));
        }
        Edges<Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState>> initializers = initializersMap.get(pseudocode.getExitInstruction());
        Set<VariableDescriptor> declaredVariables = this.getPseudocodeVariablesData().getDeclaredVariables(pseudocode, false);
        for (VariableDescriptor variable2 : declaredVariables) {
            PseudocodeVariablesData.VariableInitState variableInitState;
            if (!(variable2 instanceof PropertyDescriptor) || (variableInitState = initializers.getIncoming().get(variable2)) != null && variableInitState.isInitialized) continue;
            this.trace.record(BindingContext.IS_UNINITIALIZED, (PropertyDescriptor)variable2);
        }
    }

    public void markUnusedVariables() {
        final PseudocodeVariablesData pseudocodeVariablesData = this.getPseudocodeVariablesData();
        Map<Instruction, Edges<Map<VariableDescriptor, PseudocodeVariablesData.VariableUseState>>> variableStatusData = pseudocodeVariablesData.getVariableUseStatusData();
        final HashMap reportedDiagnosticMap = Maps.newHashMap();
        InstructionDataAnalyzeStrategy<Map<VariableDescriptor, PseudocodeVariablesData.VariableUseState>> variableStatusAnalyzeStrategy = new InstructionDataAnalyzeStrategy<Map<VariableDescriptor, PseudocodeVariablesData.VariableUseState>>(){

            @Override
            public void execute(@NotNull Instruction instruction, @Nullable Map<VariableDescriptor, PseudocodeVariablesData.VariableUseState> in, @Nullable Map<VariableDescriptor, PseudocodeVariablesData.VariableUseState> out) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$4", "execute"));
                }
                assert (in != null && out != null);
                VariableUseContext ctxt = new VariableUseContext(instruction, reportedDiagnosticMap, in, out);
                Set<VariableDescriptor> declaredVariables = pseudocodeVariablesData.getDeclaredVariables(instruction.getOwner(), false);
                VariableDescriptor variableDescriptor = PseudocodeUtil.extractVariableDescriptorIfAny(instruction, false, JetFlowInformationProvider.this.trace.getBindingContext());
                if (variableDescriptor == null || !declaredVariables.contains(variableDescriptor) || !ExpressionTypingUtils.isLocal(variableDescriptor.getContainingDeclaration(), variableDescriptor)) {
                    return;
                }
                PseudocodeVariablesData.VariableUseState variableUseState = in.get(variableDescriptor);
                if (instruction instanceof WriteValueInstruction) {
                    if (JetFlowInformationProvider.this.trace.get(BindingContext.CAPTURED_IN_CLOSURE, variableDescriptor) != null) {
                        return;
                    }
                    JetElement element = ((WriteValueInstruction)instruction).getElement();
                    if (variableUseState != PseudocodeVariablesData.VariableUseState.READ) {
                        IElementType operationToken;
                        if (element instanceof JetBinaryExpression && ((JetBinaryExpression)element).getOperationToken() == JetTokens.EQ) {
                            JetExpression right = ((JetBinaryExpression)element).getRight();
                            if (right != null) {
                                JetFlowInformationProvider.this.report(Errors.UNUSED_VALUE.on((JetBinaryExpression)element, right, variableDescriptor), ctxt);
                            }
                        } else if (element instanceof JetPostfixExpression && ((operationToken = ((JetPostfixExpression)element).getOperationReference().getReferencedNameElementType()) == JetTokens.PLUSPLUS || operationToken == JetTokens.MINUSMINUS)) {
                            JetFlowInformationProvider.this.report(Errors.UNUSED_CHANGED_VALUE.on(element, element), ctxt);
                        }
                    }
                } else if (instruction instanceof VariableDeclarationInstruction) {
                    JetDeclaration element = ((VariableDeclarationInstruction)instruction).getVariableDeclarationElement();
                    if (!(element instanceof JetNamedDeclaration)) {
                        return;
                    }
                    PsiElement nameIdentifier = ((JetNamedDeclaration)element).getNameIdentifier();
                    if (nameIdentifier == null) {
                        return;
                    }
                    if (!PseudocodeVariablesData.VariableUseState.isUsed(variableUseState)) {
                        if (JetPsiUtil.isVariableNotParameterDeclaration(element)) {
                            JetFlowInformationProvider.this.report(Errors.UNUSED_VARIABLE.on((JetNamedDeclaration)element, variableDescriptor), ctxt);
                        } else if (element instanceof JetParameter) {
                            PsiElement owner = element.getParent().getParent();
                            if (owner instanceof JetFunction) {
                                boolean isMain;
                                MainFunctionDetector mainFunctionDetector = new MainFunctionDetector(JetFlowInformationProvider.this.trace.getBindingContext());
                                boolean bl = isMain = owner instanceof JetNamedFunction && mainFunctionDetector.isMain((JetNamedFunction)owner);
                                if (owner instanceof JetFunctionLiteral) {
                                    return;
                                }
                                DeclarationDescriptor descriptor = JetFlowInformationProvider.this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, owner);
                                assert (descriptor instanceof FunctionDescriptor) : owner.getText();
                                FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
                                String functionName = functionDescriptor.getName().asString();
                                if (isMain || functionDescriptor.getModality().isOverridable() || !functionDescriptor.getOverriddenDescriptors().isEmpty() || "get".equals(functionName) || "set".equals(functionName) || "propertyDelegated".equals(functionName)) {
                                    return;
                                }
                                JetFlowInformationProvider.this.report(Errors.UNUSED_PARAMETER.on((JetParameter)element, variableDescriptor), ctxt);
                            } else if (owner instanceof JetPrimaryConstructor && !((JetParameter)element).hasValOrVarNode() && !((JetPrimaryConstructor)owner).getContainingClass().isAnnotation()) {
                                JetFlowInformationProvider.this.report(Errors.UNUSED_PARAMETER.on((JetParameter)element, variableDescriptor), ctxt);
                            }
                        }
                    } else if (variableUseState == PseudocodeVariablesData.VariableUseState.ONLY_WRITTEN_NEVER_READ && JetPsiUtil.isVariableNotParameterDeclaration(element)) {
                        JetFlowInformationProvider.this.report(Errors.ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE.on((JetNamedDeclaration)element, variableDescriptor), ctxt);
                    } else if (variableUseState == PseudocodeVariablesData.VariableUseState.WRITTEN_AFTER_READ && element instanceof JetVariableDeclaration) {
                        if (element instanceof JetProperty) {
                            JetExpression initializer = ((JetProperty)element).getInitializer();
                            if (initializer != null) {
                                JetFlowInformationProvider.this.report(Errors.VARIABLE_WITH_REDUNDANT_INITIALIZER.on(initializer, variableDescriptor), ctxt);
                            }
                        } else if (element instanceof JetMultiDeclarationEntry) {
                            JetFlowInformationProvider.this.report(Errors.VARIABLE_WITH_REDUNDANT_INITIALIZER.on(element, variableDescriptor), ctxt);
                        }
                    }
                }
            }
        };
        PseudocodeTraverserPackage.traverse(this.pseudocode, TraversalOrder.BACKWARD, variableStatusData, variableStatusAnalyzeStrategy);
    }

    public void markUnusedExpressions() {
        final HashMap reportedDiagnosticMap = Maps.newHashMap();
        PseudocodeTraverserPackage.traverse(this.pseudocode, TraversalOrder.FORWARD, (Function1<? super Instruction, ? extends Unit>)new FunctionVoid1<Instruction>(){

            @Override
            public void execute(@NotNull Instruction instruction) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$5", "execute"));
                }
                if (!(instruction instanceof JetElementInstruction)) {
                    return;
                }
                JetElement element = ((JetElementInstruction)instruction).getElement();
                if (!(element instanceof JetExpression)) {
                    return;
                }
                if (BindingContextUtilPackage.isUsedAsStatement((JetExpression)element, JetFlowInformationProvider.this.trace.getBindingContext()) && PseudocodePackage.getSideEffectFree(instruction)) {
                    VariableContext ctxt = new VariableContext(instruction, reportedDiagnosticMap);
                    JetFlowInformationProvider.this.report(element instanceof JetFunctionLiteralExpression ? Errors.UNUSED_FUNCTION_LITERAL.on((JetFunctionLiteralExpression)element) : Errors.UNUSED_EXPRESSION.on(element), ctxt);
                }
            }
        });
    }

    public void markStatements() {
        PseudocodeTraverserPackage.traverse(this.pseudocode, TraversalOrder.FORWARD, (Function1<? super Instruction, ? extends Unit>)new FunctionVoid1<Instruction>(){

            @Override
            public void execute(@NotNull Instruction instruction) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$6", "execute"));
                }
                PseudoValue value = instruction instanceof InstructionWithValue ? ((InstructionWithValue)instruction).getOutputValue() : null;
                Pseudocode pseudocode = instruction.getOwner();
                boolean isUsedAsExpression = !pseudocode.getUsages(value).isEmpty();
                for (JetElement jetElement : pseudocode.getValueElements(value)) {
                    JetFlowInformationProvider.this.trace.record(BindingContext.USED_AS_EXPRESSION, jetElement, isUsedAsExpression);
                }
            }
        });
    }

    public void markWhenWithoutElse() {
        PseudocodeTraverserPackage.traverse(this.pseudocode, TraversalOrder.FORWARD, (Function1<? super Instruction, ? extends Unit>)new FunctionVoid1<Instruction>(){

            @Override
            public void execute(@NotNull Instruction instruction) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$7", "execute"));
                }
                PseudoValue value = instruction instanceof InstructionWithValue ? ((InstructionWithValue)instruction).getOutputValue() : null;
                for (JetElement jetElement : instruction.getOwner().getValueElements(value)) {
                    JetWhenExpression whenExpression;
                    if (!(jetElement instanceof JetWhenExpression) || (whenExpression = (JetWhenExpression)jetElement).getElseExpression() != null || !WhenChecker.mustHaveElse(whenExpression, JetFlowInformationProvider.this.trace)) continue;
                    JetFlowInformationProvider.this.trace.report(Errors.NO_ELSE_IN_WHEN.on(whenExpression));
                }
            }
        });
    }

    public void markTailCalls() {
        final DeclarationDescriptor subroutineDescriptor = this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, this.subroutine);
        if (!(subroutineDescriptor instanceof FunctionDescriptor)) {
            return;
        }
        if (!KotlinBuiltIns.isTailRecursive(subroutineDescriptor)) {
            return;
        }
        final HashMap calls = new HashMap();
        PseudocodeTraverserPackage.traverse(this.pseudocode, TraversalOrder.FORWARD, (Function1<? super Instruction, ? extends Unit>)new FunctionVoid1<Instruction>(){

            @Override
            public void execute(@NotNull Instruction instruction) {
                class KindAndCall {
                    TailRecursionKind kind;
                    ResolvedCall<?> call;

                    KindAndCall(TailRecursionKind kind, ResolvedCall<?> call) {
                        this.kind = kind;
                        this.call = call;
                    }
                }
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$8", "execute"));
                }
                if (!(instruction instanceof CallInstruction)) {
                    return;
                }
                CallInstruction callInstruction = (CallInstruction)instruction;
                ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(callInstruction.getElement(), JetFlowInformationProvider.this.trace.getBindingContext());
                if (resolvedCall == null) {
                    return;
                }
                CallableDescriptor functionDescriptor = resolvedCall.getResultingDescriptor();
                if (!functionDescriptor.getOriginal().equals(subroutineDescriptor)) {
                    return;
                }
                JetElement element = callInstruction.getElement();
                JetExpression parent = (JetExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JetTryExpression.class, JetFunction.class, JetClassInitializer.class);
                if (parent instanceof JetTryExpression) {
                    calls.put(element, new KindAndCall(TailRecursionKind.IN_TRY, resolvedCall));
                    return;
                }
                boolean isTail = PseudocodeTraverserPackage.traverseFollowingInstructions(callInstruction, new HashSet<Instruction>(), TraversalOrder.FORWARD, new TailRecursionDetector(JetFlowInformationProvider.this.subroutine, callInstruction));
                boolean sameDispatchReceiver = ResolvedCallUtilPackage.hasThisOrNoDispatchReceiver(resolvedCall, JetFlowInformationProvider.this.trace.getBindingContext());
                TailRecursionKind kind = isTail && sameDispatchReceiver ? TailRecursionKind.TAIL_CALL : TailRecursionKind.NON_TAIL;
                KindAndCall kindAndCall = (KindAndCall)calls.get(element);
                calls.put(element, new KindAndCall(JetFlowInformationProvider.combineKinds(kind, kindAndCall == null ? null : kindAndCall.kind), resolvedCall));
            }
        });
        boolean hasTailCalls = false;
        for (Map.Entry entry : calls.entrySet()) {
            JetElement element = (JetElement)entry.getKey();
            KindAndCall kindAndCall = (KindAndCall)entry.getValue();
            switch (kindAndCall.kind) {
                case TAIL_CALL: {
                    this.trace.record(BindingContext.TAIL_RECURSION_CALL, kindAndCall.call, TailRecursionKind.TAIL_CALL);
                    hasTailCalls = true;
                    break;
                }
                case IN_TRY: {
                    this.trace.report(Errors.TAIL_RECURSION_IN_TRY_IS_NOT_SUPPORTED.on(element));
                    break;
                }
                case NON_TAIL: {
                    this.trace.report(Errors.NON_TAIL_RECURSIVE_CALL.on(element));
                }
            }
        }
        if (!hasTailCalls) {
            this.trace.report(Errors.NO_TAIL_CALLS_FOUND.on((JetNamedFunction)this.subroutine));
        }
    }

    private static TailRecursionKind combineKinds(TailRecursionKind kind, @Nullable TailRecursionKind existingKind) {
        TailRecursionKind resultingKind = existingKind == null || existingKind == kind ? kind : (JetFlowInformationProvider.check((Object)kind, (Object)existingKind, (Object)TailRecursionKind.IN_TRY, (Object)TailRecursionKind.TAIL_CALL) ? TailRecursionKind.IN_TRY : (JetFlowInformationProvider.check((Object)kind, (Object)existingKind, (Object)TailRecursionKind.IN_TRY, (Object)TailRecursionKind.NON_TAIL) ? TailRecursionKind.IN_TRY : TailRecursionKind.NON_TAIL));
        return resultingKind;
    }

    private static boolean check(Object a, Object b, Object x, Object y) {
        return a == x && b == y || a == y && b == x;
    }

    private void report(@NotNull Diagnostic diagnostic, @NotNull VariableContext ctxt) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "report"));
        }
        if (ctxt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctxt", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "report"));
        }
        Instruction instruction = ctxt.instruction;
        if (instruction.getCopies().isEmpty()) {
            this.trace.report(diagnostic);
            return;
        }
        Map<Instruction, DiagnosticFactory<?>> previouslyReported = ctxt.reportedDiagnosticMap;
        previouslyReported.put(instruction, diagnostic.getFactory());
        boolean alreadyReported = false;
        boolean sameErrorForAllCopies = true;
        for (Instruction copy2 : instruction.getCopies()) {
            DiagnosticFactory<?> previouslyReportedErrorFactory = previouslyReported.get(copy2);
            if (previouslyReportedErrorFactory != null) {
                alreadyReported = true;
            }
            if (previouslyReportedErrorFactory == diagnostic.getFactory()) continue;
            sameErrorForAllCopies = false;
        }
        if (JetFlowInformationProvider.mustBeReportedOnAllCopies(diagnostic.getFactory())) {
            if (sameErrorForAllCopies) {
                this.trace.report(diagnostic);
            }
        } else if (!alreadyReported) {
            this.trace.report(diagnostic);
        }
    }

    private static boolean mustBeReportedOnAllCopies(@NotNull DiagnosticFactory<?> diagnosticFactory) {
        if (diagnosticFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticFactory", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider", "mustBeReportedOnAllCopies"));
        }
        return diagnosticFactory == Errors.UNUSED_VARIABLE || diagnosticFactory == Errors.UNUSED_PARAMETER || diagnosticFactory == Errors.UNUSED_CHANGED_VALUE;
    }

    public static abstract class FunctionVoid1<P>
    implements Function1<P, Unit> {
        @Override
        public Unit invoke(P p) {
            this.execute(p);
            return Unit.INSTANCE$;
        }

        public abstract void execute(P var1);
    }

    public static abstract class InstructionDataAnalyzeStrategy<D>
    implements Function3<Instruction, D, D, Unit> {
        @Override
        public Unit invoke(Instruction instruction, D enterData, D exitData) {
            this.execute(instruction, enterData, exitData);
            return Unit.INSTANCE$;
        }

        public abstract void execute(Instruction var1, D var2, D var3);
    }

    private class VariableUseContext
    extends VariableContext {
        final PseudocodeVariablesData.VariableUseState enterUseState;
        final PseudocodeVariablesData.VariableUseState exitUseState;

        private VariableUseContext(@NotNull Instruction instruction, @NotNull Map<Instruction, DiagnosticFactory<?>> map, @NotNull Map<VariableDescriptor, PseudocodeVariablesData.VariableUseState> in, @NotNull Map<VariableDescriptor, PseudocodeVariablesData.VariableUseState> out) {
            if (instruction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$VariableUseContext", "<init>"));
            }
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$VariableUseContext", "<init>"));
            }
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$VariableUseContext", "<init>"));
            }
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$VariableUseContext", "<init>"));
            }
            super(instruction, map);
            this.enterUseState = this.variableDescriptor != null ? in.get(this.variableDescriptor) : null;
            this.exitUseState = this.variableDescriptor != null ? out.get(this.variableDescriptor) : null;
        }
    }

    private class VariableInitContext
    extends VariableContext {
        final PseudocodeVariablesData.VariableInitState enterInitState;
        final PseudocodeVariablesData.VariableInitState exitInitState;

        private VariableInitContext(@NotNull Instruction instruction, @NotNull Map<Instruction, DiagnosticFactory<?>> map, @NotNull Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState> in, @NotNull Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState> out, @NotNull LexicalScopeVariableInfo lexicalScopeVariableInfo) {
            if (instruction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$VariableInitContext", "<init>"));
            }
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$VariableInitContext", "<init>"));
            }
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$VariableInitContext", "<init>"));
            }
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$VariableInitContext", "<init>"));
            }
            if (lexicalScopeVariableInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexicalScopeVariableInfo", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$VariableInitContext", "<init>"));
            }
            super(instruction, map);
            this.enterInitState = this.initialize(this.variableDescriptor, lexicalScopeVariableInfo, in);
            this.exitInitState = this.initialize(this.variableDescriptor, lexicalScopeVariableInfo, out);
        }

        private PseudocodeVariablesData.VariableInitState initialize(VariableDescriptor variableDescriptor, LexicalScopeVariableInfo lexicalScopeVariableInfo, Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState> map) {
            if (variableDescriptor == null) {
                return null;
            }
            PseudocodeVariablesData.VariableInitState state = map.get(variableDescriptor);
            if (state != null) {
                return state;
            }
            return PseudocodeVariablesData.getDefaultValueForInitializers(variableDescriptor, this.instruction, lexicalScopeVariableInfo);
        }
    }

    private class VariableContext {
        final Map<Instruction, DiagnosticFactory<?>> reportedDiagnosticMap;
        final Instruction instruction;
        final VariableDescriptor variableDescriptor;

        private VariableContext(@NotNull Instruction instruction, @NotNull Map<Instruction, DiagnosticFactory<?>> map) {
            if (instruction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$VariableContext", "<init>"));
            }
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/cfg/JetFlowInformationProvider$VariableContext", "<init>"));
            }
            this.instruction = instruction;
            this.reportedDiagnosticMap = map;
            this.variableDescriptor = PseudocodeUtil.extractVariableDescriptorIfAny(instruction, true, JetFlowInformationProvider.this.trace.getBindingContext());
        }
    }
}

