/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import com.intellij.util.SmartList;
import com.sampullara.cli.Argument;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.ValueDescription;

public abstract class CommonCompilerArguments {
    public static final String PLUGIN_OPTION_FORMAT = "plugin:<pluginId>:<optionName>=<value>";
    @Argument(value="nowarn", description="Generate no warnings")
    public boolean suppressWarnings;
    @Argument(value="verbose", description="Enable verbose logging output")
    public boolean verbose;
    @Argument(value="version", description="Display compiler version")
    public boolean version;
    @Argument(value="help", alias="h", description="Print a synopsis of standard options")
    public boolean help;
    @Argument(value="X", description="Print a synopsis of advanced options")
    public boolean extraHelp;
    @Argument(value="Xno-inline", description="Disable method inlining")
    public boolean noInline;
    @Argument(value="Xplugin", description="Load plugins from the given classpath")
    @ValueDescription(value="<path>")
    public String[] pluginClasspaths;
    @Argument(value="P", description="\n                             Pass an option to a plugin")
    @ValueDescription(value="plugin:<pluginId>:<optionName>=<value>")
    public String[] pluginOptions;
    public List<String> freeArgs = new SmartList<String>();

    @NotNull
    public String executableScriptFileName() {
        if ("kotlinc" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments", "executableScriptFileName"));
        }
        return "kotlinc";
    }

    public static final class DummyImpl
    extends CommonCompilerArguments {
    }
}

