/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.ClassFileFactory;

public class GeneratedClassLoader
extends URLClassLoader {
    private ClassFileFactory factory;

    public GeneratedClassLoader(@NotNull ClassFileFactory factory, ClassLoader parentClassLoader, URL ... urls) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/codegen/GeneratedClassLoader", "<init>"));
        }
        super(urls, parentClassLoader);
        this.factory = factory;
    }

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/GeneratedClassLoader", "findClass"));
        }
        String classFilePath = name.replace('.', '/') + ".class";
        OutputFile outputFile = this.factory.get(classFilePath);
        if (outputFile != null) {
            String pkgName;
            byte[] bytes = outputFile.asByteArray();
            int lastDot = name.lastIndexOf(46);
            if (lastDot >= 0 && this.getPackage(pkgName = name.substring(0, lastDot)) == null) {
                this.definePackage(pkgName, new Manifest(), null);
            }
            Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/GeneratedClassLoader", "findClass"));
            }
            return clazz;
        }
        Class<?> clazz = super.findClass(name);
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/GeneratedClassLoader", "findClass"));
        }
        return clazz;
    }

    public void dispose() {
        this.factory = null;
    }

    @NotNull
    public List<OutputFile> getAllGeneratedFiles() {
        List<OutputFile> list = this.factory.asList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/GeneratedClassLoader", "getAllGeneratedFiles"));
        }
        return list;
    }
}

