/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.codegen.inline.CapturedParamDesc;
import org.jetbrains.kotlin.codegen.inline.CapturedParamInfo;
import org.jetbrains.kotlin.codegen.inline.CapturedParamOwner;
import org.jetbrains.kotlin.codegen.inline.FieldRemapper;
import org.jetbrains.kotlin.codegen.inline.InlineCodegen;
import org.jetbrains.kotlin.codegen.inline.LabelOwner;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.kotlin.codegen.inline.ParametersBuilder;
import org.jetbrains.kotlin.codegen.inline.SMAPAndMethodNode;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;

public class LambdaInfo
implements CapturedParamOwner,
LabelOwner {
    public final JetExpression expression;
    private final JetTypeMapper typeMapper;
    @NotNull
    public final Set<String> labels;
    private final CalculatedClosure closure;
    private SMAPAndMethodNode node;
    private List<CapturedParamDesc> capturedVars;
    private final FunctionDescriptor functionDescriptor;
    private final ClassDescriptor classDescriptor;
    private final Type closureClassType;

    LambdaInfo(@NotNull JetExpression expr, @NotNull JetTypeMapper typeMapper) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "<init>"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "<init>"));
        }
        this.expression = expr instanceof JetFunctionLiteralExpression ? ((JetFunctionLiteralExpression)expr).getFunctionLiteral() : expr;
        this.typeMapper = typeMapper;
        BindingContext bindingContext = typeMapper.getBindingContext();
        this.functionDescriptor = bindingContext.get(BindingContext.FUNCTION, this.expression);
        assert (this.functionDescriptor != null) : "Function is not resolved to descriptor: " + this.expression.getText();
        this.classDescriptor = CodegenBinding.anonymousClassForFunction(bindingContext, this.functionDescriptor);
        this.closureClassType = CodegenBinding.asmTypeForAnonymousClass(bindingContext, this.functionDescriptor);
        this.closure = bindingContext.get(CodegenBinding.CLOSURE, this.classDescriptor);
        assert (this.closure != null) : "Closure for lambda should be not null " + this.expression.getText();
        this.labels = InlineCodegen.getDeclarationLabels(expr, this.functionDescriptor);
    }

    public SMAPAndMethodNode getNode() {
        return this.node;
    }

    public void setNode(SMAPAndMethodNode node) {
        this.node = node;
    }

    public FunctionDescriptor getFunctionDescriptor() {
        return this.functionDescriptor;
    }

    public JetExpression getFunctionWithBodyOrCallableReference() {
        return this.expression;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    public Type getLambdaClassType() {
        return this.closureClassType;
    }

    public List<CapturedParamDesc> getCapturedVars() {
        if (this.capturedVars == null) {
            EnclosedValueDescriptor descriptor2;
            Type type2;
            this.capturedVars = new ArrayList<CapturedParamDesc>();
            if (this.closure.getCaptureThis() != null) {
                type2 = this.typeMapper.mapType(this.closure.getCaptureThis());
                descriptor2 = new EnclosedValueDescriptor("this$0", null, StackValue.field(type2, this.closureClassType, "this$0", false, StackValue.LOCAL_0), type2);
                this.capturedVars.add(this.getCapturedParamInfo(descriptor2));
            }
            if (this.closure.getCaptureReceiverType() != null) {
                type2 = this.typeMapper.mapType(this.closure.getCaptureReceiverType());
                descriptor2 = new EnclosedValueDescriptor("receiver$0", null, StackValue.field(type2, this.closureClassType, "receiver$0", false, StackValue.LOCAL_0), type2);
                this.capturedVars.add(this.getCapturedParamInfo(descriptor2));
            }
            for (EnclosedValueDescriptor descriptor2 : this.closure.getCaptureVariables().values()) {
                this.capturedVars.add(this.getCapturedParamInfo(descriptor2));
            }
        }
        return this.capturedVars;
    }

    @NotNull
    private CapturedParamDesc getCapturedParamInfo(@NotNull EnclosedValueDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "getCapturedParamInfo"));
        }
        CapturedParamDesc capturedParamDesc = CapturedParamDesc.createDesc(this, descriptor.getFieldName(), descriptor.getType());
        if (capturedParamDesc == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "getCapturedParamInfo"));
        }
        return capturedParamDesc;
    }

    @NotNull
    public List<Type> getInvokeParamsWithoutCaptured() {
        Type[] types = this.typeMapper.mapSignature(this.functionDescriptor).getAsmMethod().getArgumentTypes();
        List<Type> list = Arrays.asList(types);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "getInvokeParamsWithoutCaptured"));
        }
        return list;
    }

    @NotNull
    public Parameters addAllParameters(FieldRemapper remapper) {
        ParametersBuilder builder = ParametersBuilder.newBuilder();
        builder.addThis(AsmTypes.OBJECT_TYPE, true).setLambda(this);
        List<ValueParameterDescriptor> valueParameters = this.getFunctionDescriptor().getValueParameters();
        for (ValueParameterDescriptor parameter : valueParameters) {
            Type type2 = this.typeMapper.mapType(parameter.getType());
            builder.addNextParameter(type2, false, null);
        }
        for (CapturedParamDesc info : this.getCapturedVars()) {
            CapturedParamInfo field = remapper.findField(new FieldInsnNode(0, info.getContainingLambdaName(), info.getFieldName(), ""));
            builder.addCapturedParam(field, info.getFieldName());
        }
        Parameters parameters2 = builder.buildParameters();
        if (parameters2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "addAllParameters"));
        }
        return parameters2;
    }

    @Override
    public Type getType() {
        return this.closureClassType;
    }

    @Override
    public boolean isMyLabel(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "isMyLabel"));
        }
        return this.labels.contains(name);
    }
}

