/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetDelegationSpecifierList;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetObjectDeclarationName;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetPrimaryConstructor;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

public class JetClass
extends JetTypeParameterListOwnerStub<KotlinClassStub>
implements JetClassOrObject {
    public JetClass(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetClass", "<init>"));
        }
        super(node);
    }

    public JetClass(@NotNull KotlinClassStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetClass", "<init>"));
        }
        super(stub, JetStubElementTypes.CLASS);
    }

    @Override
    @NotNull
    public List<JetDeclaration> getDeclarations() {
        JetClassBody body = this.getBody();
        if (body == null) {
            List<JetDeclaration> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClass", "getDeclarations"));
            }
            return list;
        }
        List<JetDeclaration> list = body.getDeclarations();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClass", "getDeclarations"));
        }
        return list;
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetClass", "accept"));
        }
        return visitor2.visitClass(this, data2);
    }

    @Nullable
    public JetPrimaryConstructor getPrimaryConstructor() {
        return (JetPrimaryConstructor)this.getStubOrPsiChild(JetStubElementTypes.PRIMARY_CONSTRUCTOR);
    }

    @Nullable
    public JetParameterList getPrimaryConstructorParameterList() {
        JetPrimaryConstructor primaryConstructor2 = this.getPrimaryConstructor();
        return primaryConstructor2 != null ? primaryConstructor2.getValueParameterList() : null;
    }

    @NotNull
    public List<JetParameter> getPrimaryConstructorParameters() {
        JetParameterList list = this.getPrimaryConstructorParameterList();
        if (list == null) {
            List<JetParameter> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClass", "getPrimaryConstructorParameters"));
            }
            return list2;
        }
        List<JetParameter> list3 = list.getParameters();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClass", "getPrimaryConstructorParameters"));
        }
        return list3;
    }

    @NotNull
    public JetPrimaryConstructor createPrimaryConstructorIfAbsent() {
        JetPrimaryConstructor constructor2 = this.getPrimaryConstructor();
        if (constructor2 != null) {
            JetPrimaryConstructor jetPrimaryConstructor = constructor2;
            if (jetPrimaryConstructor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClass", "createPrimaryConstructorIfAbsent"));
            }
            return jetPrimaryConstructor;
        }
        PsiElement anchor2 = this.getTypeParameterList();
        if (anchor2 == null) {
            anchor2 = this.getNameIdentifier();
        }
        if (anchor2 == null) {
            anchor2 = this.getLastChild();
        }
        JetPrimaryConstructor jetPrimaryConstructor = (JetPrimaryConstructor)this.addAfter(new JetPsiFactory(this.getProject()).createPrimaryConstructor(), anchor2);
        if (jetPrimaryConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClass", "createPrimaryConstructorIfAbsent"));
        }
        return jetPrimaryConstructor;
    }

    @NotNull
    public JetParameterList createPrimaryConstructorParameterListIfAbsent() {
        JetPrimaryConstructor constructor2 = this.createPrimaryConstructorIfAbsent();
        JetParameterList parameterList = constructor2.getValueParameterList();
        if (parameterList != null) {
            JetParameterList jetParameterList = parameterList;
            if (jetParameterList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClass", "createPrimaryConstructorParameterListIfAbsent"));
            }
            return jetParameterList;
        }
        JetParameterList jetParameterList = (JetParameterList)constructor2.add(new JetPsiFactory(this.getProject()).createParameterList("()"));
        if (jetParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClass", "createPrimaryConstructorParameterListIfAbsent"));
        }
        return jetParameterList;
    }

    @Override
    @Nullable
    public JetDelegationSpecifierList getDelegationSpecifierList() {
        return (JetDelegationSpecifierList)this.getStubOrPsiChild(JetStubElementTypes.DELEGATION_SPECIFIER_LIST);
    }

    @Override
    @NotNull
    public List<JetDelegationSpecifier> getDelegationSpecifiers() {
        JetDelegationSpecifierList list = this.getDelegationSpecifierList();
        List<JetDelegationSpecifier> list2 = list != null ? list.getDelegationSpecifiers() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClass", "getDelegationSpecifiers"));
        }
        return list2;
    }

    @Nullable
    public JetModifierList getPrimaryConstructorModifierList() {
        JetPrimaryConstructor primaryConstructor2 = this.getPrimaryConstructor();
        return primaryConstructor2 != null ? primaryConstructor2.getModifierList() : null;
    }

    @Override
    @NotNull
    public List<JetClassInitializer> getAnonymousInitializers() {
        JetClassBody body = this.getBody();
        if (body == null) {
            List<JetClassInitializer> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClass", "getAnonymousInitializers"));
            }
            return list;
        }
        List<JetClassInitializer> list = body.getAnonymousInitializers();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClass", "getAnonymousInitializers"));
        }
        return list;
    }

    public boolean hasExplicitPrimaryConstructor() {
        return this.getPrimaryConstructor() != null;
    }

    @Override
    public JetObjectDeclarationName getNameAsDeclaration() {
        return (JetObjectDeclarationName)this.findChildByType(JetNodeTypes.OBJECT_DECLARATION_NAME);
    }

    @Override
    public JetClassBody getBody() {
        return (JetClassBody)this.getStubOrPsiChild(JetStubElementTypes.CLASS_BODY);
    }

    @Nullable
    public PsiElement getColon() {
        return this.findChildByType(JetTokens.COLON);
    }

    public List<JetProperty> getProperties() {
        JetClassBody body = this.getBody();
        if (body == null) {
            return Collections.emptyList();
        }
        return body.getProperties();
    }

    public boolean isInterface() {
        KotlinClassStub stub = (KotlinClassStub)this.getStub();
        if (stub != null) {
            return stub.isInterface();
        }
        return this.findChildByType(JetTokens.TRAIT_KEYWORD) != null || this.findChildByType(JetTokens.INTERFACE_KEYWORD) != null;
    }

    public boolean isEnum() {
        return this.hasModifier(JetTokens.ENUM_KEYWORD);
    }

    public boolean isAnnotation() {
        return this.hasModifier(JetTokens.ANNOTATION_KEYWORD);
    }

    public boolean isInner() {
        return this.hasModifier(JetTokens.INNER_KEYWORD);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        if (super.isEquivalentTo(another)) {
            return true;
        }
        if (another instanceof JetClass) {
            String fq1 = this.getQualifiedName();
            String fq2 = ((JetClass)another).getQualifiedName();
            return fq1 != null && fq2 != null && fq1.equals(fq2);
        }
        return false;
    }

    @Nullable
    private String getQualifiedName() {
        KotlinClassStub stub = (KotlinClassStub)this.getStub();
        if (stub != null) {
            FqName fqName2 = stub.getFqName();
            return fqName2 == null ? null : fqName2.asString();
        }
        ArrayList<String> parts = new ArrayList<String>();
        JetClassOrObject current = this;
        while (current != null) {
            parts.add(current.getName());
            current = PsiTreeUtil.getParentOfType((PsiElement)current, JetClassOrObject.class);
        }
        PsiFile file = this.getContainingFile();
        if (!(file instanceof JetFile)) {
            return null;
        }
        String fileQualifiedName = ((JetFile)file).getPackageFqName().asString();
        if (!fileQualifiedName.isEmpty()) {
            parts.add(fileQualifiedName);
        }
        Collections.reverse(parts);
        return StringUtil.join(parts, ".");
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public boolean isTopLevel() {
        return this.getContainingFile() == this.getParent();
    }

    @Override
    public boolean isLocal() {
        KotlinClassStub stub = (KotlinClassStub)this.getStub();
        if (stub != null) {
            return stub.isLocal();
        }
        return JetPsiUtil.isLocal(this);
    }

    @NotNull
    public List<JetObjectDeclaration> getCompanionObjects() {
        JetClassBody body = this.getBody();
        if (body == null) {
            List<JetObjectDeclaration> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClass", "getCompanionObjects"));
            }
            return list;
        }
        List<JetObjectDeclaration> list = body.getAllCompanionObjects();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClass", "getCompanionObjects"));
        }
        return list;
    }

    public boolean hasPrimaryConstructor() {
        return this.hasExplicitPrimaryConstructor() || !this.hasSecondaryConstructors();
    }

    private boolean hasSecondaryConstructors() {
        return !this.getSecondaryConstructors().isEmpty();
    }

    @NotNull
    public List<JetSecondaryConstructor> getSecondaryConstructors() {
        JetClassBody body = this.getBody();
        List<JetSecondaryConstructor> list = body != null ? body.getSecondaryConstructors() : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClass", "getSecondaryConstructors"));
        }
        return list;
    }

    @Nullable
    public PsiElement getClassOrInterfaceKeyword() {
        return this.findChildByType(TokenSet.create(JetTokens.CLASS_KEYWORD, JetTokens.INTERFACE_KEYWORD));
    }
}

