/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetDeclarationStub;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetStatementExpression;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

public class JetClassInitializer
extends JetDeclarationStub<KotlinPlaceHolderStub<JetClassInitializer>>
implements JetStatementExpression {
    public JetClassInitializer(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetClassInitializer", "<init>"));
        }
        super(node);
    }

    public JetClassInitializer(@NotNull KotlinPlaceHolderStub<JetClassInitializer> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetClassInitializer", "<init>"));
        }
        super(stub, JetStubElementTypes.ANONYMOUS_INITIALIZER);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetClassInitializer", "accept"));
        }
        return visitor2.visitAnonymousInitializer(this, data2);
    }

    @Nullable
    public JetExpression getBody() {
        return this.findChildByClass(JetExpression.class);
    }

    @Nullable
    public PsiElement getOpenBraceNode() {
        JetExpression body = this.getBody();
        return body instanceof JetBlockExpression ? ((JetBlockExpression)body).getLBrace() : null;
    }

    @NotNull
    public PsiElement getOpenBraceNodeOrSelf() {
        PsiElement result2 = this.getOpenBraceNode();
        PsiElement psiElement = result2 != null ? result2 : this;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClassInitializer", "getOpenBraceNodeOrSelf"));
        }
        return psiElement;
    }

    @Nullable
    public PsiElement getInitKeyword() {
        return this.findChildByType(JetTokens.INIT_KEYWORD);
    }
}

