/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclarationStub;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierPackage;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

public class JetPrimaryConstructor
extends JetDeclarationStub<KotlinPlaceHolderStub<JetPrimaryConstructor>> {
    public JetPrimaryConstructor(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetPrimaryConstructor", "<init>"));
        }
        super(node);
    }

    public JetPrimaryConstructor(@NotNull KotlinPlaceHolderStub<JetPrimaryConstructor> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetPrimaryConstructor", "<init>"));
        }
        super(stub, JetStubElementTypes.PRIMARY_CONSTRUCTOR);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetPrimaryConstructor", "accept"));
        }
        return visitor2.visitPrimaryConstructor(this, data2);
    }

    @Nullable
    public JetParameterList getValueParameterList() {
        return (JetParameterList)this.getStubOrPsiChild(JetStubElementTypes.VALUE_PARAMETER_LIST);
    }

    @NotNull
    public List<JetParameter> getValueParameters() {
        JetParameterList list = this.getValueParameterList();
        List<JetParameter> list2 = list != null ? list.getParameters() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPrimaryConstructor", "getValueParameters"));
        }
        return list2;
    }

    @Override
    public void addModifier(@NotNull JetModifierKeywordToken modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/kotlin/psi/JetPrimaryConstructor", "addModifier"));
        }
        JetModifierList modifierList = this.getModifierList();
        if (modifierList != null) {
            AddRemoveModifierPackage.addModifier(modifierList, modifier, JetTokens.PUBLIC_KEYWORD);
        } else {
            if (modifier == JetTokens.PUBLIC_KEYWORD) {
                return;
            }
            JetParameterList parameterList = this.getValueParameterList();
            assert (parameterList != null);
            JetPsiFactory psiFactory = new JetPsiFactory(this.getProject());
            JetModifierList newModifierList = psiFactory.createModifierList(modifier);
            this.addBefore(newModifierList, parameterList);
        }
    }

    @Nullable
    public JetClass getContainingClassOrNull() {
        JetClassOrObject classOrObject = (JetClassOrObject)this.getParent();
        return classOrObject instanceof JetClass ? (JetClass)classOrObject : null;
    }

    @NotNull
    public JetClass getContainingClass() {
        JetClass classOrNull = this.getContainingClassOrNull();
        assert (classOrNull != null) : "This method should be called when parent is JetClass";
        JetClass jetClass = classOrNull;
        if (jetClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPrimaryConstructor", "getContainingClass"));
        }
        return jetClass;
    }

    public boolean hasConstructorKeyword() {
        if (this.getStub() != null) {
            return true;
        }
        return this.getConstructorKeyword() != null;
    }

    @Nullable
    public PsiElement getConstructorKeyword() {
        return this.findChildByType(JetTokens.CONSTRUCTOR_KEYWORD);
    }
}

