/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyDelegate;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.AdditionalCheckerProvider;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TraceEntryFilter;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class DelegatedPropertyResolver {
    public static final Name PROPERTY_DELEGATED_FUNCTION_NAME = Name.identifier("propertyDelegated");
    private ExpressionTypingServices expressionTypingServices;
    private CallResolver callResolver;
    private KotlinBuiltIns builtIns;
    private AdditionalCheckerProvider additionalCheckerProvider;

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setCallResolver(@NotNull CallResolver callResolver) {
        if (callResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolver", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "setCallResolver"));
        }
        this.callResolver = callResolver;
    }

    @Inject
    public void setBuiltIns(@NotNull KotlinBuiltIns builtIns) {
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "setBuiltIns"));
        }
        this.builtIns = builtIns;
    }

    @Inject
    public void setAdditionalCheckerProvider(AdditionalCheckerProvider additionalCheckerProvider) {
        this.additionalCheckerProvider = additionalCheckerProvider;
    }

    @Nullable
    public JetType getDelegatedPropertyGetMethodReturnType(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression delegateExpression, @NotNull JetType delegateType, @NotNull BindingTrace trace, @NotNull JetScope scope2) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyGetMethodReturnType"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyGetMethodReturnType"));
        }
        if (delegateType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateType", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyGetMethodReturnType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyGetMethodReturnType"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyGetMethodReturnType"));
        }
        this.resolveDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, delegateType, trace, scope2, true);
        ResolvedCall<FunctionDescriptor> resolvedCall = trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, propertyDescriptor.getGetter());
        return resolvedCall != null ? resolvedCall.getResultingDescriptor().getReturnType() : null;
    }

    public void resolveDelegatedPropertyGetMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression delegateExpression, @NotNull JetType delegateType, @NotNull BindingTrace trace, @NotNull JetScope scope2) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyGetMethod"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyGetMethod"));
        }
        if (delegateType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateType", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyGetMethod"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyGetMethod"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyGetMethod"));
        }
        JetType returnType2 = this.getDelegatedPropertyGetMethodReturnType(propertyDescriptor, delegateExpression, delegateType, trace, scope2);
        JetType propertyType = propertyDescriptor.getType();
        if (!(propertyType instanceof DeferredType) && returnType2 != null && !JetTypeChecker.DEFAULT.isSubtypeOf(returnType2, propertyType)) {
            Call call = trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, propertyDescriptor.getGetter());
            assert (call != null) : "Call should exists for " + propertyDescriptor.getGetter();
            trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_RETURN_TYPE_MISMATCH.on(delegateExpression, this.renderCall(call, trace.getBindingContext()), propertyDescriptor.getType(), returnType2));
        }
    }

    public void resolveDelegatedPropertySetMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression delegateExpression, @NotNull JetType delegateType, @NotNull BindingTrace trace, @NotNull JetScope scope2) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertySetMethod"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertySetMethod"));
        }
        if (delegateType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateType", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertySetMethod"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertySetMethod"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertySetMethod"));
        }
        this.resolveDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, delegateType, trace, scope2, false);
    }

    @NotNull
    private JetExpression createExpressionForPropertyMetadata(@NotNull JetPsiFactory psiFactory, @NotNull PropertyDescriptor propertyDescriptor) {
        if (psiFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFactory", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "createExpressionForPropertyMetadata"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "createExpressionForPropertyMetadata"));
        }
        JetExpression jetExpression = psiFactory.createExpression(this.builtIns.getPropertyMetadataImpl().getName().asString() + "(\"" + propertyDescriptor.getName().asString() + "\"): " + this.builtIns.getPropertyMetadata().getName().asString());
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "createExpressionForPropertyMetadata"));
        }
        return jetExpression;
    }

    public void resolveDelegatedPropertyPDMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression delegateExpression, @NotNull JetType delegateType, @NotNull BindingTrace trace, @NotNull JetScope scope2) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyPDMethod"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyPDMethod"));
        }
        if (delegateType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateType", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyPDMethod"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyPDMethod"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyPDMethod"));
        }
        TemporaryBindingTrace traceToResolvePDMethod = TemporaryBindingTrace.create(trace, "Trace to resolve propertyDelegated method in delegated property");
        ExpressionTypingContext context2 = ExpressionTypingContext.newContext(this.additionalCheckerProvider, traceToResolvePDMethod, scope2, DataFlowInfo.EMPTY, TypeUtils.NO_EXPECTED_TYPE);
        ArrayList<JetExpression> arguments2 = Lists.newArrayList();
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory(delegateExpression);
        arguments2.add(this.createExpressionForPropertyMetadata(psiFactory, propertyDescriptor));
        JetSimpleNameExpression fakeCalleeExpression = psiFactory.createSimpleName(PROPERTY_DELEGATED_FUNCTION_NAME.asString());
        ExpressionReceiver receiver = new ExpressionReceiver(delegateExpression, delegateType);
        Call call = CallMaker.makeCallWithExpressions(fakeCalleeExpression, receiver, null, fakeCalleeExpression, arguments2, Call.CallType.DEFAULT);
        OverloadResolutionResults<FunctionDescriptor> functionResults = this.callResolver.resolveCallWithGivenName(context2, call, fakeCalleeExpression, PROPERTY_DELEGATED_FUNCTION_NAME);
        if (!functionResults.isSuccess()) {
            String expectedFunction = this.renderCall(call, traceToResolvePDMethod.getBindingContext());
            if (functionResults.isIncomplete() || functionResults.isSingleResult() || functionResults.getResultCode() == OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES) {
                trace.report(Errors.DELEGATE_PD_METHOD_NONE_APPLICABLE.on(delegateExpression, expectedFunction, functionResults.getResultingCalls()));
            } else if (functionResults.isAmbiguity()) {
                trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_AMBIGUITY.on(delegateExpression, expectedFunction, functionResults.getResultingCalls()));
            }
            return;
        }
        trace.record(BindingContext.DELEGATED_PROPERTY_PD_RESOLVED_CALL, propertyDescriptor, functionResults.getResultingCall());
    }

    private void resolveDelegatedPropertyConventionMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression delegateExpression, @NotNull JetType delegateType, @NotNull BindingTrace trace, @NotNull JetScope scope2, boolean isGet) {
        JetProperty property2;
        JetPropertyDelegate delegate2;
        PropertyAccessorDescriptor accessor;
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyConventionMethod"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyConventionMethod"));
        }
        if (delegateType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateType", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyConventionMethod"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyConventionMethod"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyConventionMethod"));
        }
        PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = isGet ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        assert (accessor != null) : "Delegated property should have getter/setter " + propertyDescriptor + " " + delegateExpression.getText();
        if (trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, accessor) != null) {
            return;
        }
        OverloadResolutionResults<FunctionDescriptor> functionResults = this.getDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, delegateType, trace, scope2, isGet, true);
        Call call = trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, accessor);
        assert (call != null) : "'getDelegatedPropertyConventionMethod' didn't record a call";
        if (!functionResults.isSuccess()) {
            String expectedFunction = this.renderCall(call, trace.getBindingContext());
            if (functionResults.isIncomplete()) {
                trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_MISSING.on(delegateExpression, expectedFunction, delegateType));
            } else if (functionResults.isSingleResult() || functionResults.getResultCode() == OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES) {
                trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE.on(delegateExpression, expectedFunction, functionResults.getResultingCalls()));
            } else if (functionResults.isAmbiguity()) {
                trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_AMBIGUITY.on(delegateExpression, expectedFunction, functionResults.getResultingCalls()));
            } else {
                trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_MISSING.on(delegateExpression, expectedFunction, delegateType));
            }
            return;
        }
        ResolvedCall<FunctionDescriptor> resultingCall = functionResults.getResultingCall();
        PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(propertyDescriptor);
        if (declaration instanceof JetProperty && (delegate2 = (property2 = (JetProperty)declaration).getDelegate()) != null) {
            PsiElement byKeyword = delegate2.getByKeywordNode().getPsi();
            this.additionalCheckerProvider.getSymbolUsageValidator().validateCall(resultingCall.getResultingDescriptor(), trace, byKeyword);
        }
        trace.record(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, accessor, resultingCall);
    }

    public OverloadResolutionResults<FunctionDescriptor> getDelegatedPropertyConventionMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression delegateExpression, @NotNull JetType delegateType, @NotNull BindingTrace trace, @NotNull JetScope scope2, boolean isGet, boolean isComplete) {
        PropertyAccessorDescriptor accessor;
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyConventionMethod"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyConventionMethod"));
        }
        if (delegateType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateType", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyConventionMethod"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyConventionMethod"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "getDelegatedPropertyConventionMethod"));
        }
        PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = isGet ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        assert (accessor != null) : "Delegated property should have getter/setter " + propertyDescriptor + " " + delegateExpression.getText();
        JetType expectedType = isComplete && isGet && !(propertyDescriptor.getType() instanceof DeferredType) ? propertyDescriptor.getType() : TypeUtils.NO_EXPECTED_TYPE;
        ExpressionTypingContext context2 = ExpressionTypingContext.newContext(this.additionalCheckerProvider, trace, scope2, DataFlowInfo.EMPTY, expectedType);
        boolean hasThis = propertyDescriptor.getExtensionReceiverParameter() != null || propertyDescriptor.getDispatchReceiverParameter() != null;
        ArrayList<JetExpression> arguments2 = Lists.newArrayList();
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory(delegateExpression);
        arguments2.add(psiFactory.createExpression(hasThis ? "this" : "null"));
        arguments2.add(this.createExpressionForPropertyMetadata(psiFactory, propertyDescriptor));
        if (!isGet) {
            JetReferenceExpression fakeArgument = (JetReferenceExpression)ExpressionTypingUtils.createFakeExpressionOfType(delegateExpression.getProject(), trace, "fakeArgument" + arguments2.size(), propertyDescriptor.getType());
            arguments2.add(fakeArgument);
            List<ValueParameterDescriptor> valueParameters = accessor.getValueParameters();
            trace.record(BindingContext.REFERENCE_TARGET, fakeArgument, valueParameters.get(0));
        }
        Name functionName = Name.identifier(isGet ? "get" : "set");
        JetSimpleNameExpression fakeCalleeExpression = psiFactory.createSimpleName(functionName.asString());
        ExpressionReceiver receiver = new ExpressionReceiver(delegateExpression, delegateType);
        Call call = CallMaker.makeCallWithExpressions(delegateExpression, receiver, null, fakeCalleeExpression, arguments2, Call.CallType.DEFAULT);
        trace.record(BindingContext.DELEGATED_PROPERTY_CALL, accessor, call);
        return this.callResolver.resolveCallWithGivenName(context2, call, fakeCalleeExpression, functionName);
    }

    private String renderCall(@NotNull Call call, @NotNull BindingContext context2) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "renderCall"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "renderCall"));
        }
        JetExpression calleeExpression = call.getCalleeExpression();
        assert (calleeExpression != null) : "CalleeExpression should exists for fake call of convention method";
        StringBuilder builder = new StringBuilder(calleeExpression.getText());
        builder.append("(");
        ArrayList<JetType> argumentTypes = Lists.newArrayList();
        for (ValueArgument valueArgument : call.getValueArguments()) {
            argumentTypes.add(context2.getType(valueArgument.getArgumentExpression()));
        }
        builder.append(Renderers.RENDER_COLLECTION_OF_TYPES.render(argumentTypes));
        builder.append(")");
        return builder.toString();
    }

    @Nullable
    public JetType resolveDelegateExpression(@NotNull JetExpression delegateExpression, @NotNull JetProperty jetProperty, @NotNull PropertyDescriptor propertyDescriptor, @NotNull JetScope propertyDeclarationInnerScope, @NotNull JetScope accessorScope, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        if (jetProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetProperty", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        if (propertyDeclarationInnerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDeclarationInnerScope", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        if (accessorScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessorScope", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        TemporaryBindingTrace traceToResolveDelegatedProperty = TemporaryBindingTrace.create(trace, "Trace to resolve delegated property");
        JetExpression calleeExpression = CallUtilPackage.getCalleeExpressionIfAny(delegateExpression);
        ConstraintSystemCompleter completer = this.createConstraintSystemCompleter(jetProperty, propertyDescriptor, delegateExpression, accessorScope, trace);
        if (calleeExpression != null) {
            traceToResolveDelegatedProperty.record(BindingContext.CONSTRAINT_SYSTEM_COMPLETER, calleeExpression, completer);
        }
        JetType delegateType = this.expressionTypingServices.safeGetType(propertyDeclarationInnerScope, delegateExpression, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, traceToResolveDelegatedProperty);
        traceToResolveDelegatedProperty.commit(new TraceEntryFilter(){

            @Override
            public boolean accept(@Nullable WritableSlice<?, ?> slice, Object key) {
                return slice != BindingContext.CONSTRAINT_SYSTEM_COMPLETER;
            }
        }, true);
        return delegateType;
    }

    @NotNull
    private ConstraintSystemCompleter createConstraintSystemCompleter(@NotNull JetProperty property2, final @NotNull PropertyDescriptor propertyDescriptor, final @NotNull JetExpression delegateExpression, final @NotNull JetScope accessorScope, final @NotNull BindingTrace trace) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "createConstraintSystemCompleter"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "createConstraintSystemCompleter"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "createConstraintSystemCompleter"));
        }
        if (accessorScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessorScope", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "createConstraintSystemCompleter"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "createConstraintSystemCompleter"));
        }
        final JetType expectedType = property2.getTypeReference() != null ? propertyDescriptor.getType() : TypeUtils.NO_EXPECTED_TYPE;
        ConstraintSystemCompleter constraintSystemCompleter = new ConstraintSystemCompleter(){

            @Override
            public void completeConstraintSystem(@NotNull ConstraintSystem constraintSystem, @NotNull ResolvedCall<?> resolvedCall) {
                FunctionDescriptor descriptor;
                List<ValueParameterDescriptor> valueParameters;
                if (constraintSystem == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver$2", "completeConstraintSystem"));
                }
                if (resolvedCall == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver$2", "completeConstraintSystem"));
                }
                JetType returnType2 = resolvedCall.getCandidateDescriptor().getReturnType();
                if (returnType2 == null) {
                    return;
                }
                TemporaryBindingTrace traceToResolveConventionMethods = TemporaryBindingTrace.create(trace, "Trace to resolve delegated property convention methods");
                OverloadResolutionResults<FunctionDescriptor> getMethodResults = DelegatedPropertyResolver.this.getDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, returnType2, traceToResolveConventionMethods, accessorScope, true, false);
                if (this.conventionMethodFound(getMethodResults)) {
                    FunctionDescriptor descriptor2 = getMethodResults.getResultingDescriptor();
                    JetType returnTypeOfGetMethod = descriptor2.getReturnType();
                    if (returnTypeOfGetMethod != null) {
                        constraintSystem.addSupertypeConstraint(expectedType, returnTypeOfGetMethod, ConstraintPositionKind.FROM_COMPLETER.position());
                    }
                    this.addConstraintForThisValue(constraintSystem, descriptor2);
                }
                if (!propertyDescriptor.isVar()) {
                    return;
                }
                if (propertyDescriptor.getReturnType() instanceof DeferredType) {
                    return;
                }
                OverloadResolutionResults<FunctionDescriptor> setMethodResults = DelegatedPropertyResolver.this.getDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, returnType2, traceToResolveConventionMethods, accessorScope, false, false);
                if (this.conventionMethodFound(setMethodResults) && (valueParameters = (descriptor = setMethodResults.getResultingDescriptor()).getValueParameters()).size() == 3) {
                    ValueParameterDescriptor valueParameterForThis = valueParameters.get(2);
                    if (!TypeUtils.noExpectedType(expectedType)) {
                        constraintSystem.addSubtypeConstraint(expectedType, valueParameterForThis.getType(), ConstraintPositionKind.FROM_COMPLETER.position());
                    }
                    this.addConstraintForThisValue(constraintSystem, descriptor);
                }
            }

            private boolean conventionMethodFound(@NotNull OverloadResolutionResults<FunctionDescriptor> results) {
                if (results == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver$2", "conventionMethodFound"));
                }
                return results.isSuccess() || results.isSingleResult() && results.getResultCode() == OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH;
            }

            private void addConstraintForThisValue(ConstraintSystem constraintSystem, FunctionDescriptor resultingDescriptor) {
                ReceiverParameterDescriptor extensionReceiver2 = propertyDescriptor.getExtensionReceiverParameter();
                ReceiverParameterDescriptor dispatchReceiver = propertyDescriptor.getDispatchReceiverParameter();
                JetType typeOfThis = extensionReceiver2 != null ? extensionReceiver2.getType() : (dispatchReceiver != null ? dispatchReceiver.getType() : DelegatedPropertyResolver.this.builtIns.getNullableNothingType());
                List<ValueParameterDescriptor> valueParameters = resultingDescriptor.getValueParameters();
                if (valueParameters.isEmpty()) {
                    return;
                }
                ValueParameterDescriptor valueParameterForThis = valueParameters.get(0);
                constraintSystem.addSubtypeConstraint(typeOfThis, valueParameterForThis.getType(), ConstraintPositionKind.FROM_COMPLETER.position());
            }
        };
        if (constraintSystemCompleter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DelegatedPropertyResolver", "createConstraintSystemCompleter"));
        }
        return constraintSystemCompleter;
    }
}

