/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.RedeclarationHandler;
import org.jetbrains.kotlin.resolve.scopes.WritableScope;
import org.jetbrains.kotlin.resolve.scopes.WritableScopeImpl;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;

public class FunctionDescriptorUtil {
    private static final TypeSubstitutor MAKE_TYPE_PARAMETERS_FRESH = TypeSubstitutor.create(new TypeSubstitution(){

        @Override
        public TypeProjection get(TypeConstructor key) {
            return null;
        }

        public String toString() {
            return "FunctionDescriptorUtil.MAKE_TYPE_PARAMETERS_FRESH";
        }
    });

    private FunctionDescriptorUtil() {
    }

    public static Map<TypeConstructor, TypeProjection> createSubstitutionContext(@NotNull FunctionDescriptor functionDescriptor, @NotNull List<JetType> typeArguments) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "createSubstitutionContext"));
        }
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "createSubstitutionContext"));
        }
        if (functionDescriptor.getTypeParameters().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<TypeConstructor, TypeProjection> result2 = new HashMap<TypeConstructor, TypeProjection>();
        List<TypeParameterDescriptor> typeParameters = functionDescriptor.getTypeParameters();
        assert (typeArguments.size() >= typeParameters.size()) : "Insufficient number of type arguments.\nType arguments: " + typeArguments + "\nType parameters: " + typeParameters;
        for (int i = 0; i < typeParameters.size(); ++i) {
            TypeParameterDescriptor typeParameterDescriptor = typeParameters.get(i);
            JetType typeArgument = typeArguments.get(i);
            result2.put(typeParameterDescriptor.getTypeConstructor(), new TypeProjectionImpl(typeArgument));
        }
        return result2;
    }

    @NotNull
    public static JetScope getFunctionInnerScope(@NotNull JetScope outerScope, @NotNull FunctionDescriptor descriptor, @NotNull BindingTrace trace) {
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        TraceBasedRedeclarationHandler redeclarationHandler = new TraceBasedRedeclarationHandler(trace);
        JetScope jetScope = FunctionDescriptorUtil.getFunctionInnerScope(outerScope, descriptor, redeclarationHandler);
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        return jetScope;
    }

    @NotNull
    public static JetScope getFunctionInnerScope(@NotNull JetScope outerScope, @NotNull FunctionDescriptor descriptor, @NotNull RedeclarationHandler redeclarationHandler) {
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        if (redeclarationHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "redeclarationHandler", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        WritableScopeImpl parameterScope = new WritableScopeImpl(outerScope, descriptor, redeclarationHandler, "Function inner scope");
        ReceiverParameterDescriptor receiver = descriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            parameterScope.setImplicitReceiver(receiver);
        }
        for (TypeParameterDescriptor typeParameter : descriptor.getTypeParameters()) {
            parameterScope.addClassifierDescriptor(typeParameter);
        }
        for (ValueParameterDescriptor valueParameterDescriptor : descriptor.getValueParameters()) {
            parameterScope.addVariableDescriptor(valueParameterDescriptor);
        }
        parameterScope.addLabeledDeclaration(descriptor);
        parameterScope.changeLockLevel(WritableScope.LockLevel.READING);
        WritableScopeImpl writableScopeImpl = parameterScope;
        if (writableScopeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        return writableScopeImpl;
    }

    public static void initializeFromFunctionType(@NotNull FunctionDescriptorImpl functionDescriptor, @NotNull JetType functionType, @Nullable ReceiverParameterDescriptor dispatchReceiverParameter, @NotNull Modality modality, @NotNull Visibility visibility) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "initializeFromFunctionType"));
        }
        if (functionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionType", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "initializeFromFunctionType"));
        }
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "initializeFromFunctionType"));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "initializeFromFunctionType"));
        }
        assert (KotlinBuiltIns.isFunctionOrExtensionFunctionType(functionType));
        functionDescriptor.initialize(KotlinBuiltIns.getReceiverType(functionType), dispatchReceiverParameter, Collections.emptyList(), KotlinBuiltIns.getValueParameters(functionDescriptor, functionType), KotlinBuiltIns.getReturnTypeFromFunctionType(functionType), modality, visibility);
    }

    public static <D extends CallableDescriptor> D alphaConvertTypeParameters(D candidate) {
        return (D)candidate.substitute(MAKE_TYPE_PARAMETERS_FRESH);
    }

    @NotNull
    public static FunctionDescriptor replaceFunctionParameters(@NotNull FunctionDescriptor function, @NotNull List<ValueParameterDescriptor> newParameters) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "replaceFunctionParameters"));
        }
        if (newParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParameters", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "replaceFunctionParameters"));
        }
        SimpleFunctionDescriptorImpl descriptor = SimpleFunctionDescriptorImpl.create(function.getContainingDeclaration(), function.getAnnotations(), function.getName(), function.getKind(), SourceElement.NO_SOURCE);
        ArrayList<ValueParameterDescriptor> parameters2 = new ArrayList<ValueParameterDescriptor>(newParameters.size());
        int idx = 0;
        for (ValueParameterDescriptor parameter : newParameters) {
            JetType returnType2 = parameter.getReturnType();
            assert (returnType2 != null);
            parameters2.add(new ValueParameterDescriptorImpl(descriptor, null, idx, parameter.getAnnotations(), parameter.getName(), returnType2, parameter.declaresDefaultValue(), parameter.getVarargElementType(), SourceElement.NO_SOURCE));
            ++idx;
        }
        ReceiverParameterDescriptor receiver = function.getExtensionReceiverParameter();
        ((FunctionDescriptorImpl)descriptor).initialize(receiver == null ? null : receiver.getType(), function.getDispatchReceiverParameter(), function.getTypeParameters(), parameters2, function.getReturnType(), function.getModality(), function.getVisibility());
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = descriptor;
        if (simpleFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "replaceFunctionParameters"));
        }
        return simpleFunctionDescriptorImpl;
    }
}

