/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetStubbedPsiUtil;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.AdditionalCheckerProvider;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.StringValue;

public class ModifiersChecker {
    private static final Collection<JetModifierKeywordToken> MODALITY_MODIFIERS = Lists.newArrayList(JetTokens.ABSTRACT_KEYWORD, JetTokens.OPEN_KEYWORD, JetTokens.FINAL_KEYWORD, JetTokens.OVERRIDE_KEYWORD);
    private static final Collection<JetModifierKeywordToken> VISIBILITY_MODIFIERS = Lists.newArrayList(JetTokens.PRIVATE_KEYWORD, JetTokens.PROTECTED_KEYWORD, JetTokens.PUBLIC_KEYWORD, JetTokens.INTERNAL_KEYWORD);
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final AdditionalCheckerProvider additionalCheckerProvider;

    public static void reportIllegalModifiers(@Nullable JetModifierList modifierList, @NotNull Collection<JetModifierKeywordToken> illegalModifiers, @NotNull BindingTrace trace) {
        if (illegalModifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "illegalModifiers", "org/jetbrains/kotlin/resolve/ModifiersChecker", "reportIllegalModifiers"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/ModifiersChecker", "reportIllegalModifiers"));
        }
        if (modifierList == null) {
            return;
        }
        for (JetModifierKeywordToken modifierToken : illegalModifiers) {
            if (!modifierList.hasModifier(modifierToken)) continue;
            PsiElement modifierPsi = modifierList.getModifier(modifierToken);
            assert (modifierPsi != null);
            trace.report(Errors.ILLEGAL_MODIFIER.on(modifierPsi, modifierToken));
        }
    }

    public static void checkIncompatibleModifiers(@Nullable JetModifierList modifierList, @NotNull BindingTrace trace, @NotNull Collection<JetModifierKeywordToken> availableModifiers, Collection<JetModifierKeywordToken> ... availableCombinations) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIncompatibleModifiers"));
        }
        if (availableModifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "availableModifiers", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIncompatibleModifiers"));
        }
        if (availableCombinations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "availableCombinations", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIncompatibleModifiers"));
        }
        if (modifierList == null) {
            return;
        }
        LinkedHashSet<JetModifierKeywordToken> presentModifiers = Sets.newLinkedHashSet();
        for (JetModifierKeywordToken modifier : availableModifiers) {
            if (!modifierList.hasModifier(modifier)) continue;
            presentModifiers.add(modifier);
        }
        ModifiersChecker.checkRepeatedModifiers(modifierList, trace, availableModifiers);
        if (presentModifiers.size() == 1) {
            return;
        }
        for (Collection<JetModifierKeywordToken> combination : availableCombinations) {
            if (!presentModifiers.containsAll(combination) || !combination.containsAll(presentModifiers)) continue;
            return;
        }
        for (JetModifierKeywordToken token : presentModifiers) {
            trace.report(Errors.INCOMPATIBLE_MODIFIERS.on(modifierList.getModifierNode(token).getPsi(), presentModifiers));
        }
    }

    private static void checkRepeatedModifiers(@NotNull JetModifierList modifierList, @NotNull BindingTrace trace, @NotNull Collection<JetModifierKeywordToken> availableModifiers) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkRepeatedModifiers"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkRepeatedModifiers"));
        }
        if (availableModifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "availableModifiers", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkRepeatedModifiers"));
        }
        for (JetModifierKeywordToken token : availableModifiers) {
            if (!modifierList.hasModifier(token)) continue;
            ArrayList<ASTNode> nodesOfRepeatedTokens = Lists.newArrayList();
            for (ASTNode node = modifierList.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
                if (node.getElementType() != token) continue;
                nodesOfRepeatedTokens.add(node);
            }
            if (nodesOfRepeatedTokens.size() <= 1) continue;
            for (ASTNode repeatedToken : nodesOfRepeatedTokens) {
                trace.report(Errors.REPEATED_MODIFIER.on(repeatedToken.getPsi(), token));
            }
        }
    }

    public static void checkIncompatibleVarianceModifiers(@Nullable JetModifierList modifierList, @NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIncompatibleVarianceModifiers"));
        }
        ModifiersChecker.checkIncompatibleModifiers(modifierList, trace, Arrays.asList(JetTokens.IN_KEYWORD, JetTokens.OUT_KEYWORD), new Collection[0]);
    }

    public ModifiersChecker(@NotNull BindingTrace trace, @NotNull AdditionalCheckerProvider additionalCheckerProvider) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/ModifiersChecker", "<init>"));
        }
        if (additionalCheckerProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalCheckerProvider", "org/jetbrains/kotlin/resolve/ModifiersChecker", "<init>"));
        }
        this.trace = trace;
        this.additionalCheckerProvider = additionalCheckerProvider;
    }

    public static ModifiersChecker create(@NotNull BindingTrace trace, @NotNull AdditionalCheckerProvider provider) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/ModifiersChecker", "create"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/resolve/ModifiersChecker", "create"));
        }
        return new ModifiersChecker(trace, provider);
    }

    public void checkModifiersForDeclaration(@NotNull JetDeclaration modifierListOwner, @NotNull MemberDescriptor descriptor) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkModifiersForDeclaration"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkModifiersForDeclaration"));
        }
        if (modifierListOwner instanceof JetEnumEntry) {
            this.reportIllegalModifiers(modifierListOwner, Arrays.asList(JetTokens.MODIFIER_KEYWORDS_ARRAY));
        } else {
            this.checkInnerModifier(modifierListOwner, descriptor);
            this.checkDefaultModifier(modifierListOwner);
            this.checkModalityModifiers(modifierListOwner);
            this.checkVisibilityModifiers(modifierListOwner, descriptor);
            this.checkVarianceModifiers(modifierListOwner);
            this.checkVarargsModifiers(modifierListOwner, descriptor);
        }
        this.checkPlatformNameApplicability(descriptor);
        this.runDeclarationCheckers(modifierListOwner, descriptor);
    }

    private void checkVarargsModifiers(@NotNull JetDeclaration owner, @NotNull MemberDescriptor descriptor) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkVarargsModifiers"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkVarargsModifiers"));
        }
        if (!(owner instanceof JetParameter)) {
            this.reportIllegalModifiers(owner, Collections.singleton(JetTokens.VARARG_KEYWORD));
        }
    }

    public void checkModifiersForLocalDeclaration(@NotNull JetDeclaration modifierListOwner, @NotNull DeclarationDescriptor descriptor) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkModifiersForLocalDeclaration"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkModifiersForLocalDeclaration"));
        }
        this.reportIllegalModalityModifiers(modifierListOwner);
        this.reportIllegalVisibilityModifiers(modifierListOwner);
        this.checkPlatformNameApplicability(descriptor);
        this.runDeclarationCheckers(modifierListOwner, descriptor);
    }

    public void reportIllegalModalityModifiers(@NotNull JetModifierListOwner modifierListOwner) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker", "reportIllegalModalityModifiers"));
        }
        this.reportIllegalModifiers(modifierListOwner, MODALITY_MODIFIERS);
    }

    public void reportIllegalVisibilityModifiers(@NotNull JetModifierListOwner modifierListOwner) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker", "reportIllegalVisibilityModifiers"));
        }
        this.reportIllegalModifiers(modifierListOwner, VISIBILITY_MODIFIERS);
    }

    private void checkModalityModifiers(@NotNull JetModifierListOwner modifierListOwner) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkModalityModifiers"));
        }
        JetModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            return;
        }
        this.checkRedundantModifier(modifierList, Pair.create(JetTokens.OPEN_KEYWORD, JetTokens.ABSTRACT_KEYWORD), Pair.create(JetTokens.OPEN_KEYWORD, JetTokens.OVERRIDE_KEYWORD));
        this.checkCompatibility(modifierList, Arrays.asList(JetTokens.ABSTRACT_KEYWORD, JetTokens.OPEN_KEYWORD, JetTokens.FINAL_KEYWORD), Arrays.asList(JetTokens.ABSTRACT_KEYWORD, JetTokens.OPEN_KEYWORD));
        if (modifierListOwner instanceof JetObjectDeclaration) {
            this.reportIllegalModalityModifiers(modifierListOwner);
        } else if (modifierListOwner instanceof JetClassOrObject) {
            this.reportIllegalModifiers(modifierListOwner, Collections.singletonList(JetTokens.OVERRIDE_KEYWORD));
        }
    }

    private void checkVisibilityModifiers(@NotNull JetModifierListOwner modifierListOwner, @NotNull DeclarationDescriptor descriptor) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkVisibilityModifiers"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkVisibilityModifiers"));
        }
        JetModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            return;
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration instanceof PackageFragmentDescriptor && modifierList.hasModifier(JetTokens.PROTECTED_KEYWORD)) {
            this.trace.report(Errors.PACKAGE_MEMBER_CANNOT_BE_PROTECTED.on(modifierListOwner));
        }
        this.checkCompatibility(modifierList, VISIBILITY_MODIFIERS, new Collection[0]);
    }

    private void checkInnerModifier(@NotNull JetModifierListOwner modifierListOwner, @NotNull DeclarationDescriptor descriptor) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkInnerModifier"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkInnerModifier"));
        }
        if (modifierListOwner.hasModifier(JetTokens.INNER_KEYWORD)) {
            switch (ModifiersChecker.checkIllegalInner(descriptor)) {
                case ALLOWED: {
                    break;
                }
                case ILLEGAL_POSITION: {
                    this.reportIllegalModifiers(modifierListOwner, Collections.singletonList(JetTokens.INNER_KEYWORD));
                    break;
                }
                case IN_TRAIT: {
                    this.trace.report(Errors.INNER_CLASS_IN_TRAIT.on(modifierListOwner));
                    break;
                }
                case IN_OBJECT: {
                    this.trace.report(Errors.INNER_CLASS_IN_OBJECT.on(modifierListOwner));
                }
            }
            return;
        }
        if (modifierListOwner instanceof JetClass && !(modifierListOwner instanceof JetEnumEntry)) {
            boolean localEnumError;
            JetClass aClass = (JetClass)modifierListOwner;
            boolean bl = localEnumError = aClass.isLocal() && aClass.isEnum();
            if (!localEnumError && ModifiersChecker.isIllegalNestedClass(descriptor)) {
                this.trace.report(Errors.NESTED_CLASS_NOT_ALLOWED.on(aClass));
            }
        }
    }

    public static boolean isIllegalInner(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker", "isIllegalInner"));
        }
        return ModifiersChecker.checkIllegalInner(descriptor) != InnerModifierCheckResult.ALLOWED;
    }

    private void checkDefaultModifier(@NotNull JetDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkDefaultModifier"));
        }
        if (declaration.hasModifier(JetTokens.COMPANION_KEYWORD) && !ModifiersChecker.isDefaultModifierAllowed(declaration)) {
            this.reportIllegalModifiers(declaration, Collections.singletonList(JetTokens.COMPANION_KEYWORD));
        }
    }

    public static boolean isDefaultModifierAllowed(@NotNull JetDeclaration declaration) {
        JetDeclaration containingDeclaration;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/ModifiersChecker", "isDefaultModifierAllowed"));
        }
        return declaration instanceof JetObjectDeclaration && (containingDeclaration = JetStubbedPsiUtil.getContainingDeclaration(declaration)) instanceof JetClassOrObject;
    }

    @NotNull
    private static InnerModifierCheckResult checkIllegalInner(DeclarationDescriptor descriptor) {
        if (!(descriptor instanceof ClassDescriptor)) {
            InnerModifierCheckResult innerModifierCheckResult = InnerModifierCheckResult.ILLEGAL_POSITION;
            if (innerModifierCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
            }
            return innerModifierCheckResult;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
        if (classDescriptor.getKind() != ClassKind.CLASS) {
            InnerModifierCheckResult innerModifierCheckResult = InnerModifierCheckResult.ILLEGAL_POSITION;
            if (innerModifierCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
            }
            return innerModifierCheckResult;
        }
        DeclarationDescriptor containingDeclaration = classDescriptor.getContainingDeclaration();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            InnerModifierCheckResult innerModifierCheckResult = InnerModifierCheckResult.ILLEGAL_POSITION;
            if (innerModifierCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
            }
            return innerModifierCheckResult;
        }
        if (DescriptorUtils.isTrait(containingDeclaration)) {
            InnerModifierCheckResult innerModifierCheckResult = InnerModifierCheckResult.IN_TRAIT;
            if (innerModifierCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
            }
            return innerModifierCheckResult;
        }
        if (DescriptorUtils.isObject(containingDeclaration)) {
            InnerModifierCheckResult innerModifierCheckResult = InnerModifierCheckResult.IN_OBJECT;
            if (innerModifierCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
            }
            return innerModifierCheckResult;
        }
        InnerModifierCheckResult innerModifierCheckResult = InnerModifierCheckResult.ALLOWED;
        if (innerModifierCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
        }
        return innerModifierCheckResult;
    }

    private static boolean isIllegalNestedClass(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker", "isIllegalNestedClass"));
        }
        if (!(descriptor instanceof ClassDescriptor)) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            return false;
        }
        ClassDescriptor containingClass = (ClassDescriptor)containingDeclaration;
        return containingClass.isInner() || containingClass.getContainingDeclaration() instanceof FunctionDescriptor;
    }

    private void checkPlatformNameApplicability(@NotNull DeclarationDescriptor descriptor) {
        String value;
        CompileTimeConstant<?> name;
        Collection<CompileTimeConstant<?>> values;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkPlatformNameApplicability"));
        }
        AnnotationDescriptor annotation2 = descriptor.getAnnotations().findAnnotation(new FqName("kotlin.platform.platformName"));
        if (annotation2 == null) {
            return;
        }
        JetAnnotationEntry annotationEntry = this.trace.get(BindingContext.ANNOTATION_DESCRIPTOR_TO_PSI_ELEMENT, annotation2);
        if (annotationEntry == null) {
            return;
        }
        if (!DescriptorUtils.isTopLevelDeclaration(descriptor) || !(descriptor instanceof FunctionDescriptor) || descriptor instanceof ConstructorDescriptor) {
            this.trace.report(Errors.INAPPLICABLE_ANNOTATION.on(annotationEntry));
        }
        if (!((values = annotation2.getAllValueArguments().values()).isEmpty() || !((name = values.iterator().next()) instanceof StringValue) || (value = (String)((StringValue)name).getValue()) != null && Name.isValidIdentifier(value))) {
            this.trace.report(Errors.ILLEGAL_PLATFORM_NAME.on(annotationEntry, String.valueOf(value)));
        }
    }

    private void checkCompatibility(@Nullable JetModifierList modifierList, Collection<JetModifierKeywordToken> availableModifiers, Collection<JetModifierKeywordToken> ... availableCombinations) {
        ModifiersChecker.checkIncompatibleModifiers(modifierList, this.trace, availableModifiers, availableCombinations);
    }

    private void checkRedundantModifier(@NotNull JetModifierList modifierList, Pair<JetModifierKeywordToken, JetModifierKeywordToken> ... redundantBundles) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkRedundantModifier"));
        }
        for (Pair<JetModifierKeywordToken, JetModifierKeywordToken> tokenPair : redundantBundles) {
            JetModifierKeywordToken redundantModifier = tokenPair.getFirst();
            JetModifierKeywordToken sufficientModifier = tokenPair.getSecond();
            if (!modifierList.hasModifier(redundantModifier) || !modifierList.hasModifier(sufficientModifier)) continue;
            this.trace.report(Errors.REDUNDANT_MODIFIER.on(modifierList.getModifierNode(redundantModifier).getPsi(), redundantModifier, sufficientModifier));
        }
    }

    public void reportIllegalModifiers(@NotNull JetModifierListOwner modifierListOwner, @NotNull Collection<JetModifierKeywordToken> illegalModifiers) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker", "reportIllegalModifiers"));
        }
        if (illegalModifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "illegalModifiers", "org/jetbrains/kotlin/resolve/ModifiersChecker", "reportIllegalModifiers"));
        }
        ModifiersChecker.reportIllegalModifiers(modifierListOwner.getModifierList(), illegalModifiers, this.trace);
    }

    @NotNull
    public static Map<JetModifierKeywordToken, ASTNode> getNodesCorrespondingToModifiers(@NotNull JetModifierList modifierList, @NotNull Collection<JetModifierKeywordToken> possibleModifiers) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/kotlin/resolve/ModifiersChecker", "getNodesCorrespondingToModifiers"));
        }
        if (possibleModifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleModifiers", "org/jetbrains/kotlin/resolve/ModifiersChecker", "getNodesCorrespondingToModifiers"));
        }
        HashMap<JetModifierKeywordToken, ASTNode> nodes = Maps.newHashMap();
        for (JetModifierKeywordToken modifier : possibleModifiers) {
            if (!modifierList.hasModifier(modifier)) continue;
            nodes.put(modifier, modifierList.getModifierNode(modifier));
        }
        HashMap<JetModifierKeywordToken, ASTNode> hashMap = nodes;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "getNodesCorrespondingToModifiers"));
        }
        return hashMap;
    }

    @NotNull
    public static Modality resolveModalityFromModifiers(@NotNull JetModifierListOwner modifierListOwner, @NotNull Modality defaultModality) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
        }
        if (defaultModality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultModality", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
        }
        Modality modality = ModifiersChecker.resolveModalityFromModifiers(modifierListOwner.getModifierList(), defaultModality);
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
        }
        return modality;
    }

    public static Modality resolveModalityFromModifiers(@Nullable JetModifierList modifierList, @NotNull Modality defaultModality) {
        if (defaultModality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultModality", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
        }
        if (modifierList == null) {
            return defaultModality;
        }
        boolean hasAbstractModifier = modifierList.hasModifier(JetTokens.ABSTRACT_KEYWORD);
        boolean hasOverrideModifier = modifierList.hasModifier(JetTokens.OVERRIDE_KEYWORD);
        if (modifierList.hasModifier(JetTokens.OPEN_KEYWORD)) {
            if (hasAbstractModifier || defaultModality == Modality.ABSTRACT) {
                return Modality.ABSTRACT;
            }
            return Modality.OPEN;
        }
        if (hasAbstractModifier) {
            return Modality.ABSTRACT;
        }
        boolean hasFinalModifier = modifierList.hasModifier(JetTokens.FINAL_KEYWORD);
        if (hasOverrideModifier && !hasFinalModifier && defaultModality != Modality.ABSTRACT) {
            return Modality.OPEN;
        }
        if (hasFinalModifier) {
            return Modality.FINAL;
        }
        return defaultModality;
    }

    @NotNull
    public static Visibility resolveVisibilityFromModifiers(@NotNull JetModifierListOwner modifierListOwner, @NotNull Visibility defaultVisibility) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveVisibilityFromModifiers"));
        }
        if (defaultVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultVisibility", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveVisibilityFromModifiers"));
        }
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(modifierListOwner.getModifierList(), defaultVisibility);
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveVisibilityFromModifiers"));
        }
        return visibility;
    }

    public static Visibility resolveVisibilityFromModifiers(@Nullable JetModifierList modifierList, @NotNull Visibility defaultVisibility) {
        if (defaultVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultVisibility", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveVisibilityFromModifiers"));
        }
        if (modifierList == null) {
            return defaultVisibility;
        }
        if (modifierList.hasModifier(JetTokens.PRIVATE_KEYWORD)) {
            return Visibilities.PRIVATE;
        }
        if (modifierList.hasModifier(JetTokens.PUBLIC_KEYWORD)) {
            return Visibilities.PUBLIC;
        }
        if (modifierList.hasModifier(JetTokens.PROTECTED_KEYWORD)) {
            return Visibilities.PROTECTED;
        }
        if (modifierList.hasModifier(JetTokens.INTERNAL_KEYWORD)) {
            return Visibilities.INTERNAL;
        }
        return defaultVisibility;
    }

    public static boolean isInnerClass(@Nullable JetModifierList modifierList) {
        return modifierList != null && modifierList.hasModifier(JetTokens.INNER_KEYWORD);
    }

    @NotNull
    public static Visibility getDefaultClassVisibility(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker", "getDefaultClassVisibility"));
        }
        if (DescriptorUtils.isEnumEntry(descriptor)) {
            Visibility visibility = Visibilities.PUBLIC;
            if (visibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "getDefaultClassVisibility"));
            }
            return visibility;
        }
        if (DescriptorUtils.isCompanionObject(descriptor)) {
            Visibility visibility = ((ClassDescriptor)descriptor.getContainingDeclaration()).getVisibility();
            if (visibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "getDefaultClassVisibility"));
            }
            return visibility;
        }
        Visibility visibility = Visibilities.INTERNAL;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "getDefaultClassVisibility"));
        }
        return visibility;
    }

    private void runDeclarationCheckers(@NotNull JetDeclaration declaration, @NotNull DeclarationDescriptor descriptor) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/ModifiersChecker", "runDeclarationCheckers"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker", "runDeclarationCheckers"));
        }
        for (DeclarationChecker checker : this.additionalCheckerProvider.getDeclarationCheckers()) {
            checker.check(declaration, descriptor, this.trace);
        }
    }

    public void checkVarianceModifiers(@NotNull JetModifierListOwner modifierListOwner) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkVarianceModifiers"));
        }
        this.reportIllegalModifiers(modifierListOwner, Arrays.asList(JetTokens.IN_KEYWORD, JetTokens.OUT_KEYWORD, JetTokens.REIFIED_KEYWORD));
        if (!(modifierListOwner instanceof JetTypeParameterListOwner)) {
            return;
        }
        List<JetTypeParameter> typeParameters = ((JetTypeParameterListOwner)modifierListOwner).getTypeParameters();
        for (JetTypeParameter typeParameter : typeParameters) {
            JetModifierList modifierList = typeParameter.getModifierList();
            ModifiersChecker.checkIncompatibleVarianceModifiers(modifierList, this.trace);
        }
    }

    private static enum InnerModifierCheckResult {
        ALLOWED,
        ILLEGAL_POSITION,
        IN_TRAIT,
        IN_OBJECT;

    }
}

