/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.scopes.RedeclarationHandler;

public class TraceBasedRedeclarationHandler
implements RedeclarationHandler {
    private final BindingTrace trace;

    public TraceBasedRedeclarationHandler(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/TraceBasedRedeclarationHandler", "<init>"));
        }
        this.trace = trace;
    }

    @Override
    public void handleRedeclaration(@NotNull DeclarationDescriptor first, @NotNull DeclarationDescriptor second) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/kotlin/resolve/TraceBasedRedeclarationHandler", "handleRedeclaration"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "org/jetbrains/kotlin/resolve/TraceBasedRedeclarationHandler", "handleRedeclaration"));
        }
        this.report(first);
        this.report(second);
    }

    private void report(DeclarationDescriptor descriptor) {
        PsiElement firstElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor);
        if (firstElement == null) {
            throw new IllegalStateException("No declaration found for " + descriptor);
        }
        this.trace.report(Errors.REDECLARATION.on(firstElement, descriptor.getName().asString()));
    }
}

