/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.expressions.CaptureKind;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"9\b)I2)\u00199ukJLgnZ%o\u00072|7/\u001e:f\u0007\",7m[3s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'b\u0002:fg>dg/\u001a\u0006\u0006G\u0006dGn\u001d\u0006\tG\",7m[3sg*Y1)\u00197m\u0007\",7m[3s\u0015\u0019a\u0014N\\5u})\taI\u0003\nDC2d\u0017M\u00197f\t\u0016\u001c8M]5qi>\u0014(b\u00033fg\u000e\u0014\u0018\u000e\u001d;peNTQa\u00195fG.TAB]3t_24X\rZ\"bY2TABU3t_24X\rZ\"bY2TQ!\\8eK2TqaY8oi\u0016DHO\u0003\u000eCCNL7mQ1mYJ+7o\u001c7vi&|gnQ8oi\u0016DHO\u0003\u0003V]&$(bF2iK\u000e\\7)\u00199ukJLgnZ%o\u00072|7/\u001e:f\u0015!1\u0018M]5bE2,'B\u0005,be&\f'\r\\3EKN\u001c'/\u001b9u_JTQ\u0001\u001e:bG\u0016TABQ5oI&tw\r\u0016:bG\u0016TQa]2pa\u0016T\u0001BS3u'\u000e|\u0007/\u001a\u0006\u0007g\u000e|\u0007/Z:\u000b%%\u001c8)\u00199ukJ,G-\u00138J]2Lg.\u001a\u0006\u000f\u0005&tG-\u001b8h\u0007>tG/\u001a=u\u00159\u00198m\u001c9f\u0007>tG/Y5oKJTQ\u0003R3dY\u0006\u0014\u0018\r^5p]\u0012+7o\u0019:jaR|'O\u0003\bwCJL\u0017M\u00197f!\u0006\u0014XM\u001c;\u000b\u000f\t{w\u000e\\3b]*\u0011\u0012n]\"baR,(/\u001a3WCJL\u0017M\u00197f\u0011\bQ!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015QA\u0001\u0003\u0003\u0011\r)1\u0001\"\u0002\t\u00011\u0001Qa\u0001C\u0003\u0011\u000fa\u0001!\u0002\u0002\u0005\u0003!-Qa\u0001\u0003\u0005\u0011\u0015a\u0001!\u0002\u0002\u0005\u0005!=Qa\u0001\u0003\u0006\u0011\u001da\u0001!\u0002\u0002\u0005\u0005!AQa\u0001\u0003\u0007\u0011#a\u0001!B\u0001\t\u0004\u0015\u0019Aa\u0002\u0005\n\u0019\u0001)!\u0001B\u0003\t\u000f\u0015\u0011AA\u0002E\t\u000b\r!A\u0001#\u0006\r\u0001\u0015\u0019A1\u0001E\f\u0019\u0001)!\u0001b\u0001\t\u001b\u0015\u0019AA\u0003E\r\u0019\u0001)!\u0001\u0002\u0003\t\u0016\u0015\u0011A1\u0001E\f\u000b\t!!\u0002#\u0007\u0006\u0007\u0011\r\u0001B\u0004\u0007\u0001\u000b\r!A\u0001C\b\r\u0001\u0015\u0019Aa\u0002\u0005\u0011\u0019\u0001)!\u0001b\u0001\t\u001d\u0015\u0011A\u0001\u0002\u0005\u0010\t\u0001a1!\u0007\u0002\u0006\u0003!\u001dQv\n\u0003\f#\u0015!\u0001\u0001#\u0003\u0016\u0005\u0015\t\u0001\u0012\u0002\r\u0007;/!\u0001\u0001#\u0004\u000e\u000f\u0015\t\u00012B\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001A\u001b\u0001!(\u0004\u0005\u0001!AQBA\u0003\u0002\u0011\u001b\u00016\u0011A\u0011\u0003\u000b\u0005Ay!U\u0002\b\t\u0019I\u0011\u0001\u0002\u0001\u000e\u0003!AQ\"\u0001E\t[\u0019\"\u0011\u0001g\u0005\u001e\u000e\u0011\u0001\u0001BC\u0007\u0003\u000b\u0005A\u0011\u0002U\u0002\u0001;\u001b!\u0001\u0001C\u0006\u000e\u0005\u0015\t\u00012\u0003)\u0004\u0002u5A\u0001\u0001\u0005\r\u001b\t)\u0011\u0001#\u0006Q\u0007\u0005\t#!B\u0001\t\u0010E\u001b\u0011\u0002b\u0005\n\u0003\u0011\u0001Q\"\u0001\u0005\f\u001b\u0005A9\"D\u0001\t\u001952C!\u0001M\u000e;\u001b!\u0001\u0001\u0003\u0005\u000e\u0005\u0015\t\u0001\u0012\u0004)\u0004\u0001u5A\u0001\u0001E\u000f\u001b\t)\u0011\u0001C\u0007Q\u0007\u0003ij\u0001\u0002\u0001\t 5\u0011Q!\u0001\u0005\u000e!\u000e\t\u0011EA\u0003\u0002\u00117\t6!\u0003C\u000e\u0013\u0005!\t!D\u0001\t\u001d5\t\u0001RD\u0007\u0002\u0011;iK\u0004B\u0001\u0019\"u5A\u0001\u0001E\u0010\u001b\t)\u0011\u0001C\u0007Q\u0007\u0001ij\u0001\u0002\u0001\t\u001e5\u0011Q!\u0001\u0005\u000e!\u000e\u0005\u0011EA\u0003\u0002\u00117\t6a\u0002C\u0011\u0013\u0005!\t!D\u0001\t\u001e5\t\u0001RD\u001b\f\u000b)!1\u001d\u0001\r\u0005C\t)\u0011\u0001C\u0002R\u0007\r!A!C\u0001\u0005\u0001\u0001"})
public final class CapturingInClosureChecker
implements CallChecker {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(CapturingInClosureChecker.class);
    }

    @Override
    public <F extends CallableDescriptor> void check(@JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<F> resolvedCall, @JetValueParameter(name="context") @NotNull BasicCallResolutionContext context2) {
        VariableDescriptor variableDescriptor;
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        ResolvedCall<F> variableResolvedCall = resolvedCall instanceof VariableAsFunctionResolvedCall ? ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getVariableCall() : resolvedCall;
        F f = variableResolvedCall.getResultingDescriptor();
        if (!(f instanceof VariableDescriptor)) {
            f = null;
        }
        if ((variableDescriptor = (VariableDescriptor)f) != null) {
            BindingTrace bindingTrace = ((ResolutionContext)context2).trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            JetScope jetScope = ((ResolutionContext)context2).scope;
            Intrinsics.checkExpressionValueIsNotNull(jetScope, "context.scope");
            this.checkCapturingInClosure(variableDescriptor, bindingTrace, jetScope);
        }
    }

    private final void checkCapturingInClosure(@JetValueParameter(name="variable") VariableDescriptor variable2, @JetValueParameter(name="trace") BindingTrace trace, @JetValueParameter(name="scope") JetScope scope2) {
        DeclarationDescriptor variableParent = variable2.getContainingDeclaration();
        DeclarationDescriptor scopeContainer = scope2.getContainingDeclaration();
        DeclarationDescriptor declarationDescriptor = variableParent;
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "variableParent");
        if (this.isCapturedVariable(declarationDescriptor, scopeContainer) && Intrinsics.areEqual((Object)((CaptureKind)((Object)trace.get(BindingContext.CAPTURED_IN_CLOSURE, variable2))), (Object)CaptureKind.NOT_INLINE) ^ true) {
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
            DeclarationDescriptor declarationDescriptor2 = variableParent;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "variableParent");
            boolean inline2 = this.isCapturedInInline(bindingContext, scopeContainer, declarationDescriptor2);
            trace.record(BindingContext.CAPTURED_IN_CLOSURE, variable2, inline2 ? CaptureKind.INLINE_ONLY : CaptureKind.NOT_INLINE);
        }
    }

    private final boolean isCapturedVariable(@JetValueParameter(name="variableParent") DeclarationDescriptor variableParent, @JetValueParameter(name="scopeContainer") DeclarationDescriptor scopeContainer) {
        if (!(variableParent instanceof FunctionDescriptor) || Intrinsics.areEqual(scopeContainer, variableParent)) {
            return false;
        }
        if (variableParent instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)variableParent).getContainingDeclaration();
            if (Intrinsics.areEqual(scopeContainer, classDescriptor)) {
                return false;
            }
            if (scopeContainer instanceof PropertyDescriptor && Intrinsics.areEqual(((PropertyDescriptor)scopeContainer).getContainingDeclaration(), classDescriptor)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCapturedInInline(@JetValueParameter(name="context") BindingContext context2, @JetValueParameter(name="scopeContainer") DeclarationDescriptor scopeContainer, @JetValueParameter(name="variableParent") DeclarationDescriptor variableParent) {
        void value;
        PsiElement scopeDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(scopeContainer);
        if (!InlineUtil.canBeInlineArgument(scopeDeclaration)) {
            return false;
        }
        PsiElement psiElement = scopeDeclaration;
        if (psiElement == null) {
            throw new TypeCastException("com.intellij.psi.PsiElement? cannot be cast to org.jetbrains.kotlin.psi.JetFunction");
        }
        if (!InlineUtil.isInlinedArgument((JetFunction)psiElement, context2, false)) return false;
        DeclarationDescriptor scopeContainerParent = scopeContainer.getContainingDeclaration();
        boolean bl = scopeContainerParent != null;
        if (KotlinPackage.getASSERTIONS_ENABLED() && value == false) {
            String message = "parent is null for " + scopeContainer;
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        DeclarationDescriptor declarationDescriptor = scopeContainerParent;
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "scopeContainerParent");
        if (!this.isCapturedVariable(variableParent, declarationDescriptor)) return true;
        DeclarationDescriptor declarationDescriptor2 = scopeContainerParent;
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "scopeContainerParent");
        if (!this.isCapturedInInline(context2, declarationDescriptor2, variableParent)) return false;
        return true;
    }
}

