/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.CallResolverUtil;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallableDescriptors;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionTaskHolder;
import org.jetbrains.kotlin.resolve.calls.tasks.TasksPackage$dynamicCalls$b5563953;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tasks.collectors.CallableDescriptorCollector;
import org.jetbrains.kotlin.resolve.calls.tasks.collectors.CallableDescriptorCollectors;
import org.jetbrains.kotlin.resolve.calls.tasks.collectors.CollectorsPackage$CallableDescriptorCollectors$50805b7c;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.JetScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.JetScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypesPackage$dynamicTypes$18e465db;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"^\u0018)yA+Y:l!JLwN]5uSj,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u001d\u0011Xm]8mm\u0016TQaY1mYNTQ\u0001^1tWNT1!\u00118z\u0015\u0019a\u0014N\\5u})q1\u000f^8sC\u001e,W*\u00198bO\u0016\u0014(BD*u_J\fw-Z'b]\u0006<WM\u001d\u0006\bgR|'/Y4f\u0015\u0005!%BE\"bY2\f'\r\\3EKN\u001c'/\u001b9u_JT1\u0002Z3tGJL\u0007\u000f^8sg*\taIC\u0010bI\u0012\u001c\u0015M\u001c3jI\u0006$Xm\u001d$pe\u0012Kh.Y7jGJ+7-Z5wKJT\u0001#\u001a=qY&\u001c\u0017\u000e\u001e*fG\u0016Lg/\u001a:\u000b\u001bI+7-Z5wKJ4\u0016\r\\;f\u0015\u0019\u00198m\u001c9fg*I!/Z2fSZ,'o\u001d\u0006\u0012S6\u0004H.[2jiJ+7-Z5wKJ\u001c(BC\"pY2,7\r^5p]*\t1M\u0003\fUCN\\\u0007K]5pe&$\u0018N_3s\u0007>tG/\u001a=u\u0015)I7/\u0012=qY&\u001c\u0017\u000e\u001e\u0006\b\u0005>|G.Z1o\u0015\u0011)f.\u001b;\u000b\t)\fg/\u0019\u0006\u0005kRLGN\u0003\u0014UCN\\\u0007K]5pe&$\u0018N_3sIQ\u000b7o\u001b)sS>\u0014\u0018\u000e^5{KJ\u001cuN\u001c;fqRT\u0001%\u00193e\u0007\u0006tG-\u001b3bi\u0016\u001chi\u001c:FqBd\u0017nY5u%\u0016\u001cW-\u001b<fe*1\u0012\r\u001a3DC:$\u0017\u000eZ1uKN4uN]%om>\\WM\u0003\u000ebI\u0012\u001c\u0015M\u001c3jI\u0006$Xm\u001d$pe:{'+Z2fSZ,'OC\u001fbI\u0012\u001c\u0015M\u001c3jI\u0006$Xm],iK:LeN^8lK&\u001bX*Z7cKJ\fe\u000eZ#yi\u0016t7/[8o)>,\u0005\u0010\u001d7jG&$(+Z2fSZ,'O\u0003\teSN\u0004\u0018\r^2i%\u0016\u001cW-\u001b<fe*\t\"/Z2fSZ,'\u000fU1sC6,G/\u001a:\u000b\u0019I,7-Z5wKJ\\\u0015N\u001c3\u000b)\u0015C\b\u000f\\5dSR\u0014VmY3jm\u0016\u00148*\u001b8e\u0015Y\tG\rZ#yi\u0016t7/[8o\u0007\u0006tG-\u001b3bi\u0016\u001c(\u0002H1eI6+WNY3s\u000bb$XM\\:j_:\u001c\u0015M\u001c3jI\u0006$Xm\u001d\u0006\u001cG\u0006dG.\u00192mK\u0012+7o\u0019:jaR|'oQ8mY\u0016\u001cGo\u001c:\u000b7\r\u000bG\u000e\\1cY\u0016$Um]2sSB$xN]\"pY2,7\r^8s\u0015)\u0019w\u000e\u001c7fGR|'o\u001d\u0006\u000bC\u0012$W*Z7cKJ\u001c(\"D:uCRL7-T3nE\u0016\u00148OC\fd_6\u0004X\u000f^3Qe&|'/\u001b;ju\u0016$G+Y:lg*91m\u001c8uKb$(B\u0007\"bg&\u001c7)\u00197m%\u0016\u001cx\u000e\\;uS>t7i\u001c8uKb$(\u0002\u00028b[\u0016TAAT1nK*9AO]1dS:<'b\u0004+sC\u000eLgnZ*ue\u0006$XmZ=\u000b9\r\fG\u000e\\1cY\u0016$Um]2sSB$xN]\"pY2,7\r^8sg*a2)\u00197mC\ndW\rR3tGJL\u0007\u000f^8s\u0007>dG.Z2u_J\u001c(\u0002\u0002'jgRTaBU3t_2,H/[8o)\u0006\u001c8NC\u0013d_6\u0004X\u000f^3Qe&|'/\u001b;ju\u0016$G+Y:lg\u001a\u0013x.\\\"b]\u0012LG-\u0019;fg*Q1-\u00198eS\u0012\fG/Z:\u000b'I+7o\u001c7vi&|gnQ1oI&$\u0017\r^3\u000bE\r|W\u000e];uKR\u000b7o[:G_J\u001cE.Y:t\u001f\nTWm\u0019;SK\u000e,\u0017N^3s\u0015E\tX/\u00197jM&,'OU3dK&4XM\u001d\u0006\u0012#V\fG.\u001b4jKJ\u0014VmY3jm\u0016\u0014(B\u0006;bg.\u0004&/[8sSRL'0\u001a:D_:$X\r\u001f;\u000b-\r|gN^3si^KG\u000f[%na2LW\r\u001a+iSNTQa]2pa\u0016T\u0001BS3u'\u000e|\u0007/\u001a\u0006\u0005G\u0006dGN\u0003\u0003DC2d'b\u00019tS*\u00193m\u001c8wKJ$x+\u001b;i\u00136\u0004H.[3e)\"L7/\u00118e\u001d>\u0014VmY3jm\u0016\u0014(\u0002F2p]Z,'\u000f^,ji\"\u0014VmY3jm\u0016\u00148OC\tfqR,gn]5p]J+7-Z5wKJTaA]3tk2$(\"E'vi\u0006\u0014G.Z\"pY2,7\r^5p]*!R\r\u001f9mS\u000eLGOU3dK&4XM]&j]\u0012T!b\u0019:fCR,7*\u001b8e\u0015\u0011Y\u0017N\u001c3\u000b\u001d\u0011|7i\\7qkR,G+Y:lg*A!/Z2fSZ,'O\u0003\btKRLU\u000e\u001d7jK\u0012$\u0006.[:\u000b\u0013\r\fg\u000eZ5eCR,'BH:qY&$H*\u001a=jG\u0006dG.\u001f'pG\u0006dG)Z:de&\u0004Ho\u001c:t\u00159\tG\u000e\u001c#fg\u000e\u0014\u0018\u000e\u001d;peNTQdY8oi\u0006Lg.\u001a:PMRCWmQ;se\u0016tG\u000fT8dC2LG/\u001f\u0006\u0016\t\u0016\u001cG.\u0019:bi&|g\u000eR3tGJL\u0007\u000f^8s\u0015\u0015awnY1m\u0015!qwN\u001c7pG\u0006d'\u0002\u0006)sS>\u0014\u0018\u000e^=Qe>4\u0018\u000eZ3s\u00136\u0004H\u000e?\u0002\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\t!!\u0001C\u0002\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\u0005A\u0019!B\u0002\u0005\b!\u001dA\u0002A\u0003\u0003\t\u0005AY!B\u0002\u0005\n!)A\u0002A\u0003\u0003\t\u0013AQ!\u0002\u0002\u0005\u0003!9Qa\u0001\u0003\u0007\u0011\u001ba\u0001!\u0002\u0002\u0005\u0004!MQA\u0001\u0003\b\u0011))1\u0001b\u0004\t\u00131\u0001Qa\u0001C\u0004\u0011-a\u0001!B\u0002\u0005\u0007!aA\u0002A\u0003\u0004\t\u000fAQ\u0002\u0004\u0001\u0006\u0007\u0011\u001d\u00012\u0004\u0007\u0001\u000b\t!y\u0001C\u0005\u0006\u0003!qQA\u0001\u0003\f\u0011;)!\u0001b\u0006\t\u0017\u0015\u0011AQ\u0001\u0005\u0010\u000b\r!)\u0001C\n\r\u0001\u0015\u0011AQ\u0001\u0005\u0014\u000b\t!)\u0001c\u000b\u0006\u0007\u0011q\u0001\"\u0006\u0007\u0001\u000b\t!a\u0002C\u000b\u0006\u0005\u0011\u0011\u0001rF\u0003\u0004\t?A\u0001\u0004\u0004\u0001\u0006\u0005\u0011\t\u0001\u0012G\u0003\u0004\tCA\u0011\u0004\u0004\u0001\u0006\u0007\u0011\u0015\u0001B\u0007\u0007\u0001\u000b\r!a\u0002C\u000e\r\u0001\u0015\u0019Aq\u0001E\u001c\u0019\u0001)1\u0001\"\u0002\t91\u0001QA\u0001C\f\u0011o)!\u0001b\b\t1\u0015\u0011A\u0011\u0005\u0005\u001a\u000b\t!)\u0001\u0003\u000e\u0006\u0005\u0011q\u0001bG\u0003\u0004\t\u000bAY\u0004\u0004\u0001\u0006\u0007\u0011=\u0001b\b\u0007\u0001\u000b\t!y\u0001C\u0010\u0006\u0007\u00119\u0001\"\t\u0007\u0001\u000b\t!\u0011\u0001#\u0012\u0006\u0007\u0011A\u0002B\t\u0007\u0001\u000b\t!q\u0001C\u0011\u0006\u0005\u0011A\u0002BI\u0003\u0004\t\u000fAQ\u0005\u0004\u0001\u0006\u0005\u0011\u0015\u00012H\u0003\u0004\t\u0019A)\u0006\u0004\u0001\u0006\u0005\u00111\u0001R\u000b\u0003\u0004\u0019\rI\"!B\u0001\t\tqaC\u0004D\u0017\f\t\u0005$\u0001\u0014B\u0011\u0003\u000b\u0005AQ!V\u0002\u0005\u000b\r!I!C\u0001\t\f5V\r\u0001B\u0001\u0012\u000b\u0011\u0001\u0001BB\u000b\u0003\u000b\u0005Ai!\u0005\u0004\u0005\u0002!=QcA\u0003\u0003\t\u0003A\u0001\u0001\u0007\u0005\u001e\u000e\u0011\u0001\u0001\u0012C\u0007\u0003\u000b\u0005A\u0001\u0002U\u0002\u0001;+!\u0001\u0001#\u0006\u000e\r\u0015\t\u0001\u0012C\u0005\u0004\u0013\t)\u0011\u0001\u0003\u0005Q\u0007\u0003i\n\u0003\u0002\u0001\t\u00185aQ!\u0001\u0005\n\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001#\u0001Q\u0007\u0005ij\u0001\u0002\u0001\t\u001a5\u0011Q!\u0001E\n!\u000e\r\u0011EA\u0003\u0002\u0011)\t6a\u0003\u0003\t\u0013\u0005!\u0001!D\u0001\t\u00165\t\u0001\u0002D\u0007\u0002\u00113i\u0011\u0001\"\u0001.\u0016\u0004!\u0011!E\u0003\u0005\u0001!1QCA\u0003\u0002\u0011\u001b\tb\u0001\"\u0001\t\u0010U\u0019QA\u0001C\u0001\u0011\u0001Az\"(\u0004\u0005\u0001!EQBA\u0003\u0002\u0011!\u00016\u0001AO\u000b\t\u0001A)\"\u0004\u0004\u0006\u0003!E\u0011bA\u0005\u0003\u000b\u0005A\u0001\u0002UB\u0001;C!\u0001\u0001c\u0006\u000e\u0019\u0015\t\u0001\"C\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001%!\u0011bA\u0003\u0003\t\u0003A\t\u0001U\u0002\u0002;\u001b!\u0001\u0001#\u0007\u000e\u0005\u0015\t\u00012\u0003)\u0004\u0004\u0005\u0012Q!\u0001\u0005\u000b#\u000eYAqD\u0005\u0002\t\u0001i\u0011\u0001#\u0006\u000e\u0003!aQ\"\u0001E\r\u001b\u0005!\t!l\u001a\u0005\u0003E)A\u0001\u0001\u0005\u0007+\t)\u0011\u0001#\u0004\u0012\r\u0011\u0005\u0001rB\u000b\u0004\u000b\t!\t\u0001\u0003\u0001\u0019!u5A\u0001\u0001E\t\u001b\t)\u0011\u0001\u0003\u0005Q\u0007\u0001i\n\u0003\u0002\u0001\t\u00185aQ!\u0001\u0005\n\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001#\u0001Q\u0007\u0003\t#!B\u0001\t\u0015E\u001bq\u0001\u0002\t\n\u0003\u0011\u0001Q\"\u0001E\u000b\u001b\u0005AI\"l\u001c\u0005\u0003E)A\u0001\u0001\u0005\u0007+\t)\u0011\u0001#\u0004\u0012\r\u0011\u0005\u0001rB\u000b\u0004\u000b\t!\t\u0001\u0003\u0001\u0019\"uUA\u0001\u0001E\u000b\u001b\u0019)\u0011\u0001#\u0005\n\u0007%\u0011Q!\u0001\u0005\t!\u000e\u0001Q\u0014\u0005\u0003\u0001\u0011/iA\"B\u0001\t\u0013%!\u0011bA\u0003\u0003\t\u0003A\u0001!\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001E\u0001!\u000e\u0005\u0011EA\u0003\u0002\u0011)\t6a\u0002C\u0011\u0013\u0005!\u0001!D\u0001\t\u00195\t\u0001\u0012DWG\u0002\u0011\t\u0011#\u0002\u0003\u0001\u0011\u0019)\"!B\u0001\t\u000eE1A\u0011\u0001E\b+\r)!\u0001\"\u0001\t\u0001a\tRT\u0002\u0003\u0001\u0011Gi!!B\u0001\t\u0011A\u001b\u0001!(\u0004\u0005\u0001!\u0011RBA\u0003\u0002\u0011!\u00016\u0011AO\u0011\t\u0001A9\"\u0004\u0007\u0006\u0003!I\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001\n\t%\u0019QA\u0001C\u0001\u0011\u0003\u00016!AO\u0007\t\u0001A)#\u0004\u0002\u0006\u0003!i\u0001ka\u0001\"\u0005\u0015\t\u0001BC)\u0004\u0017\u0011\t\u0012\"\u0001\u0003\u0001\u001b\u0005A)\"D\u0001\t\u00165\t\u0001\u0012D\u0007\u0002\u00117i+\u001a\u0001\u0003\u0002#\u0015!\u0001\u0001\u0003\u0004\u0016\u0005\u0015\t\u0001RB\t\u0007\t\u0003Ay!F\u0002\u0006\u0005\u0011\u0005\u0001\u0002\u0001M\u0014;\u001b!\u0001\u0001#\u0005\u000e\u0005\u0015\t\u0001\u0002\u0003)\u0004\u0001uUA\u0001\u0001E\u000b\u001b\u0019)\u0011\u0001#\u0005\n\u0007%\u0011Q!\u0001\u0005\t!\u000e\u0005Q\u0014\u0005\u0003\u0001\u0011/iA\"B\u0001\t\u0013%!\u0011bA\u0003\u0003\t\u0003A\u0001!\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001E\u0001!\u000e\tQT\u0002\u0003\u0001\u00113i!!B\u0001\t\u0014A\u001b\u0019!\t\u0002\u0006\u0003!Q\u0011kA\u0006\u0005(%\tA\u0001A\u0007\u0002\u0011+i\u0011\u0001\u0003\u0007\u000e\u0003!eQ\"\u0001C\u0001[U\u0007A!A\t\u0006\t\u0001Aa!\u0006\u0002\u0006\u0003!5\u0011C\u0002C\u0001\u0011\u001f)2!\u0002\u0002\u0005\u0002!\u0001\u0001\u0004FO\u0007\t\u0001A\u0019#\u0004\u0002\u0006\u0003!A\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001BE\u0007\u0003\u000b\u0005A\u0001\u0002UB\u0001;/!\u0001\u0001#\u000b\u000e\u000f\u0015\t\u0001RD\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001A\u001b\u0011!(\t\u0005\u0001!]Q\u0002D\u0003\u0002\u0011%IA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0002A\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0002A\u001b\u0019!(\u0004\u0005\u0001!\u0015RBA\u0003\u0002\u00115\u00016AA\u0011\u0003\u000b\u0005A!\"U\u0002\u000e\tQI\u0011\u0001\u0002\u0001\u000e\u0003!UQ\"\u0001E\u000b\u001b\u0005Aq\"D\u0001\t\u001a5\t\u00012DWG\u0002\u0011\t\u0011#\u0002\u0003\u0001\u0011\u0019)\"!B\u0001\t\u000eE1A\u0011\u0001E\b+\r)!\u0001\"\u0001\t\u0001a1RT\u0002\u0003\u0001\u0011#i!!B\u0001\t\u0011A\u001b\u0001!(\t\u0005\u0001!]Q\u0002D\u0003\u0002\u0011%IA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0002A\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0002A\u001b\t!(\u0004\u0005\u0001!5RBA\u0003\u0002\u0011'\u00016!AO\u0007\t\u0001AI\"\u0004\u0002\u0006\u0003!M\u0001ka\u0001\"\u0005\u0015\t\u0001BC)\u0004\u0017\u00111\u0012\"\u0001\u0003\u0001\u001b\u0005A)\"D\u0001\t\u001a5\tA\u0011A\u0007\u0002\t\u0003i{\u001a\u0001\u0003\u0004#\u0015!\u0001\u0001\u0003\u0004\u0016\u0005\u0015\t\u0001RB\t\u0007\t\u0003Ay!F\u0002\u0006\u0005\u0011\u0005\u0001\u0002\u0001\r\u0018;\u001b!\u0001\u0001c\f\u000e\u0005\u0015\t\u0001\u0002\u0005)\u0004\u0001u5A\u0001\u0001E\u0019\u001b\t)\u0011\u0001C\tQ\u0007\u0003ij\u0001\u0002\u0001\t45\u0011Q!\u0001E\u0012!\u000e\tQt\u0003\u0003\u0001\u0011kiq!B\u0001\t%%!\u0011bA\u0003\u0003\t\u0003A\u0001\u0001UB\u0002CA)\u0011\u0001#\n\n\u001b%aQ!\u0001\u0005\u0014\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001#\u0001R\u0007-!q#C\u0001\t(5\t\u0001\u0002F\u0007\u0002\u0011Si\u0011\u0001C\u000b\u000e\u0003!-RF3\u0001\u0005\u0007E)A\u0001\u0001\u0005\u0007+\t)\u0011\u0001#\u0004\u0012\r\u0011\u0005\u0001rB\u000b\u0004\u000b\t!\t\u0001\u0003\u0001\u0019:u5A\u0001\u0001E\u0018\u001b\t)\u0011\u0001\u0003\tQ\u0007\u0001iz\u0002\u0002\u0001\t;5YQ!\u0001E\t\u0013!Iq!B\u0001\t-%!\u0011bA\u0003\u0003\t\u0003A\u0001\u0001UB\u0001;\u001b!\u0001\u0001c\r\u000e\u0005\u0015\t\u00012\u0005)\u0004\u0003\u0005\u0002R!\u0001E\u0013\u00135IA\"B\u0001\t'%!\u0011bA\u0003\u0003\t\u0003A\u0001!\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001E\u0001#\u000eIA\u0011H\u0005\u0002\u0011Oi\u0011\u0001\u0003\u000b\u000e\u0003!aQ\"\u0001\u0005\u0016[O\"\u0011!E\u0003\u0005\u0001!1QCA\u0003\u0002\u0011\u001b\tb\u0001\"\u0001\t\u0010U\u0019QA\u0001C\u0001\u0011\u0001Ab$(\u0004\u0005\u0001!uRBA\u0003\u0002\u0011[\u00016\u0001AO\u0011\t\u0001Ay$\u0004\u0007\u0006\u0003!I\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001\n\t%\u0019QA\u0001C\u0001\u0011\u0003\u00016\u0011A\u0011\u0003\u000b\u0005A!\"U\u0002\b\tyI\u0011\u0001\u0002\u0001\u000e\u0003!9R\"\u0001E\r[5\u0007AaA\t\u0006\t\u0001Aa!\u0006\u0002\u0006\u0003!5\u0001\u0004IO\u0007\t\u0001A\t%\u0004\u0002\u0006\u0003!=\u0002k\u0001\u0001\u001e\u000e\u0011\u0001\u0001BE\u0007\u0003\u000b\u0005A\u0001\u0002UB\u0001;/!\u0001\u0001C\u0004\u000e\u000f\u0015\t\u0001\u0012C\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001A\u001b\u0011!(\u0004\u0005\u0001!\u0015RBA\u0003\u0002\u00115\u000161AO\u0007\t\u0001A\u0019%\u0004\u0002\u0006\u0003!E\u0002k\u0001\u0002\"\u0017\u0015\t\u0001\u0012C\u0005\t\u0013\u001d)\u0011\u0001\u0003\f\n\t%\u0019QA\u0001C\u0001\u0011\u0001\t6!\u0004\u0003!\u0013\u0005AA\"D\u0001\t35\t\u0001RC\u0007\u0002\u00111i\u0011\u0001c\u0007\u000e\u0003!MRF\u000f\u0003\u0004#\u0015!\u0001\u0001\u0003\u0004\u0016\u0005\u0015\t\u0001R\u0002\r$;\u001b!\u0001\u0001#\u0011\u000e\u0005\u0015\t\u0001r\u0006)\u0004\u0001u]A\u0001\u0001\u0005\b\u001b\u001d)\u0011\u0001#\u0005\n\t%\u0019QA\u0001C\u0001\u0011\u0001\u00016\u0011AO\u0007\t\u0001A\u0019%\u0004\u0002\u0006\u0003!E\u0002kA\u0001\"\u0017\u0015\t\u0001\u0012C\u0005\t\u0013\u001d)\u0011\u0001\u0003\f\n\t%\u0019QA\u0001C\u0001\u0011\u0001\t6!\u0003\u0003$\u0013\u0005AA\"D\u0001\t35\t\u0001\u0002D\u0007\u0002\u0011gik\u001b\u0001\u0003\u0002#\u0015!\u0001\u0001\u0003\u0004\u0016\u0005\u0015\t\u0001R\u0002M$;/!\u0001\u0001C\u0004\u000e\u000f\u0015\t\u0001\u0012C\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001A\u001b\u0001!(\u0004\u0005\u0001!\rRBA\u0003\u0002\u0011!\u00016\u0011AO\u0007\t\u0001AA%\u0004\u0002\u0006\u0003!A\u0001kA\u0001\u001e \u0011\u0001\u0001\u0012J\u0007\f\u000b\u0005A!$\u0003\u0005\n\u000f\u0015\t\u0001BF\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001A\u001b\u0019!(\u0004\u0005\u0001!-SBA\u0003\u0002\u00115\u00016AAO\u0007\t\u0001A\u0019%\u0004\u0002\u0006\u0003!E\u0002k!\u0002\"\u0005\u0015\t\u0001BC)\u0004\u001f\u0011\u001d\u0013\"\u0001\u0003\u0001\u001b\u0005AA\"D\u0001\t\u00165\t\u0001RC\u0007\u0002\u00111i\u0011\u0001c\u0007\u000e\u0003!MR&4\u0001\u0005\u0003E)A\u0001\u0001\u0005\u0007+\t)\u0011\u0001#\u0004\u0019Hu]A\u0001\u0001\u0005\b\u001b\u001d)\u0011\u0001#\u0005\n\t%\u0019QA\u0001C\u0001\u0011\u0001\u00016\u0001AO\u0007\t\u0001A\u0019#\u0004\u0002\u0006\u0003!A\u0001k!\u0001\u001e\u000e\u0011\u0001\u0001\u0002J\u0007\u0003\u000b\u0005A\u0001\u0002U\u0002\u0002;\u001b!\u0001\u0001c\u0013\u000e\u0005\u0015\t\u0001\"\u0004)\u0004\u0004u5A\u0001\u0001E\"\u001b\t)\u0011\u0001#\rQ\u0007\t\t3\"B\u0001\t\u0012%A\u0011bB\u0003\u0002\u0011YIA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0002A)\u0004\u001b\u0011\u001d\u0013\"\u0001\u0005\r\u001b\u0005AA\"D\u0001\t\u00165\t\u0001RC\u0007\u0002\u00117i\u0011\u0001c\r.:\u0011\t\u0001DJO\u0007\t\u0001Ai%\u0004\u0002\u0006\u0003!i\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001\u0012D\u0007\u0003\u000b\u0005A\u0019\u0002UB\u0001C\t)\u0011\u0001C\u0007R\u0007\u001d!a%C\u0001\t\u001c5\t\u00012D\u0007\u0002\t\u0003i;\u0007B\u0001\u0012\u000b\u0011\u0001\u0001BB\u000b\u0003\u000b\u0005Ai!\u0005\u0004\u0005\u0002!=QcA\u0003\u0003\t\u0003A\u0001\u0001G\u0014\u001e\u000e\u0011\u0001\u0001rJ\u0007\u0003\u000b\u0005A\u0001\u0002U\u0002\u0001;C!\u0001\u0001c\u0006\u000e\u0019\u0015\t\u0001\"C\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001%!\u0011bA\u0003\u0003\t\u0003A\t\u0001UB\u0001C\t)\u0011\u0001\u0003\u0006R\u0007\u001d!q%C\u0001\u0005\u00015\t\u0001RC\u0007\u0002\u00113i{\u0005B\u0001\u0012\u000b\u0011\u0001\u0001BB\u000b\u0003\u000b\u0005Ai\u0001\u0007\u0015\u001e\u000e\u0011\u0001\u0001\u0012I\u0007\u0003\u000b\u0005Ay\u0003U\u0002\u0001;/!\u0001\u0001#\u0015\u000e\u000f\u0015\t\u0001BF\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001A\u001b\t!\t\u0002\u0006\u0003!M\u0011kA\u0004\u0005Q%\tA\u0011A\u0007\u0002\u0011ei\u0011\u0001#\u000e.\"\u0004!1!E\u0003\u0005\u0001!1QCA\u0003\u0002\u0011\u001bA\u0012&h\b\u0005\u0001!MSbC\u0003\u0002\u0011#I\u0001\"C\u0004\u0006\u0003!1\u0012\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001Q\u0007\u0001ij\u0001\u0002\u0001\tU5\u0011Q!\u0001\u0005\u001c!\u000e\u0005Qt\u0004\u0003\u0001\u0011-j1\"B\u0001\t5%A\u0011bB\u0003\u0002\u0011YIA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0002\u0001)\u0004\u0003u}A\u0001\u0001E,\u001b-)\u0011\u0001\u0003\u000e\n\u0011%9Q!\u0001\u0005\u0017\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001\u0001ka\u0001\"\u0005\u0015\t\u0001BC)\u0004\u0017\u0011I\u0013\"\u0001\u0003\u0001\u001b\u0005AA\"D\u0001\t85\t\u0001\u0002D\u0007\u0002\u00111)L#b\n\u0005G\u0004AB!(\u0004\u0005\u0001!%QBA\u0003\u0002\u0011\u0015\u00016\u0001A\u0011\u0003\u000b\u0005A1!U\u0002\u0006\t\u0011I\u0011\u0001\u0002\u0001\u000e\u0003!-\u0001"})
public final class TaskPrioritizer {
    public static final /* synthetic */ KClass $kotlinClass;
    private final StorageManager storageManager;

    static {
        $kotlinClass = Reflection.createKotlinClass(TaskPrioritizer.class);
    }

    public final <D extends CallableDescriptor> void splitLexicallyLocalDescriptors(@JetValueParameter(name="allDescriptors") @NotNull Collection<? extends ResolutionCandidate<D>> allDescriptors2, @JetValueParameter(name="containerOfTheCurrentLocality") @NotNull DeclarationDescriptor containerOfTheCurrentLocality, @JetValueParameter(name="local") @NotNull Collection<ResolutionCandidate<D>> local, @JetValueParameter(name="nonlocal") @NotNull Collection<ResolutionCandidate<D>> nonlocal) {
        Intrinsics.checkParameterIsNotNull(allDescriptors2, "allDescriptors");
        Intrinsics.checkParameterIsNotNull(containerOfTheCurrentLocality, "containerOfTheCurrentLocality");
        Intrinsics.checkParameterIsNotNull(local, "local");
        Intrinsics.checkParameterIsNotNull(nonlocal, "nonlocal");
        for (ResolutionCandidate<D> resolvedCall : allDescriptors2) {
            if (ExpressionTypingUtils.isLocal(containerOfTheCurrentLocality, (DeclarationDescriptor)resolvedCall.getDescriptor())) {
                local.add(resolvedCall);
                continue;
            }
            nonlocal.add(resolvedCall);
        }
    }

    @NotNull
    public final <D extends CallableDescriptor, F extends D> List<ResolutionTask<D, F>> computePrioritizedTasks(@JetValueParameter(name="context") @NotNull BasicCallResolutionContext context2, @JetValueParameter(name="name") @NotNull Name name, @JetValueParameter(name="tracing") @NotNull TracingStrategy tracing, @JetValueParameter(name="callableDescriptorCollectors") @NotNull CallableDescriptorCollectors<D> callableDescriptorCollectors) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(tracing, "tracing");
        Intrinsics.checkParameterIsNotNull(callableDescriptorCollectors, "callableDescriptorCollectors");
        ReceiverValue explicitReceiver = ((CallResolutionContext)context2).call.getExplicitReceiver();
        ResolutionTaskHolder result2 = new ResolutionTaskHolder(this.storageManager, context2, new PriorityProviderImpl(context2), tracing);
        JetScope jetScope = ((ResolutionContext)context2).scope;
        Intrinsics.checkExpressionValueIsNotNull(jetScope, "context.scope");
        TaskPrioritizerContext taskPrioritizerContext = new TaskPrioritizerContext(name, result2, context2, jetScope, callableDescriptorCollectors);
        if (explicitReceiver instanceof QualifierReceiver) {
            ReceiverValue receiverValue = explicitReceiver;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "explicitReceiver");
            QualifierReceiver qualifierReceiver = (QualifierReceiver)receiverValue;
            ReceiverValue receiverValue2 = ReceiverValue.NO_RECEIVER;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue2, "NO_RECEIVER");
            this.doComputeTasks(receiverValue2, taskPrioritizerContext.replaceScope(qualifierReceiver.getNestedClassesAndPackageMembersScope()));
            this.computeTasksForClassObjectReceiver(qualifierReceiver, taskPrioritizerContext);
        } else {
            ReceiverValue receiverValue = explicitReceiver;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "explicitReceiver");
            this.doComputeTasks(receiverValue, taskPrioritizerContext);
        }
        return result2.getTasks();
    }

    private final <D extends CallableDescriptor, F extends D> void computeTasksForClassObjectReceiver(@JetValueParameter(name="qualifierReceiver") QualifierReceiver qualifierReceiver, @JetValueParameter(name="taskPrioritizerContext") TaskPrioritizerContext<D, F> taskPrioritizerContext) {
        ReceiverValue classObjectReceiver = qualifierReceiver.getClassObjectReceiver();
        if (!classObjectReceiver.exists()) {
            return;
        }
        ClassifierDescriptor classifierDescriptor = qualifierReceiver.getClassifier();
        this.doComputeTasks(classObjectReceiver, taskPrioritizerContext.filterCollectors(new Function1<D, Boolean>(classifierDescriptor){
            final /* synthetic */ ClassifierDescriptor $classifierDescriptor;

            public final boolean invoke(@JetValueParameter(name="it") @NotNull D it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                return this.$classifierDescriptor instanceof ClassDescriptor && ((ClassDescriptor)this.$classifierDescriptor).getCompanionObjectDescriptor() != null ? !(it2 instanceof ConstructorDescriptor) && !(it2 instanceof FakeCallableDescriptorForObject) : (this.$classifierDescriptor != null && DescriptorUtils.isEnumEntry(this.$classifierDescriptor) ? !(it2 instanceof FakeCallableDescriptorForObject) : true);
            }
            {
                this.$classifierDescriptor = classifierDescriptor;
                super(1);
            }
        }));
    }

    private final <D extends CallableDescriptor, F extends D> void doComputeTasks(@JetValueParameter(name="receiver") ReceiverValue receiver, @JetValueParameter(name="c") TaskPrioritizerContext<D, F> c) {
        ProgressIndicatorProvider.checkCanceled();
        boolean resolveInvoke = ((CallResolutionContext)c.getContext()).call.getDispatchReceiver().exists();
        if (resolveInvoke) {
            this.addCandidatesForInvoke(receiver, c);
            return;
        }
        LinkedHashSet implicitReceivers = Sets.newLinkedHashSet((Iterable)JetScopeUtils.getImplicitReceiversHierarchyValues(c.getScope()));
        if (receiver.exists()) {
            Collection collection = implicitReceivers;
            Intrinsics.checkExpressionValueIsNotNull(collection, "implicitReceivers");
            this.addCandidatesForExplicitReceiver(receiver, collection, c, true);
            this.addMembers(receiver, c, true, true);
            return;
        }
        Collection collection = implicitReceivers;
        Intrinsics.checkExpressionValueIsNotNull(collection, "implicitReceivers");
        this.addCandidatesForNoReceiver(collection, c);
    }

    private final <D extends CallableDescriptor, F extends D> void addCandidatesForExplicitReceiver(@JetValueParameter(name="explicitReceiver") ReceiverValue explicitReceiver, @JetValueParameter(name="implicitReceivers") Collection<? extends ReceiverValue> implicitReceivers, @JetValueParameter(name="c") TaskPrioritizerContext<D, F> c, @JetValueParameter(name="isExplicit") boolean isExplicit) {
        this.addMembers(explicitReceiver, c, false, isExplicit);
        if (TypesPackage$dynamicTypes$18e465db.isDynamic(explicitReceiver.getType())) {
            this.addCandidatesForDynamicReceiver(explicitReceiver, implicitReceivers, c, isExplicit);
        } else {
            this.addExtensionCandidates(explicitReceiver, implicitReceivers, c, isExplicit);
        }
    }

    private final <D extends CallableDescriptor, F extends D> void addExtensionCandidates(@JetValueParameter(name="explicitReceiver") ReceiverValue explicitReceiver, @JetValueParameter(name="implicitReceivers") Collection<? extends ReceiverValue> implicitReceivers, @JetValueParameter(name="c") TaskPrioritizerContext<D, F> c, @JetValueParameter(name="isExplicit") boolean isExplicit) {
        for (CallableDescriptorCollector<D> callableDescriptorCollector : c.getCallableDescriptorCollectors()) {
            for (ReceiverValue receiverValue : implicitReceivers) {
                this.addMemberExtensionCandidates(receiverValue, explicitReceiver, callableDescriptorCollector, c, this.createKind(ExplicitReceiverKind.EXTENSION_RECEIVER, isExplicit));
            }
            c.getResult().addCandidates(new Function0<Collection<? extends ResolutionCandidate<D>>>(this, c, explicitReceiver, callableDescriptorCollector, isExplicit){
                final /* synthetic */ TaskPrioritizer this$0;
                final /* synthetic */ TaskPrioritizerContext $c;
                final /* synthetic */ ReceiverValue $explicitReceiver;
                final /* synthetic */ CallableDescriptorCollector $callableDescriptorCollector;
                final /* synthetic */ boolean $isExplicit;

                @NotNull
                public final Collection<ResolutionCandidate<D>> invoke() {
                    JetScope jetScope = this.$c.getScope();
                    JetScope jetScope2 = this.$c.getScope();
                    Name name = this.$c.getName();
                    BindingTrace bindingTrace = ((ResolutionContext)this.$c.getContext()).trace;
                    Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.context.trace");
                    Collection<D> collection = this.$callableDescriptorCollector.getExtensionsByName(jetScope2, name, bindingTrace);
                    ExplicitReceiverKind explicitReceiverKind = TaskPrioritizer.access$createKind$0(this.this$0, ExplicitReceiverKind.EXTENSION_RECEIVER, this.$isExplicit);
                    Call call = ((CallResolutionContext)this.$c.getContext()).call;
                    Intrinsics.checkExpressionValueIsNotNull(call, "c.context.call");
                    return this.this$0.convertWithImpliedThis(jetScope, this.$explicitReceiver, collection, explicitReceiverKind, call);
                }
                {
                    this.this$0 = taskPrioritizer;
                    this.$c = taskPrioritizerContext;
                    this.$explicitReceiver = receiverValue;
                    this.$callableDescriptorCollector = callableDescriptorCollector;
                    this.$isExplicit = bl;
                    super(0);
                }
            });
        }
    }

    private final <D extends CallableDescriptor, F extends D> void addMembers(@JetValueParameter(name="explicitReceiver") ReceiverValue explicitReceiver, @JetValueParameter(name="c") TaskPrioritizerContext<D, F> c, @JetValueParameter(name="staticMembers") boolean staticMembers, @JetValueParameter(name="isExplicit") boolean isExplicit) {
        for (CallableDescriptorCollector<D> callableDescriptorCollector : c.getCallableDescriptorCollectors()) {
            c.getResult().addCandidates(new Function0<ArrayList<ResolutionCandidate<D>>>(this, explicitReceiver, c, staticMembers, callableDescriptorCollector, isExplicit){
                final /* synthetic */ TaskPrioritizer this$0;
                final /* synthetic */ ReceiverValue $explicitReceiver;
                final /* synthetic */ TaskPrioritizerContext $c;
                final /* synthetic */ boolean $staticMembers;
                final /* synthetic */ CallableDescriptorCollector $callableDescriptorCollector;
                final /* synthetic */ boolean $isExplicit;

                public final ArrayList<ResolutionCandidate<D>> invoke() {
                    List<JetType> variantsForExplicitReceiver = SmartCastUtils.getSmartCastVariants(this.$explicitReceiver, this.$c.getContext());
                    ArrayList<ResolutionCandidate<D>> members = Lists.newArrayList();
                    for (JetType type2 : variantsForExplicitReceiver) {
                        Collection<D> collection;
                        if (this.$staticMembers) {
                            JetType jetType = type2;
                            Intrinsics.checkExpressionValueIsNotNull(jetType, "type");
                            Name name = this.$c.getName();
                            BindingTrace bindingTrace = ((ResolutionContext)this.$c.getContext()).trace;
                            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.context.trace");
                            collection = this.$callableDescriptorCollector.getStaticMembersByName(jetType, name, bindingTrace);
                        } else {
                            JetType jetType = type2;
                            Intrinsics.checkExpressionValueIsNotNull(jetType, "type");
                            Name name = this.$c.getName();
                            BindingTrace bindingTrace = ((ResolutionContext)this.$c.getContext()).trace;
                            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.context.trace");
                            collection = this.$callableDescriptorCollector.getMembersByName(jetType, name, bindingTrace);
                        }
                        Collection<D> membersForThisVariant = collection;
                        ReceiverValue receiverValue = ReceiverValue.NO_RECEIVER;
                        Intrinsics.checkExpressionValueIsNotNull(receiverValue, "NO_RECEIVER");
                        Collection collection2 = members;
                        Intrinsics.checkExpressionValueIsNotNull(collection2, "members");
                        ExplicitReceiverKind explicitReceiverKind = TaskPrioritizer.access$createKind$0(this.this$0, ExplicitReceiverKind.DISPATCH_RECEIVER, this.$isExplicit);
                        Call call = ((CallResolutionContext)this.$c.getContext()).call;
                        Intrinsics.checkExpressionValueIsNotNull(call, "c.context.call");
                        TaskPrioritizer.access$convertWithReceivers$1(this.this$0, membersForThisVariant, this.$explicitReceiver, receiverValue, collection2, explicitReceiverKind, call);
                    }
                    ArrayList<ResolutionCandidate<D>> arrayList = members;
                    Intrinsics.checkExpressionValueIsNotNull(arrayList, "members");
                    return arrayList;
                }
                {
                    this.this$0 = taskPrioritizer;
                    this.$explicitReceiver = receiverValue;
                    this.$c = taskPrioritizerContext;
                    this.$staticMembers = bl;
                    this.$callableDescriptorCollector = callableDescriptorCollector;
                    this.$isExplicit = bl2;
                    super(0);
                }
            });
        }
    }

    private final <D extends CallableDescriptor, F extends D> void addCandidatesForDynamicReceiver(@JetValueParameter(name="explicitReceiver") ReceiverValue explicitReceiver, @JetValueParameter(name="implicitReceivers") Collection<? extends ReceiverValue> implicitReceivers, @JetValueParameter(name="c") TaskPrioritizerContext<D, F> c, @JetValueParameter(name="isExplicit") boolean isExplicit) {
        TaskPrioritizerContext<D, F> onlyDynamicReceivers = c.replaceCollectors(TasksPackage$dynamicCalls$b5563953.onlyDynamicReceivers(c.getCallableDescriptorCollectors()));
        this.addExtensionCandidates(explicitReceiver, implicitReceivers, onlyDynamicReceivers, isExplicit);
        c.getResult().addCandidates(new Function0<Collection<? extends ResolutionCandidate<D>>>(this, c, explicitReceiver, isExplicit){
            final /* synthetic */ TaskPrioritizer this$0;
            final /* synthetic */ TaskPrioritizerContext $c;
            final /* synthetic */ ReceiverValue $explicitReceiver;
            final /* synthetic */ boolean $isExplicit;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Collection<ResolutionCandidate<D>> invoke() {
                void destination;
                void $receiver;
                Call call = ((CallResolutionContext)this.$c.getContext()).call;
                Intrinsics.checkExpressionValueIsNotNull(call, "c.context.call");
                JetScopeImpl dynamicScope = DynamicCallableDescriptors.createDynamicDescriptorScope(call, this.$c.getScope().getContainingDeclaration());
                Iterable $receiver2 = this.$c.getCallableDescriptorCollectors();
                Iterable iterable = $receiver2;
                Collection collection = new ArrayList<E>();
                for (T element : $receiver) {
                    CallableDescriptorCollector it2 = (CallableDescriptorCollector)element;
                    JetScope jetScope = dynamicScope;
                    Name name = this.$c.getName();
                    BindingTrace bindingTrace = ((ResolutionContext)this.$c.getContext()).trace;
                    Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.context.trace");
                    Iterable list = it2.getNonExtensionsByName(jetScope, name, bindingTrace);
                    KotlinPackage.addAll(destination, list);
                }
                List dynamicDescriptors = (List)destination;
                Collection collection2 = dynamicDescriptors;
                ReceiverValue receiverValue = ReceiverValue.NO_RECEIVER;
                Intrinsics.checkExpressionValueIsNotNull(receiverValue, "NO_RECEIVER");
                ExplicitReceiverKind explicitReceiverKind = TaskPrioritizer.access$createKind$0(this.this$0, ExplicitReceiverKind.DISPATCH_RECEIVER, this.$isExplicit);
                Call call2 = ((CallResolutionContext)this.$c.getContext()).call;
                Intrinsics.checkExpressionValueIsNotNull(call2, "c.context.call");
                return TaskPrioritizer.access$convertWithReceivers$2(this.this$0, collection2, this.$explicitReceiver, receiverValue, explicitReceiverKind, call2);
            }
            {
                this.this$0 = taskPrioritizer;
                this.$c = taskPrioritizerContext;
                this.$explicitReceiver = receiverValue;
                this.$isExplicit = bl;
                super(0);
            }
        });
    }

    private final ExplicitReceiverKind createKind(@JetValueParameter(name="kind") ExplicitReceiverKind kind, @JetValueParameter(name="isExplicit") boolean isExplicit) {
        if (isExplicit) {
            return kind;
        }
        return ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
    }

    private final <D extends CallableDescriptor, F extends D> void addMemberExtensionCandidates(@JetValueParameter(name="dispatchReceiver") ReceiverValue dispatchReceiver, @JetValueParameter(name="receiverParameter") ReceiverValue receiverParameter, @JetValueParameter(name="callableDescriptorCollector") CallableDescriptorCollector<D> callableDescriptorCollector, @JetValueParameter(name="c") TaskPrioritizerContext<D, F> c, @JetValueParameter(name="receiverKind") ExplicitReceiverKind receiverKind) {
        c.getResult().addCandidates(new Function0<Collection<? extends ResolutionCandidate<D>>>(this, callableDescriptorCollector, dispatchReceiver, c, receiverParameter, receiverKind){
            final /* synthetic */ TaskPrioritizer this$0;
            final /* synthetic */ CallableDescriptorCollector $callableDescriptorCollector;
            final /* synthetic */ ReceiverValue $dispatchReceiver;
            final /* synthetic */ TaskPrioritizerContext $c;
            final /* synthetic */ ReceiverValue $receiverParameter;
            final /* synthetic */ ExplicitReceiverKind $receiverKind;

            @NotNull
            public final Collection<ResolutionCandidate<D>> invoke() {
                JetScope jetScope = this.$dispatchReceiver.getType().getMemberScope();
                Intrinsics.checkExpressionValueIsNotNull(jetScope, "dispatchReceiver.getType().getMemberScope()");
                Name name = this.$c.getName();
                BindingTrace bindingTrace = ((ResolutionContext)this.$c.getContext()).trace;
                Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.context.trace");
                Collection<D> memberExtensions = this.$callableDescriptorCollector.getExtensionsByName(jetScope, name, bindingTrace);
                Call call = ((CallResolutionContext)this.$c.getContext()).call;
                Intrinsics.checkExpressionValueIsNotNull(call, "c.context.call");
                return TaskPrioritizer.access$convertWithReceivers$2(this.this$0, memberExtensions, this.$dispatchReceiver, this.$receiverParameter, this.$receiverKind, call);
            }
            {
                this.this$0 = taskPrioritizer;
                this.$callableDescriptorCollector = callableDescriptorCollector;
                this.$dispatchReceiver = receiverValue;
                this.$c = taskPrioritizerContext;
                this.$receiverParameter = receiverValue2;
                this.$receiverKind = explicitReceiverKind;
                super(0);
            }
        });
    }

    private final <D extends CallableDescriptor, F extends D> void addCandidatesForNoReceiver(@JetValueParameter(name="implicitReceivers") Collection<? extends ReceiverValue> implicitReceivers, @JetValueParameter(name="c") TaskPrioritizerContext<D, F> c) {
        ArrayList localsList = Lists.newArrayList();
        ArrayList nonlocalsList = Lists.newArrayList();
        for (CallableDescriptorCollector<D> callableDescriptorCollector : c.getCallableDescriptorCollectors()) {
            JetScope jetScope = c.getScope();
            JetScope jetScope2 = c.getScope();
            Name name = c.getName();
            BindingTrace bindingTrace = ((ResolutionContext)c.getContext()).trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.context.trace");
            Collection<D> collection = callableDescriptorCollector.getNonExtensionsByName(jetScope2, name, bindingTrace);
            Call call = ((CallResolutionContext)c.getContext()).call;
            Intrinsics.checkExpressionValueIsNotNull(call, "c.context.call");
            Collection<ResolutionCandidate<D>> members = this.convertWithImpliedThisAndNoReceiver(jetScope, collection, call);
            ArrayList nonlocals = Lists.newArrayList();
            ArrayList locals = Lists.newArrayList();
            DeclarationDescriptor declarationDescriptor = c.getScope().getContainingDeclaration();
            Collection collection2 = locals;
            Intrinsics.checkExpressionValueIsNotNull(collection2, "locals");
            Collection collection3 = nonlocals;
            Intrinsics.checkExpressionValueIsNotNull(collection3, "nonlocals");
            this.splitLexicallyLocalDescriptors(members, declarationDescriptor, collection2, collection3);
            localsList.add(locals);
            nonlocalsList.add(nonlocals);
        }
        ResolutionTaskHolder<D, F> resolutionTaskHolder = c.getResult();
        List list = localsList;
        Intrinsics.checkExpressionValueIsNotNull(list, "localsList");
        resolutionTaskHolder.addCandidates(list);
        for (ReceiverValue receiverValue : implicitReceivers) {
            this.addCandidatesForExplicitReceiver(receiverValue, implicitReceivers, c, false);
        }
        ResolutionTaskHolder<D, F> resolutionTaskHolder2 = c.getResult();
        List list2 = nonlocalsList;
        Intrinsics.checkExpressionValueIsNotNull(list2, "nonlocalsList");
        resolutionTaskHolder2.addCandidates(list2);
        for (ReceiverValue receiverValue : implicitReceivers) {
            this.addMembers(receiverValue, c, true, false);
        }
    }

    private final <D extends CallableDescriptor, F extends D> void addCandidatesForInvoke(@JetValueParameter(name="explicitReceiver") ReceiverValue explicitReceiver, @JetValueParameter(name="c") TaskPrioritizerContext<D, F> c) {
        List<ReceiverValue> implicitReceivers = JetScopeUtils.getImplicitReceiversHierarchyValues(c.getScope());
        ReceiverValue variableReceiver = ((CallResolutionContext)c.getContext()).call.getDispatchReceiver();
        KotlinPackage.assert(variableReceiver.exists(), "'Invoke' call hasn't got variable receiver");
        if (!explicitReceiver.exists()) {
            ReceiverValue receiverValue = variableReceiver;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "variableReceiver");
            Collection collection = implicitReceivers;
            Intrinsics.checkExpressionValueIsNotNull(collection, "implicitReceivers");
            this.addCandidatesForExplicitReceiver(receiverValue, collection, c, true);
        }
        if (explicitReceiver.exists()) {
            ReceiverValue receiverValue = variableReceiver;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "variableReceiver");
            this.addCandidatesWhenInvokeIsMemberAndExtensionToExplicitReceiver(receiverValue, explicitReceiver, c, ExplicitReceiverKind.BOTH_RECEIVERS);
            return;
        }
        for (ReceiverValue implicitReceiver : implicitReceivers) {
            ReceiverValue receiverValue = variableReceiver;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "variableReceiver");
            ReceiverValue receiverValue2 = implicitReceiver;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue2, "implicitReceiver");
            this.addCandidatesWhenInvokeIsMemberAndExtensionToExplicitReceiver(receiverValue, receiverValue2, c, ExplicitReceiverKind.DISPATCH_RECEIVER);
        }
    }

    private final <D extends CallableDescriptor, F extends D> void addCandidatesWhenInvokeIsMemberAndExtensionToExplicitReceiver(@JetValueParameter(name="dispatchReceiver") ReceiverValue dispatchReceiver, @JetValueParameter(name="receiverParameter") ReceiverValue receiverParameter, @JetValueParameter(name="c") TaskPrioritizerContext<D, F> c, @JetValueParameter(name="receiverKind") ExplicitReceiverKind receiverKind) {
        for (CallableDescriptorCollector<D> callableDescriptorCollector : c.getCallableDescriptorCollectors()) {
            this.addMemberExtensionCandidates(dispatchReceiver, receiverParameter, callableDescriptorCollector, c, receiverKind);
        }
    }

    private final <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> convertWithReceivers(@JetValueParameter(name="descriptors") Collection<? extends D> descriptors, @JetValueParameter(name="dispatchReceiver") ReceiverValue dispatchReceiver, @JetValueParameter(name="extensionReceiver") ReceiverValue extensionReceiver2, @JetValueParameter(name="explicitReceiverKind") ExplicitReceiverKind explicitReceiverKind, @JetValueParameter(name="call") Call call) {
        ArrayList result2 = Lists.newArrayList();
        Collection collection = result2;
        Intrinsics.checkExpressionValueIsNotNull(collection, "result");
        this.convertWithReceivers(descriptors, dispatchReceiver, extensionReceiver2, collection, explicitReceiverKind, call);
        Collection collection2 = result2;
        Intrinsics.checkExpressionValueIsNotNull(collection2, "result");
        return collection2;
    }

    private final <D extends CallableDescriptor> void convertWithReceivers(@JetValueParameter(name="descriptors") Collection<? extends D> descriptors, @JetValueParameter(name="dispatchReceiver") ReceiverValue dispatchReceiver, @JetValueParameter(name="extensionReceiver") ReceiverValue extensionReceiver2, @JetValueParameter(name="result") Collection<ResolutionCandidate<D>> result2, @JetValueParameter(name="explicitReceiverKind") ExplicitReceiverKind explicitReceiverKind, @JetValueParameter(name="call") Call call) {
        for (CallableDescriptor descriptor : descriptors) {
            ResolutionCandidate<CallableDescriptor> candidate = ResolutionCandidate.create(call, descriptor);
            candidate.setDispatchReceiver(dispatchReceiver);
            candidate.setExtensionReceiver(extensionReceiver2);
            candidate.setExplicitReceiverKind(explicitReceiverKind);
            ResolutionCandidate<CallableDescriptor> resolutionCandidate = candidate;
            Intrinsics.checkExpressionValueIsNotNull(resolutionCandidate, "candidate");
            result2.add(resolutionCandidate);
        }
    }

    @NotNull
    public final <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> convertWithImpliedThisAndNoReceiver(@JetValueParameter(name="scope") @NotNull JetScope scope2, @JetValueParameter(name="descriptors") @NotNull Collection<? extends D> descriptors, @JetValueParameter(name="call") @NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        Intrinsics.checkParameterIsNotNull(call, "call");
        ReceiverValue receiverValue = ReceiverValue.NO_RECEIVER;
        Intrinsics.checkExpressionValueIsNotNull(receiverValue, "NO_RECEIVER");
        return this.convertWithImpliedThis(scope2, receiverValue, descriptors, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, call);
    }

    @NotNull
    public final <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> convertWithImpliedThis(@JetValueParameter(name="scope") @NotNull JetScope scope2, @JetValueParameter(name="receiverParameter") @NotNull ReceiverValue receiverParameter, @JetValueParameter(name="descriptors") @NotNull Collection<? extends D> descriptors, @JetValueParameter(name="receiverKind") @NotNull ExplicitReceiverKind receiverKind, @JetValueParameter(name="call") @NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(receiverParameter, "receiverParameter");
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        Intrinsics.checkParameterIsNotNull((Object)receiverKind, "receiverKind");
        Intrinsics.checkParameterIsNotNull(call, "call");
        ArrayList<ResolutionCandidate<CallableDescriptor>> result2 = Lists.newArrayList();
        for (CallableDescriptor descriptor : descriptors) {
            ResolutionCandidate<CallableDescriptor> candidate = ResolutionCandidate.create(call, descriptor);
            candidate.setExtensionReceiver(receiverParameter);
            candidate.setExplicitReceiverKind(receiverKind);
            ResolutionCandidate<CallableDescriptor> resolutionCandidate = candidate;
            Intrinsics.checkExpressionValueIsNotNull(resolutionCandidate, "candidate");
            if (!this.setImpliedThis(scope2, resolutionCandidate)) continue;
            result2.add(candidate);
        }
        Collection collection = result2;
        Intrinsics.checkExpressionValueIsNotNull(collection, "result");
        return collection;
    }

    private final <D extends CallableDescriptor> boolean setImpliedThis(@JetValueParameter(name="scope") JetScope scope2, @JetValueParameter(name="candidate") ResolutionCandidate<D> candidate) {
        ReceiverParameterDescriptor dispatchReceiver = candidate.getDescriptor().getDispatchReceiverParameter();
        if (dispatchReceiver == null) {
            return true;
        }
        List<ReceiverParameterDescriptor> receivers = scope2.getImplicitReceiversHierarchy();
        for (ReceiverParameterDescriptor receiver : receivers) {
            if (!JetTypeChecker.DEFAULT.isSubtypeOf(receiver.getType(), dispatchReceiver.getType())) continue;
            candidate.setDispatchReceiver(dispatchReceiver.getValue());
            return true;
        }
        return false;
    }

    @NotNull
    public final <D extends CallableDescriptor, F extends D> List<ResolutionTask<D, F>> computePrioritizedTasksFromCandidates(@JetValueParameter(name="context") @NotNull BasicCallResolutionContext context2, @JetValueParameter(name="candidates") @NotNull Collection<? extends ResolutionCandidate<D>> candidates, @JetValueParameter(name="tracing") @NotNull TracingStrategy tracing) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Intrinsics.checkParameterIsNotNull(candidates, "candidates");
        Intrinsics.checkParameterIsNotNull(tracing, "tracing");
        ResolutionTaskHolder result2 = new ResolutionTaskHolder(this.storageManager, context2, new PriorityProviderImpl(context2), tracing);
        result2.addCandidates(new Function0<Collection<? extends ResolutionCandidate<D>>>(candidates){
            final /* synthetic */ Collection $candidates;

            @NotNull
            public final Collection<ResolutionCandidate<D>> invoke() {
                return this.$candidates;
            }
            {
                this.$candidates = collection;
                super(0);
            }
        });
        return result2.getTasks();
    }

    public TaskPrioritizer(@JetValueParameter(name="storageManager") @NotNull StorageManager storageManager) {
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        this.storageManager = storageManager;
    }

    @NotNull
    public static final /* synthetic */ ExplicitReceiverKind access$createKind$0(@JetValueParameter(name="$this", type="?") TaskPrioritizer $this, @JetValueParameter(name="kind") @NotNull ExplicitReceiverKind kind, @JetValueParameter(name="isExplicit") boolean isExplicit) {
        return $this.createKind(kind, isExplicit);
    }

    public static final /* synthetic */ <D extends CallableDescriptor> void access$convertWithReceivers$1(@JetValueParameter(name="$this", type="?") TaskPrioritizer $this, @JetValueParameter(name="descriptors") @NotNull Collection<? extends D> descriptors, @JetValueParameter(name="dispatchReceiver") @NotNull ReceiverValue dispatchReceiver, @JetValueParameter(name="extensionReceiver") @NotNull ReceiverValue extensionReceiver2, @JetValueParameter(name="result") @NotNull Collection<ResolutionCandidate<D>> result2, @JetValueParameter(name="explicitReceiverKind") @NotNull ExplicitReceiverKind explicitReceiverKind, @JetValueParameter(name="call") @NotNull Call call) {
        $this.convertWithReceivers(descriptors, dispatchReceiver, extensionReceiver2, result2, explicitReceiverKind, call);
    }

    @NotNull
    public static final /* synthetic */ <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> access$convertWithReceivers$2(@JetValueParameter(name="$this", type="?") TaskPrioritizer $this, @JetValueParameter(name="descriptors") @NotNull Collection<? extends D> descriptors, @JetValueParameter(name="dispatchReceiver") @NotNull ReceiverValue dispatchReceiver, @JetValueParameter(name="extensionReceiver") @NotNull ReceiverValue extensionReceiver2, @JetValueParameter(name="explicitReceiverKind") @NotNull ExplicitReceiverKind explicitReceiverKind, @JetValueParameter(name="call") @NotNull Call call) {
        return $this.convertWithReceivers(descriptors, dispatchReceiver, extensionReceiver2, explicitReceiverKind, call);
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"Q\u0006)!\u0002K]5pe&$\u0018\u0010\u0015:pm&$WM]%na2Tq\u0002V1tWB\u0013\u0018n\u001c:ji&TXM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*9!/Z:pYZ,'\"B2bY2\u001c(\"\u0002;bg.\u001c(\"\u0001#\u000b%\r\u000bG\u000e\\1cY\u0016$Um]2sSB$xN\u001d\u0006\fI\u0016\u001c8M]5qi>\u00148O\u0003\tQe&|'/\u001b;z!J|g/\u001b3fe*!\"+Z:pYV$\u0018n\u001c8UCN\\\u0007j\u001c7eKJT1CU3t_2,H/[8o\u0007\u0006tG-\u001b3bi\u0016Ta\u0001P5oSRt$bB2p]R,\u0007\u0010\u001e\u0006\u001b\u0005\u0006\u001c\u0018nY\"bY2\u0014Vm]8mkRLwN\\\"p]R,\u0007\u0010\u001e\u0006\u000fO\u0016$X*\u0019=Qe&|'/\u001b;z\u0015\rIe\u000e\u001e\u0006\fO\u0016$\bK]5pe&$\u0018PC\u0005dC:$\u0017\u000eZ1uK*Q\u0002.Y:J[Bd\u0017nY5u\tft\u0017-\\5d%\u0016\u001cW-\u001b<fe*9!i\\8mK\u0006t'\"D5t'ftG\u000f[3tSj,GMC\u0005jgZK7/\u001b2mK\u001a\r!B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0003\t\u0007A1!\u0002\u0002\u0005\u0005!\u001dQa\u0001C\u0003\u0011\u0003a\u0001!B\u0002\u0005\u0007!\u0001A\u0002A\u0003\u0003\t\u0005AQ!B\u0002\u0005\t!%A\u0002A\u0003\u0004\t\u000bAa\u0001\u0004\u0001\u0006\u0007\u0011)\u00012\u0002\u0007\u0001\u000b\r!)\u0001#\u0004\r\u0001\u0015\u0011AA\u0001E\b\u000b\r!i\u0001\u0003\u0005\r\u0001\u0015\u0011AQ\u0002\u0005\t\u000b\u0005A!!B\u0002\u0005\u0011!IA\u0002A\u0003\u0003\t\u000bAi!B\u0002\u0005\u0011!YA\u0002\u0001\u0003\u0002\u0019\u000f)R\u0001\u0002\u0001\t\tU\u0011Q!\u0001E\u00053-)\u0011\u0001c\u0003\n\u0011%9Q!\u0001\u0005\u0007\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001Qf\u0003\u0003b\ta=\u0011EA\u0003\u0002\u0011\u001d)6\u0001B\u0003\u0004\t\u001fI\u0011\u0001c\u0004.\u0014\u0011Y\u0001\u0014C\u0011\u0003\u000b\u0005A\t\"U\u0002\u0004\t#I\u0011\u0001\"\u0002.1\u0011Y\u00014CO\f\t\u0001A!\"D\u0004\u0006\u0003!1\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001Q\u0007\u0001\t#!B\u0001\t\u0012E\u001bQ\u0001b\u0005\n\u0003\u0011\u0015Q\"\u0001\u0005\n[a!\u0001\u0001'\u0006\u001e\u0018\u0011\u0001\u0001BC\u0007\b\u000b\u0005Aa!\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001\u0005\u0001!\u000e\u0001\u0011EA\u0003\u0002\u0011'\t6!\u0002C\u000b\u0013\u0005!\t!D\u0001\t\u00135BB!\u0001M\f;/!\u0001\u0001\u0003\u0006\u000e\u000f\u0015\t\u0001BB\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001A\u001b\u0001!\t\u0002\u0006\u0003!M\u0011kA\u0003\u0005\u0018%\tA\u0011A\u0007\u0002\u0011%i\u0013\u0004B\u0001\u0019\u0019ueA\u0001\u0001\u0005\u000b\u001b!)\u0011\u0001\u0003\u0004\n\t%\u0019QA\u0001C\u0001\u0011\u0001a\t\u0001U\u0002\u0001C\t)\u0011\u0001c\u0005R\u0007\u0015!A\"C\u0001\u0005\u00025\t\u0001\"C[ \u000b{!1\u001dA\t\u0006\t\u0001AA!\u0006\u0002\u0006\u0003!%\u0001dBO\u0007\t\u0001Ay!\u0004\u0002\u0006\u0003!9\u0001k\u0001\u0001\"\u000f\u0015\t\u0001rA\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001E\u001bQ\u0001B\u0004\n\u0003\u0011\u0001Q\"\u0001E\b"})
    private static final class PriorityProviderImpl<D extends CallableDescriptor>
    implements ResolutionTaskHolder.PriorityProvider<ResolutionCandidate<D>> {
        public static final /* synthetic */ KClass $kotlinClass;
        private final BasicCallResolutionContext context;

        static {
            $kotlinClass = Reflection.createKotlinClass(PriorityProviderImpl.class);
        }

        @Override
        public int getPriority(@JetValueParameter(name="candidate") @NotNull ResolutionCandidate<D> candidate) {
            Intrinsics.checkParameterIsNotNull(candidate, "candidate");
            return this.hasImplicitDynamicReceiver(candidate) ? 0 : (this.isVisible(candidate) ? 2 : 0) + (this.isSynthesized(candidate) ? 0 : 1);
        }

        @Override
        public int getMaxPriority() {
            return 3;
        }

        private final boolean isVisible(@JetValueParameter(name="candidate", type="?") ResolutionCandidate<D> candidate) {
            if (candidate == null) {
                return false;
            }
            D candidateDescriptor = candidate.getDescriptor();
            if (ErrorUtils.isError((DeclarationDescriptor)candidateDescriptor)) {
                return true;
            }
            ReceiverValue receiverValue = ExpressionTypingUtils.normalizeReceiverValueForVisibility(candidate.getDispatchReceiver(), ((ResolutionContext)this.context).trace.getBindingContext());
            return Visibilities.isVisible(receiverValue, (DeclarationDescriptorWithVisibility)candidateDescriptor, ((ResolutionContext)this.context).scope.getContainingDeclaration());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isSynthesized(@JetValueParameter(name="candidate") ResolutionCandidate<D> candidate) {
            D descriptor = candidate.getDescriptor();
            if (!(descriptor instanceof CallableMemberDescriptor)) return false;
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)descriptor;
            Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "descriptor");
            if (!CallResolverUtil.isOrOverridesSynthesized(callableMemberDescriptor)) return false;
            return true;
        }

        public final boolean hasImplicitDynamicReceiver(@JetValueParameter(name="candidate") @NotNull ResolutionCandidate<D> candidate) {
            Intrinsics.checkParameterIsNotNull(candidate, "candidate");
            return (!candidate.getExplicitReceiverKind().isDispatchReceiver() || !candidate.getCall().getExplicitReceiver().exists()) && TasksPackage$dynamicCalls$b5563953.isDynamic((DeclarationDescriptor)candidate.getDescriptor());
        }

        public PriorityProviderImpl(@JetValueParameter(name="context") @NotNull BasicCallResolutionContext context2) {
            Intrinsics.checkParameterIsNotNull(context2, "context");
            this.context = context2;
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"(\n)1B+Y:l!JLwN]5uSj,'oQ8oi\u0016DHOC\bUCN\\\u0007K]5pe&$\u0018N_3s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'b\u0002:fg>dg/\u001a\u0006\u0006G\u0006dGn\u001d\u0006\u0006i\u0006\u001c8n\u001d\u0006\u0002\t*\u00112)\u00197mC\ndW\rR3tGJL\u0007\u000f^8s\u0015-!Wm]2sSB$xN]:\u000b\u0003\u0019S1!\u00118z\u0015\u0019a\u0014N\\5u})!a.Y7f\u0015\u0011q\u0015-\\3\u000b\rI,7/\u001e7u\u0015Q\u0011Vm]8mkRLwN\u001c+bg.Du\u000e\u001c3fe*91m\u001c8uKb$(B\u0007\"bg&\u001c7)\u00197m%\u0016\u001cx\u000e\\;uS>t7i\u001c8uKb$(\"B:d_B,'\u0002\u0003&fiN\u001bw\u000e]3\u000b\rM\u001cw\u000e]3t\u0015q\u0019\u0017\r\u001c7bE2,G)Z:de&\u0004Ho\u001c:D_2dWm\u0019;peNTAdQ1mY\u0006\u0014G.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe\u000e{G\u000e\\3di>\u00148O\u0003\u0006d_2dWm\u0019;peNTqdZ3u\u0007\u0006dG.\u00192mK\u0012+7o\u0019:jaR|'oQ8mY\u0016\u001cGo\u001c:t\u0015)9W\r^\"p]R,\u0007\u0010\u001e\u0006\bO\u0016$h*Y7f\u0015%9W\r\u001e*fgVdGO\u0003\u0005hKR\u001c6m\u001c9f\u0015A1\u0017\u000e\u001c;fe\u000e{G\u000e\\3di>\u00148O\u0003\u0004gS2$XM\u001d\u0006\n\rVt7\r^5p]FRqAQ8pY\u0016\fgN\u0003\u0014UCN\\\u0007K]5pe&$\u0018N_3sIQ\u000b7o\u001b)sS>\u0014\u0018\u000e^5{KJ\u001cuN\u001c;fqRT1A\u001b<n\u0015%1WO\\2uS>t7OC\tsKBd\u0017mY3D_2dWm\u0019;peNTQB\\3x\u0007>dG.Z2u_J\u001c(\u0002\u0004:fa2\f7-Z*d_B,'\u0002\u00038foN\u001bw\u000e]3S\u0004)\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\u0015QA\u0001C\u0002\u0011\r)!\u0001\u0002\u0002\t\b\u0015\u0019AQ\u0001E\u0001\u0019\u0001)1\u0001B\u0002\t\u00011\u0001QA\u0001\u0003\u0002\u0011\u0015)1\u0001\u0002\u0003\t\n1\u0001Q!\u0001\u0005\u0003\u000b\r!Q\u0001\u0003\u0004\r\u0001\u0015\u0011A!\u0001\u0005\b\u000b\r!a\u0001c\u0004\r\u0001\u0015\u0019AQ\u0001E\t\u0019\u0001)!\u0001\u0002\u0002\t\u0013\u0015\u0019Aq\u0002E\n\u0019\u0001)!\u0001b\u0001\t\u0017\u0015\u0019A\u0011\u0003E\u000b\u0019\u0001)!\u0001\"\u0002\t\u001a\u0015\u0019A1\u0003\u0005\r\u0019\u0001)!\u0001\u0002\u0004\t\u0010\u0015\u0011AQ\u0001E\t\u000b\t!y\u0001c\u0005\u0006\u0005\u0011E\u0001RC\u0003\u0003\t'AA\"B\u0002\u0005\u000b!\u0005B\u0002A\u0003\u0004\t\u0015A\u0011\u0003\u0004\u0001\u0006\u0005\u0011\u0015\u00012E\u0003\u0003\t\u0015A!#\u0002\u0002\u0005\u001e!\u0015RA\u0001\u0003\u0010\u0011C!\u0011\u0001d\u0002\u0016\u000b\u0011\u0001\u0001\u0002B\u000b\u0003\u000b\u0005AI!\u0006\u0004\u0005\u0002!-QcA\u0003\u0003\t\u0003A\u0001!\u0007\u0002\u0006\u0003!-Q\u0006\u0006\u0003a\ta]\u0011eB\u0003\u0002\u0011)IA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0002A+\u0004\u0011\u0015\u0019AqC\u0005\u0002\u00113i1\u0001B\u0007\n\u0003!eQf\u0004\u0003a\taI\u0011EA\u0003\u0002\u0011!)6\u0001C\u0003\u0004\t%I\u0011\u0001c\u0006\u000e\u0007\u0011m\u0011\"\u0001E\f[=!\u0001\r\u0002\r\bC\t)\u0011\u0001#\u0004V\u0007!)1\u0001B\u0004\n\u0003!UQb\u0001\u0003\u000f\u0013\u0005A)\"L\r\u0005A\u0012A\u0002\"\t\u0007\u0006\u0003!9\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001\n\t%\u0019QA\u0001C\u0001\u0011\u0003)6\u0001C\u0003\u0004\t!I\u0011\u0001C\u0006\u000e\u0007\u0011u\u0011\"\u0001\u0005\f[=!\u0001\r\u0002\r\u000bC\t)\u0011\u0001C\u0005V\u0007!)1\u0001\u0002\u0006\n\u0003!aQb\u0001\u0003\u0010\u0013\u0005AA\"\f\u0014\u0005\u0001a}Qt\u0004\u0003\u0001\u0011Ai1\"B\u0001\t\u001b%!\u0011bA\u0003\u0003\t\u0003A\u0001!C\u0002\n\u0005\u0015\t\u00012\u0004)\u0004\u0001\u0005bQ!\u0001E\u0004\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001#\u0001R\u0007\u0015!y\"C\u0001\t\u001d5\t\u0001rD\u0017#\t\u0001A2#h\u0006\u0005\u0001!\u001dRbB\u0003\u0002\u0011)IA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0002\u0001)\u0004\u0001\u0005bQ!\u0001E\u0004\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001#\u0001R\u0007\u0015!1#C\u0001\t\u001d5\t\u0001\u0012D\u0017\u001e\t\u0001AB#(\u0004\u0005\u0001!%RBA\u0003\u0002\u0011%\u00016\u0001A\u0011\r\u000b\u0005A9!\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001\u0005\u0001\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0005\u0011kA\u0003\u0005)%\t\u0001BD\u0007\u0002\u00111)\u0014\u001dAC`\u0002\u0011\u0019\u000f!E\u0003\u0005\u0001!!QCA\u0003\u0002\u0011\u0013\tb\u0001\"\u0001\t\fU\u0019QA\u0001C\u0001\u0011\u0001Aj!(\u0004\u0005\u0001!9QBA\u0003\u0002\u0011\u001b\u00016\u0001AO\u0011\t\u0001A\u0001\"\u0004\u0007\u0006\u0003!9\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001\n\t%\u0019QA\u0001C\u0001\u0011\u0003\u00016\u0011AO\u0007\t\u0001A\u0011\"\u0004\u0002\u0006\u0003!A\u0001kA\u0001\u001e\u000e\u0011\u0001\u0001BC\u0007\u0003\u000b\u0005A\u0011\u0002UB\u0002;/!\u0001\u0001c\u0006\u000e\u000f\u0015\t\u0001BC\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001A\u001b!!\t\u0007\u0006\u0003!\u001d\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001\n\t%\u0019QA\u0001C\u0001\u0011\u0003\t6!\u0004C\u0007\u0013\u0005!\u0001!D\u0001\t\u00165\t\u0001bC\u0007\u0002\u0011/i\u0011\u0001\u0003\u0007\u000e\u0003!e\u0001"})
    private static final class TaskPrioritizerContext<D extends CallableDescriptor, F extends D> {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final Name name;
        @NotNull
        private final ResolutionTaskHolder<D, F> result;
        @NotNull
        private final BasicCallResolutionContext context;
        @NotNull
        private final JetScope scope;
        @NotNull
        private final CallableDescriptorCollectors<D> callableDescriptorCollectors;

        static {
            $kotlinClass = Reflection.createKotlinClass(TaskPrioritizerContext.class);
        }

        @NotNull
        public final TaskPrioritizerContext<D, F> replaceScope(@JetValueParameter(name="newScope") @NotNull JetScope newScope) {
            Intrinsics.checkParameterIsNotNull(newScope, "newScope");
            return new TaskPrioritizerContext<D, F>(this.name, this.result, this.context, newScope, this.callableDescriptorCollectors);
        }

        @NotNull
        public final TaskPrioritizerContext<D, F> replaceCollectors(@JetValueParameter(name="newCollectors") @NotNull CallableDescriptorCollectors<D> newCollectors) {
            Intrinsics.checkParameterIsNotNull(newCollectors, "newCollectors");
            return new TaskPrioritizerContext<D, F>(this.name, this.result, this.context, this.scope, newCollectors);
        }

        @NotNull
        public final TaskPrioritizerContext<D, F> filterCollectors(@JetValueParameter(name="filter") @NotNull Function1<? super D, ? extends Boolean> filter) {
            Intrinsics.checkParameterIsNotNull(filter, "filter");
            return new TaskPrioritizerContext<D, F>(this.name, this.result, this.context, this.scope, CollectorsPackage$CallableDescriptorCollectors$50805b7c.filtered(this.callableDescriptorCollectors, filter));
        }

        @NotNull
        public final Name getName() {
            return this.name;
        }

        @NotNull
        public final ResolutionTaskHolder<D, F> getResult() {
            return this.result;
        }

        @NotNull
        public final BasicCallResolutionContext getContext() {
            return this.context;
        }

        @NotNull
        public final JetScope getScope() {
            return this.scope;
        }

        @NotNull
        public final CallableDescriptorCollectors<D> getCallableDescriptorCollectors() {
            return this.callableDescriptorCollectors;
        }

        public TaskPrioritizerContext(@JetValueParameter(name="name") @NotNull Name name, @JetValueParameter(name="result") @NotNull ResolutionTaskHolder<D, F> result2, @JetValueParameter(name="context") @NotNull BasicCallResolutionContext context2, @JetValueParameter(name="scope") @NotNull JetScope scope2, @JetValueParameter(name="callableDescriptorCollectors") @NotNull CallableDescriptorCollectors<D> callableDescriptorCollectors) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(result2, "result");
            Intrinsics.checkParameterIsNotNull(context2, "context");
            Intrinsics.checkParameterIsNotNull(scope2, "scope");
            Intrinsics.checkParameterIsNotNull(callableDescriptorCollectors, "callableDescriptorCollectors");
            this.name = name;
            this.result = result2;
            this.context = context2;
            this.scope = scope2;
            this.callableDescriptorCollectors = callableDescriptorCollectors;
        }
    }
}

