/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NamePackage;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedDeclarationUtil;
import org.jetbrains.kotlin.resolve.scopes.JetScope;

public class ResolveSessionUtils {
    private ResolveSessionUtils() {
    }

    @NotNull
    public static Collection<ClassDescriptor> getClassDescriptorsByFqName(@NotNull ModuleDescriptor module, @NotNull FqName fqName2) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "getClassDescriptorsByFqName"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "getClassDescriptorsByFqName"));
        }
        Collection<ClassDescriptor> collection = ResolveSessionUtils.getClassOrObjectDescriptorsByFqName(module, fqName2, Predicates.<ClassDescriptor>alwaysTrue());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "getClassDescriptorsByFqName"));
        }
        return collection;
    }

    @NotNull
    public static Collection<ClassDescriptor> getClassOrObjectDescriptorsByFqName(@NotNull ModuleDescriptor module, @NotNull FqName fqName2, @NotNull Predicate<ClassDescriptor> filter) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "getClassOrObjectDescriptorsByFqName"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "getClassOrObjectDescriptorsByFqName"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "getClassOrObjectDescriptorsByFqName"));
        }
        if (fqName2.isRoot()) {
            List<ClassDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "getClassOrObjectDescriptorsByFqName"));
            }
            return list;
        }
        ArrayList<ClassDescriptor> result2 = new ArrayList<ClassDescriptor>(1);
        FqName packageFqName = fqName2.parent();
        while (true) {
            PackageViewDescriptor packageDescriptor;
            if ((packageDescriptor = module.getPackage(packageFqName)) != null) {
                FqName relativeClassFqName = NamePackage.tail(fqName2, packageFqName);
                ClassDescriptor classDescriptor = ResolveSessionUtils.findByQualifiedName(packageDescriptor.getMemberScope(), relativeClassFqName);
                if (classDescriptor != null && filter.apply(classDescriptor)) {
                    result2.add(classDescriptor);
                }
            }
            if (packageFqName.isRoot()) break;
            packageFqName = packageFqName.parent();
        }
        ArrayList<ClassDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "getClassOrObjectDescriptorsByFqName"));
        }
        return arrayList;
    }

    @Nullable
    public static ClassDescriptor findByQualifiedName(@NotNull JetScope outerScope, @NotNull FqName path) {
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "findByQualifiedName"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "findByQualifiedName"));
        }
        if (path.isRoot()) {
            return null;
        }
        JetScope scope2 = outerScope;
        for (Name name : path.pathSegments()) {
            ClassifierDescriptor classifier2 = scope2.getClassifier(name);
            if (!(classifier2 instanceof ClassDescriptor)) {
                return null;
            }
            scope2 = ((ClassDescriptor)classifier2).getUnsubstitutedInnerClassesScope();
        }
        return (ClassDescriptor)scope2.getContainingDeclaration();
    }

    @NotNull
    public static Name safeNameForLazyResolve(@NotNull JetNamedDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "safeNameForLazyResolve"));
        }
        Name name = ResolveSessionUtils.safeNameForLazyResolve(declaration.getNameAsName());
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "safeNameForLazyResolve"));
        }
        return name;
    }

    @NotNull
    public static Name safeNameForLazyResolve(@Nullable Name name) {
        Name name2 = SpecialNames.safeIdentifier(name);
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "safeNameForLazyResolve"));
        }
        return name2;
    }

    @Nullable
    public static FqName safeFqNameForLazyResolve(@NotNull JetNamedDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils", "safeFqNameForLazyResolve"));
        }
        FqName parentFqName = JetNamedDeclarationUtil.getParentFqName(declaration);
        return parentFqName != null ? parentFqName.child(ResolveSessionUtils.safeNameForLazyResolve(declaration)) : null;
    }
}

