/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.cli;

import com.sampullara.cli.Argument;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Args {
    public static List<String> parse(Object target, String[] args) {
        Class<?> clazz;
        ArrayList<String> arguments2 = new ArrayList<String>();
        arguments2.addAll(Arrays.asList(args));
        if (target instanceof Class) {
            clazz = (Class<?>)target;
        } else {
            clazz = target.getClass();
            try {
                BeanInfo info = Introspector.getBeanInfo(clazz);
                for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                    Args.processProperty(target, pd, arguments2);
                }
            }
            catch (IntrospectionException info) {
                // empty catch block
            }
        }
        for (Class<?> currentClazz = clazz; currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            for (Field field2 : currentClazz.getDeclaredFields()) {
                Args.processField(target, field2, arguments2);
            }
        }
        for (String argument : arguments2) {
            if (!argument.startsWith("-")) continue;
            throw new IllegalArgumentException("Invalid argument: " + argument);
        }
        return arguments2;
    }

    private static void processField(Object target, Field field2, List<String> arguments2) {
        Argument argument = field2.getAnnotation(Argument.class);
        if (argument != null) {
            boolean set = false;
            Iterator<String> i = arguments2.iterator();
            while (i.hasNext()) {
                String arg = i.next();
                String prefix = argument.prefix();
                String delimiter = argument.delimiter();
                if (!arg.startsWith(prefix)) continue;
                String name = Args.getName(argument, field2);
                String alias = Args.getAlias(argument);
                arg = arg.substring(prefix.length());
                Class<?> type2 = field2.getType();
                if (arg.equals(name) || alias != null && arg.equals(alias)) {
                    i.remove();
                    Object value = Args.consumeArgumentValue(type2, argument, i);
                    if (!set) {
                        Args.setField(type2, field2, target, value, delimiter);
                    } else {
                        Args.addArgument(type2, field2, target, value, delimiter);
                    }
                    set = true;
                }
                if (!set || type2.isArray()) continue;
                break;
            }
            if (!set && argument.required()) {
                String name = Args.getName(argument, field2);
                throw new IllegalArgumentException("You must set argument " + name);
            }
        }
    }

    private static void addArgument(Class type2, Field field2, Object target, Object value, String delimiter) {
        try {
            Object[] os = (Object[])field2.get(target);
            Object[] vs = (Object[])Args.getValue(type2, value, delimiter);
            Object[] s = (Object[])Array.newInstance(type2.getComponentType(), os.length + vs.length);
            System.arraycopy(os, 0, s, 0, os.length);
            System.arraycopy(vs, 0, s, os.length, vs.length);
            field2.set(target, s);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set field " + field2, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type2.getName() + " that takes a string", e);
        }
    }

    private static void addPropertyArgument(Class type2, PropertyDescriptor property2, Object target, Object value, String delimiter) {
        try {
            Object[] os = (Object[])property2.getReadMethod().invoke(target, new Object[0]);
            Object[] vs = (Object[])Args.getValue(type2, value, delimiter);
            Object[] s = (Object[])Array.newInstance(type2.getComponentType(), os.length + vs.length);
            System.arraycopy(os, 0, s, 0, os.length);
            System.arraycopy(vs, 0, s, os.length, vs.length);
            property2.getWriteMethod().invoke(target, new Object[]{s});
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set property " + property2, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type2.getName() + " that takes a string", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to validate argument " + value + " for " + property2);
        }
    }

    private static void processProperty(Object target, PropertyDescriptor property2, List<String> arguments2) {
        Argument argument;
        Method writeMethod = property2.getWriteMethod();
        if (writeMethod != null && (argument = writeMethod.getAnnotation(Argument.class)) != null) {
            boolean set = false;
            Iterator<String> i = arguments2.iterator();
            while (i.hasNext()) {
                String arg = i.next();
                String prefix = argument.prefix();
                String delimiter = argument.delimiter();
                if (!arg.startsWith(prefix)) continue;
                String name = Args.getName(argument, property2);
                String alias = Args.getAlias(argument);
                arg = arg.substring(prefix.length());
                Class<?> type2 = property2.getPropertyType();
                if (arg.equals(name) || alias != null && arg.equals(alias)) {
                    i.remove();
                    Object value = Args.consumeArgumentValue(type2, argument, i);
                    if (!set) {
                        Args.setProperty(type2, property2, target, value, delimiter);
                    } else {
                        Args.addPropertyArgument(type2, property2, target, value, delimiter);
                    }
                    set = true;
                }
                if (!set || type2.isArray()) continue;
                break;
            }
            if (!set && argument.required()) {
                String name = Args.getName(argument, property2);
                throw new IllegalArgumentException("You must set argument " + name);
            }
        }
    }

    static String getName(Argument argument, PropertyDescriptor property2) {
        String name = argument.value();
        if (name.equals("")) {
            name = property2.getName();
        }
        return name;
    }

    private static Object consumeArgumentValue(Class<?> type2, Argument argument, Iterator<String> i) {
        Object value;
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            value = true;
        } else if (i.hasNext()) {
            value = i.next();
            i.remove();
        } else {
            throw new IllegalArgumentException("Must have a value for non-boolean argument " + argument.value());
        }
        return value;
    }

    static void setProperty(Class<?> type2, PropertyDescriptor property2, Object target, Object value, String delimiter) {
        try {
            value = Args.getValue(type2, value, delimiter);
            property2.getWriteMethod().invoke(target, value);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set property " + property2, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type2.getName() + " that takes a string", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to validate argument " + value + " for " + property2);
        }
    }

    static String getAlias(Argument argument) {
        String alias = argument.alias();
        if (alias.equals("")) {
            alias = null;
        }
        return alias;
    }

    static String getName(Argument argument, Field field2) {
        String name = argument.value();
        if (name.equals("")) {
            name = field2.getName();
        }
        return name;
    }

    static void setField(Class<?> type2, Field field2, Object target, Object value, String delimiter) {
        Args.makeAccessible(field2);
        try {
            value = Args.getValue(type2, value, delimiter);
            field2.set(target, value);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set field " + field2, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type2.getName() + " that takes a string", e);
        }
    }

    private static Object getValue(Class<?> type2, Object value, String delimiter) throws NoSuchMethodException {
        if (type2 != String.class && type2 != Boolean.class && type2 != Boolean.TYPE) {
            if (type2.isArray()) {
                String string = (String)value;
                String[] strings2 = string.split(delimiter);
                if ((type2 = type2.getComponentType()) == String.class) {
                    value = strings2;
                } else {
                    Object[] array = (Object[])Array.newInstance(type2, strings2.length);
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = Args.createValue(type2, strings2[i]);
                    }
                    value = array;
                }
            } else {
                value = Args.createValue(type2, value);
            }
        }
        return value;
    }

    private static Object createValue(Class<?> type2, Object value) throws NoSuchMethodException {
        Constructor<?> init = type2.getDeclaredConstructor(String.class);
        try {
            value = init.newInstance(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to convert " + value + " to type " + type2.getName(), e);
        }
        return value;
    }

    private static void makeAccessible(AccessibleObject ao) {
        Member member;
        if (ao instanceof Member && !Modifier.isPublic((member = (Member)((Object)ao)).getModifiers())) {
            ao.setAccessible(true);
        }
    }
}

