/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.VariableDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueParameterDescriptorImpl
extends VariableDescriptorImpl
implements ValueParameterDescriptor {
    private Boolean hasDefaultValue;
    private final boolean declaresDefaultValue;
    private final JetType varargElementType;
    private final int index;
    private final ValueParameterDescriptor original;
    private final Set<ValueParameterDescriptor> overriddenDescriptors;
    private boolean overriddenDescriptorsLocked;
    private final Set<? extends ValueParameterDescriptor> readOnlyOverriddenDescriptors;

    public ValueParameterDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @Nullable ValueParameterDescriptor original, int index2, @NotNull Annotations annotations2, @NotNull Name name, @NotNull JetType outType, boolean declaresDefaultValue, @Nullable JetType varargElementType, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        if (outType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outType", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        super(containingDeclaration, annotations2, name, outType, source);
        this.overriddenDescriptors = new LinkedHashSet<ValueParameterDescriptor>();
        this.overriddenDescriptorsLocked = false;
        this.readOnlyOverriddenDescriptors = Collections.unmodifiableSet(this.overriddenDescriptors);
        this.original = original == null ? this : original;
        this.index = index2;
        this.declaresDefaultValue = declaresDefaultValue;
        this.varargElementType = varargElementType;
    }

    public void setType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "setType"));
        }
        this.setOutType(type2);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean hasDefaultValue() {
        this.computeDefaultValuePresence();
        return this.hasDefaultValue;
    }

    @Override
    public boolean declaresDefaultValue() {
        return this.declaresDefaultValue && ((CallableMemberDescriptor)this.getContainingDeclaration()).getKind().isReal();
    }

    private void computeDefaultValuePresence() {
        if (this.hasDefaultValue != null) {
            return;
        }
        this.overriddenDescriptorsLocked = true;
        if (this.declaresDefaultValue) {
            this.hasDefaultValue = true;
        } else {
            for (ValueParameterDescriptor descriptor2 : this.overriddenDescriptors) {
                if (!descriptor2.hasDefaultValue()) continue;
                this.hasDefaultValue = true;
                return;
            }
            this.hasDefaultValue = false;
        }
    }

    @Override
    @Nullable
    public JetType getVarargElementType() {
        return this.varargElementType;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor getOriginal() {
        ValueParameterDescriptor valueParameterDescriptor = this.original == this ? this : this.original.getOriginal();
        if (valueParameterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "getOriginal"));
        }
        return valueParameterDescriptor;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "substitute"));
        }
        if (substitutor.isEmpty()) {
            ValueParameterDescriptorImpl valueParameterDescriptorImpl = this;
            if (valueParameterDescriptorImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "substitute"));
            }
            return valueParameterDescriptorImpl;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
        return visitor2.visitValueParameterDescriptor(this, data2);
    }

    @Override
    public boolean isVar() {
        return false;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor copy(@NotNull DeclarationDescriptor newOwner, @NotNull Name newName) {
        if (newOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOwner", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "copy"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "copy"));
        }
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(newOwner, null, this.index, this.getAnnotations(), newName, this.getType(), this.declaresDefaultValue(), this.varargElementType, SourceElement.NO_SOURCE);
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "copy"));
        }
        return valueParameterDescriptorImpl;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = Visibilities.LOCAL;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "getVisibility"));
        }
        return visibility;
    }

    @Override
    @NotNull
    public Set<? extends ValueParameterDescriptor> getOverriddenDescriptors() {
        Set<? extends ValueParameterDescriptor> set = this.readOnlyOverriddenDescriptors;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "getOverriddenDescriptors"));
        }
        return set;
    }

    @Override
    public void addOverriddenDescriptor(@NotNull ValueParameterDescriptor overridden) {
        if (overridden == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "addOverriddenDescriptor"));
        }
        assert (!this.overriddenDescriptorsLocked) : "Adding more overridden descriptors is not allowed at this point: the presence of the default value has already been calculated";
        this.overriddenDescriptors.add(overridden);
    }
}

