/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeType;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.lexer.JetKeywordToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.parsing.AbstractJetParsing;
import org.jetbrains.kotlin.parsing.AbstractTokenStreamPredicate;
import org.jetbrains.kotlin.parsing.Consumer;
import org.jetbrains.kotlin.parsing.FirstBefore;
import org.jetbrains.kotlin.parsing.JetExpressionParsing;
import org.jetbrains.kotlin.parsing.LastBefore;
import org.jetbrains.kotlin.parsing.PrecedingCommentsBinder;
import org.jetbrains.kotlin.parsing.SemanticWhitespaceAwarePsiBuilder;
import org.jetbrains.kotlin.parsing.SemanticWhitespaceAwarePsiBuilderForByClause;
import org.jetbrains.kotlin.parsing.TrailingCommentsBinder;

public class JetParsing
extends AbstractJetParsing {
    private static final Logger LOG = Logger.getInstance(JetParsing.class);
    public static final Map<String, IElementType> MODIFIER_KEYWORD_MAP = new HashMap<String, IElementType>();
    private static final TokenSet TOP_LEVEL_DECLARATION_FIRST;
    private static final TokenSet DECLARATION_FIRST;
    private static final TokenSet CLASS_NAME_RECOVERY_SET;
    private static final TokenSet TYPE_PARAMETER_GT_RECOVERY_SET;
    private static final TokenSet PARAMETER_NAME_RECOVERY_SET;
    private static final TokenSet PACKAGE_NAME_RECOVERY_SET;
    private static final TokenSet IMPORT_RECOVERY_SET;
    static final TokenSet TYPE_REF_FIRST;
    private static final TokenSet RECEIVER_TYPE_TERMINATORS;
    private static final TokenSet VALUE_PARAMETER_FIRST;
    private static final TokenSet LAMBDA_VALUE_PARAMETER_FIRST;
    private static final TokenSet SOFT_KEYWORDS_AT_MEMBER_START;
    private JetExpressionParsing myExpressionParsing;

    static JetParsing createForTopLevel(SemanticWhitespaceAwarePsiBuilder builder) {
        JetParsing jetParsing = new JetParsing(builder);
        jetParsing.myExpressionParsing = new JetExpressionParsing(builder, jetParsing);
        return jetParsing;
    }

    private static JetParsing createForByClause(SemanticWhitespaceAwarePsiBuilder builder) {
        final SemanticWhitespaceAwarePsiBuilderForByClause builderForByClause = new SemanticWhitespaceAwarePsiBuilderForByClause(builder);
        JetParsing jetParsing = new JetParsing(builderForByClause);
        jetParsing.myExpressionParsing = new JetExpressionParsing(builderForByClause, jetParsing){

            @Override
            protected boolean parseCallWithClosure() {
                if (builderForByClause.getStackSize() > 0) {
                    return super.parseCallWithClosure();
                }
                return false;
            }

            @Override
            protected JetParsing create(SemanticWhitespaceAwarePsiBuilder builder) {
                return JetParsing.createForByClause(builder);
            }
        };
        return jetParsing;
    }

    private JetParsing(SemanticWhitespaceAwarePsiBuilder builder) {
        super(builder);
    }

    void parseFile() {
        PsiBuilder.Marker fileMarker = this.mark();
        this.parsePreamble();
        while (!this.eof()) {
            this.parseTopLevelDeclaration();
        }
        fileMarker.done(JetNodeTypes.JET_FILE);
    }

    void parseTypeCodeFragment() {
        PsiBuilder.Marker marker = this.mark();
        this.parseTypeRef();
        this.checkForUnexpectedSymbols();
        marker.done(JetNodeTypes.TYPE_CODE_FRAGMENT);
    }

    void parseExpressionCodeFragment() {
        PsiBuilder.Marker marker = this.mark();
        this.myExpressionParsing.parseExpression();
        this.checkForUnexpectedSymbols();
        marker.done(JetNodeTypes.EXPRESSION_CODE_FRAGMENT);
    }

    void parseBlockCodeFragment() {
        PsiBuilder.Marker marker = this.mark();
        PsiBuilder.Marker blockMarker = this.mark();
        if (this.at(JetTokens.PACKAGE_KEYWORD) || this.at(JetTokens.IMPORT_KEYWORD)) {
            PsiBuilder.Marker err = this.mark();
            this.parsePreamble();
            err.error("Package directive and imports are forbidden in code fragments");
        }
        this.myExpressionParsing.parseStatements();
        this.checkForUnexpectedSymbols();
        blockMarker.done(JetNodeTypes.BLOCK);
        marker.done(JetNodeTypes.BLOCK_CODE_FRAGMENT);
    }

    void parseScript() {
        PsiBuilder.Marker fileMarker = this.mark();
        this.parsePreamble();
        PsiBuilder.Marker scriptMarker = this.mark();
        PsiBuilder.Marker blockMarker = this.mark();
        this.myExpressionParsing.parseStatements();
        this.checkForUnexpectedSymbols();
        blockMarker.done(JetNodeTypes.BLOCK);
        scriptMarker.done(JetNodeTypes.SCRIPT);
        fileMarker.done(JetNodeTypes.JET_FILE);
    }

    private void checkForUnexpectedSymbols() {
        while (!this.eof()) {
            this.errorAndAdvance("unexpected symbol");
        }
    }

    private void parsePreamble() {
        PsiBuilder.Marker firstEntry = this.mark();
        this.parseFileAnnotationList(AnnotationParsingMode.FILE_ANNOTATIONS_BEFORE_PACKAGE);
        PsiBuilder.Marker packageDirective = this.mark();
        this.parseModifierList(AnnotationParsingMode.ALLOW_UNESCAPED_REGULAR_ANNOTATIONS);
        if (this.at(JetTokens.PACKAGE_KEYWORD)) {
            this.advance();
            this.parsePackageName();
            firstEntry.drop();
            this.consumeIf(JetTokens.SEMICOLON);
            packageDirective.done(JetNodeTypes.PACKAGE_DIRECTIVE);
        } else {
            firstEntry.rollbackTo();
            this.parseFileAnnotationList(AnnotationParsingMode.FILE_ANNOTATIONS_WHEN_PACKAGE_OMITTED);
            packageDirective = this.mark();
            packageDirective.done(JetNodeTypes.PACKAGE_DIRECTIVE);
            packageDirective.setCustomEdgeTokenBinders(PrecedingCommentsBinder.INSTANCE$, null);
        }
        this.parseImportDirectives();
    }

    private void parsePackageName() {
        PsiBuilder.Marker qualifiedExpression = this.mark();
        boolean simpleName = true;
        while (true) {
            if (this.myBuilder.newlineBeforeCurrentToken()) {
                this.errorWithRecovery("Package name must be a '.'-separated identifier list placed on a single line", PACKAGE_NAME_RECOVERY_SET);
                break;
            }
            if (this.at(JetTokens.DOT)) {
                this.advance();
                qualifiedExpression.error("Package name must be a '.'-separated identifier list");
                qualifiedExpression = this.mark();
                continue;
            }
            PsiBuilder.Marker nsName = this.mark();
            boolean simpleNameFound = this.expect(JetTokens.IDENTIFIER, "Package name must be a '.'-separated identifier list", PACKAGE_NAME_RECOVERY_SET);
            if (simpleNameFound) {
                nsName.done(JetNodeTypes.REFERENCE_EXPRESSION);
            } else {
                nsName.drop();
            }
            if (!simpleName) {
                PsiBuilder.Marker precedingMarker = qualifiedExpression.precede();
                qualifiedExpression.done(JetNodeTypes.DOT_QUALIFIED_EXPRESSION);
                qualifiedExpression = precedingMarker;
            }
            if (!this.at(JetTokens.DOT)) break;
            this.advance();
            if (simpleName && !simpleNameFound) {
                qualifiedExpression.drop();
                qualifiedExpression = this.mark();
                continue;
            }
            simpleName = false;
        }
        qualifiedExpression.drop();
    }

    private void parseImportDirective() {
        assert (this._at(JetTokens.IMPORT_KEYWORD));
        PsiBuilder.Marker importDirective = this.mark();
        this.advance();
        if (this.closeImportWithErrorIfNewline(importDirective, "Expecting qualified name")) {
            return;
        }
        PsiBuilder.Marker qualifiedName = this.mark();
        PsiBuilder.Marker reference = this.mark();
        this.expect(JetTokens.IDENTIFIER, "Expecting qualified name");
        reference.done(JetNodeTypes.REFERENCE_EXPRESSION);
        while (this.at(JetTokens.DOT) && this.lookahead(1) != JetTokens.MUL) {
            this.advance();
            if (this.closeImportWithErrorIfNewline(importDirective, "Import must be placed on a single line")) {
                qualifiedName.drop();
                return;
            }
            reference = this.mark();
            if (this.expect(JetTokens.IDENTIFIER, "Qualified name must be a '.'-separated identifier list", IMPORT_RECOVERY_SET)) {
                reference.done(JetNodeTypes.REFERENCE_EXPRESSION);
            } else {
                reference.drop();
            }
            PsiBuilder.Marker precede = qualifiedName.precede();
            qualifiedName.done(JetNodeTypes.DOT_QUALIFIED_EXPRESSION);
            qualifiedName = precede;
        }
        qualifiedName.drop();
        if (this.at(JetTokens.DOT)) {
            this.advance();
            assert (this._at(JetTokens.MUL));
            this.advance();
            if (this.at(JetTokens.AS_KEYWORD)) {
                PsiBuilder.Marker as = this.mark();
                this.advance();
                if (this.closeImportWithErrorIfNewline(importDirective, "Expecting identifier")) {
                    as.drop();
                    return;
                }
                this.consumeIf(JetTokens.IDENTIFIER);
                as.error("Cannot rename all imported items to one identifier");
            }
        }
        if (this.at(JetTokens.AS_KEYWORD)) {
            this.advance();
            if (this.closeImportWithErrorIfNewline(importDirective, "Expecting identifier")) {
                return;
            }
            this.expect(JetTokens.IDENTIFIER, "Expecting identifier", TokenSet.create(JetTokens.SEMICOLON));
        }
        this.consumeIf(JetTokens.SEMICOLON);
        importDirective.done(JetNodeTypes.IMPORT_DIRECTIVE);
        importDirective.setCustomEdgeTokenBinders(null, TrailingCommentsBinder.INSTANCE$);
    }

    private boolean closeImportWithErrorIfNewline(PsiBuilder.Marker importDirective, String errorMessage) {
        if (this.myBuilder.newlineBeforeCurrentToken()) {
            this.error(errorMessage);
            importDirective.done(JetNodeTypes.IMPORT_DIRECTIVE);
            return true;
        }
        return false;
    }

    private void parseImportDirectives() {
        if (this.at(JetTokens.IMPORT_KEYWORD)) {
            PsiBuilder.Marker importList = this.mark();
            while (this.at(JetTokens.IMPORT_KEYWORD)) {
                this.parseImportDirective();
            }
            importList.done(JetNodeTypes.IMPORT_LIST);
        }
    }

    private void parseTopLevelDeclaration() {
        if (this.at(JetTokens.SEMICOLON)) {
            this.advance();
            return;
        }
        PsiBuilder.Marker decl = this.mark();
        ModifierDetector detector = new ModifierDetector();
        this.parseModifierList(detector, AnnotationParsingMode.ALLOW_UNESCAPED_REGULAR_ANNOTATIONS);
        IElementType keywordToken = this.tt();
        IElementType declType = null;
        if (keywordToken == JetTokens.CLASS_KEYWORD || keywordToken == JetTokens.TRAIT_KEYWORD || keywordToken == JetTokens.INTERFACE_KEYWORD) {
            declType = this.parseClass(detector.isEnumDetected(), DeclarationParsingMode.TOP_LEVEL);
        } else if (keywordToken == JetTokens.FUN_KEYWORD) {
            declType = this.parseFunction();
        } else if (keywordToken == JetTokens.VAL_KEYWORD || keywordToken == JetTokens.VAR_KEYWORD) {
            declType = this.parseProperty();
        } else if (keywordToken == JetTokens.TYPE_ALIAS_KEYWORD) {
            declType = this.parseTypeAlias();
        } else if (keywordToken == JetTokens.OBJECT_KEYWORD) {
            this.parseObject(NameParsingMode.REQUIRED, true, DeclarationParsingMode.TOP_LEVEL);
            declType = JetNodeTypes.OBJECT_DECLARATION;
        } else if (this.at(JetTokens.LBRACE)) {
            this.error("Expecting a top level declaration");
            this.parseBlock();
            declType = JetNodeTypes.FUN;
        }
        if (declType == null) {
            this.errorAndAdvance("Expecting a top level declaration");
            decl.drop();
        } else {
            JetParsing.closeDeclarationWithCommentBinders(decl, declType, true);
        }
    }

    boolean parseModifierList(@NotNull AnnotationParsingMode annotationParsingMode) {
        if (annotationParsingMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationParsingMode", "org/jetbrains/kotlin/parsing/JetParsing", "parseModifierList"));
        }
        return this.parseModifierList(null, annotationParsingMode);
    }

    boolean parseModifierList(@Nullable Consumer<IElementType> tokenConsumer, @NotNull AnnotationParsingMode annotationParsingMode) {
        if (annotationParsingMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationParsingMode", "org/jetbrains/kotlin/parsing/JetParsing", "parseModifierList"));
        }
        PsiBuilder.Marker list = this.mark();
        boolean empty = true;
        while (!(this.eof() || annotationParsingMode.atMemberStart && this.atSet(SOFT_KEYWORDS_AT_MEMBER_START) || (annotationParsingMode == AnnotationParsingMode.PRIMARY_CONSTRUCTOR_MODIFIER_LIST || annotationParsingMode == AnnotationParsingMode.PRIMARY_CONSTRUCTOR_MODIFIER_LIST_LOCAL) && this.atSet(JetTokens.CONSTRUCTOR_KEYWORD, JetTokens.WHERE_KEYWORD))) {
            if (this.at(JetTokens.AT)) {
                if (!this.tryParseModifier(tokenConsumer)) {
                    this.parseAnnotation(annotationParsingMode);
                }
            } else if (!this.tryParseModifier(tokenConsumer)) {
                if (!this.at(JetTokens.LBRACKET) && (!annotationParsingMode.allowShortAnnotations || !this.at(JetTokens.IDENTIFIER))) break;
                this.parseAnnotation(annotationParsingMode);
            }
            empty = false;
        }
        if (empty) {
            list.drop();
        } else {
            list.done(JetNodeTypes.MODIFIER_LIST);
        }
        return !empty;
    }

    private boolean tryParseModifier(@Nullable Consumer<IElementType> tokenConsumer) {
        PsiBuilder.Marker marker = this.mark();
        if (this.at(JetTokens.AT) && !JetTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(this.myBuilder.rawLookup(1))) {
            this.advance();
        }
        if (this.atSet(JetTokens.MODIFIER_KEYWORDS)) {
            IElementType tt = this.tt();
            if (tokenConsumer != null) {
                tokenConsumer.consume(tt);
            }
            this.advance();
            marker.collapse(tt);
            return true;
        }
        marker.rollbackTo();
        return false;
    }

    private void parseFileAnnotationList(AnnotationParsingMode mode) {
        if (!mode.isFileAnnotationParsingMode) {
            LOG.error("expected file annotation parsing mode, but:" + (Object)((Object)mode));
        }
        PsiBuilder.Marker fileAnnotationsList = this.mark();
        if (this.parseAnnotations(mode)) {
            fileAnnotationsList.done(JetNodeTypes.FILE_ANNOTATION_LIST);
        } else {
            fileAnnotationsList.drop();
        }
    }

    boolean parseAnnotations(AnnotationParsingMode mode) {
        if (!this.parseAnnotation(mode)) {
            return false;
        }
        while (this.parseAnnotation(mode)) {
        }
        return true;
    }

    private boolean parseAnnotation(AnnotationParsingMode mode) {
        if (this.at(JetTokens.LBRACKET)) {
            return this.parseAnnotationList(mode, false);
        }
        if (mode.allowShortAnnotations && this.at(JetTokens.IDENTIFIER)) {
            return this.parseAnnotationEntry(mode);
        }
        if (this.at(JetTokens.AT)) {
            IElementType nextRawToken;
            IElementType tokenToMatch = nextRawToken = this.myBuilder.rawLookup(1);
            boolean isTargetedAnnotation = false;
            if ((nextRawToken == JetTokens.IDENTIFIER || nextRawToken == JetTokens.FILE_KEYWORD) && this.lookahead(2) == JetTokens.COLON) {
                tokenToMatch = this.lookahead(3);
                isTargetedAnnotation = true;
            } else if (this.lookahead(1) == JetTokens.COLON) {
                isTargetedAnnotation = true;
                tokenToMatch = this.lookahead(2);
            }
            if (tokenToMatch == JetTokens.IDENTIFIER) {
                return this.parseAnnotationEntry(mode);
            }
            if (tokenToMatch == JetTokens.LBRACKET) {
                return this.parseAnnotationList(mode, true);
            }
            if (isTargetedAnnotation) {
                if (this.lookahead(1) == JetTokens.COLON) {
                    this.errorAndAdvance("Expected annotation identifier after ':'", 2);
                } else {
                    this.errorAndAdvance("Expected annotation identifier after '@file:'", 3);
                }
            } else {
                this.errorAndAdvance("Expected annotation identifier after '@'", 1);
            }
            return true;
        }
        return false;
    }

    private boolean parseAnnotationList(AnnotationParsingMode mode, boolean expectAtSymbol) {
        assert (!expectAtSymbol || this._at(JetTokens.AT));
        assert (expectAtSymbol || this._at(JetTokens.LBRACKET));
        PsiBuilder.Marker annotation2 = this.mark();
        this.myBuilder.disableNewlines();
        this.advance();
        if (!this.parseAnnotationTargetIfNeeded(mode)) {
            annotation2.rollbackTo();
            this.myBuilder.restoreNewlinesState();
            return false;
        }
        if (expectAtSymbol) {
            assert (this._at(JetTokens.LBRACKET));
            this.advance();
        }
        if (!this.at(JetTokens.IDENTIFIER) && !this.at(JetTokens.AT)) {
            this.error("Expecting a list of annotations");
        } else {
            while (this.at(JetTokens.IDENTIFIER) || this.at(JetTokens.AT)) {
                if (this.at(JetTokens.AT)) {
                    this.errorAndAdvance("No '@' needed in annotation list");
                    continue;
                }
                this.parseAnnotationEntry(AnnotationParsingMode.ALLOW_UNESCAPED_REGULAR_ANNOTATIONS);
                while (this.at(JetTokens.COMMA)) {
                    this.errorAndAdvance("No commas needed to separate annotations");
                }
            }
        }
        this.expect(JetTokens.RBRACKET, "Expecting ']' to close the annotation list");
        this.myBuilder.restoreNewlinesState();
        annotation2.done(JetNodeTypes.ANNOTATION);
        return true;
    }

    private boolean parseAnnotationTargetIfNeeded(AnnotationParsingMode mode) {
        if (mode.isFileAnnotationParsingMode) {
            if (this.at(JetTokens.COLON)) {
                this.errorAndAdvance("Expected 'file' keyword before ':'");
                return true;
            }
            if (this.lookahead(1) == JetTokens.COLON && !this.at(JetTokens.FILE_KEYWORD) && this.at(JetTokens.IDENTIFIER)) {
                this.errorAndAdvance("Expected 'file' keyword as target");
                this.advance();
                return true;
            }
            if (!(mode != AnnotationParsingMode.FILE_ANNOTATIONS_WHEN_PACKAGE_OMITTED || this.at(JetTokens.FILE_KEYWORD) && this.lookahead(1) == JetTokens.COLON)) {
                return false;
            }
            String message = "Expecting \"" + JetTokens.FILE_KEYWORD.getValue() + JetTokens.COLON.getValue() + "\" prefix for file annotations";
            this.expect(JetTokens.FILE_KEYWORD, message);
            this.expect(JetTokens.COLON, message, TokenSet.create(JetTokens.IDENTIFIER, JetTokens.RBRACKET, JetTokens.LBRACKET));
        } else if (this.at(JetTokens.FILE_KEYWORD) && this.lookahead(1) == JetTokens.COLON) {
            this.errorAndAdvance("File annotations are only allowed before package declaration", 2);
        }
        return true;
    }

    private boolean parseAnnotationEntry(AnnotationParsingMode mode) {
        assert (this._at(JetTokens.IDENTIFIER) || this._at(JetTokens.AT) && !JetTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(this.myBuilder.rawLookup(1)));
        PsiBuilder.Marker annotation2 = this.mark();
        if (this.at(JetTokens.AT)) {
            this.advance();
        }
        if (!this.parseAnnotationTargetIfNeeded(mode)) {
            annotation2.rollbackTo();
            return false;
        }
        PsiBuilder.Marker reference = this.mark();
        PsiBuilder.Marker typeReference = this.mark();
        this.parseUserType();
        typeReference.done(JetNodeTypes.TYPE_REFERENCE);
        reference.done(JetNodeTypes.CONSTRUCTOR_CALLEE);
        this.parseTypeArgumentList();
        if (this.at(JetTokens.LPAR)) {
            this.myExpressionParsing.parseValueArgumentList();
        }
        annotation2.done(JetNodeTypes.ANNOTATION_ENTRY);
        return true;
    }

    IElementType parseClassOrObject(boolean object, NameParsingMode nameParsingMode, boolean optionalBody, boolean enumClass, DeclarationParsingMode declarationParsingMode) {
        Object marker;
        if (object ? !$assertionsDisabled && !this._at(JetTokens.OBJECT_KEYWORD) : !$assertionsDisabled && !this._atSet(JetTokens.CLASS_KEYWORD, JetTokens.TRAIT_KEYWORD, JetTokens.INTERFACE_KEYWORD)) {
            throw new AssertionError();
        }
        this.advance();
        if (nameParsingMode == NameParsingMode.REQUIRED) {
            marker = new AbstractJetParsing.OptionalMarker(object);
            this.expect(JetTokens.IDENTIFIER, "Name expected", CLASS_NAME_RECOVERY_SET);
            ((AbstractJetParsing.OptionalMarker)marker).done(JetNodeTypes.OBJECT_DECLARATION_NAME);
        } else {
            assert (object) : "Must be an object to be nameless";
            if (this.at(JetTokens.IDENTIFIER)) {
                if (nameParsingMode == NameParsingMode.PROHIBITED) {
                    this.errorAndAdvance("An object expression cannot bind a name");
                } else {
                    assert (nameParsingMode == NameParsingMode.ALLOWED);
                    marker = this.mark();
                    this.advance();
                    marker.done(JetNodeTypes.OBJECT_DECLARATION_NAME);
                }
            }
        }
        AbstractJetParsing.OptionalMarker typeParamsMarker = new AbstractJetParsing.OptionalMarker(object);
        boolean typeParametersDeclared = this.parseTypeParameterList(TYPE_PARAMETER_GT_RECOVERY_SET);
        typeParamsMarker.error("Type parameters are not allowed for objects");
        PsiBuilder.Marker beforeConstructorModifiers = this.mark();
        PsiBuilder.Marker primaryConstructorMarker = this.mark();
        boolean hasConstructorModifiers = this.parseModifierList(declarationParsingMode != DeclarationParsingMode.LOCAL ? AnnotationParsingMode.PRIMARY_CONSTRUCTOR_MODIFIER_LIST : AnnotationParsingMode.PRIMARY_CONSTRUCTOR_MODIFIER_LIST_LOCAL);
        if (hasConstructorModifiers && !this.atSet(JetTokens.LPAR, JetTokens.LBRACE, JetTokens.COLON, JetTokens.CONSTRUCTOR_KEYWORD)) {
            beforeConstructorModifiers.rollbackTo();
            return object ? JetNodeTypes.OBJECT_DECLARATION : JetNodeTypes.CLASS;
        }
        beforeConstructorModifiers.drop();
        boolean hasConstructorKeyword = this.at(JetTokens.CONSTRUCTOR_KEYWORD);
        if (hasConstructorKeyword) {
            this.advance();
        }
        if (this.at(JetTokens.LPAR)) {
            this.parseValueParameterList(false, true, TokenSet.create(JetTokens.LBRACE, JetTokens.RBRACE));
            primaryConstructorMarker.done(JetNodeTypes.PRIMARY_CONSTRUCTOR);
        } else if (hasConstructorModifiers || hasConstructorKeyword) {
            primaryConstructorMarker.done(JetNodeTypes.PRIMARY_CONSTRUCTOR);
            if (hasConstructorKeyword) {
                this.error("Expecting primary constructor parameter list");
            } else {
                this.error("Expecting 'constructor' keyword");
            }
        } else {
            primaryConstructorMarker.drop();
        }
        if (this.at(JetTokens.COLON)) {
            this.advance();
            this.parseDelegationSpecifierList();
        }
        AbstractJetParsing.OptionalMarker whereMarker = new AbstractJetParsing.OptionalMarker(object);
        this.parseTypeConstraintsGuarded(typeParametersDeclared);
        whereMarker.error("Where clause is not allowed for objects");
        if (this.at(JetTokens.LBRACE)) {
            if (enumClass) {
                this.parseEnumClassBody();
            } else {
                this.parseClassBody();
            }
        } else if (!optionalBody) {
            PsiBuilder.Marker fakeBody = this.mark();
            this.error("Expecting a class body");
            fakeBody.done(JetNodeTypes.CLASS_BODY);
        }
        return object ? JetNodeTypes.OBJECT_DECLARATION : JetNodeTypes.CLASS;
    }

    IElementType parseClass(boolean enumClass, DeclarationParsingMode declarationParsingMode) {
        return this.parseClassOrObject(false, NameParsingMode.REQUIRED, true, enumClass, declarationParsingMode);
    }

    void parseObject(NameParsingMode nameParsingMode, boolean optionalBody, DeclarationParsingMode declarationParsingMode) {
        this.parseClassOrObject(true, nameParsingMode, optionalBody, false, declarationParsingMode);
    }

    private void parseEnumClassBody() {
        if (!this.at(JetTokens.LBRACE)) {
            return;
        }
        PsiBuilder.Marker body = this.mark();
        this.myBuilder.enableNewlines();
        this.advance();
        this.parseEnumEntries();
        this.consumeIf(JetTokens.SEMICOLON);
        this.parseMembers(true);
        this.expect(JetTokens.RBRACE, "Expecting '}' to close enum class body");
        this.myBuilder.restoreNewlinesState();
        body.done(JetNodeTypes.CLASS_BODY);
    }

    private void parseEnumEntries() {
        while (!this.eof() && !this.at(JetTokens.RBRACE) && this.parseEnumEntry()) {
            this.parseEnumEntryDelimiter();
        }
    }

    private void parseEnumEntryDelimiter() {
        if (this.at(JetTokens.SEMICOLON)) {
            PsiBuilder.Marker temp = this.mark();
            this.advance();
            ModifierDetector detector = new ModifierDetector();
            this.parseModifierList(detector, AnnotationParsingMode.ONLY_ESCAPED_REGULAR_ANNOTATIONS);
            if (!this.atSet(SOFT_KEYWORDS_AT_MEMBER_START) && this.at(JetTokens.IDENTIFIER)) {
                temp.rollbackTo();
                temp = this.mark();
                this.advance();
                temp.error("Expecting ','");
            } else {
                temp.rollbackTo();
            }
        } else {
            this.consumeIf(JetTokens.COMMA);
        }
    }

    private boolean parseEnumEntry() {
        PsiBuilder.Marker entry = this.mark();
        ModifierDetector detector = new ModifierDetector();
        this.parseModifierList(detector, AnnotationParsingMode.ONLY_ESCAPED_REGULAR_ANNOTATIONS);
        if (!this.atSet(SOFT_KEYWORDS_AT_MEMBER_START) && this.at(JetTokens.IDENTIFIER)) {
            PsiBuilder.Marker nameAsDeclaration = this.mark();
            this.advance();
            nameAsDeclaration.done(JetNodeTypes.OBJECT_DECLARATION_NAME);
            if (this.at(JetTokens.LPAR)) {
                PsiBuilder.Marker initializerList = this.mark();
                PsiBuilder.Marker delegatorSuperCall = this.mark();
                PsiBuilder.Marker callee = this.mark();
                PsiBuilder.Marker typeReference = this.mark();
                PsiBuilder.Marker type2 = this.mark();
                PsiBuilder.Marker referenceExpr = this.mark();
                referenceExpr.done(JetNodeTypes.ENUM_ENTRY_SUPERCLASS_REFERENCE_EXPRESSION);
                type2.done(JetNodeTypes.USER_TYPE);
                typeReference.done(JetNodeTypes.TYPE_REFERENCE);
                callee.done(JetNodeTypes.CONSTRUCTOR_CALLEE);
                this.myExpressionParsing.parseValueArgumentList();
                delegatorSuperCall.done(JetNodeTypes.DELEGATOR_SUPER_CALL);
                initializerList.done(JetNodeTypes.INITIALIZER_LIST);
            } else if (this.at(JetTokens.COLON)) {
                this.advance();
                this.parseInitializerList();
            }
            if (this.at(JetTokens.LBRACE)) {
                this.parseClassBody();
            }
            JetParsing.closeDeclarationWithCommentBinders(entry, JetNodeTypes.ENUM_ENTRY, true);
            return true;
        }
        entry.rollbackTo();
        return false;
    }

    private void parseClassBody() {
        PsiBuilder.Marker body = this.mark();
        this.myBuilder.enableNewlines();
        if (this.expect(JetTokens.LBRACE, "Expecting a class body")) {
            this.parseMembers();
            this.expect(JetTokens.RBRACE, "Missing '}");
        }
        this.myBuilder.restoreNewlinesState();
        body.done(JetNodeTypes.CLASS_BODY);
    }

    private void parseMembers() {
        this.parseMembers(false);
    }

    private void parseMembers(boolean deprecatedEnumEntryPossible) {
        while (!this.eof() && !this.at(JetTokens.RBRACE)) {
            if (deprecatedEnumEntryPossible && this.parseEnumEntry()) {
                this.parseEnumEntryDelimiter();
                this.consumeIf(JetTokens.SEMICOLON);
                continue;
            }
            this.parseMemberDeclaration();
        }
    }

    private void parseMemberDeclaration() {
        if (this.at(JetTokens.SEMICOLON)) {
            this.advance();
            return;
        }
        PsiBuilder.Marker decl = this.mark();
        ModifierDetector detector = new ModifierDetector();
        this.parseModifierList(detector, AnnotationParsingMode.ALLOW_UNESCAPED_REGULAR_ANNOTATIONS_AT_MEMBER_MODIFIER_LIST);
        IElementType declType = this.parseMemberDeclarationRest(detector.isEnumDetected(), detector.isDefaultDetected());
        if (declType == null) {
            this.errorWithRecovery("Expecting member declaration", TokenSet.EMPTY);
            decl.drop();
        } else {
            JetParsing.closeDeclarationWithCommentBinders(decl, declType, true);
        }
    }

    private IElementType parseMemberDeclarationRest(boolean isEnum, boolean isDefault) {
        IElementType keywordToken = this.tt();
        IElementType declType = null;
        if (keywordToken == JetTokens.CLASS_KEYWORD || keywordToken == JetTokens.TRAIT_KEYWORD || keywordToken == JetTokens.INTERFACE_KEYWORD) {
            declType = this.parseClass(isEnum, DeclarationParsingMode.CLASS_MEMBER);
        } else if (keywordToken == JetTokens.FUN_KEYWORD) {
            declType = this.parseFunction();
        } else if (keywordToken == JetTokens.VAL_KEYWORD || keywordToken == JetTokens.VAR_KEYWORD) {
            declType = this.parseProperty();
        } else if (keywordToken == JetTokens.TYPE_ALIAS_KEYWORD) {
            declType = this.parseTypeAlias();
        } else if (keywordToken == JetTokens.OBJECT_KEYWORD) {
            this.parseObject(isDefault ? NameParsingMode.ALLOWED : NameParsingMode.REQUIRED, true, DeclarationParsingMode.CLASS_MEMBER);
            declType = JetNodeTypes.OBJECT_DECLARATION;
        } else if (this.at(JetTokens.INIT_KEYWORD)) {
            this.advance();
            if (this.at(JetTokens.LBRACE)) {
                this.parseBlock();
            } else {
                this.mark().error("Expecting '{' after 'init'");
            }
            declType = JetNodeTypes.ANONYMOUS_INITIALIZER;
        } else if (this.at(JetTokens.CONSTRUCTOR_KEYWORD)) {
            this.parseSecondaryConstructor();
            declType = JetNodeTypes.SECONDARY_CONSTRUCTOR;
        } else if (this.at(JetTokens.LBRACE)) {
            this.error("Expecting member declaration");
            this.parseBlock();
            declType = JetNodeTypes.FUN;
        }
        return declType;
    }

    private void parseSecondaryConstructor() {
        assert (this._at(JetTokens.CONSTRUCTOR_KEYWORD));
        this.advance();
        TokenSet valueArgsRecoverySet = TokenSet.create(JetTokens.LBRACE, JetTokens.SEMICOLON, JetTokens.RPAR, JetTokens.EOL_OR_SEMICOLON, JetTokens.RBRACE);
        if (this.at(JetTokens.LPAR)) {
            this.parseValueParameterList(false, true, valueArgsRecoverySet);
        } else {
            this.errorWithRecovery("Expecting '('", TokenSet.orSet(valueArgsRecoverySet, TokenSet.create(JetTokens.COLON)));
        }
        if (this.at(JetTokens.COLON)) {
            this.advance();
            PsiBuilder.Marker delegationCall = this.mark();
            if (this.at(JetTokens.THIS_KEYWORD) || this.at(JetTokens.SUPER_KEYWORD)) {
                this.parseThisOrSuper();
                this.myExpressionParsing.parseValueArgumentList();
            } else {
                this.error("Expecting a 'this' or 'super' constructor call");
                PsiBuilder.Marker beforeWrongDelegationCallee = null;
                if (!this.at(JetTokens.LPAR)) {
                    beforeWrongDelegationCallee = this.mark();
                    this.advance();
                }
                this.myExpressionParsing.parseValueArgumentList();
                if (beforeWrongDelegationCallee != null) {
                    if (this.at(JetTokens.LBRACE)) {
                        beforeWrongDelegationCallee.drop();
                    } else {
                        beforeWrongDelegationCallee.rollbackTo();
                    }
                }
            }
            delegationCall.done(JetNodeTypes.CONSTRUCTOR_DELEGATION_CALL);
        } else {
            PsiBuilder.Marker emptyDelegationCall = this.mark();
            this.mark().done(JetNodeTypes.CONSTRUCTOR_DELEGATION_REFERENCE);
            emptyDelegationCall.done(JetNodeTypes.CONSTRUCTOR_DELEGATION_CALL);
        }
        if (this.at(JetTokens.LBRACE)) {
            this.parseBlock();
        }
    }

    private void parseThisOrSuper() {
        assert (this._at(JetTokens.THIS_KEYWORD) || this._at(JetTokens.SUPER_KEYWORD));
        PsiBuilder.Marker mark = this.mark();
        this.advance();
        mark.done(JetNodeTypes.CONSTRUCTOR_DELEGATION_REFERENCE);
    }

    private void parseInitializerList() {
        PsiBuilder.Marker list = this.mark();
        if (this.at(JetTokens.COMMA)) {
            this.errorAndAdvance("Expecting a this or super constructor call");
        }
        this.parseInitializer();
        list.done(JetNodeTypes.INITIALIZER_LIST);
    }

    private void parseInitializer() {
        PsiBuilder.Marker initializer = this.mark();
        this.parseAnnotations(AnnotationParsingMode.ONLY_ESCAPED_REGULAR_ANNOTATIONS);
        if (!this.atSet(TYPE_REF_FIRST)) {
            this.errorWithRecovery("Expecting constructor call (<class-name>(...))", TokenSet.orSet(TOP_LEVEL_DECLARATION_FIRST, TokenSet.create(JetTokens.RBRACE, JetTokens.LBRACE, JetTokens.COMMA, JetTokens.SEMICOLON)));
            initializer.drop();
            return;
        }
        PsiBuilder.Marker reference = this.mark();
        this.parseTypeRef();
        reference.done(JetNodeTypes.CONSTRUCTOR_CALLEE);
        IElementType type2 = JetNodeTypes.DELEGATOR_SUPER_CALL;
        this.myExpressionParsing.parseValueArgumentList();
        initializer.done(type2);
    }

    JetNodeType parseTypeAlias() {
        assert (this._at(JetTokens.TYPE_ALIAS_KEYWORD));
        this.advance();
        this.expect(JetTokens.IDENTIFIER, "Type name expected", TokenSet.orSet(TokenSet.create(JetTokens.LT, JetTokens.EQ, JetTokens.SEMICOLON), TOP_LEVEL_DECLARATION_FIRST));
        if (this.parseTypeParameterList(TYPE_PARAMETER_GT_RECOVERY_SET)) {
            this.parseTypeConstraints();
        }
        this.expect(JetTokens.EQ, "Expecting '='", TokenSet.orSet(TOP_LEVEL_DECLARATION_FIRST, TokenSet.create(JetTokens.SEMICOLON)));
        this.parseTypeRef();
        this.consumeIf(JetTokens.SEMICOLON);
        return JetNodeTypes.TYPEDEF;
    }

    private IElementType parseProperty() {
        return this.parseProperty(false);
    }

    public IElementType parseProperty(boolean local) {
        if (this.at(JetTokens.VAL_KEYWORD) || this.at(JetTokens.VAR_KEYWORD)) {
            this.advance();
        } else {
            this.errorAndAdvance("Expecting 'val' or 'var'");
        }
        boolean typeParametersDeclared = this.at(JetTokens.LT) && this.parseTypeParameterList(TokenSet.create(JetTokens.IDENTIFIER, JetTokens.EQ, JetTokens.COLON, JetTokens.SEMICOLON));
        TokenSet propertyNameFollow = TokenSet.create(JetTokens.COLON, JetTokens.EQ, JetTokens.LBRACE, JetTokens.RBRACE, JetTokens.SEMICOLON, JetTokens.VAL_KEYWORD, JetTokens.VAR_KEYWORD, JetTokens.FUN_KEYWORD, JetTokens.CLASS_KEYWORD);
        this.myBuilder.disableJoiningComplexTokens();
        PsiBuilder.Marker receiver = this.mark();
        boolean receiverTypeDeclared = this.parseReceiverType("property", propertyNameFollow);
        boolean multiDeclaration = this.at(JetTokens.LPAR);
        JetParsing.errorIf(receiver, multiDeclaration && receiverTypeDeclared, "Receiver type is not allowed on a multi-declaration");
        if (multiDeclaration) {
            PsiBuilder.Marker multiDecl = this.mark();
            this.parseMultiDeclarationName(propertyNameFollow);
            JetParsing.errorIf(multiDecl, !local, "Multi-declarations are only allowed for local variables/values");
        } else {
            this.parseFunctionOrPropertyName(receiverTypeDeclared, "property", propertyNameFollow, false);
        }
        this.myBuilder.restoreJoiningComplexTokensState();
        if (this.at(JetTokens.COLON)) {
            PsiBuilder.Marker type2 = this.mark();
            this.advance();
            this.parseTypeRef();
            JetParsing.errorIf(type2, multiDeclaration, "Type annotations are not allowed on multi-declarations");
        }
        this.parseTypeConstraintsGuarded(typeParametersDeclared);
        if (local) {
            if (this.at(JetTokens.BY_KEYWORD)) {
                this.parsePropertyDelegate();
            } else if (this.at(JetTokens.EQ)) {
                this.advance();
                this.myExpressionParsing.parseExpression();
            }
        } else {
            if (this.at(JetTokens.BY_KEYWORD)) {
                this.parsePropertyDelegate();
                this.consumeIf(JetTokens.SEMICOLON);
            } else if (this.at(JetTokens.EQ)) {
                this.advance();
                this.myExpressionParsing.parseExpression();
                this.consumeIf(JetTokens.SEMICOLON);
            }
            if (this.parsePropertyGetterOrSetter()) {
                this.parsePropertyGetterOrSetter();
            }
            if (!this.atSet(JetTokens.EOL_OR_SEMICOLON, JetTokens.RBRACE)) {
                if (this.getLastToken() != JetTokens.SEMICOLON) {
                    this.errorUntil("Property getter or setter expected", TokenSet.create(JetTokens.EOL_OR_SEMICOLON, JetTokens.LBRACE, JetTokens.RBRACE));
                }
            } else {
                this.consumeIf(JetTokens.SEMICOLON);
            }
        }
        return multiDeclaration ? JetNodeTypes.MULTI_VARIABLE_DECLARATION : JetNodeTypes.PROPERTY;
    }

    private void parsePropertyDelegate() {
        assert (this._at(JetTokens.BY_KEYWORD));
        PsiBuilder.Marker delegate2 = this.mark();
        this.advance();
        this.myExpressionParsing.parseExpression();
        delegate2.done(JetNodeTypes.PROPERTY_DELEGATE);
    }

    public void parseMultiDeclarationName(TokenSet follow) {
        this.myBuilder.disableNewlines();
        this.advance();
        TokenSet recoverySet = TokenSet.orSet(PARAMETER_NAME_RECOVERY_SET, follow);
        if (!this.atSet(follow)) {
            while (true) {
                if (this.at(JetTokens.COMMA)) {
                    this.errorAndAdvance("Expecting a name");
                } else if (this.at(JetTokens.RPAR)) {
                    this.error("Expecting a name");
                    break;
                }
                PsiBuilder.Marker property2 = this.mark();
                this.parseModifierListWithUnescapedAnnotations(TokenSet.create(JetTokens.COMMA, JetTokens.RPAR, JetTokens.COLON, JetTokens.IN_KEYWORD, JetTokens.EQ));
                this.expect(JetTokens.IDENTIFIER, "Expecting a name", recoverySet);
                if (this.at(JetTokens.COLON)) {
                    this.advance();
                    this.parseTypeRef(follow);
                }
                property2.done(JetNodeTypes.MULTI_VARIABLE_DECLARATION_ENTRY);
                if (!this.at(JetTokens.COMMA)) break;
                this.advance();
            }
        }
        this.expect(JetTokens.RPAR, "Expecting ')'", follow);
        this.myBuilder.restoreNewlinesState();
    }

    private boolean parsePropertyGetterOrSetter() {
        PsiBuilder.Marker getterOrSetter = this.mark();
        this.parseModifierList(AnnotationParsingMode.ONLY_ESCAPED_REGULAR_ANNOTATIONS);
        if (!this.at(JetTokens.GET_KEYWORD) && !this.at(JetTokens.SET_KEYWORD)) {
            getterOrSetter.rollbackTo();
            return false;
        }
        boolean setter2 = this.at(JetTokens.SET_KEYWORD);
        this.advance();
        if (!this.at(JetTokens.LPAR)) {
            TokenSet ACCESSOR_FIRST_OR_PROPERTY_END = TokenSet.orSet(JetTokens.MODIFIER_KEYWORDS, TokenSet.create(JetTokens.LBRACKET, JetTokens.GET_KEYWORD, JetTokens.SET_KEYWORD, JetTokens.EOL_OR_SEMICOLON, JetTokens.RBRACE));
            if (!this.atSet(ACCESSOR_FIRST_OR_PROPERTY_END)) {
                this.errorUntil("Accessor body expected", TokenSet.orSet(ACCESSOR_FIRST_OR_PROPERTY_END, TokenSet.create(JetTokens.LBRACE, JetTokens.LPAR, JetTokens.EQ)));
            } else {
                JetParsing.closeDeclarationWithCommentBinders(getterOrSetter, JetNodeTypes.PROPERTY_ACCESSOR, false);
                return true;
            }
        }
        this.myBuilder.disableNewlines();
        this.expect(JetTokens.LPAR, "Expecting '('", TokenSet.create(JetTokens.RPAR, JetTokens.IDENTIFIER, JetTokens.COLON, JetTokens.LBRACE, JetTokens.EQ));
        if (setter2) {
            PsiBuilder.Marker parameterList = this.mark();
            PsiBuilder.Marker setterParameter = this.mark();
            this.parseModifierListWithUnescapedAnnotations(TokenSet.create(JetTokens.RPAR, JetTokens.COMMA, JetTokens.COLON));
            this.expect(JetTokens.IDENTIFIER, "Expecting parameter name", TokenSet.create(JetTokens.RPAR, JetTokens.COLON, JetTokens.LBRACE, JetTokens.EQ));
            if (this.at(JetTokens.COLON)) {
                this.advance();
                this.parseTypeRef();
            }
            setterParameter.done(JetNodeTypes.VALUE_PARAMETER);
            parameterList.done(JetNodeTypes.VALUE_PARAMETER_LIST);
        }
        if (!this.at(JetTokens.RPAR)) {
            this.errorUntil("Expecting ')'", TokenSet.create(JetTokens.RPAR, JetTokens.COLON, JetTokens.LBRACE, JetTokens.RBRACE, JetTokens.EQ, JetTokens.EOL_OR_SEMICOLON));
        }
        if (this.at(JetTokens.RPAR)) {
            this.advance();
        }
        this.myBuilder.restoreNewlinesState();
        if (this.at(JetTokens.COLON)) {
            this.advance();
            this.parseTypeRef();
        }
        this.parseFunctionBody();
        JetParsing.closeDeclarationWithCommentBinders(getterOrSetter, JetNodeTypes.PROPERTY_ACCESSOR, false);
        return true;
    }

    IElementType parseFunction() {
        assert (this._at(JetTokens.FUN_KEYWORD));
        this.advance();
        if (this.at(JetTokens.RBRACE)) {
            this.error("Function body expected");
            return JetNodeTypes.FUN;
        }
        boolean typeParameterListOccurred = false;
        if (this.at(JetTokens.LT)) {
            this.parseTypeParameterList(TokenSet.create(JetTokens.LBRACKET, JetTokens.LBRACE, JetTokens.RBRACE, JetTokens.LPAR));
            typeParameterListOccurred = true;
        }
        this.myBuilder.disableJoiningComplexTokens();
        TokenSet functionNameFollow = TokenSet.create(JetTokens.LT, JetTokens.LPAR, JetTokens.RPAR, JetTokens.COLON, JetTokens.EQ);
        boolean receiverFound = this.parseReceiverType("function", functionNameFollow);
        this.parseFunctionOrPropertyName(receiverFound, "function", functionNameFollow, true);
        this.myBuilder.restoreJoiningComplexTokensState();
        TokenSet valueParametersFollow = TokenSet.create(JetTokens.EQ, JetTokens.LBRACE, JetTokens.RBRACE, JetTokens.SEMICOLON, JetTokens.RPAR);
        if (this.at(JetTokens.LT)) {
            PsiBuilder.Marker error = this.mark();
            this.parseTypeParameterList(TokenSet.orSet(TokenSet.create(JetTokens.LPAR), valueParametersFollow));
            JetParsing.errorIf(error, typeParameterListOccurred, "Only one type parameter list is allowed for a function");
            typeParameterListOccurred = true;
        }
        if (this.at(JetTokens.LPAR)) {
            this.parseValueParameterList(false, false, valueParametersFollow);
        } else {
            this.error("Expecting '('");
        }
        if (this.at(JetTokens.COLON)) {
            this.advance();
            this.parseTypeRef();
        }
        this.parseTypeConstraintsGuarded(typeParameterListOccurred);
        if (this.at(JetTokens.SEMICOLON)) {
            this.advance();
        } else if (this.at(JetTokens.EQ) || this.at(JetTokens.LBRACE)) {
            this.parseFunctionBody();
        }
        return JetNodeTypes.FUN;
    }

    private boolean parseReceiverType(String title, TokenSet nameFollow) {
        boolean receiverPresent;
        PsiBuilder.Marker annotations2 = this.mark();
        boolean annotationsPresent = this.parseAnnotations(AnnotationParsingMode.ONLY_ESCAPED_REGULAR_ANNOTATIONS);
        int lastDot = this.lastDotAfterReceiver();
        boolean bl = receiverPresent = lastDot != -1;
        if (annotationsPresent) {
            if (receiverPresent) {
                annotations2.rollbackTo();
            } else {
                annotations2.error("Annotations are not allowed in this position");
            }
        } else {
            annotations2.drop();
        }
        if (!receiverPresent) {
            return false;
        }
        this.createTruncatedBuilder(lastDot).parseTypeRef();
        if (this.atSet(RECEIVER_TYPE_TERMINATORS)) {
            this.advance();
        } else {
            this.errorWithRecovery("Expecting '.' before a " + title + " name", nameFollow);
        }
        return true;
    }

    private int lastDotAfterReceiver() {
        if (this.at(JetTokens.LPAR)) {
            return this.matchTokenStreamPredicate(new FirstBefore((AbstractJetParsing)this.new AbstractJetParsing.AtSet(RECEIVER_TYPE_TERMINATORS), new AbstractTokenStreamPredicate(){

                @Override
                public boolean matching(boolean topLevel) {
                    if (topLevel && JetParsing.this.definitelyOutOfReceiver()) {
                        return true;
                    }
                    return topLevel && !JetParsing.this.at(JetTokens.QUEST) && !JetParsing.this.at(JetTokens.LPAR) && !JetParsing.this.at(JetTokens.RPAR);
                }
            }));
        }
        return this.matchTokenStreamPredicate(new LastBefore((AbstractJetParsing)this.new AbstractJetParsing.AtSet(RECEIVER_TYPE_TERMINATORS), new AbstractTokenStreamPredicate(){

            @Override
            public boolean matching(boolean topLevel) {
                if (topLevel && (JetParsing.this.definitelyOutOfReceiver() || JetParsing.this.at(JetTokens.LPAR))) {
                    return true;
                }
                if (topLevel && JetParsing.this.at(JetTokens.IDENTIFIER)) {
                    IElementType lookahead = JetParsing.this.lookahead(1);
                    return lookahead != JetTokens.LT && lookahead != JetTokens.DOT && lookahead != JetTokens.SAFE_ACCESS && lookahead != JetTokens.QUEST;
                }
                return false;
            }
        }));
    }

    private boolean definitelyOutOfReceiver() {
        return this.atSet(JetTokens.EQ, JetTokens.COLON, JetTokens.LBRACE, JetTokens.RBRACE, JetTokens.BY_KEYWORD) || this.atSet(TOP_LEVEL_DECLARATION_FIRST);
    }

    private void parseFunctionOrPropertyName(boolean receiverFound, String title, TokenSet nameFollow, boolean nameRequired) {
        if (nameRequired && this.atSet(nameFollow)) {
            return;
        }
        TokenSet recoverySet = TokenSet.orSet(nameFollow, TokenSet.create(JetTokens.LBRACE, JetTokens.RBRACE));
        if (!receiverFound) {
            this.expect(JetTokens.IDENTIFIER, "Expecting " + title + " name or receiver type", recoverySet);
        } else {
            this.expect(JetTokens.IDENTIFIER, "Expecting " + title + " name", recoverySet);
        }
    }

    private void parseFunctionBody() {
        if (this.at(JetTokens.LBRACE)) {
            this.parseBlock();
        } else if (this.at(JetTokens.EQ)) {
            this.advance();
            this.myExpressionParsing.parseExpression();
            this.consumeIf(JetTokens.SEMICOLON);
        } else {
            this.error("Expecting function body");
        }
    }

    void parseBlock() {
        PsiBuilder.Marker block = this.mark();
        this.myBuilder.enableNewlines();
        this.expect(JetTokens.LBRACE, "Expecting '{' to open a block");
        this.myExpressionParsing.parseStatements();
        this.expect(JetTokens.RBRACE, "Expecting '}'");
        this.myBuilder.restoreNewlinesState();
        block.done(JetNodeTypes.BLOCK);
    }

    void parseDelegationSpecifierList() {
        PsiBuilder.Marker list = this.mark();
        while (true) {
            if (this.at(JetTokens.COMMA)) {
                this.errorAndAdvance("Expecting a delegation specifier");
                continue;
            }
            this.parseDelegationSpecifier();
            if (!this.at(JetTokens.COMMA)) break;
            this.advance();
        }
        list.done(JetNodeTypes.DELEGATION_SPECIFIER_LIST);
    }

    private void parseDelegationSpecifier() {
        PsiBuilder.Marker delegator = this.mark();
        PsiBuilder.Marker reference = this.mark();
        this.parseTypeRef();
        if (this.at(JetTokens.BY_KEYWORD)) {
            reference.drop();
            this.advance();
            JetParsing.createForByClause((SemanticWhitespaceAwarePsiBuilder)this.myBuilder).myExpressionParsing.parseExpression();
            delegator.done(JetNodeTypes.DELEGATOR_BY);
        } else if (this.at(JetTokens.LPAR)) {
            reference.done(JetNodeTypes.CONSTRUCTOR_CALLEE);
            this.myExpressionParsing.parseValueArgumentList();
            delegator.done(JetNodeTypes.DELEGATOR_SUPER_CALL);
        } else {
            reference.drop();
            delegator.done(JetNodeTypes.DELEGATOR_SUPER_CLASS);
        }
    }

    private boolean parseTypeParameterList(TokenSet recoverySet) {
        boolean result2 = false;
        if (this.at(JetTokens.LT)) {
            PsiBuilder.Marker list = this.mark();
            this.myBuilder.disableNewlines();
            this.advance();
            while (true) {
                if (this.at(JetTokens.COMMA)) {
                    this.errorAndAdvance("Expecting type parameter declaration");
                }
                this.parseTypeParameter();
                if (!this.at(JetTokens.COMMA)) break;
                this.advance();
            }
            this.expect(JetTokens.GT, "Missing '>'", recoverySet);
            this.myBuilder.restoreNewlinesState();
            result2 = true;
            list.done(JetNodeTypes.TYPE_PARAMETER_LIST);
        }
        return result2;
    }

    private void parseTypeConstraintsGuarded(boolean typeParameterListOccurred) {
        PsiBuilder.Marker error = this.mark();
        boolean constraints = this.parseTypeConstraints();
        JetParsing.errorIf(error, constraints && !typeParameterListOccurred, "Type constraints are not allowed when no type parameters declared");
    }

    private boolean parseTypeConstraints() {
        if (this.at(JetTokens.WHERE_KEYWORD)) {
            this.parseTypeConstraintList();
            return true;
        }
        return false;
    }

    private void parseTypeConstraintList() {
        assert (this._at(JetTokens.WHERE_KEYWORD));
        this.advance();
        PsiBuilder.Marker list = this.mark();
        while (true) {
            if (this.at(JetTokens.COMMA)) {
                this.errorAndAdvance("Type constraint expected");
            }
            this.parseTypeConstraint();
            if (!this.at(JetTokens.COMMA)) break;
            this.advance();
        }
        list.done(JetNodeTypes.TYPE_CONSTRAINT_LIST);
    }

    private void parseTypeConstraint() {
        PsiBuilder.Marker constraint = this.mark();
        this.parseAnnotations(AnnotationParsingMode.ONLY_ESCAPED_REGULAR_ANNOTATIONS);
        PsiBuilder.Marker reference = this.mark();
        if (this.expect(JetTokens.IDENTIFIER, "Expecting type parameter name", TokenSet.orSet(TokenSet.create(JetTokens.COLON, JetTokens.COMMA, JetTokens.LBRACE, JetTokens.RBRACE), TYPE_REF_FIRST))) {
            reference.done(JetNodeTypes.REFERENCE_EXPRESSION);
        } else {
            reference.drop();
        }
        this.expect(JetTokens.COLON, "Expecting ':' before the upper bound", TokenSet.orSet(TokenSet.create(JetTokens.LBRACE, JetTokens.RBRACE), TYPE_REF_FIRST));
        this.parseTypeRef();
        constraint.done(JetNodeTypes.TYPE_CONSTRAINT);
    }

    private void parseTypeParameter() {
        if (this.atSet(TYPE_PARAMETER_GT_RECOVERY_SET)) {
            this.error("Type parameter declaration expected");
            return;
        }
        PsiBuilder.Marker mark = this.mark();
        this.parseModifierListWithUnescapedAnnotations(TokenSet.create(JetTokens.COMMA, JetTokens.GT, JetTokens.COLON));
        this.expect(JetTokens.IDENTIFIER, "Type parameter name expected", TokenSet.EMPTY);
        if (this.at(JetTokens.COLON)) {
            this.advance();
            this.parseTypeRef();
        }
        mark.done(JetNodeTypes.TYPE_PARAMETER);
    }

    void parseTypeRef() {
        this.parseTypeRef(TokenSet.EMPTY);
    }

    void parseTypeRef(TokenSet extraRecoverySet) {
        PsiBuilder.Marker typeRefMarker = this.parseTypeRefContents(extraRecoverySet);
        typeRefMarker.done(JetNodeTypes.TYPE_REFERENCE);
    }

    private PsiBuilder.Marker parseTypeRefContents(TokenSet extraRecoverySet) {
        PsiBuilder.Marker typeRefMarker = this.mark();
        this.parseAnnotations(AnnotationParsingMode.ONLY_ESCAPED_REGULAR_ANNOTATIONS);
        IElementType lookahead = this.lookahead(1);
        IElementType lookahead2 = this.lookahead(2);
        if (this.at(JetTokens.IDENTIFIER) && (lookahead != JetTokens.DOT || lookahead2 != JetTokens.IDENTIFIER) && lookahead != JetTokens.LT && this.at(JetTokens.DYNAMIC_KEYWORD)) {
            PsiBuilder.Marker dynamicType = this.mark();
            this.advance();
            dynamicType.done(JetNodeTypes.DYNAMIC_TYPE);
        } else if (this.at(JetTokens.IDENTIFIER) || this.at(JetTokens.PACKAGE_KEYWORD) || this.atParenthesizedMutableForPlatformTypes(0)) {
            this.parseUserType();
        } else if (this.at(JetTokens.HASH)) {
            this.parseTupleType();
        } else if (this.at(JetTokens.LPAR)) {
            PsiBuilder.Marker functionOrParenthesizedType = this.mark();
            this.advance();
            this.parseTypeRefContents(TokenSet.EMPTY).drop();
            if (this.at(JetTokens.RPAR)) {
                this.advance();
                if (this.at(JetTokens.ARROW)) {
                    functionOrParenthesizedType.rollbackTo();
                    this.parseFunctionType();
                } else {
                    functionOrParenthesizedType.drop();
                }
            } else {
                functionOrParenthesizedType.rollbackTo();
                this.parseFunctionType();
            }
        } else if (this.at(JetTokens.CAPITALIZED_THIS_KEYWORD)) {
            this.parseSelfType();
        } else {
            this.errorWithRecovery("Type expected", TokenSet.orSet(TOP_LEVEL_DECLARATION_FIRST, TokenSet.create(JetTokens.EQ, JetTokens.COMMA, JetTokens.GT, JetTokens.RBRACKET, JetTokens.DOT, JetTokens.RPAR, JetTokens.RBRACE, JetTokens.LBRACE, JetTokens.SEMICOLON), extraRecoverySet));
        }
        typeRefMarker = this.parseNullableTypeSuffix(typeRefMarker);
        if (this.at(JetTokens.DOT)) {
            PsiBuilder.Marker functionType = typeRefMarker.precede();
            PsiBuilder.Marker receiverType = typeRefMarker.precede();
            typeRefMarker.done(JetNodeTypes.TYPE_REFERENCE);
            receiverType.done(JetNodeTypes.FUNCTION_TYPE_RECEIVER);
            this.advance();
            if (this.at(JetTokens.LPAR)) {
                this.parseFunctionTypeContents().drop();
            } else {
                this.error("Expecting function type");
            }
            typeRefMarker = functionType.precede();
            functionType.done(JetNodeTypes.FUNCTION_TYPE);
        }
        return typeRefMarker;
    }

    @NotNull
    PsiBuilder.Marker parseNullableTypeSuffix(@NotNull PsiBuilder.Marker typeRefMarker) {
        if (typeRefMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeRefMarker", "org/jetbrains/kotlin/parsing/JetParsing", "parseNullableTypeSuffix"));
        }
        while (this.at(JetTokens.QUEST)) {
            PsiBuilder.Marker precede = typeRefMarker.precede();
            this.advance();
            typeRefMarker.done(JetNodeTypes.NULLABLE_TYPE);
            typeRefMarker = precede;
        }
        PsiBuilder.Marker marker = typeRefMarker;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/JetParsing", "parseNullableTypeSuffix"));
        }
        return marker;
    }

    void parseUserType() {
        PsiBuilder.Marker userType = this.mark();
        if (this.at(JetTokens.PACKAGE_KEYWORD)) {
            this.advance();
            this.expect(JetTokens.DOT, "Expecting '.'", TokenSet.create(JetTokens.IDENTIFIER, JetTokens.LBRACE, JetTokens.RBRACE));
        }
        PsiBuilder.Marker reference = this.mark();
        while (true) {
            this.recoverOnParenthesizedWordForPlatformTypes(0, "Mutable", true);
            if (!this.expect(JetTokens.IDENTIFIER, "Expecting type name", TokenSet.orSet(JetExpressionParsing.EXPRESSION_FIRST, JetExpressionParsing.EXPRESSION_FOLLOW, DECLARATION_FIRST))) {
                reference.drop();
                break;
            }
            reference.done(JetNodeTypes.REFERENCE_EXPRESSION);
            this.parseTypeArgumentList();
            this.recoverOnPlatformTypeSuffix();
            if (!this.at(JetTokens.DOT) || this.lookahead(1) == JetTokens.LPAR && !this.atParenthesizedMutableForPlatformTypes(1)) break;
            PsiBuilder.Marker precede = userType.precede();
            userType.done(JetNodeTypes.USER_TYPE);
            userType = precede;
            this.advance();
            reference = this.mark();
        }
        userType.done(JetNodeTypes.USER_TYPE);
    }

    private boolean atParenthesizedMutableForPlatformTypes(int offset) {
        return this.recoverOnParenthesizedWordForPlatformTypes(offset, "Mutable", false);
    }

    private boolean recoverOnParenthesizedWordForPlatformTypes(int offset, String word, boolean consume) {
        if (this.lookahead(offset) == JetTokens.LPAR && this.lookahead(offset + 1) == JetTokens.IDENTIFIER && this.lookahead(offset + 2) == JetTokens.RPAR && this.lookahead(offset + 3) == JetTokens.IDENTIFIER) {
            PsiBuilder.Marker error = this.mark();
            this.advance(offset);
            this.advance();
            if (!word.equals(this.myBuilder.getTokenText())) {
                error.rollbackTo();
                return false;
            }
            this.advance();
            this.advance();
            if (consume) {
                error.error("Unexpected tokens");
            } else {
                error.rollbackTo();
            }
            return true;
        }
        return false;
    }

    private void recoverOnPlatformTypeSuffix() {
        if (this.at(JetTokens.EXCL)) {
            PsiBuilder.Marker error = this.mark();
            this.advance();
            error.error("Unexpected token");
        }
    }

    private void parseSelfType() {
        assert (this._at(JetTokens.CAPITALIZED_THIS_KEYWORD));
        PsiBuilder.Marker type2 = this.mark();
        this.advance();
        type2.done(JetNodeTypes.SELF_TYPE);
    }

    private PsiBuilder.Marker parseTypeArgumentList() {
        if (!this.at(JetTokens.LT)) {
            return null;
        }
        PsiBuilder.Marker list = this.mark();
        this.tryParseTypeArgumentList(TokenSet.EMPTY);
        list.done(JetNodeTypes.TYPE_ARGUMENT_LIST);
        return list;
    }

    boolean tryParseTypeArgumentList(TokenSet extraRecoverySet) {
        this.myBuilder.disableNewlines();
        this.advance();
        while (true) {
            PsiBuilder.Marker projection = this.mark();
            this.recoverOnParenthesizedWordForPlatformTypes(0, "out", true);
            this.parseModifierList(AnnotationParsingMode.ONLY_ESCAPED_REGULAR_ANNOTATIONS);
            if (this.at(JetTokens.MUL)) {
                this.advance();
            } else {
                this.parseTypeRef(extraRecoverySet);
            }
            projection.done(JetNodeTypes.TYPE_PROJECTION);
            if (!this.at(JetTokens.COMMA)) break;
            this.advance();
        }
        boolean atGT = this.at(JetTokens.GT);
        if (!atGT) {
            this.error("Expecting a '>'");
        } else {
            this.advance();
        }
        this.myBuilder.restoreNewlinesState();
        return atGT;
    }

    public void parseModifierListWithUnescapedAnnotations(TokenSet stopAt) {
        this.parseModifierListWithUnescapedAnnotations(TokenSet.create(JetTokens.IDENTIFIER), stopAt);
    }

    public void parseModifierListWithUnescapedAnnotations(TokenSet lookFor, TokenSet stopAt) {
        int lastId = this.findLastBefore(lookFor, stopAt, false);
        this.createTruncatedBuilder(lastId).parseModifierList(AnnotationParsingMode.ALLOW_UNESCAPED_REGULAR_ANNOTATIONS);
    }

    @Deprecated
    private void parseTupleType() {
        assert (this._at(JetTokens.HASH));
        PsiBuilder.Marker tuple = this.mark();
        this.myBuilder.disableNewlines();
        this.advance();
        this.consumeIf(JetTokens.LPAR);
        if (!this.at(JetTokens.RPAR)) {
            while (true) {
                if (this.at(JetTokens.COLON)) {
                    this.errorAndAdvance("Expecting a name for tuple entry");
                }
                if (this.at(JetTokens.IDENTIFIER) && this.lookahead(1) == JetTokens.COLON) {
                    this.advance();
                    this.advance();
                    this.parseTypeRef();
                } else if (TYPE_REF_FIRST.contains(this.tt())) {
                    this.parseTypeRef();
                } else {
                    this.error("Type expected");
                    break;
                }
                if (!this.at(JetTokens.COMMA)) break;
                this.advance();
            }
        }
        this.consumeIf(JetTokens.RPAR);
        this.myBuilder.restoreNewlinesState();
        tuple.error("Tuples are not supported. Use data classes instead.");
    }

    private void parseFunctionType() {
        this.parseFunctionTypeContents().done(JetNodeTypes.FUNCTION_TYPE);
    }

    private PsiBuilder.Marker parseFunctionTypeContents() {
        assert (this._at(JetTokens.LPAR)) : this.tt();
        PsiBuilder.Marker functionType = this.mark();
        this.parseValueParameterList(true, true, TokenSet.EMPTY);
        this.expect(JetTokens.ARROW, "Expecting '->' to specify return type of a function type", TYPE_REF_FIRST);
        this.parseTypeRef();
        return functionType;
    }

    void parseValueParameterList(boolean isFunctionTypeContents, boolean typeRequired, TokenSet recoverySet) {
        assert (this._at(JetTokens.LPAR));
        PsiBuilder.Marker parameters2 = this.mark();
        this.myBuilder.disableNewlines();
        this.advance();
        if (!this.at(JetTokens.RPAR) && !this.atSet(recoverySet)) {
            while (true) {
                if (this.at(JetTokens.COMMA)) {
                    this.errorAndAdvance("Expecting a parameter declaration");
                } else if (this.at(JetTokens.RPAR)) {
                    this.error("Expecting a parameter declaration");
                    break;
                }
                if (isFunctionTypeContents) {
                    if (!this.tryParseValueParameter(typeRequired)) {
                        PsiBuilder.Marker valueParameter = this.mark();
                        this.parseModifierList(AnnotationParsingMode.ONLY_ESCAPED_REGULAR_ANNOTATIONS);
                        this.parseTypeRef();
                        JetParsing.closeDeclarationWithCommentBinders(valueParameter, JetNodeTypes.VALUE_PARAMETER, false);
                    }
                } else {
                    this.parseValueParameter(typeRequired);
                }
                if (this.at(JetTokens.COMMA)) {
                    this.advance();
                    continue;
                }
                if (!this.at(JetTokens.RPAR)) {
                    this.error("Expecting comma or ')'");
                }
                if (!this.atSet(isFunctionTypeContents ? LAMBDA_VALUE_PARAMETER_FIRST : VALUE_PARAMETER_FIRST)) break;
            }
        }
        this.expect(JetTokens.RPAR, "Expecting ')'", recoverySet);
        this.myBuilder.restoreNewlinesState();
        parameters2.done(JetNodeTypes.VALUE_PARAMETER_LIST);
    }

    private boolean tryParseValueParameter(boolean typeRequired) {
        return this.parseValueParameter(true, typeRequired);
    }

    public void parseValueParameter(boolean typeRequired) {
        this.parseValueParameter(false, typeRequired);
    }

    private boolean parseValueParameter(boolean rollbackOnFailure, boolean typeRequired) {
        PsiBuilder.Marker parameter = this.mark();
        this.parseModifierListWithUnescapedAnnotations(TokenSet.create(JetTokens.COMMA, JetTokens.RPAR, JetTokens.COLON));
        if (this.at(JetTokens.VAR_KEYWORD) || this.at(JetTokens.VAL_KEYWORD)) {
            this.advance();
        }
        if (!this.parseFunctionParameterRest(typeRequired) && rollbackOnFailure) {
            parameter.rollbackTo();
            return false;
        }
        JetParsing.closeDeclarationWithCommentBinders(parameter, JetNodeTypes.VALUE_PARAMETER, false);
        return true;
    }

    private boolean parseFunctionParameterRest(boolean typeRequired) {
        boolean noErrors = true;
        if (this.at(JetTokens.IDENTIFIER) && this.lookahead(1) == JetTokens.LT || this.at(JetTokens.COLON)) {
            this.error("Parameter name expected");
            if (this.at(JetTokens.COLON)) {
                this.advance();
            } else {
                noErrors = false;
            }
            this.parseTypeRef();
        } else {
            this.expect(JetTokens.IDENTIFIER, "Parameter name expected", PARAMETER_NAME_RECOVERY_SET);
            if (this.at(JetTokens.COLON)) {
                this.advance();
                this.parseTypeRef();
            } else if (typeRequired) {
                this.errorWithRecovery("Parameters must have type annotation", PARAMETER_NAME_RECOVERY_SET);
                noErrors = false;
            }
        }
        if (this.at(JetTokens.EQ)) {
            this.advance();
            this.myExpressionParsing.parseExpression();
        }
        return noErrors;
    }

    @Override
    protected JetParsing create(SemanticWhitespaceAwarePsiBuilder builder) {
        return JetParsing.createForTopLevel(builder);
    }

    static {
        for (IElementType softKeyword : JetTokens.MODIFIER_KEYWORDS.getTypes()) {
            MODIFIER_KEYWORD_MAP.put(((JetKeywordToken)softKeyword).getValue(), softKeyword);
        }
        TOP_LEVEL_DECLARATION_FIRST = TokenSet.create(JetTokens.TYPE_ALIAS_KEYWORD, JetTokens.TRAIT_KEYWORD, JetTokens.INTERFACE_KEYWORD, JetTokens.CLASS_KEYWORD, JetTokens.OBJECT_KEYWORD, JetTokens.FUN_KEYWORD, JetTokens.VAL_KEYWORD, JetTokens.PACKAGE_KEYWORD);
        DECLARATION_FIRST = TokenSet.orSet(TOP_LEVEL_DECLARATION_FIRST, TokenSet.create(JetTokens.INIT_KEYWORD, JetTokens.GET_KEYWORD, JetTokens.SET_KEYWORD, JetTokens.CONSTRUCTOR_KEYWORD));
        CLASS_NAME_RECOVERY_SET = TokenSet.orSet(TokenSet.create(JetTokens.LT, JetTokens.LPAR, JetTokens.COLON, JetTokens.LBRACE), TOP_LEVEL_DECLARATION_FIRST);
        TYPE_PARAMETER_GT_RECOVERY_SET = TokenSet.create(JetTokens.WHERE_KEYWORD, JetTokens.LPAR, JetTokens.COLON, JetTokens.LBRACE, JetTokens.GT);
        PARAMETER_NAME_RECOVERY_SET = TokenSet.create(JetTokens.COLON, JetTokens.EQ, JetTokens.COMMA, JetTokens.RPAR);
        PACKAGE_NAME_RECOVERY_SET = TokenSet.create(JetTokens.DOT, JetTokens.EOL_OR_SEMICOLON);
        IMPORT_RECOVERY_SET = TokenSet.create(JetTokens.AS_KEYWORD, JetTokens.DOT, JetTokens.EOL_OR_SEMICOLON);
        TYPE_REF_FIRST = TokenSet.create(JetTokens.LBRACKET, JetTokens.IDENTIFIER, JetTokens.LPAR, JetTokens.CAPITALIZED_THIS_KEYWORD, JetTokens.HASH, JetTokens.DYNAMIC_KEYWORD);
        RECEIVER_TYPE_TERMINATORS = TokenSet.create(JetTokens.DOT, JetTokens.SAFE_ACCESS);
        VALUE_PARAMETER_FIRST = TokenSet.orSet(TokenSet.create(JetTokens.IDENTIFIER, JetTokens.LBRACKET, JetTokens.VAL_KEYWORD, JetTokens.VAR_KEYWORD), JetTokens.MODIFIER_KEYWORDS);
        LAMBDA_VALUE_PARAMETER_FIRST = TokenSet.orSet(TokenSet.create(JetTokens.IDENTIFIER, JetTokens.LBRACKET), JetTokens.MODIFIER_KEYWORDS);
        SOFT_KEYWORDS_AT_MEMBER_START = TokenSet.create(JetTokens.CONSTRUCTOR_KEYWORD, JetTokens.INIT_KEYWORD);
    }

    static enum AnnotationParsingMode {
        FILE_ANNOTATIONS_BEFORE_PACKAGE(false, true, false),
        FILE_ANNOTATIONS_WHEN_PACKAGE_OMITTED(false, true, false),
        ONLY_ESCAPED_REGULAR_ANNOTATIONS(false, false, false),
        ALLOW_UNESCAPED_REGULAR_ANNOTATIONS(true, false, false),
        ALLOW_UNESCAPED_REGULAR_ANNOTATIONS_AT_MEMBER_MODIFIER_LIST(true, false, true),
        PRIMARY_CONSTRUCTOR_MODIFIER_LIST(true, false, false),
        PRIMARY_CONSTRUCTOR_MODIFIER_LIST_LOCAL(false, false, false);

        boolean allowShortAnnotations;
        boolean isFileAnnotationParsingMode;
        boolean atMemberStart;

        private AnnotationParsingMode(boolean allowShortAnnotations, boolean isFileAnnotationParsingMode, boolean atMemberStart) {
            this.allowShortAnnotations = allowShortAnnotations;
            this.isFileAnnotationParsingMode = isFileAnnotationParsingMode;
            this.atMemberStart = atMemberStart;
        }
    }

    static class ModifierDetector
    implements Consumer<IElementType> {
        private boolean enumDetected = false;
        private boolean defaultDetected = false;

        ModifierDetector() {
        }

        @Override
        public void consume(IElementType item) {
            if (item == JetTokens.ENUM_KEYWORD) {
                this.enumDetected = true;
            } else if (item == JetTokens.COMPANION_KEYWORD) {
                this.defaultDetected = true;
            }
        }

        public boolean isEnumDetected() {
            return this.enumDetected;
        }

        public boolean isDefaultDetected() {
            return this.defaultDetected;
        }
    }

    public static enum DeclarationParsingMode {
        TOP_LEVEL,
        CLASS_MEMBER,
        LOCAL;

    }

    public static enum NameParsingMode {
        REQUIRED,
        ALLOWED,
        PROHIBITED;

    }
}

