/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.MemberComparator;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.serialization.Flags;
import org.jetbrains.kotlin.serialization.Interner;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializerExtension;
import org.jetbrains.kotlin.serialization.StringTable;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.Variance;

public class DescriptorSerializer {
    private final StringTable stringTable;
    private final Interner<TypeParameterDescriptor> typeParameters;
    private final SerializerExtension extension;

    private DescriptorSerializer(StringTable stringTable, Interner<TypeParameterDescriptor> typeParameters, SerializerExtension extension2) {
        this.stringTable = stringTable;
        this.typeParameters = typeParameters;
        this.extension = extension2;
    }

    @NotNull
    public static DescriptorSerializer createTopLevel(@NotNull SerializerExtension extension2) {
        if (extension2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "createTopLevel"));
        }
        DescriptorSerializer descriptorSerializer = new DescriptorSerializer(new StringTable(extension2), new Interner<TypeParameterDescriptor>(), extension2);
        if (descriptorSerializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "createTopLevel"));
        }
        return descriptorSerializer;
    }

    @NotNull
    public static DescriptorSerializer create(@NotNull ClassDescriptor descriptor2, @NotNull SerializerExtension extension2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "create"));
        }
        if (extension2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "create"));
        }
        DeclarationDescriptor container = descriptor2.getContainingDeclaration();
        DescriptorSerializer parentSerializer = container instanceof ClassDescriptor ? DescriptorSerializer.create((ClassDescriptor)container, extension2) : DescriptorSerializer.createTopLevel(extension2);
        DescriptorSerializer serializer = parentSerializer.createChildSerializer();
        for (TypeParameterDescriptor typeParameter : descriptor2.getTypeConstructor().getParameters()) {
            serializer.typeParameters.intern(typeParameter);
        }
        DescriptorSerializer descriptorSerializer = serializer;
        if (descriptorSerializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "create"));
        }
        return descriptorSerializer;
    }

    private DescriptorSerializer createChildSerializer() {
        return new DescriptorSerializer(this.stringTable, new Interner<TypeParameterDescriptor>(this.typeParameters), this.extension);
    }

    @NotNull
    public StringTable getStringTable() {
        StringTable stringTable = this.stringTable;
        if (stringTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "getStringTable"));
        }
        return stringTable;
    }

    @NotNull
    public ProtoBuf.Class.Builder classProto(@NotNull ClassDescriptor classDescriptor) {
        ConstructorDescriptor primaryConstructor2;
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "classProto"));
        }
        ProtoBuf.Class.Builder builder = ProtoBuf.Class.newBuilder();
        int flags = Flags.getClassFlags(DescriptorSerializer.hasAnnotations(classDescriptor), classDescriptor.getVisibility(), classDescriptor.getModality(), classDescriptor.getKind(), classDescriptor.isInner(), classDescriptor.isCompanionObject());
        builder.setFlags(flags);
        builder.setFqName(this.getClassId(classDescriptor));
        for (TypeParameterDescriptor typeParameterDescriptor : classDescriptor.getTypeConstructor().getParameters()) {
            builder.addTypeParameter(this.typeParameter(typeParameterDescriptor));
        }
        if (!KotlinBuiltIns.isSpecialClassWithNoSupertypes(classDescriptor)) {
            for (JetType supertype : classDescriptor.getTypeConstructor().getSupertypes()) {
                builder.addSupertype(this.type(supertype));
            }
        }
        if ((primaryConstructor2 = classDescriptor.getUnsubstitutedPrimaryConstructor()) != null) {
            if (DescriptorFactory.isDefaultPrimaryConstructor(primaryConstructor2)) {
                builder.setPrimaryConstructor(ProtoBuf.Class.PrimaryConstructor.getDefaultInstance());
            } else {
                ProtoBuf.Class.PrimaryConstructor.Builder constructorBuilder = ProtoBuf.Class.PrimaryConstructor.newBuilder();
                constructorBuilder.setData(this.callableProto(primaryConstructor2));
                builder.setPrimaryConstructor(constructorBuilder);
            }
        }
        for (ConstructorDescriptor constructorDescriptor : DescriptorUtilPackage.getSecondaryConstructors(classDescriptor)) {
            builder.addSecondaryConstructor(this.callableProto(constructorDescriptor));
        }
        for (DeclarationDescriptor descriptor2 : DescriptorSerializer.sort(classDescriptor.getDefaultType().getMemberScope().getAllDescriptors())) {
            CallableMemberDescriptor member;
            if (!(descriptor2 instanceof CallableMemberDescriptor) || (member = (CallableMemberDescriptor)descriptor2).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) continue;
            builder.addMember(this.callableProto(member));
        }
        for (DeclarationDescriptor descriptor2 : DescriptorSerializer.sort(classDescriptor.getUnsubstitutedInnerClassesScope().getAllDescriptors())) {
            int name = this.stringTable.getSimpleNameIndex(descriptor2.getName());
            if (DescriptorUtils.isEnumEntry(descriptor2)) {
                builder.addEnumEntry(name);
                continue;
            }
            builder.addNestedClassName(name);
        }
        ClassDescriptor companionObjectDescriptor2 = classDescriptor.getCompanionObjectDescriptor();
        if (companionObjectDescriptor2 != null) {
            builder.setCompanionObjectName(this.stringTable.getSimpleNameIndex(companionObjectDescriptor2.getName()));
        }
        this.extension.serializeClass(classDescriptor, builder, this.stringTable);
        ProtoBuf.Class.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "classProto"));
        }
        return builder2;
    }

    @NotNull
    public ProtoBuf.Callable.Builder callableProto(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "callableProto"));
        }
        ProtoBuf.Callable.Builder builder = ProtoBuf.Callable.newBuilder();
        DescriptorSerializer local = this.createChildSerializer();
        boolean hasGetter = false;
        boolean hasSetter = false;
        boolean hasConstant = false;
        if (descriptor2 instanceof PropertyDescriptor) {
            CompileTimeConstant<?> compileTimeConstant;
            PropertySetterDescriptor setter2;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
            int propertyFlags = Flags.getAccessorFlags(DescriptorSerializer.hasAnnotations(propertyDescriptor), propertyDescriptor.getVisibility(), propertyDescriptor.getModality(), false);
            PropertyGetterDescriptor getter2 = propertyDescriptor.getGetter();
            if (getter2 != null) {
                hasGetter = true;
                int accessorFlags = DescriptorSerializer.getAccessorFlags(getter2);
                if (accessorFlags != propertyFlags) {
                    builder.setGetterFlags(accessorFlags);
                }
            }
            if ((setter2 = propertyDescriptor.getSetter()) != null) {
                hasSetter = true;
                int accessorFlags = DescriptorSerializer.getAccessorFlags(setter2);
                if (accessorFlags != propertyFlags) {
                    builder.setSetterFlags(accessorFlags);
                }
                if (!setter2.isDefault()) {
                    for (ValueParameterDescriptor valueParameterDescriptor : setter2.getValueParameters()) {
                        builder.addValueParameter(local.valueParameter(valueParameterDescriptor));
                    }
                }
            }
            hasConstant = (compileTimeConstant = propertyDescriptor.getCompileTimeInitializer()) != null && !(compileTimeConstant instanceof NullValue);
        }
        builder.setFlags(Flags.getCallableFlags(DescriptorSerializer.hasAnnotations(descriptor2), descriptor2.getVisibility(), descriptor2.getModality(), descriptor2.getKind(), DescriptorSerializer.callableKind(descriptor2), hasGetter, hasSetter, hasConstant));
        for (TypeParameterDescriptor typeParameterDescriptor : descriptor2.getTypeParameters()) {
            builder.addTypeParameter(local.typeParameter(typeParameterDescriptor));
        }
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            builder.setReceiverType(local.type(receiverParameter.getType()));
        }
        builder.setName(this.stringTable.getSimpleNameIndex(descriptor2.getName()));
        for (ValueParameterDescriptor valueParameterDescriptor : descriptor2.getValueParameters()) {
            builder.addValueParameter(local.valueParameter(valueParameterDescriptor));
        }
        builder.setReturnType(local.type(descriptor2.getReturnType()));
        this.extension.serializeCallable(descriptor2, builder, this.stringTable);
        ProtoBuf.Callable.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "callableProto"));
        }
        return builder2;
    }

    private static int getAccessorFlags(@NotNull PropertyAccessorDescriptor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "getAccessorFlags"));
        }
        return Flags.getAccessorFlags(DescriptorSerializer.hasAnnotations(accessor), accessor.getVisibility(), accessor.getModality(), !accessor.isDefault());
    }

    @NotNull
    private static ProtoBuf.Callable.CallableKind callableKind(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "callableKind"));
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            ProtoBuf.Callable.CallableKind callableKind = ((PropertyDescriptor)descriptor2).isVar() ? ProtoBuf.Callable.CallableKind.VAR : ProtoBuf.Callable.CallableKind.VAL;
            if (callableKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "callableKind"));
            }
            return callableKind;
        }
        if (descriptor2 instanceof ConstructorDescriptor) {
            ProtoBuf.Callable.CallableKind callableKind = ProtoBuf.Callable.CallableKind.CONSTRUCTOR;
            if (callableKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "callableKind"));
            }
            return callableKind;
        }
        assert (descriptor2 instanceof FunctionDescriptor) : "Unknown descriptor class: " + descriptor2.getClass();
        ProtoBuf.Callable.CallableKind callableKind = ProtoBuf.Callable.CallableKind.FUN;
        if (callableKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "callableKind"));
        }
        return callableKind;
    }

    @NotNull
    private ProtoBuf.Callable.ValueParameter.Builder valueParameter(@NotNull ValueParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "valueParameter"));
        }
        ProtoBuf.Callable.ValueParameter.Builder builder = ProtoBuf.Callable.ValueParameter.newBuilder();
        builder.setFlags(Flags.getValueParameterFlags(DescriptorSerializer.hasAnnotations(descriptor2), descriptor2.declaresDefaultValue()));
        builder.setName(this.stringTable.getSimpleNameIndex(descriptor2.getName()));
        builder.setType(this.type(descriptor2.getType()));
        JetType varargElementType = descriptor2.getVarargElementType();
        if (varargElementType != null) {
            builder.setVarargElementType(this.type(varargElementType));
        }
        this.extension.serializeValueParameter(descriptor2, builder, this.stringTable);
        ProtoBuf.Callable.ValueParameter.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "valueParameter"));
        }
        return builder2;
    }

    private ProtoBuf.TypeParameter.Builder typeParameter(TypeParameterDescriptor typeParameter) {
        ProtoBuf.TypeParameter.Variance variance;
        ProtoBuf.TypeParameter.Builder builder = ProtoBuf.TypeParameter.newBuilder();
        builder.setId(this.getTypeParameterId(typeParameter));
        builder.setName(this.stringTable.getSimpleNameIndex(typeParameter.getName()));
        if (typeParameter.isReified()) {
            builder.setReified(true);
        }
        if ((variance = DescriptorSerializer.variance(typeParameter.getVariance())) != ProtoBuf.TypeParameter.Variance.INV) {
            builder.setVariance(variance);
        }
        for (JetType upperBound : typeParameter.getUpperBounds()) {
            builder.addUpperBound(this.type(upperBound));
        }
        return builder;
    }

    private static ProtoBuf.TypeParameter.Variance variance(Variance variance) {
        switch (variance) {
            case INVARIANT: {
                return ProtoBuf.TypeParameter.Variance.INV;
            }
            case IN_VARIANCE: {
                return ProtoBuf.TypeParameter.Variance.IN;
            }
            case OUT_VARIANCE: {
                return ProtoBuf.TypeParameter.Variance.OUT;
            }
        }
        throw new IllegalStateException("Unknown variance: " + (Object)((Object)variance));
    }

    @NotNull
    public ProtoBuf.Type.Builder type(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "type"));
        }
        assert (!type2.isError()) : "Can't serialize error types: " + type2;
        if (TypesPackage.isFlexible(type2)) {
            ProtoBuf.Type.Builder builder = this.flexibleType(type2);
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "type"));
            }
            return builder;
        }
        ProtoBuf.Type.Builder builder = ProtoBuf.Type.newBuilder();
        builder.setConstructor(this.typeConstructor(type2.getConstructor()));
        for (TypeProjection projection : type2.getArguments()) {
            builder.addArgument(this.typeArgument(projection));
        }
        if (type2.isMarkedNullable()) {
            builder.setNullable(true);
        }
        this.extension.serializeType(type2, builder, this.stringTable);
        ProtoBuf.Type.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "type"));
        }
        return builder2;
    }

    private ProtoBuf.Type.Builder flexibleType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "flexibleType"));
        }
        Flexibility flexibility = TypesPackage.flexibility(type2);
        ProtoBuf.Type.Builder builder = this.type(flexibility.getLowerBound());
        builder.setFlexibleTypeCapabilitiesId(this.stringTable.getStringIndex(flexibility.getExtraCapabilities().getId()));
        builder.setFlexibleUpperBound(this.type(flexibility.getUpperBound()));
        return builder;
    }

    @NotNull
    private ProtoBuf.Type.Argument.Builder typeArgument(@NotNull TypeProjection typeProjection) {
        if (typeProjection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjection", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "typeArgument"));
        }
        ProtoBuf.Type.Argument.Builder builder = ProtoBuf.Type.Argument.newBuilder();
        if (typeProjection.isStarProjection()) {
            builder.setProjection(ProtoBuf.Type.Argument.Projection.STAR);
        } else {
            ProtoBuf.Type.Argument.Projection projection = DescriptorSerializer.projection(typeProjection.getProjectionKind());
            if (projection != ProtoBuf.Type.Argument.Projection.INV) {
                builder.setProjection(projection);
            }
            builder.setType(this.type(typeProjection.getType()));
        }
        ProtoBuf.Type.Argument.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "typeArgument"));
        }
        return builder2;
    }

    @NotNull
    private ProtoBuf.Type.Constructor.Builder typeConstructor(@NotNull TypeConstructor typeConstructor2) {
        if (typeConstructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "typeConstructor"));
        }
        ProtoBuf.Type.Constructor.Builder builder = ProtoBuf.Type.Constructor.newBuilder();
        ClassifierDescriptor declarationDescriptor = typeConstructor2.getDeclarationDescriptor();
        assert (declarationDescriptor instanceof TypeParameterDescriptor || declarationDescriptor instanceof ClassDescriptor) : "Unknown declaration descriptor: " + typeConstructor2;
        if (declarationDescriptor instanceof TypeParameterDescriptor) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)declarationDescriptor;
            builder.setKind(ProtoBuf.Type.Constructor.Kind.TYPE_PARAMETER);
            builder.setId(this.getTypeParameterId(typeParameterDescriptor));
        } else {
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
            builder.setId(this.getClassId(classDescriptor));
        }
        ProtoBuf.Type.Constructor.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "typeConstructor"));
        }
        return builder2;
    }

    @NotNull
    public ProtoBuf.Package.Builder packageProto(@NotNull Collection<PackageFragmentDescriptor> fragments) {
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "packageProto"));
        }
        ProtoBuf.Package.Builder builder = this.packageProto(fragments, null);
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "packageProto"));
        }
        return builder;
    }

    @NotNull
    public ProtoBuf.Package.Builder packageProto(@NotNull Collection<PackageFragmentDescriptor> fragments, @Nullable Function1<DeclarationDescriptor, Boolean> skip2) {
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "packageProto"));
        }
        ProtoBuf.Package.Builder builder = ProtoBuf.Package.newBuilder();
        ArrayList<DeclarationDescriptor> members = new ArrayList<DeclarationDescriptor>();
        for (PackageFragmentDescriptor fragment : fragments) {
            members.addAll(fragment.getMemberScope().getAllDescriptors());
        }
        for (DeclarationDescriptor declaration : DescriptorSerializer.sort(members)) {
            if (skip2 != null && skip2.invoke(declaration).booleanValue() || !(declaration instanceof PropertyDescriptor) && !(declaration instanceof FunctionDescriptor)) continue;
            builder.addMember(this.callableProto((CallableMemberDescriptor)declaration));
        }
        this.extension.serializePackage(fragments, builder, this.stringTable);
        ProtoBuf.Package.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "packageProto"));
        }
        return builder2;
    }

    @NotNull
    private static ProtoBuf.Type.Argument.Projection projection(@NotNull Variance projectionKind) {
        if (projectionKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionKind", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "projection"));
        }
        switch (projectionKind) {
            case INVARIANT: {
                ProtoBuf.Type.Argument.Projection projection = ProtoBuf.Type.Argument.Projection.INV;
                if (projection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "projection"));
                }
                return projection;
            }
            case IN_VARIANCE: {
                ProtoBuf.Type.Argument.Projection projection = ProtoBuf.Type.Argument.Projection.IN;
                if (projection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "projection"));
                }
                return projection;
            }
            case OUT_VARIANCE: {
                ProtoBuf.Type.Argument.Projection projection = ProtoBuf.Type.Argument.Projection.OUT;
                if (projection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "projection"));
                }
                return projection;
            }
        }
        throw new IllegalStateException("Unknown projectionKind: " + (Object)((Object)projectionKind));
    }

    private int getClassId(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "getClassId"));
        }
        return this.stringTable.getFqNameIndex(descriptor2);
    }

    private int getTypeParameterId(@NotNull TypeParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "getTypeParameterId"));
        }
        return this.typeParameters.intern(descriptor2);
    }

    private static boolean hasAnnotations(Annotated descriptor2) {
        return !descriptor2.getAnnotations().isEmpty();
    }

    @NotNull
    public static <T extends DeclarationDescriptor> List<T> sort(@NotNull Collection<T> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "sort"));
        }
        ArrayList<T> result2 = new ArrayList<T>(descriptors);
        Collections.sort(result2, MemberComparator.INSTANCE);
        ArrayList<T> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "sort"));
        }
        return arrayList;
    }
}

