/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.management.ThreadMXBean;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Semaphore;

public class PerformanceWatcher {
    private final Semaphore myShutdownSemaphore = new Semaphore(1);
    private ThreadMXBean myThreadMXBean;
    private final DateFormat myDateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private int myUnresponsiveDuration = 0;
    private File myCurHangLogDir;
    private List<StackTraceElement> myStacktraceCommonPart;
    private int UNRESPONSIVE_THRESHOLD = 5;
    private int UNRESPONSIVE_INTERVAL = 5;

    public static PerformanceWatcher getInstance() {
        return ServiceManager.getService(PerformanceWatcher.class);
    }

    private boolean shallNotWatch() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment() || this.UNRESPONSIVE_INTERVAL == 0 || this.UNRESPONSIVE_THRESHOLD == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpThreads(String pathPrefix, boolean millis) {
        if (this.shallNotWatch()) {
            return;
        }
        String suffix = millis ? "-" + String.valueOf(System.currentTimeMillis()) : "";
        File file = new File(this.myCurHangLogDir, pathPrefix + "threadDump-" + this.myDateFormat.format(new Date()) + suffix + ".txt");
        File dir = file.getParentFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            return;
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));
            try {
                StackTraceElement[] edtStack = ThreadDumper.dumpThreadsToFile(this.myThreadMXBean, writer);
                if (edtStack != null) {
                    if (this.myStacktraceCommonPart == null) {
                        this.myStacktraceCommonPart = ContainerUtil.newArrayList(edtStack);
                    } else {
                        this.updateStacktraceCommonPart(edtStack);
                    }
                }
            }
            finally {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateStacktraceCommonPart(StackTraceElement[] stackTraceElements) {
        for (int i = 0; i < this.myStacktraceCommonPart.size() && i < stackTraceElements.length; ++i) {
            StackTraceElement el2;
            StackTraceElement el1 = this.myStacktraceCommonPart.get(this.myStacktraceCommonPart.size() - i - 1);
            if (el1.equals(el2 = stackTraceElements[stackTraceElements.length - i - 1])) continue;
            this.myStacktraceCommonPart = this.myStacktraceCommonPart.subList(this.myStacktraceCommonPart.size() - i, this.myStacktraceCommonPart.size());
            break;
        }
    }
}

