/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.AnchorElementInfoFactory;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerAnchorProvider;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnchorElementInfo
extends SelfElementInfo {
    private volatile long myStubElementTypeAndId;

    AnchorElementInfo(@NotNull PsiElement anchor2, @NotNull PsiFile containingFile) {
        if (anchor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        super(containingFile.getProject(), ProperTextRange.create(anchor2.getTextRange()), anchor2.getClass(), containingFile, LanguageUtil.getRootLanguage(anchor2));
        assert (!(anchor2 instanceof PsiFile)) : "FileElementInfo must be used for file: " + anchor2;
        this.myStubElementTypeAndId = AnchorElementInfo.pack(-1, null);
    }

    AnchorElementInfo(@NotNull PsiElement anchor2, @NotNull PsiFileWithStubSupport containingFile, int stubId, @NotNull IStubElementType stubElementType) {
        if (anchor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        if (stubElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubElementType", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        super(containingFile.getProject(), new ProperTextRange(0, 0), anchor2.getClass(), containingFile, containingFile.getLanguage());
        this.myStubElementTypeAndId = AnchorElementInfo.pack(stubId, stubElementType);
        assert (!(anchor2 instanceof PsiFile)) : "FileElementInfo must be used for file: " + anchor2;
    }

    private static long pack(int stubId, IStubElementType stubElementType) {
        return (long)stubId | (stubElementType == null ? 0L : (long)stubElementType.getIndex() << 32);
    }

    private int getStubId() {
        return (int)this.myStubElementTypeAndId;
    }

    @Override
    @Nullable
    public PsiElement restoreElement() {
        long typeAndId = this.myStubElementTypeAndId;
        int stubId = (int)typeAndId;
        if (stubId != -1) {
            PsiFile file = this.restoreFile();
            if (!(file instanceof PsiFileWithStubSupport)) {
                return null;
            }
            IStubElementType stubElementType = (IStubElementType)IElementType.find((short)(typeAndId >> 32));
            return PsiAnchor.restoreFromStubIndex((PsiFileWithStubSupport)file, stubId, stubElementType, false);
        }
        if (!this.mySyncMarkerIsValid) {
            return null;
        }
        PsiFile file = this.restoreFile();
        if (file == null) {
            return null;
        }
        PsiElement anchor2 = file.findElementAt(this.getSyncStartOffset());
        if (anchor2 == null) {
            return null;
        }
        TextRange range = anchor2.getTextRange();
        if (range.getStartOffset() != this.getSyncStartOffset() || range.getEndOffset() != this.getSyncEndOffset()) {
            return null;
        }
        for (SmartPointerAnchorProvider provider : SmartPointerAnchorProvider.EP_NAME.getExtensions()) {
            PsiElement element = provider.restoreElement(anchor2);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @Override
    public boolean pointsToTheSameElementAs(final @NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "pointsToTheSameElementAs"));
        }
        if (other instanceof AnchorElementInfo) {
            AnchorElementInfo otherAnchor = (AnchorElementInfo)other;
            if (this.getStubId() == -1 != (otherAnchor.getStubId() == -1)) {
                return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

                    @Override
                    public Boolean compute() {
                        return Comparing.equal(AnchorElementInfo.this.restoreElement(), other.restoreElement());
                    }
                });
            }
            if (this.myStubElementTypeAndId != otherAnchor.myStubElementTypeAndId) {
                return false;
            }
        }
        return super.pointsToTheSameElementAs(other);
    }

    @Override
    public void fastenBelt(int offset, RangeMarker[] cachedRangeMarker) {
        if (this.getStubId() != -1) {
            this.switchToTree();
        }
        super.fastenBelt(offset, cachedRangeMarker);
    }

    private void switchToTree() {
        PsiElement element = this.restoreElement();
        if (element != null) {
            this.myStubElementTypeAndId = AnchorElementInfo.pack(-1, null);
            PsiElement anchor2 = AnchorElementInfoFactory.getAnchor(element);
            this.setRange((anchor2 == null ? element : anchor2).getTextRange());
        }
    }

    @Override
    public Segment getRange() {
        if (this.getStubId() != -1) {
            this.switchToTree();
        }
        return super.getRange();
    }
}

