/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JDOMElementBinding
extends Binding
implements MultiNodeBinding {
    private final String myTagName;

    public JDOMElementBinding(@NotNull MutableAccessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/JDOMElementBinding", "<init>"));
        }
        super(accessor);
        Tag tag = this.myAccessor.getAnnotation(Tag.class);
        assert (tag != null) : "jdom.Element property without @Tag annotation: " + accessor;
        String tagName = tag.value();
        if (StringUtil.isEmpty(tagName)) {
            tagName = this.myAccessor.getName();
        }
        this.myTagName = tagName;
    }

    @Override
    @Nullable
    public Object deserializeList(Object context2, @NotNull List<Element> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/xmlb/JDOMElementBinding", "deserializeList"));
        }
        if (this.myAccessor.getValueClass().isArray()) {
            this.myAccessor.set(context2, elements.toArray(new Element[elements.size()]));
        } else {
            this.myAccessor.set(context2, elements.get(0));
        }
        return context2;
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    @Override
    @Nullable
    public Object deserialize(Object context2, @NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/JDOMElementBinding", "deserialize"));
        }
        this.myAccessor.set(context2, element);
        return context2;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/JDOMElementBinding", "isBoundTo"));
        }
        return element.getName().equals(this.myTagName);
    }
}

