/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.List;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.ScriptContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.DiagnosticsPackage;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class ScriptCodegen
extends MemberCodegen<JetScript> {
    private final JetScript scriptDeclaration;
    private final ScriptContext context;
    private final ScriptDescriptor scriptDescriptor;

    public static ScriptCodegen createScriptCodegen(@NotNull JetScript declaration, @NotNull GenerationState state, @NotNull CodegenContext parentContext) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/ScriptCodegen", "createScriptCodegen"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/ScriptCodegen", "createScriptCodegen"));
        }
        if (parentContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentContext", "org/jetbrains/kotlin/codegen/ScriptCodegen", "createScriptCodegen"));
        }
        BindingContext bindingContext = state.getBindingContext();
        ScriptDescriptor scriptDescriptor = bindingContext.get(BindingContext.SCRIPT, declaration);
        assert (scriptDescriptor != null);
        ClassDescriptor classDescriptorForScript = bindingContext.get(CodegenBinding.CLASS_FOR_SCRIPT, scriptDescriptor);
        assert (classDescriptorForScript != null);
        Type classType = CodegenBinding.asmTypeForScriptDescriptor(bindingContext, scriptDescriptor);
        ClassBuilder builder = state.getFactory().newVisitor(DiagnosticsPackage.OtherOrigin(declaration, classDescriptorForScript), classType, declaration.getContainingFile());
        List<ScriptDescriptor> earlierScripts = state.getEarlierScriptsForReplInterpreter();
        ScriptContext scriptContext = parentContext.intoScript(scriptDescriptor, earlierScripts == null ? Collections.emptyList() : earlierScripts, classDescriptorForScript);
        return new ScriptCodegen(declaration, state, scriptContext, builder);
    }

    private ScriptCodegen(@NotNull JetScript scriptDeclaration, @NotNull GenerationState state, @NotNull ScriptContext context2, @NotNull ClassBuilder builder) {
        if (scriptDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDeclaration", "org/jetbrains/kotlin/codegen/ScriptCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/ScriptCodegen", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/ScriptCodegen", "<init>"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/codegen/ScriptCodegen", "<init>"));
        }
        super(state, null, context2, scriptDeclaration, builder);
        this.scriptDeclaration = scriptDeclaration;
        this.context = context2;
        this.scriptDescriptor = context2.getScriptDescriptor();
    }

    @Override
    protected void generateDeclaration() {
        Type classType = this.typeMapper.mapClass((ClassifierDescriptor)this.context.getContextDescriptor());
        this.v.defineClass(this.scriptDeclaration, 50, 1, classType.getInternalName(), null, "java/lang/Object", ArrayUtil.EMPTY_STRING_ARRAY);
        ScriptCodegen.generateReflectionObjectField(this.state, classType, this.v, AsmUtil.method("createKotlinClass", AsmTypes.K_CLASS_TYPE, AsmTypes.getType(Class.class)), "$kotlinClass", this.createOrGetClInitCodegen().v);
    }

    @Override
    protected void generateBody() {
        this.genMembers();
        this.genFieldsForParameters(this.scriptDescriptor, this.v);
        this.genConstructor(this.scriptDescriptor, (ClassDescriptor)this.context.getContextDescriptor(), this.v, this.context.intoFunction(this.scriptDescriptor.getScriptCodeDescriptor()));
    }

    @Override
    protected void generateKotlinAnnotation() {
    }

    private void genConstructor(@NotNull ScriptDescriptor scriptDescriptor, @NotNull ClassDescriptor classDescriptorForScript, @NotNull ClassBuilder classBuilder, @NotNull MethodContext methodContext) {
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDescriptor", "org/jetbrains/kotlin/codegen/ScriptCodegen", "genConstructor"));
        }
        if (classDescriptorForScript == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptorForScript", "org/jetbrains/kotlin/codegen/ScriptCodegen", "genConstructor"));
        }
        if (classBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classBuilder", "org/jetbrains/kotlin/codegen/ScriptCodegen", "genConstructor"));
        }
        if (methodContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodContext", "org/jetbrains/kotlin/codegen/ScriptCodegen", "genConstructor"));
        }
        Type blockType = this.typeMapper.mapType(scriptDescriptor.getScriptCodeDescriptor().getReturnType());
        PropertyDescriptor scriptResultProperty2 = scriptDescriptor.getScriptResultProperty();
        classBuilder.newField(DiagnosticsPackage.OtherOrigin(scriptResultProperty2), 17, scriptResultProperty2.getName().asString(), blockType.getDescriptor(), null, null);
        JvmMethodSignature jvmSignature = this.typeMapper.mapScriptSignature(scriptDescriptor, this.context.getEarlierScripts());
        MethodVisitor mv = classBuilder.newMethod(DiagnosticsPackage.OtherOrigin(this.scriptDeclaration, scriptDescriptor.getClassDescriptor().getUnsubstitutedPrimaryConstructor()), 1, jvmSignature.getAsmMethod().getName(), jvmSignature.getAsmMethod().getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            Type classType = this.typeMapper.mapType(classDescriptorForScript);
            iv.load(0, classType);
            iv.invokespecial("java/lang/Object", "<init>", "()V", false);
            iv.load(0, classType);
            FrameMap frameMap = new FrameMap();
            frameMap.enterTemp(AsmTypes.OBJECT_TYPE);
            for (ScriptDescriptor importedScript : this.context.getEarlierScripts()) {
                frameMap.enter(importedScript, AsmTypes.OBJECT_TYPE);
            }
            Type[] argTypes = jvmSignature.getAsmMethod().getArgumentTypes();
            int add = 0;
            for (int i = 0; i < scriptDescriptor.getScriptCodeDescriptor().getValueParameters().size(); ++i) {
                ValueParameterDescriptor parameter = scriptDescriptor.getScriptCodeDescriptor().getValueParameters().get(i);
                frameMap.enter(parameter, argTypes[i + add]);
            }
            int offset = 1;
            for (ScriptDescriptor earlierScript : this.context.getEarlierScripts()) {
                Type earlierClassType = CodegenBinding.asmTypeForScriptDescriptor(this.bindingContext, earlierScript);
                iv.load(0, classType);
                iv.load(offset, earlierClassType);
                offset += earlierClassType.getSize();
                iv.putfield(classType.getInternalName(), this.context.getScriptFieldName(earlierScript), earlierClassType.getDescriptor());
            }
            for (ValueParameterDescriptor parameter : scriptDescriptor.getScriptCodeDescriptor().getValueParameters()) {
                Type parameterType = this.typeMapper.mapType(parameter.getType());
                iv.load(0, classType);
                iv.load(offset, parameterType);
                offset += parameterType.getSize();
                iv.putfield(classType.getInternalName(), parameter.getName().getIdentifier(), parameterType.getDescriptor());
            }
            final ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, Type.VOID_TYPE, methodContext, this.state, this);
            this.generateInitializers(new Function0<ExpressionCodegen>(){

                @Override
                public ExpressionCodegen invoke() {
                    return codegen;
                }
            });
            StackValue stackValue = codegen.gen(this.scriptDeclaration.getBlockExpression());
            if (stackValue.type != Type.VOID_TYPE) {
                StackValue.Field resultValue = StackValue.field(blockType, classType, "rv", false, StackValue.LOCAL_0);
                resultValue.store(stackValue, iv);
            } else {
                stackValue.put(blockType, iv);
            }
            iv.areturn(Type.VOID_TYPE);
        }
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void genFieldsForParameters(@NotNull ScriptDescriptor script, @NotNull ClassBuilder classBuilder) {
        int access;
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/codegen/ScriptCodegen", "genFieldsForParameters"));
        }
        if (classBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classBuilder", "org/jetbrains/kotlin/codegen/ScriptCodegen", "genFieldsForParameters"));
        }
        for (ScriptDescriptor earlierScript : this.context.getEarlierScripts()) {
            Type earlierClassName = CodegenBinding.asmTypeForScriptDescriptor(this.bindingContext, earlierScript);
            access = 18;
            classBuilder.newField(JvmDeclarationOrigin.NO_ORIGIN, access, this.context.getScriptFieldName(earlierScript), earlierClassName.getDescriptor(), null, null);
        }
        for (ValueParameterDescriptor parameter : script.getScriptCodeDescriptor().getValueParameters()) {
            Type parameterType = this.typeMapper.mapType(parameter);
            access = 17;
            classBuilder.newField(DiagnosticsPackage.OtherOrigin(parameter), access, parameter.getName().getIdentifier(), parameterType.getDescriptor(), null, null);
        }
    }

    private void genMembers() {
        for (JetDeclaration declaration : this.scriptDeclaration.getDeclarations()) {
            if (declaration instanceof JetProperty || declaration instanceof JetNamedFunction) {
                this.genFunctionOrProperty(declaration);
                continue;
            }
            if (!(declaration instanceof JetClassOrObject)) continue;
            this.genClassOrObject((JetClassOrObject)declaration);
        }
    }
}

