/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compiler.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compiler.plugin.CliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOptionValue;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class PluginPackage$CliOptions$8fe09176 {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String cliPluginUsageString(@JetValueParameter(name="pluginId") @NotNull String pluginId, @JetValueParameter(name="options") @NotNull Collection<? extends CliOption> options) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(pluginId, "pluginId");
        Intrinsics.checkParameterIsNotNull(options, "options");
        int LEFT_INDENT = 2;
        int MAX_OPTION_WIDTH = 26;
        Iterable iterable = options;
        void var6_5 = $receiver2;
        Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it2;
            CliOption cliOption = (CliOption)item;
            void var15_14 = destination;
            String name = it2.getName() + " " + it2.getValueDescription();
            String margin = name.length() > MAX_OPTION_WIDTH ? "\n" + KotlinPackage.repeat(" ", MAX_OPTION_WIDTH + LEFT_INDENT + 1) : KotlinPackage.repeat(" ", 1 + MAX_OPTION_WIDTH - name.length());
            List modifiers = KotlinPackage.filterNotNull((Iterable)KotlinPackage.listOf(it2.getRequired() ? "required" : (String)null, it2.getAllowMultipleOccurrences() ? "multiple" : (String)null));
            String modifiersEnclosed = modifiers.isEmpty() ? "" : " (" + KotlinPackage.joinToString$default(modifiers, null, null, null, 0, null, null, 63) + ")";
            String string = KotlinPackage.repeat(" ", LEFT_INDENT) + name + margin + it2.getDescription() + modifiersEnclosed;
            var15_14.add(string);
        }
        List renderedOptions = (List)destination;
        return "Plugin " + "\"" + pluginId + "\"" + " usage:" + "\n" + KotlinPackage.joinToString$default(renderedOptions, "\n", null, "\n", 0, null, null, 58);
    }

    @Nullable
    public static final CliOptionValue parsePluginOption(@JetValueParameter(name="argumentValue") @NotNull String argumentValue) {
        Intrinsics.checkParameterIsNotNull(argumentValue, "argumentValue");
        Pattern pattern = Pattern.compile("^plugin:([^:]*):([^=]*)=(.*)$");
        Matcher matcher = pattern.matcher(argumentValue);
        if (matcher.matches()) {
            String string = matcher.group(1);
            Intrinsics.checkExpressionValueIsNotNull(string, "matcher.group(1)");
            String string2 = matcher.group(2);
            Intrinsics.checkExpressionValueIsNotNull(string2, "matcher.group(2)");
            String string3 = matcher.group(3);
            Intrinsics.checkExpressionValueIsNotNull(string3, "matcher.group(3)");
            return new CliOptionValue(string, string2, string3);
        }
        return null;
    }

    @NotNull
    public static final String getPluginOptionString(@JetValueParameter(name="pluginId") @NotNull String pluginId, @JetValueParameter(name="key") @NotNull String key, @JetValueParameter(name="value") @NotNull String value) {
        Intrinsics.checkParameterIsNotNull(pluginId, "pluginId");
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(value, "value");
        return "plugin:" + pluginId + ":" + key + "=" + value;
    }
}

