/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.load.java.components.ExternalAnnotationResolver;
import org.jetbrains.kotlin.load.java.components.ExternalSignatureResolver;
import org.jetbrains.kotlin.load.java.components.MethodSignatureChecker;
import org.jetbrains.kotlin.load.java.structure.JavaArrayType;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.JavaPrimitiveType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaValueParameter;
import org.jetbrains.kotlin.load.java.structure.JavaWildcardType;
import org.jetbrains.kotlin.load.java.structure.impl.JavaMethodImpl;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.SignaturesUtil;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.SubstitutionUtils;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;

public class PsiBasedMethodSignatureChecker
implements MethodSignatureChecker {
    private static final Logger LOG = Logger.getInstance(PsiBasedMethodSignatureChecker.class);
    private ExternalAnnotationResolver externalAnnotationResolver;
    private ExternalSignatureResolver externalSignatureResolver;

    @Inject
    public void setExternalAnnotationResolver(ExternalAnnotationResolver externalAnnotationResolver) {
        this.externalAnnotationResolver = externalAnnotationResolver;
    }

    @Inject
    public void setExternalSignatureResolver(ExternalSignatureResolver externalSignatureResolver) {
        this.externalSignatureResolver = externalSignatureResolver;
    }

    private void checkFunctionOverridesCorrectly(@NotNull JavaMethod method, @NotNull FunctionDescriptor function, @NotNull FunctionDescriptor superFunction) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/load/java/components/PsiBasedMethodSignatureChecker", "checkFunctionOverridesCorrectly"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/load/java/components/PsiBasedMethodSignatureChecker", "checkFunctionOverridesCorrectly"));
        }
        if (superFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superFunction", "org/jetbrains/kotlin/load/java/components/PsiBasedMethodSignatureChecker", "checkFunctionOverridesCorrectly"));
        }
        ClassDescriptor klass = (ClassDescriptor)function.getContainingDeclaration();
        ArrayList<TypeSubstitution> substitutions = new ArrayList<TypeSubstitution>();
        while (true) {
            substitutions.add(SubstitutionUtils.buildDeepSubstitutor(klass.getDefaultType()).getSubstitution());
            if (!klass.isInner()) break;
            klass = (ClassDescriptor)klass.getContainingDeclaration();
        }
        TypeSubstitutor substitutor = TypeSubstitutor.create(substitutions.toArray(new TypeSubstitution[substitutions.size()]));
        FunctionDescriptor superFunctionSubstituted = superFunction.substitute(substitutor);
        assert (superFunctionSubstituted != null) : "Couldn't substitute super function: " + superFunction + ", substitutor = " + substitutor;
        OverridingUtil.OverrideCompatibilityInfo.Result overridableResult = OverridingUtil.DEFAULT.isOverridableBy(superFunctionSubstituted, function).getResult();
        boolean paramsOk = overridableResult == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE;
        boolean returnTypeOk = OverrideResolver.isReturnTypeOkForOverride(superFunctionSubstituted, function);
        if (!paramsOk || !returnTypeOk) {
            LOG.warn("Loaded Java method overrides another, but resolved as Kotlin function, doesn't.\nsuper function = " + superFunction + "\n" + "super class = " + superFunction.getContainingDeclaration() + "\n" + "sub function = " + function + "\n" + "sub class = " + function.getContainingDeclaration() + "\n" + "sub method = " + method + "\n" + "@KotlinSignature = " + SignaturesUtil.getKotlinSignature(this.externalAnnotationResolver, method));
        }
    }

    private static boolean containsErrorType(@NotNull List<FunctionDescriptor> superFunctions, @NotNull FunctionDescriptor function) {
        if (superFunctions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superFunctions", "org/jetbrains/kotlin/load/java/components/PsiBasedMethodSignatureChecker", "containsErrorType"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/load/java/components/PsiBasedMethodSignatureChecker", "containsErrorType"));
        }
        if (ErrorUtils.containsErrorType(function)) {
            return true;
        }
        for (FunctionDescriptor superFunction : superFunctions) {
            if (!ErrorUtils.containsErrorType(superFunction)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMethodReturnTypeCompatible(@NotNull JavaMethodImpl method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/load/java/components/PsiBasedMethodSignatureChecker", "isMethodReturnTypeCompatible"));
        }
        if (method.isStatic()) {
            return true;
        }
        HierarchicalMethodSignature methodSignature = ((PsiMethod)method.getPsi()).getHierarchicalMethodSignature();
        List<HierarchicalMethodSignature> superSignatures = methodSignature.getSuperSignatures();
        PsiType returnType2 = methodSignature.getSubstitutor().substitute(((PsiMethod)method.getPsi()).getReturnType());
        if (returnType2 == null) {
            return true;
        }
        for (HierarchicalMethodSignature superMethodSignature : superSignatures) {
            PsiMethod superMethod = superMethodSignature.getMethod();
            PsiType declaredReturnType = superMethod.getReturnType();
            PsiType superReturnType = superMethodSignature.isRaw() ? TypeConversionUtil.erasure(declaredReturnType) : declaredReturnType;
            if (superReturnType == null || method == superMethod || superMethod.getContainingClass() == null || PsiBasedMethodSignatureChecker.areMethodsReturnTypesCompatible(superMethodSignature, superReturnType, methodSignature, returnType2)) continue;
            return false;
        }
        return true;
    }

    private static boolean areMethodsReturnTypesCompatible(@NotNull MethodSignatureBackedByPsiMethod superMethodSignature, @NotNull PsiType superReturnType, @NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull PsiType returnType2) {
        PsiSubstitutor unifyingSubstitutor;
        if (superMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodSignature", "org/jetbrains/kotlin/load/java/components/PsiBasedMethodSignatureChecker", "areMethodsReturnTypesCompatible"));
        }
        if (superReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superReturnType", "org/jetbrains/kotlin/load/java/components/PsiBasedMethodSignatureChecker", "areMethodsReturnTypesCompatible"));
        }
        if (methodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSignature", "org/jetbrains/kotlin/load/java/components/PsiBasedMethodSignatureChecker", "areMethodsReturnTypesCompatible"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/load/java/components/PsiBasedMethodSignatureChecker", "areMethodsReturnTypesCompatible"));
        }
        boolean isJdk15 = PsiUtil.isLanguageLevel5OrHigher(methodSignature.getMethod());
        PsiType substitutedSuperReturnType = isJdk15 && !superMethodSignature.isRaw() && superMethodSignature.equals(methodSignature) ? ((unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(methodSignature, superMethodSignature)) == null ? superReturnType : unifyingSubstitutor.substitute(superReturnType)) : TypeConversionUtil.erasure(superMethodSignature.getSubstitutor().substitute(superReturnType));
        if (returnType2.equals(substitutedSuperReturnType)) {
            return true;
        }
        return !(returnType2 instanceof PsiPrimitiveType) && substitutedSuperReturnType.getDeepComponentType() instanceof PsiClassType && isJdk15 && TypeConversionUtil.isAssignable(substitutedSuperReturnType, returnType2);
    }

    @Override
    public void checkSignature(@NotNull JavaMethod method, boolean reportSignatureErrors, @NotNull SimpleFunctionDescriptor descriptor2, @NotNull List<String> signatureErrors, @NotNull List<FunctionDescriptor> superFunctions) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/load/java/components/PsiBasedMethodSignatureChecker", "checkSignature"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/load/java/components/PsiBasedMethodSignatureChecker", "checkSignature"));
        }
        if (signatureErrors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatureErrors", "org/jetbrains/kotlin/load/java/components/PsiBasedMethodSignatureChecker", "checkSignature"));
        }
        if (superFunctions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superFunctions", "org/jetbrains/kotlin/load/java/components/PsiBasedMethodSignatureChecker", "checkSignature"));
        }
        if (superFunctions.isEmpty() && (signatureErrors.isEmpty() || !reportSignatureErrors)) {
            return;
        }
        JavaMethodImpl methodWithPsi = (JavaMethodImpl)method;
        if (!RawTypesCheck.hasRawTypesInHierarchicalSignature(methodWithPsi) && PsiBasedMethodSignatureChecker.isMethodReturnTypeCompatible(methodWithPsi) && !PsiBasedMethodSignatureChecker.containsErrorType(superFunctions, descriptor2)) {
            if (signatureErrors.isEmpty()) {
                for (FunctionDescriptor superFunction : superFunctions) {
                    this.checkFunctionOverridesCorrectly(method, descriptor2, superFunction);
                }
            } else if (reportSignatureErrors) {
                this.externalSignatureResolver.reportSignatureErrors(descriptor2, signatureErrors);
            }
        }
    }

    private static class RawTypesCheck {
        private static boolean isPartiallyRawType(@NotNull JavaType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/load/java/components/PsiBasedMethodSignatureChecker$RawTypesCheck", "isPartiallyRawType"));
            }
            if (type2 instanceof JavaPrimitiveType) {
                return false;
            }
            if (type2 instanceof JavaClassifierType) {
                JavaClassifierType classifierType = (JavaClassifierType)type2;
                if (classifierType.isRaw()) {
                    return true;
                }
                for (JavaType argument : classifierType.getTypeArguments()) {
                    if (!RawTypesCheck.isPartiallyRawType(argument)) continue;
                    return true;
                }
                return false;
            }
            if (type2 instanceof JavaArrayType) {
                return RawTypesCheck.isPartiallyRawType(((JavaArrayType)type2).getComponentType());
            }
            if (type2 instanceof JavaWildcardType) {
                JavaType bound = ((JavaWildcardType)type2).getBound();
                return bound != null && RawTypesCheck.isPartiallyRawType(bound);
            }
            throw new IllegalStateException("Unexpected type: " + type2);
        }

        private static boolean hasRawTypesInSignature(@NotNull JavaMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/load/java/components/PsiBasedMethodSignatureChecker$RawTypesCheck", "hasRawTypesInSignature"));
            }
            JavaType returnType2 = method.getReturnType();
            if (returnType2 != null && RawTypesCheck.isPartiallyRawType(returnType2)) {
                return true;
            }
            for (JavaValueParameter parameter : method.getValueParameters()) {
                if (!RawTypesCheck.isPartiallyRawType(parameter.getType())) continue;
                return true;
            }
            for (JavaTypeParameter typeParameter : method.getTypeParameters()) {
                for (JavaClassifierType upperBound : typeParameter.getUpperBounds()) {
                    if (!RawTypesCheck.isPartiallyRawType(upperBound)) continue;
                    return true;
                }
            }
            return false;
        }

        public static boolean hasRawTypesInHierarchicalSignature(@NotNull JavaMethodImpl method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/load/java/components/PsiBasedMethodSignatureChecker$RawTypesCheck", "hasRawTypesInHierarchicalSignature"));
            }
            if (method.isStatic()) {
                return false;
            }
            if (RawTypesCheck.hasRawTypesInSignature(method)) {
                return true;
            }
            for (HierarchicalMethodSignature superSignature : ((PsiMethod)method.getPsi()).getHierarchicalMethodSignature().getSuperSignatures()) {
                JavaMethodImpl superMethod = new JavaMethodImpl(superSignature.getMethod());
                if (!superSignature.isRaw() && !RawTypesCheck.typeParameterIsErased(method, superMethod) && !RawTypesCheck.hasRawTypesInSignature(superMethod)) continue;
                return true;
            }
            return false;
        }

        private static boolean typeParameterIsErased(@NotNull JavaMethod method, @NotNull JavaMethod superMethod) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/load/java/components/PsiBasedMethodSignatureChecker$RawTypesCheck", "typeParameterIsErased"));
            }
            if (superMethod == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "org/jetbrains/kotlin/load/java/components/PsiBasedMethodSignatureChecker$RawTypesCheck", "typeParameterIsErased"));
            }
            return method.getTypeParameters().size() != superMethod.getTypeParameters().size();
        }

        private RawTypesCheck() {
        }
    }
}

