/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.CompositePackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.kotlin.resolve.lazy.LazyFileScope;

public class LazyTopDownAnalyzerForTopLevel {
    private KotlinCodeAnalyzer resolveSession;
    private LazyTopDownAnalyzer lazyTopDownAnalyzer;

    @Inject
    public void setKotlinCodeAnalyzer(@NotNull KotlinCodeAnalyzer kotlinCodeAnalyzer) {
        if (kotlinCodeAnalyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinCodeAnalyzer", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "setKotlinCodeAnalyzer"));
        }
        this.resolveSession = kotlinCodeAnalyzer;
    }

    @Inject
    public void setLazyTopDownAnalyzer(@NotNull LazyTopDownAnalyzer lazyTopDownAnalyzer) {
        if (lazyTopDownAnalyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lazyTopDownAnalyzer", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "setLazyTopDownAnalyzer"));
        }
        this.lazyTopDownAnalyzer = lazyTopDownAnalyzer;
    }

    @NotNull
    public TopDownAnalysisContext analyzeFiles(@NotNull TopDownAnalysisMode topDownAnalysisMode, @NotNull Collection<JetFile> files, @NotNull List<? extends PackageFragmentProvider> additionalProviders) {
        if (topDownAnalysisMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisMode", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "analyzeFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "analyzeFiles"));
        }
        if (additionalProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalProviders", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "analyzeFiles"));
        }
        PackageFragmentProvider provider = additionalProviders.isEmpty() ? this.resolveSession.getPackageFragmentProvider() : new CompositePackageFragmentProvider(KotlinPackage.plus(Arrays.asList(this.resolveSession.getPackageFragmentProvider()), additionalProviders));
        ((ModuleDescriptorImpl)this.resolveSession.getModuleDescriptor()).initialize(provider);
        TopDownAnalysisContext topDownAnalysisContext = this.analyzeDeclarations(topDownAnalysisMode, files);
        if (topDownAnalysisContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "analyzeFiles"));
        }
        return topDownAnalysisContext;
    }

    @NotNull
    public TopDownAnalysisContext analyzeDeclarations(@NotNull TopDownAnalysisMode topDownAnalysisMode, @NotNull Collection<? extends PsiElement> elements) {
        if (topDownAnalysisMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisMode", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "analyzeDeclarations"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "analyzeDeclarations"));
        }
        TopDownAnalysisContext c = this.lazyTopDownAnalyzer.analyzeDeclarations(topDownAnalysisMode, elements, DataFlowInfo.EMPTY);
        LazyTopDownAnalyzerForTopLevel.resolveImportsInAllFiles(c, this.resolveSession);
        TopDownAnalysisContext topDownAnalysisContext = c;
        if (topDownAnalysisContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "analyzeDeclarations"));
        }
        return topDownAnalysisContext;
    }

    private static void resolveImportsInAllFiles(TopDownAnalysisContext c, KotlinCodeAnalyzer resolveSession) {
        for (JetFile file : c.getFiles()) {
            LazyTopDownAnalyzerForTopLevel.resolveAndCheckImports(file, resolveSession);
        }
        for (JetScript script : c.getScripts().keySet()) {
            LazyTopDownAnalyzerForTopLevel.resolveAndCheckImports(script.getContainingJetFile(), resolveSession);
        }
    }

    private static void resolveAndCheckImports(@NotNull JetFile file, @NotNull KotlinCodeAnalyzer resolveSession) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "resolveAndCheckImports"));
        }
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSession", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "resolveAndCheckImports"));
        }
        LazyFileScope fileScope = resolveSession.getScopeProvider().getFileScope(file);
        fileScope.forceResolveAllImports();
    }
}

