/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import com.intellij.psi.PsiElement;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilPackage$BindingContextUtils$03b1da29;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage$DescriptorUtils$01ec8e24;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class ReceiversPackage$Qualifier$cfd356c9 {
    @Nullable
    public static final QualifierReceiver createQualifier(@JetValueParameter(name="expression") @NotNull JetSimpleNameExpression expression, @JetValueParameter(name="receiver") @NotNull ReceiverValue receiver, @JetValueParameter(name="context") @NotNull ExpressionTypingContext context2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(receiver, "receiver");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        JetScope receiverScope = !receiver.exists() ? ((ResolutionContext)context2).scope : (receiver instanceof QualifierReceiver ? ((QualifierReceiver)receiver).getScope() : receiver.getType().getMemberScope());
        Name name = expression.getReferencedNameAsName();
        PackageViewDescriptor packageViewDescriptor = receiverScope.getPackage(name);
        ClassifierDescriptor classifierDescriptor = receiverScope.getClassifier(name);
        if (packageViewDescriptor == null && classifierDescriptor == null) {
            return null;
        }
        BindingContextUtilPackage$BindingContextUtils$03b1da29.recordScopeAndDataFlowInfo(context2, expression);
        QualifierReceiver qualifier = new QualifierReceiver(expression, packageViewDescriptor, classifierDescriptor);
        ((ResolutionContext)context2).trace.record(BindingContext.QUALIFIER, qualifier.getExpression(), qualifier);
        return qualifier;
    }

    @Nullable
    public static final JetType resolveAsStandaloneExpression(@JetValueParameter(name="$receiver") QualifierReceiver $receiver, @JetValueParameter(name="context") @NotNull ExpressionTypingContext context2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        ReceiversPackage$Qualifier$cfd356c9.resolveAndRecordReferenceTarget($receiver, context2, null);
        if ($receiver.getClassifier() instanceof TypeParameterDescriptor) {
            ((ResolutionContext)context2).trace.report(Errors.TYPE_PARAMETER_IS_NOT_AN_EXPRESSION.on((JetSimpleNameExpression)((PsiElement)$receiver.getReferenceExpression()), (TypeParameterDescriptor)$receiver.getClassifier()));
        } else if ($receiver.getClassifier() instanceof ClassDescriptor && !DescriptorUtilPackage$DescriptorUtils$01ec8e24.getHasClassObjectType((ClassDescriptor)$receiver.getClassifier())) {
            ((ResolutionContext)context2).trace.report(Errors.NO_COMPANION_OBJECT.on((JetSimpleNameExpression)((PsiElement)$receiver.getReferenceExpression()), $receiver.getClassifier()));
        } else if ($receiver.getPackageView() != null) {
            ((ResolutionContext)context2).trace.report(Errors.EXPRESSION_EXPECTED_PACKAGE_FOUND.on((JetSimpleNameExpression)((PsiElement)$receiver.getReferenceExpression())));
        }
        return null;
    }

    public static final void resolveAsReceiverInQualifiedExpression(@JetValueParameter(name="$receiver") QualifierReceiver $receiver, @JetValueParameter(name="context") @NotNull ExpressionTypingContext context2, @JetValueParameter(name="selector", type="?") @Nullable DeclarationDescriptor selector) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        ReceiversPackage$Qualifier$cfd356c9.resolveAndRecordReferenceTarget($receiver, context2, selector);
        if ($receiver.getClassifier() instanceof TypeParameterDescriptor) {
            ((ResolutionContext)context2).trace.report(Errors.TYPE_PARAMETER_ON_LHS_OF_DOT.on((JetSimpleNameExpression)((PsiElement)$receiver.getReferenceExpression()), (TypeParameterDescriptor)$receiver.getClassifier()));
        } else if ($receiver.getClassifier() instanceof ClassDescriptor && DescriptorUtilPackage$DescriptorUtils$01ec8e24.getHasClassObjectType((ClassDescriptor)$receiver.getClassifier())) {
            ((ResolutionContext)context2).trace.recordType($receiver.getExpression(), DescriptorUtilPackage$DescriptorUtils$01ec8e24.getClassObjectType((ClassDescriptor)$receiver.getClassifier()));
        }
    }

    public static final void resolveAndRecordReferenceTarget(@JetValueParameter(name="$receiver") QualifierReceiver $receiver, @JetValueParameter(name="context") @NotNull ExpressionTypingContext context2, @JetValueParameter(name="selector", type="?") @Nullable DeclarationDescriptor selector) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        $receiver.setResultingDescriptor(ReceiversPackage$Qualifier$cfd356c9.resolveReferenceTarget($receiver, context2, selector));
        ((ResolutionContext)context2).trace.record(BindingContext.REFERENCE_TARGET, $receiver.getReferenceExpression(), $receiver.getResultingDescriptor());
    }

    @NotNull
    public static final DeclarationDescriptor resolveReferenceTarget(@JetValueParameter(name="$receiver") QualifierReceiver $receiver, @JetValueParameter(name="context") @NotNull ExpressionTypingContext context2, @JetValueParameter(name="selector", type="?") @Nullable DeclarationDescriptor selector) {
        ClassDescriptor companionObjectDescriptor2;
        DeclarationDescriptor selectorContainer;
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        if ($receiver.getClassifier() instanceof TypeParameterDescriptor) {
            return $receiver.getClassifier();
        }
        if (selector instanceof ConstructorDescriptor) {
            declarationDescriptor = ((ConstructorDescriptor)selector).getContainingDeclaration().getContainingDeclaration();
        } else {
            DeclarationDescriptor declarationDescriptor2 = selector;
            declarationDescriptor = selectorContainer = declarationDescriptor2 != null ? declarationDescriptor2.getContainingDeclaration() : null;
        }
        if ($receiver.getPackageView() != null && (selectorContainer instanceof PackageFragmentDescriptor || selectorContainer instanceof PackageViewDescriptor) && Intrinsics.areEqual(DescriptorUtils.getFqName($receiver.getPackageView()), DescriptorUtils.getFqName(selectorContainer))) {
            return $receiver.getPackageView();
        }
        boolean isCallableWithReceiver = selector instanceof CallableDescriptor && (((CallableDescriptor)selector).getDispatchReceiverParameter() != null || ((CallableDescriptor)selector).getExtensionReceiverParameter() != null);
        DeclarationDescriptor declarationDescriptor3 = $receiver.getDescriptor();
        if (declarationDescriptor3 instanceof ClassifierDescriptor) {
            SymbolUsageValidator symbolUsageValidator = ((ResolutionContext)context2).symbolUsageValidator;
            ClassifierDescriptor classifierDescriptor = (ClassifierDescriptor)declarationDescriptor3;
            BindingTrace bindingTrace = ((ResolutionContext)context2).trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            symbolUsageValidator.validateTypeUsage(classifierDescriptor, bindingTrace, $receiver.getReferenceExpression());
        }
        if (isCallableWithReceiver && $receiver.getClassifier() instanceof ClassDescriptor && DescriptorUtilPackage$DescriptorUtils$01ec8e24.getHasClassObjectType((ClassDescriptor)$receiver.getClassifier()) && (companionObjectDescriptor2 = ((ClassDescriptor)$receiver.getClassifier()).getCompanionObjectDescriptor()) != null) {
            ((ResolutionContext)context2).trace.record(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, $receiver.getReferenceExpression(), $receiver.getClassifier());
            SymbolUsageValidator symbolUsageValidator = ((ResolutionContext)context2).symbolUsageValidator;
            ClassifierDescriptor classifierDescriptor = companionObjectDescriptor2;
            BindingTrace bindingTrace = ((ResolutionContext)context2).trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            symbolUsageValidator.validateTypeUsage(classifierDescriptor, bindingTrace, $receiver.getReferenceExpression());
            return companionObjectDescriptor2;
        }
        return declarationDescriptor3;
    }
}

