/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Interner<T> {
    private final Interner<T> parent;
    private final int firstIndex;
    private final Map<T, Integer> interned = new HashMap<T, Integer>();

    public Interner(Interner<T> parent) {
        this.parent = parent;
        this.firstIndex = parent != null ? parent.interned.size() + parent.firstIndex : 0;
    }

    public Interner() {
        this(null);
    }

    @Nullable
    private Integer find(@NotNull T obj) {
        Integer index2;
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "org/jetbrains/kotlin/serialization/Interner", "find"));
        }
        assert (this.parent == null || this.parent.interned.size() + this.parent.firstIndex == this.firstIndex) : "Parent changed in parallel with child: indexes will be wrong";
        if (this.parent != null && (index2 = super.find(obj)) != null) {
            return index2;
        }
        return this.interned.get(obj);
    }

    public int intern(@NotNull T obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "org/jetbrains/kotlin/serialization/Interner", "intern"));
        }
        Integer index2 = this.find(obj);
        if (index2 != null) {
            return index2;
        }
        index2 = this.firstIndex + this.interned.size();
        this.interned.put(obj, index2);
        return index2;
    }

    @NotNull
    public List<T> getAllInternedObjects() {
        List<T> list = KotlinPackage.toSortedListBy(this.interned.keySet(), new Function1<T, Integer>(){

            @Override
            public Integer invoke(T key) {
                return (Integer)Interner.this.interned.get(key);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/Interner", "getAllInternedObjects"));
        }
        return list;
    }
}

