/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import java.util.Collections;
import javax.inject.Inject;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class ForLoopConventionsChecker {
    private KotlinBuiltIns builtIns;
    private SymbolUsageValidator symbolUsageValidator;
    private FakeCallResolver fakeCallResolver;

    @Inject
    public void setBuiltIns(@NotNull KotlinBuiltIns builtIns) {
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "setBuiltIns"));
        }
        this.builtIns = builtIns;
    }

    @Inject
    public void setFakeCallResolver(@NotNull FakeCallResolver fakeCallResolver) {
        if (fakeCallResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fakeCallResolver", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "setFakeCallResolver"));
        }
        this.fakeCallResolver = fakeCallResolver;
    }

    @Inject
    public void setSymbolUsageValidator(SymbolUsageValidator symbolUsageValidator) {
        this.symbolUsageValidator = symbolUsageValidator;
    }

    @Nullable
    public JetType checkIterableConvention(@NotNull ExpressionReceiver loopRange, ExpressionTypingContext context2) {
        if (loopRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopRange", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "checkIterableConvention"));
        }
        JetExpression loopRangeExpression = loopRange.getExpression();
        Name iterator2 = Name.identifier("iterator");
        Pair<Call, OverloadResolutionResults<FunctionDescriptor>> calls = this.fakeCallResolver.makeAndResolveFakeCall(loopRange, context2, Collections.emptyList(), iterator2, loopRange.getExpression());
        OverloadResolutionResults<FunctionDescriptor> iteratorResolutionResults = calls.getSecond();
        if (iteratorResolutionResults.isSuccess()) {
            ResolvedCall<FunctionDescriptor> iteratorResolvedCall = iteratorResolutionResults.getResultingCall();
            context2.trace.record(BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, loopRangeExpression, iteratorResolvedCall);
            FunctionDescriptor iteratorFunction = iteratorResolvedCall.getResultingDescriptor();
            this.symbolUsageValidator.validateCall(iteratorFunction, context2.trace, loopRangeExpression);
            JetType iteratorType = iteratorFunction.getReturnType();
            JetType hasNextType = this.checkConventionForIterator(context2, loopRangeExpression, iteratorType, "hasNext", Errors.HAS_NEXT_FUNCTION_AMBIGUITY, Errors.HAS_NEXT_MISSING, Errors.HAS_NEXT_FUNCTION_NONE_APPLICABLE, BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL);
            if (hasNextType != null && !this.builtIns.isBooleanOrSubtype(hasNextType)) {
                context2.trace.report(Errors.HAS_NEXT_FUNCTION_TYPE_MISMATCH.on(loopRangeExpression, hasNextType));
            }
            return this.checkConventionForIterator(context2, loopRangeExpression, iteratorType, "next", Errors.NEXT_AMBIGUITY, Errors.NEXT_MISSING, Errors.NEXT_NONE_APPLICABLE, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL);
        }
        if (iteratorResolutionResults.isAmbiguity()) {
            context2.trace.report(Errors.ITERATOR_AMBIGUITY.on(loopRangeExpression, iteratorResolutionResults.getResultingCalls()));
        } else {
            context2.trace.report(Errors.ITERATOR_MISSING.on(loopRangeExpression));
        }
        return null;
    }

    @Nullable
    private JetType checkConventionForIterator(@NotNull ExpressionTypingContext context2, @NotNull JetExpression loopRangeExpression, @NotNull JetType iteratorType, @NotNull String name, @NotNull DiagnosticFactory1<JetExpression, JetType> ambiguity, @NotNull DiagnosticFactory1<JetExpression, JetType> missing, @NotNull DiagnosticFactory1<JetExpression, JetType> noneApplicable, @NotNull WritableSlice<JetExpression, ResolvedCall<FunctionDescriptor>> resolvedCallKey) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (loopRangeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopRangeExpression", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (iteratorType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iteratorType", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (ambiguity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ambiguity", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (missing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "missing", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (noneApplicable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "noneApplicable", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (resolvedCallKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCallKey", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        OverloadResolutionResults<FunctionDescriptor> nextResolutionResults = this.fakeCallResolver.resolveFakeCall(context2, new TransientReceiver(iteratorType), Name.identifier(name), loopRangeExpression);
        if (nextResolutionResults.isAmbiguity()) {
            context2.trace.report(ambiguity.on(loopRangeExpression, iteratorType));
        } else if (nextResolutionResults.isNothing()) {
            context2.trace.report(missing.on(loopRangeExpression, iteratorType));
        } else if (!nextResolutionResults.isSuccess()) {
            context2.trace.report(noneApplicable.on(loopRangeExpression, iteratorType));
        } else {
            assert (nextResolutionResults.isSuccess());
            ResolvedCall<FunctionDescriptor> resolvedCall = nextResolutionResults.getResultingCall();
            context2.trace.record(resolvedCallKey, loopRangeExpression, resolvedCall);
            FunctionDescriptor functionDescriptor = resolvedCall.getResultingDescriptor();
            this.symbolUsageValidator.validateCall(functionDescriptor, context2.trace, loopRangeExpression);
            return functionDescriptor.getReturnType();
        }
        return null;
    }
}

