/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBFont;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import javax.swing.UIManager;

public class JBUI {
    private static float SCALE_FACTOR = JBUI.calculateScaleFactor();

    private static float calculateScaleFactor() {
        if (SystemInfo.isMac) {
            return 1.0f;
        }
        if (SystemProperties.has("hidpi") && !SystemProperties.is("hidpi")) {
            return 1.0f;
        }
        if (SystemInfo.isLinux) {
            int dpi = JBUI.getSystemDPI();
            if (dpi < 120) {
                return 1.0f;
            }
            if (dpi < 144) {
                return 1.25f;
            }
            if (dpi < 168) {
                return 1.5f;
            }
            if (dpi < 192) {
                return 1.75f;
            }
            return 2.0f;
        }
        int size = -1;
        try {
            if (SystemInfo.isWindows) {
                size = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("win.system.font.height");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (size == -1) {
            size = Fonts.label().getSize();
        }
        if (size <= 13) {
            return 1.0f;
        }
        if (size <= 16) {
            return 1.25f;
        }
        if (size <= 18) {
            return 1.5f;
        }
        if (size < 24) {
            return 1.75f;
        }
        return 2.0f;
    }

    private static int getSystemDPI() {
        try {
            return Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException e) {
            return 96;
        }
    }

    public static float scale(float f) {
        return f * SCALE_FACTOR;
    }

    public static boolean isHiDPI() {
        return SCALE_FACTOR > 1.0f;
    }

    public static class Fonts {
        public static JBFont label() {
            return JBFont.create(UIManager.getFont("Label.font"), false);
        }
    }
}

