/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.FunctionParameterContext;
import com.sun.jna.FunctionResultContext;
import com.sun.jna.Memory;
import com.sun.jna.MethodParameterContext;
import com.sun.jna.MethodResultContext;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;

public class Function
extends Pointer {
    static final Integer INTEGER_TRUE = new Integer(-1);
    static final Integer INTEGER_FALSE = new Integer(0);
    private NativeLibrary library;
    private final String functionName;
    int callFlags;
    final Map options;
    static /* synthetic */ Class class$com$sun$jna$NativeMapped;
    static /* synthetic */ Class array$Lcom$sun$jna$Structure$ByReference;
    static /* synthetic */ Class array$Lcom$sun$jna$Structure;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$jna$WString;
    static /* synthetic */ Class class$com$sun$jna$Pointer;
    static /* synthetic */ Class class$com$sun$jna$Structure;
    static /* synthetic */ Class class$com$sun$jna$Structure$ByValue;
    static /* synthetic */ Class class$com$sun$jna$Callback;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$Lcom$sun$jna$WString;
    static /* synthetic */ Class array$Lcom$sun$jna$Pointer;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$Lcom$sun$jna$NativeMapped;
    static /* synthetic */ Class class$com$sun$jna$Structure$ByReference;

    Function(NativeLibrary library, String functionName, int callFlags) {
        this.checkCallingConvention(callFlags & 3);
        if (functionName == null) {
            throw new NullPointerException("Function name must not be null");
        }
        this.library = library;
        this.functionName = functionName;
        this.callFlags = callFlags;
        this.options = library.options;
        try {
            this.peer = library.getSymbolAddress(functionName);
        }
        catch (UnsatisfiedLinkError e) {
            throw new UnsatisfiedLinkError(new StringBuffer().append("Error looking up function '").append(functionName).append("': ").append(e.getMessage()).toString());
        }
    }

    Function(Pointer functionAddress, int callFlags) {
        this.checkCallingConvention(callFlags & 3);
        if (functionAddress == null || functionAddress.peer == 0L) {
            throw new NullPointerException("Function address may not be null");
        }
        this.functionName = functionAddress.toString();
        this.callFlags = callFlags;
        this.peer = functionAddress.peer;
        this.options = Collections.EMPTY_MAP;
    }

    private void checkCallingConvention(int convention) throws IllegalArgumentException {
        switch (convention) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer().append("Unrecognized calling convention: ").append(convention).toString());
            }
        }
    }

    public String getName() {
        return this.functionName;
    }

    public Object invoke(Class returnType2, Object[] inArgs, Map options) {
        Object[] args = new Object[]{};
        if (inArgs != null) {
            if (inArgs.length > 256) {
                throw new UnsupportedOperationException("Maximum argument count is 256");
            }
            args = new Object[inArgs.length];
            System.arraycopy(inArgs, 0, args, 0, args.length);
        }
        TypeMapper mapper = (TypeMapper)options.get("type-mapper");
        Method invokingMethod = (Method)options.get("invoking-method");
        boolean allowObjects = Boolean.TRUE.equals(options.get("allow-objects"));
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.convertArgument(args, i, invokingMethod, mapper, allowObjects);
        }
        Class nativeType = returnType2;
        FromNativeConverter resultConverter = null;
        if ((class$com$sun$jna$NativeMapped == null ? (class$com$sun$jna$NativeMapped = Function.class$("com.sun.jna.NativeMapped")) : class$com$sun$jna$NativeMapped).isAssignableFrom(returnType2)) {
            NativeMappedConverter tc = NativeMappedConverter.getInstance(returnType2);
            resultConverter = tc;
            nativeType = tc.nativeType();
        } else if (mapper != null && (resultConverter = mapper.getFromNativeConverter(returnType2)) != null) {
            nativeType = resultConverter.nativeType();
        }
        Object result2 = this.invoke(args, nativeType, allowObjects);
        if (resultConverter != null) {
            FunctionResultContext context = invokingMethod != null ? new MethodResultContext(returnType2, this, inArgs, invokingMethod) : new FunctionResultContext(returnType2, this, inArgs);
            result2 = resultConverter.fromNative(result2, context);
        }
        if (inArgs != null) {
            for (int i = 0; i < inArgs.length; ++i) {
                Object inArg = inArgs[i];
                if (inArg == null) continue;
                if (inArg instanceof Structure) {
                    if (inArg instanceof Structure.ByValue) continue;
                    ((Structure)inArg).autoRead();
                    continue;
                }
                if (args[i] instanceof PostCallRead) {
                    ((PostCallRead)args[i]).read();
                    if (!(args[i] instanceof PointerArray)) continue;
                    PointerArray array = (PointerArray)args[i];
                    if (!(array$Lcom$sun$jna$Structure$ByReference == null ? Function.class$("[Lcom.sun.jna.Structure$ByReference;") : array$Lcom$sun$jna$Structure$ByReference).isAssignableFrom(inArg.getClass())) continue;
                    Class<?> type2 = inArg.getClass().getComponentType();
                    Structure[] ss = (Structure[])inArg;
                    for (int si = 0; si < ss.length; ++si) {
                        Pointer p = array.getPointer(Pointer.SIZE * si);
                        ss[si] = Structure.updateStructureByReference(type2, ss[si], p);
                    }
                    continue;
                }
                if (!(array$Lcom$sun$jna$Structure == null ? Function.class$("[Lcom.sun.jna.Structure;") : array$Lcom$sun$jna$Structure).isAssignableFrom(inArg.getClass())) continue;
                Structure.autoRead((Structure[])inArg);
            }
        }
        return result2;
    }

    Object invoke(Object[] args, Class returnType2, boolean allowObjects) {
        Object result2 = null;
        if (returnType2 == null || returnType2 == Void.TYPE || returnType2 == (class$java$lang$Void == null ? (class$java$lang$Void = Function.class$("java.lang.Void")) : class$java$lang$Void)) {
            Native.invokeVoid(this.peer, this.callFlags, args);
            result2 = null;
        } else if (returnType2 == Boolean.TYPE || returnType2 == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Function.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            result2 = Function.valueOf(Native.invokeInt(this.peer, this.callFlags, args) != 0);
        } else if (returnType2 == Byte.TYPE || returnType2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = Function.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            result2 = new Byte((byte)Native.invokeInt(this.peer, this.callFlags, args));
        } else if (returnType2 == Short.TYPE || returnType2 == (class$java$lang$Short == null ? (class$java$lang$Short = Function.class$("java.lang.Short")) : class$java$lang$Short)) {
            result2 = new Short((short)Native.invokeInt(this.peer, this.callFlags, args));
        } else if (returnType2 == Character.TYPE || returnType2 == (class$java$lang$Character == null ? (class$java$lang$Character = Function.class$("java.lang.Character")) : class$java$lang$Character)) {
            result2 = new Character((char)Native.invokeInt(this.peer, this.callFlags, args));
        } else if (returnType2 == Integer.TYPE || returnType2 == (class$java$lang$Integer == null ? (class$java$lang$Integer = Function.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            result2 = new Integer(Native.invokeInt(this.peer, this.callFlags, args));
        } else if (returnType2 == Long.TYPE || returnType2 == (class$java$lang$Long == null ? (class$java$lang$Long = Function.class$("java.lang.Long")) : class$java$lang$Long)) {
            result2 = new Long(Native.invokeLong(this.peer, this.callFlags, args));
        } else if (returnType2 == Float.TYPE || returnType2 == (class$java$lang$Float == null ? (class$java$lang$Float = Function.class$("java.lang.Float")) : class$java$lang$Float)) {
            result2 = new Float(Native.invokeFloat(this.peer, this.callFlags, args));
        } else if (returnType2 == Double.TYPE || returnType2 == (class$java$lang$Double == null ? (class$java$lang$Double = Function.class$("java.lang.Double")) : class$java$lang$Double)) {
            result2 = new Double(Native.invokeDouble(this.peer, this.callFlags, args));
        } else if (returnType2 == (class$java$lang$String == null ? (class$java$lang$String = Function.class$("java.lang.String")) : class$java$lang$String)) {
            result2 = this.invokeString(this.callFlags, args, false);
        } else if (returnType2 == (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = Function.class$("com.sun.jna.WString")) : class$com$sun$jna$WString)) {
            String s = this.invokeString(this.callFlags, args, true);
            if (s != null) {
                result2 = new WString(s);
            }
        } else {
            if ((class$com$sun$jna$Pointer == null ? (class$com$sun$jna$Pointer = Function.class$("com.sun.jna.Pointer")) : class$com$sun$jna$Pointer).isAssignableFrom(returnType2)) {
                return this.invokePointer(this.callFlags, args);
            }
            if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Function.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(returnType2)) {
                if ((class$com$sun$jna$Structure$ByValue == null ? (class$com$sun$jna$Structure$ByValue = Function.class$("com.sun.jna.Structure$ByValue")) : class$com$sun$jna$Structure$ByValue).isAssignableFrom(returnType2)) {
                    Structure s = Native.invokeStructure(this.peer, this.callFlags, args, Structure.newInstance(returnType2));
                    s.autoRead();
                    result2 = s;
                } else {
                    result2 = this.invokePointer(this.callFlags, args);
                    if (result2 != null) {
                        Structure s = Structure.newInstance(returnType2);
                        s.useMemory((Pointer)result2);
                        s.autoRead();
                        result2 = s;
                    }
                }
            } else if ((class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = Function.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(returnType2)) {
                result2 = this.invokePointer(this.callFlags, args);
                if (result2 != null) {
                    result2 = CallbackReference.getCallback(returnType2, (Pointer)result2);
                }
            } else if (returnType2 == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = Function.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
                Pointer p = this.invokePointer(this.callFlags, args);
                if (p != null) {
                    result2 = p.getStringArray(0L);
                }
            } else if (returnType2 == (array$Lcom$sun$jna$WString == null ? (array$Lcom$sun$jna$WString = Function.class$("[Lcom.sun.jna.WString;")) : array$Lcom$sun$jna$WString)) {
                Pointer p = this.invokePointer(this.callFlags, args);
                if (p != null) {
                    String[] arr = p.getStringArray(0L, true);
                    WString[] warr = new WString[arr.length];
                    for (int i = 0; i < arr.length; ++i) {
                        warr[i] = new WString(arr[i]);
                    }
                    result2 = warr;
                }
            } else if (returnType2 == (array$Lcom$sun$jna$Pointer == null ? (array$Lcom$sun$jna$Pointer = Function.class$("[Lcom.sun.jna.Pointer;")) : array$Lcom$sun$jna$Pointer)) {
                Pointer p = this.invokePointer(this.callFlags, args);
                if (p != null) {
                    result2 = p.getPointerArray(0L);
                }
            } else if (allowObjects) {
                result2 = Native.invokeObject(this.peer, this.callFlags, args);
                if (result2 != null && !returnType2.isAssignableFrom(result2.getClass())) {
                    throw new ClassCastException(new StringBuffer().append("Return type ").append(returnType2).append(" does not match result ").append(result2.getClass()).toString());
                }
            } else {
                throw new IllegalArgumentException(new StringBuffer().append("Unsupported return type ").append(returnType2).append(" in function ").append(this.getName()).toString());
            }
        }
        return result2;
    }

    private Pointer invokePointer(int callFlags, Object[] args) {
        long ptr = Native.invokePointer(this.peer, callFlags, args);
        return ptr == 0L ? null : new Pointer(ptr);
    }

    private Object convertArgument(Object[] args, int index2, Method invokingMethod, TypeMapper mapper, boolean allowObjects) {
        Object arg = args[index2];
        if (arg != null) {
            Class<?> type2 = arg.getClass();
            ToNativeConverter converter = null;
            if ((class$com$sun$jna$NativeMapped == null ? (class$com$sun$jna$NativeMapped = Function.class$("com.sun.jna.NativeMapped")) : class$com$sun$jna$NativeMapped).isAssignableFrom(type2)) {
                converter = NativeMappedConverter.getInstance(type2);
            } else if (mapper != null) {
                converter = mapper.getToNativeConverter(type2);
            }
            if (converter != null) {
                FunctionParameterContext context = invokingMethod != null ? new MethodParameterContext(this, args, index2, invokingMethod) : new FunctionParameterContext(this, args, index2);
                arg = converter.toNative(arg, context);
            }
        }
        if (arg == null || this.isPrimitiveArray(arg.getClass())) {
            return arg;
        }
        Class<?> argClass = arg.getClass();
        if (arg instanceof Structure) {
            Structure struct = (Structure)arg;
            struct.autoWrite();
            if (struct instanceof Structure.ByValue) {
                Class<?> ptype = struct.getClass();
                if (invokingMethod != null) {
                    Class<?>[] ptypes = invokingMethod.getParameterTypes();
                    if (Function.isVarArgs(invokingMethod)) {
                        if (index2 < ptypes.length - 1) {
                            ptype = ptypes[index2];
                        } else {
                            Class<?> etype = ptypes[ptypes.length - 1].getComponentType();
                            if (etype != (class$java$lang$Object == null ? (class$java$lang$Object = Function.class$("java.lang.Object")) : class$java$lang$Object)) {
                                ptype = etype;
                            }
                        }
                    } else {
                        ptype = ptypes[index2];
                    }
                }
                if ((class$com$sun$jna$Structure$ByValue == null ? (class$com$sun$jna$Structure$ByValue = Function.class$("com.sun.jna.Structure$ByValue")) : class$com$sun$jna$Structure$ByValue).isAssignableFrom(ptype)) {
                    return struct;
                }
            }
            return struct.getPointer();
        }
        if (arg instanceof Callback) {
            return CallbackReference.getFunctionPointer((Callback)arg);
        }
        if (arg instanceof String) {
            return new NativeString((String)arg, false).getPointer();
        }
        if (arg instanceof WString) {
            return new NativeString(arg.toString(), true).getPointer();
        }
        if (arg instanceof Boolean) {
            return Boolean.TRUE.equals(arg) ? INTEGER_TRUE : INTEGER_FALSE;
        }
        if ((array$Ljava$lang$String == null ? (array$Ljava$lang$String = Function.class$("[Ljava.lang.String;")) : array$Ljava$lang$String) == argClass) {
            return new StringArray((String[])arg);
        }
        if ((array$Lcom$sun$jna$WString == null ? (array$Lcom$sun$jna$WString = Function.class$("[Lcom.sun.jna.WString;")) : array$Lcom$sun$jna$WString) == argClass) {
            return new StringArray((WString[])arg);
        }
        if ((array$Lcom$sun$jna$Pointer == null ? (array$Lcom$sun$jna$Pointer = Function.class$("[Lcom.sun.jna.Pointer;")) : array$Lcom$sun$jna$Pointer) == argClass) {
            return new PointerArray((Pointer[])arg);
        }
        if ((array$Lcom$sun$jna$NativeMapped == null ? (array$Lcom$sun$jna$NativeMapped = Function.class$("[Lcom.sun.jna.NativeMapped;")) : array$Lcom$sun$jna$NativeMapped).isAssignableFrom(argClass)) {
            return new NativeMappedArray((NativeMapped[])arg);
        }
        if ((array$Lcom$sun$jna$Structure == null ? (array$Lcom$sun$jna$Structure = Function.class$("[Lcom.sun.jna.Structure;")) : array$Lcom$sun$jna$Structure).isAssignableFrom(argClass)) {
            Class<?> type3;
            Structure[] ss = (Structure[])arg;
            boolean byRef = (class$com$sun$jna$Structure$ByReference == null ? (class$com$sun$jna$Structure$ByReference = Function.class$("com.sun.jna.Structure$ByReference")) : class$com$sun$jna$Structure$ByReference).isAssignableFrom(type3 = argClass.getComponentType());
            if (byRef) {
                Pointer[] pointers = new Pointer[ss.length + 1];
                for (int i = 0; i < ss.length; ++i) {
                    pointers[i] = ss[i] != null ? ss[i].getPointer() : null;
                }
                return new PointerArray(pointers);
            }
            if (ss.length == 0) {
                throw new IllegalArgumentException("Structure array must have non-zero length");
            }
            if (ss[0] == null) {
                Structure.newInstance(type3).toArray(ss);
                return ss[0].getPointer();
            }
            Structure.autoWrite(ss);
            return ss[0].getPointer();
        }
        if (argClass.isArray()) {
            throw new IllegalArgumentException(new StringBuffer().append("Unsupported array argument type: ").append(argClass.getComponentType()).toString());
        }
        if (allowObjects) {
            return arg;
        }
        if (!Native.isSupportedNativeType(arg.getClass())) {
            throw new IllegalArgumentException(new StringBuffer().append("Unsupported argument type ").append(arg.getClass().getName()).append(" at parameter ").append(index2).append(" of function ").append(this.getName()).toString());
        }
        return arg;
    }

    private boolean isPrimitiveArray(Class argClass) {
        return argClass.isArray() && argClass.getComponentType().isPrimitive();
    }

    private String invokeString(int callFlags, Object[] args, boolean wide) {
        Pointer ptr = this.invokePointer(callFlags, args);
        String s = null;
        if (ptr != null) {
            s = wide ? ptr.getString(0L, wide) : ptr.getString(0L);
        }
        return s;
    }

    @Override
    public String toString() {
        if (this.library != null) {
            return new StringBuffer().append("native function ").append(this.functionName).append("(").append(this.library.getName()).append(")@0x").append(Long.toHexString(this.peer)).toString();
        }
        return new StringBuffer().append("native function@0x").append(Long.toHexString(this.peer)).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            Function other = (Function)o;
            return other.callFlags == this.callFlags && ((Object)other.options).equals(this.options) && other.peer == this.peer;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.callFlags + ((Object)this.options).hashCode() + super.hashCode();
    }

    static Object[] concatenateVarArgs(Object[] inArgs) {
        if (inArgs != null && inArgs.length > 0) {
            Class<?> argType;
            Object lastArg = inArgs[inArgs.length - 1];
            Class<?> clazz = argType = lastArg != null ? lastArg.getClass() : null;
            if (argType != null && argType.isArray()) {
                Object[] varArgs = (Object[])lastArg;
                Object[] fullArgs = new Object[inArgs.length + varArgs.length];
                System.arraycopy(inArgs, 0, fullArgs, 0, inArgs.length - 1);
                System.arraycopy(varArgs, 0, fullArgs, inArgs.length - 1, varArgs.length);
                fullArgs[fullArgs.length - 1] = null;
                inArgs = fullArgs;
            }
        }
        return inArgs;
    }

    static boolean isVarArgs(Method m) {
        try {
            Method v = m.getClass().getMethod("isVarArgs", new Class[0]);
            return Boolean.TRUE.equals(v.invoke((Object)m, new Object[0]));
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    static Boolean valueOf(boolean b) {
        return b ? Boolean.TRUE : Boolean.FALSE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    private static class PointerArray
    extends Memory
    implements PostCallRead {
        private final Pointer[] original;

        public PointerArray(Pointer[] arg) {
            super(Pointer.SIZE * (arg.length + 1));
            this.original = arg;
            for (int i = 0; i < arg.length; ++i) {
                this.setPointer(i * Pointer.SIZE, arg[i]);
            }
            this.setPointer(Pointer.SIZE * arg.length, null);
        }

        @Override
        public void read() {
            this.read(0L, this.original, 0, this.original.length);
        }
    }

    private static class NativeMappedArray
    extends Memory
    implements PostCallRead {
        private final NativeMapped[] original;

        public NativeMappedArray(NativeMapped[] arg) {
            super(Native.getNativeSize(arg.getClass(), arg));
            this.original = arg;
            this.setValue(0L, this.original, this.original.getClass());
        }

        @Override
        public void read() {
            this.getValue(0L, this.original.getClass(), this.original);
        }
    }

    public static interface PostCallRead {
        public void read();
    }
}

