/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.bridges;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.bridges.Bridge;
import org.jetbrains.kotlin.backend.common.bridges.BridgesKt;
import org.jetbrains.kotlin.backend.common.bridges.FunctionHandle;
import org.jetbrains.kotlin.utils.DFS;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"\n\u0006)Aa)\u001e8di&|gN\u0003\bGk:\u001cG/[8o\u0011\u0006tG\r\\3\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TqAY1dW\u0016tGM\u0003\u0004d_6lwN\u001c\u0006\bEJLGmZ3t\u0015q1\u0017N\u001c3BY2\u0014V-Y2iC\ndW\rR3dY\u0006\u0014\u0018\r^5p]NT\u0001BZ;oGRLwN\u001c\u0006\u000b\u001bV$\u0018M\u00197f'\u0016$(\u0002\u00026bm\u0006TA!\u001e;jY*\u00191+\u001a;\u000b\u0013\t\u0013\u0018\u000eZ4fg.#(\u0002\b4j]\u0012\u001cuN\\2sKR,7+\u001e9fe\u0012+7\r\\1sCRLwN\u001c\u0006\n'&<g.\u0019;ve\u0016T1!\u00118z\u0015=9WM\\3sCR,'I]5eO\u0016\u001c(\"C:jO:\fG/\u001e:f\u0015%1UO\\2uS>t\u0017G\u0003\u0004Ce&$w-\u001a\u0006\u0004UZl'\"\u00034v]\u000e$\u0018n\u001c8t}*\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\u0015QA\u0001C\u0002\u0011\r)!\u0001\u0002\u0002\t\b\u0015\u0019AQ\u0001E\u0001\u0019\u0001)\u0011\u0001\u0003\u0002\u0006\u0007\u0011\u001d\u0001\"\u0002\u0007\u0001\u000b\u0005AY!\u0002\u0002\u0005\n!1QA\u0001\u0003\u0006\u0011\u001b)!\u0001\"\u0002\t\u0002\u0015\u0019Aq\u0001E\t\u0019\u0001)1\u0001b\u0002\t\u00151\u0001Qa\u0001C\u0004\u0011\u001ba\u0001!B\u0002\u0005\u0006!UA\u0002A\u0003\u0003\t\u000fA1\"\u0002\u0002\u0005\u0012!]QA\u0001\u0003\n\u0011))I\u0005B\u0001\u0012\r\u0011\u0001\u0001\u0002A\u000b\u0004\u000b\u0005A1\u0001G\u0002\u0019\tuEA\u0001\u0001E\u0005\u001b\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0001k\u0001\u0001\"\u0013\u0015\t\u0001\u0002B\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0001\u0004B)\u0004\u000b\u0011!\u0011\"\u0001E\u0006\u001b\u0005Aa\u0001W\u0002\b\u000b\u007f!\u0011!\u0005\u0004\u0005\u0001!\u0001QcA\u0003\u0002\u0011\rA2\u0001g\u0004\u001e\u0012\u0011\u0001\u0001\u0012B\u0007\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001A\u001b\u0001!\t\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u0001#\u000e)AqB\u0005\u0002\u0011\u0019i\u0011\u0001\u0003\u0004Y\u0007\u001d)\u0001\u001a\u0001\u0003\u0004#\u0019!\u0001\u0001\u0003\u0001\u0016\u0007\u0015\t\u0001b\u0001\r\u0004#\u001d!\t\u0001\u0003\u0005\u0016\t\u0015\t\u0001R\u0002G\u00011\u001bA\u0012\"(\u0005\u0005\u0001!%Q\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001Q\u0007\u0001i:\u0003\u0002\u0001\t\u00145yQ!\u0001\u0005\b\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004A\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0002q\u0005\u0001d\u0002)\u0004\u0002\u0005rQ!\u0001E\b\u0013)I\u0011\"B\u0001\t\u0011%)\u0011\u0002B\u0003\u0003\t\u0003A\t\u0001(\u0001\u0019\u0011a=\u0011kA\u0004\u0005\u0013%\t\u00012B\u0007\u0002\u0011\u0019i\u0011\u0001c\u0005Y\u0007\u001d\u0001"})
public final class BridgesKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <Function extends FunctionHandle, Signature> Set<Bridge<Signature>> generateBridges(@NotNull Function function, @NotNull Function1<? super Function, ? extends Signature> signature) {
        void destination;
        void $receiver;
        void $receiver2;
        Object object;
        Collection $receiver22;
        Object object2;
        void $receiver3;
        HashSet hashSet;
        Iterable destination2;
        Object it2;
        boolean fake;
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(signature, "signature");
        if (function.getIsAbstract()) {
            return KotlinPackage.setOf();
        }
        boolean bl = fake = !function.getIsDeclaration();
        if (fake) {
            boolean bl2;
            block10: {
                Iterable<FunctionHandle> $receiver5 = function.getOverridden();
                for (FunctionHandle functionHandle : $receiver5) {
                    it2 = functionHandle;
                    if (!it2.getIsAbstract()) continue;
                    bl2 = false;
                    break block10;
                }
                bl2 = true;
            }
            if (bl2) {
                return KotlinPackage.setOf();
            }
        }
        Function implementation = BridgesKt.findConcreteSuperDeclaration(function);
        Iterable iterable = BridgesKt.findAllReachableDeclarations(function);
        it2 = new HashSet();
        for (Object item : iterable) {
            destination2.add(signature.invoke(item));
        }
        HashSet bridgesToGenerate = (HashSet)destination2;
        if (fake) {
            Iterable<FunctionHandle> iterable2 = function.getOverridden();
            if (iterable2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Iterable<Function>");
            }
            for (FunctionHandle functionHandle : iterable2) {
                void destination3;
                Object item;
                if (functionHandle.getIsAbstract()) continue;
                Iterable iterable3 = BridgesKt.findAllReachableDeclarations(functionHandle);
                hashSet = bridgesToGenerate;
                item = $receiver3;
                object2 = new ArrayList(KotlinPackage.collectionSizeOrDefault($receiver3, 10));
                for (Object item2 : $receiver22) {
                    destination3.add(signature.invoke(item2));
                }
                object = (List)destination3;
                hashSet.removeAll((Collection)object);
            }
        }
        Signature Signature = signature.invoke(implementation);
        bridgesToGenerate.remove(Signature);
        destination2 = bridgesToGenerate;
        $receiver3 = $receiver2;
        $receiver22 = new ArrayList(KotlinPackage.collectionSizeOrDefault($receiver2, 10));
        object2 = $receiver.iterator();
        while (object2.hasNext()) {
            void it3;
            Object item;
            Object item2;
            item2 = item = object2.next();
            hashSet = destination;
            object = new Bridge<void>(it3, (void)Signature);
            hashSet.add(object);
        }
        return KotlinPackage.toSet((List)destination);
    }

    @NotNull
    public static final <Function extends FunctionHandle> Set<Function> findAllReachableDeclarations(@NotNull Function function) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        DFS.NodeHandlerWithListResult collector2 = new DFS.NodeHandlerWithListResult<Function, Function>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(findAllReachableDeclarations.collector.1.class);
            }

            public void afterChildren(@NotNull Function current) {
                Intrinsics.checkParameterIsNotNull(current, "current");
                if (current.getIsDeclaration()) {
                    ((LinkedList)this.result).add(current);
                }
            }
        };
        DFS.dfs((Collection)KotlinPackage.listOf(function), findAllReachableDeclarations.1.INSTANCE$, collector2);
        return new HashSet((Collection)collector2.result());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <Function extends FunctionHandle> Function findConcreteSuperDeclaration(@NotNull Function function) {
        void destination;
        void $receiver;
        void $receiver2;
        Set<Function> reachable;
        Intrinsics.checkParameterIsNotNull(function, "function");
        boolean value = !function.getIsAbstract();
        if (!value) {
            String message = "Only concrete functions have implementations: " + function;
            throw (Throwable)new IllegalArgumentException(message.toString());
        }
        if (function.getIsDeclaration()) {
            return function;
        }
        Set<Function> result2 = BridgesKt.findAllReachableDeclarations(function);
        HashSet toRemove = new HashSet();
        for (Function declaration : result2) {
            reachable = BridgesKt.findAllReachableDeclarations(declaration);
            reachable.remove(declaration);
            toRemove.addAll(reachable);
        }
        result2.removeAll(toRemove);
        Iterable iterable = result2;
        reachable = $receiver2;
        Collection collection = new ArrayList();
        for (Object element : $receiver) {
            FunctionHandle it2 = (FunctionHandle)element;
            if (!(!it2.getIsAbstract())) continue;
            destination.add(element);
        }
        List concreteRelevantDeclarations = (List)destination;
        if (concreteRelevantDeclarations.size() != 1) {
            KotlinPackage.error("Concrete fake override " + function + " should have exactly one concrete super-declaration: " + concreteRelevantDeclarations);
        }
        return (Function)((FunctionHandle)concreteRelevantDeclarations.get(0));
    }
}

