/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.MutableClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.resolve.jvm.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

public class JvmRuntimeTypes {
    private final ClassDescriptor lambda;
    private final ClassDescriptor functionReference;
    private final List<ClassDescriptor> propertyReferences;
    private final List<ClassDescriptor> mutablePropertyReferences;

    public JvmRuntimeTypes() {
        ModuleDescriptorImpl module = new ModuleDescriptorImpl(Name.special("<jvm functions impl>"), LockBasedStorageManager.NO_LOCKS, TopDownAnalyzerFacadeForJVM.JVM_MODULE_PARAMETERS);
        MutablePackageFragmentDescriptor kotlinJvmInternal = new MutablePackageFragmentDescriptor(module, new FqName("kotlin.jvm.internal"));
        this.lambda = JvmRuntimeTypes.createClass(kotlinJvmInternal, "Lambda");
        this.functionReference = JvmRuntimeTypes.createClass(kotlinJvmInternal, "FunctionReference");
        this.propertyReferences = new ArrayList<ClassDescriptor>(3);
        this.mutablePropertyReferences = new ArrayList<ClassDescriptor>(3);
        for (int i = 0; i <= 2; ++i) {
            this.propertyReferences.add(JvmRuntimeTypes.createClass(kotlinJvmInternal, "PropertyReference" + i));
            this.mutablePropertyReferences.add(JvmRuntimeTypes.createClass(kotlinJvmInternal, "MutablePropertyReference" + i));
        }
    }

    @NotNull
    private static ClassDescriptor createClass(@NotNull PackageFragmentDescriptor packageFragment, @NotNull String name) {
        if (packageFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFragment", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "createClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "createClass"));
        }
        MutableClassDescriptor descriptor2 = new MutableClassDescriptor(packageFragment, ClassKind.CLASS, false, Name.identifier(name), SourceElement.NO_SOURCE);
        descriptor2.setModality(Modality.FINAL);
        descriptor2.setVisibility(Visibilities.PUBLIC);
        descriptor2.setTypeParameterDescriptors(Collections.<TypeParameterDescriptor>emptyList());
        descriptor2.createTypeConstructor();
        MutableClassDescriptor mutableClassDescriptor = descriptor2;
        if (mutableClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "createClass"));
        }
        return mutableClassDescriptor;
    }

    @NotNull
    public Collection<JetType> getSupertypesForClosure(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "getSupertypesForClosure"));
        }
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        JetType functionType = DescriptorUtilPackage.getBuiltIns(descriptor2).getFunctionType(Annotations.EMPTY, receiverParameter == null ? null : receiverParameter.getType(), ExpressionTypingUtils.getValueParametersTypes(descriptor2.getValueParameters()), descriptor2.getReturnType());
        List<JetType> list = Arrays.asList(this.lambda.getDefaultType(), functionType);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "getSupertypesForClosure"));
        }
        return list;
    }

    @NotNull
    public Collection<JetType> getSupertypesForFunctionReference(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "getSupertypesForFunctionReference"));
        }
        ReceiverParameterDescriptor extensionReceiver2 = descriptor2.getExtensionReceiverParameter();
        ReceiverParameterDescriptor dispatchReceiver = descriptor2.getDispatchReceiverParameter();
        JetType receiverType = extensionReceiver2 != null ? extensionReceiver2.getType() : (dispatchReceiver != null ? dispatchReceiver.getType() : null);
        JetType functionType = DescriptorUtilPackage.getBuiltIns(descriptor2).getFunctionType(Annotations.EMPTY, receiverType, ExpressionTypingUtils.getValueParametersTypes(descriptor2.getValueParameters()), descriptor2.getReturnType());
        List<JetType> list = Arrays.asList(this.functionReference.getDefaultType(), functionType);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "getSupertypesForFunctionReference"));
        }
        return list;
    }

    @NotNull
    public JetType getSupertypeForPropertyReference(@NotNull PropertyDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "getSupertypeForPropertyReference"));
        }
        int arity = (descriptor2.getExtensionReceiverParameter() != null ? 1 : 0) + (descriptor2.getDispatchReceiverParameter() != null ? 1 : 0);
        JetType jetType = (descriptor2.isVar() ? this.mutablePropertyReferences : this.propertyReferences).get(arity).getDefaultType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "getSupertypeForPropertyReference"));
        }
        return jetType;
    }
}

