/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.intellij.psi.PsiElement;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.js.config.Config;
import org.jetbrains.kotlin.js.translate.context.AliasingContext;
import org.jetbrains.kotlin.js.translate.context.DefinitionPlace;
import org.jetbrains.kotlin.js.translate.context.DynamicContext;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.StaticContext;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import org.jetbrains.kotlin.js.translate.intrinsic.Intrinsics;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;

public class TranslationContext {
    @NotNull
    private final DynamicContext dynamicContext;
    @NotNull
    private final StaticContext staticContext;
    @NotNull
    private final AliasingContext aliasingContext;
    @Nullable
    private final UsageTracker usageTracker;
    @Nullable
    private final TranslationContext parent;
    @Nullable
    private final DefinitionPlace definitionPlace;
    private final Map<JsExpression, TemporaryConstVariable> expressionToTempConstVariableCache;

    @NotNull
    public static TranslationContext rootContext(@NotNull StaticContext staticContext, JsFunction rootFunction) {
        if (staticContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "staticContext", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "rootContext"));
        }
        DynamicContext rootDynamicContext = DynamicContext.rootContext(rootFunction.getScope(), rootFunction.getBody());
        AliasingContext rootAliasingContext = AliasingContext.getCleanContext();
        TranslationContext translationContext = new TranslationContext(null, staticContext, rootDynamicContext, rootAliasingContext, null, null);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "rootContext"));
        }
        return translationContext;
    }

    private TranslationContext(@Nullable TranslationContext parent, @NotNull StaticContext staticContext, @NotNull DynamicContext dynamicContext, @NotNull AliasingContext aliasingContext, @Nullable UsageTracker usageTracker, @Nullable DefinitionPlace definitionPlace) {
        if (staticContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "staticContext", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "<init>"));
        }
        if (dynamicContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dynamicContext", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "<init>"));
        }
        if (aliasingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasingContext", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "<init>"));
        }
        this.expressionToTempConstVariableCache = new HashMap<JsExpression, TemporaryConstVariable>();
        this.parent = parent;
        this.dynamicContext = dynamicContext;
        this.staticContext = staticContext;
        this.aliasingContext = aliasingContext;
        this.usageTracker = usageTracker;
        this.definitionPlace = definitionPlace;
    }

    @Nullable
    public UsageTracker usageTracker() {
        return this.usageTracker;
    }

    @NotNull
    public DynamicContext dynamicContext() {
        DynamicContext dynamicContext = this.dynamicContext;
        if (dynamicContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "dynamicContext"));
        }
        return dynamicContext;
    }

    @NotNull
    public TranslationContext contextWithScope(@NotNull JsFunction fun) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "contextWithScope"));
        }
        TranslationContext translationContext = this.newFunctionBody(fun, this.aliasingContext);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "contextWithScope"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext newFunctionBody(@NotNull JsFunction fun, @Nullable AliasingContext aliasingContext) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "newFunctionBody"));
        }
        DynamicContext dynamicContext = DynamicContext.newContext(fun.getScope(), fun.getBody());
        if (aliasingContext == null) {
            aliasingContext = this.aliasingContext.inner();
        }
        TranslationContext translationContext = new TranslationContext(this, this.staticContext, dynamicContext, aliasingContext, this.usageTracker, null);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "newFunctionBody"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext newFunctionBodyWithUsageTracker(@NotNull JsFunction fun, @NotNull MemberDescriptor descriptor2) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "newFunctionBodyWithUsageTracker"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "newFunctionBodyWithUsageTracker"));
        }
        DynamicContext dynamicContext = DynamicContext.newContext(fun.getScope(), fun.getBody());
        UsageTracker usageTracker = new UsageTracker(this.usageTracker, descriptor2, fun.getScope());
        TranslationContext translationContext = new TranslationContext(this, this.staticContext, dynamicContext, this.aliasingContext.inner(), usageTracker, this.definitionPlace);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "newFunctionBodyWithUsageTracker"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerBlock(@NotNull JsBlock block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerBlock"));
        }
        TranslationContext translationContext = new TranslationContext(this, this.staticContext, this.dynamicContext.innerBlock(block), this.aliasingContext, this.usageTracker, null);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerBlock"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerBlock() {
        TranslationContext translationContext = this.innerBlock(new JsBlock());
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerBlock"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext newDeclaration(@NotNull DeclarationDescriptor descriptor2, @Nullable DefinitionPlace place) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "newDeclaration"));
        }
        DynamicContext dynamicContext = DynamicContext.newContext(this.getScopeForDescriptor(descriptor2), this.getBlockForDescriptor(descriptor2));
        TranslationContext translationContext = new TranslationContext(this, this.staticContext, dynamicContext, this.aliasingContext, this.usageTracker, place);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "newDeclaration"));
        }
        return translationContext;
    }

    @NotNull
    private TranslationContext innerWithAliasingContext(AliasingContext aliasingContext) {
        TranslationContext translationContext = new TranslationContext(this, this.staticContext, this.dynamicContext, aliasingContext, this.usageTracker, null);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerWithAliasingContext"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerContextWithAliased(@NotNull DeclarationDescriptor correspondingDescriptor, @NotNull JsExpression alias) {
        if (correspondingDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "correspondingDescriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerContextWithAliased"));
        }
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerContextWithAliased"));
        }
        TranslationContext translationContext = this.innerWithAliasingContext(this.aliasingContext.inner(correspondingDescriptor, alias));
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerContextWithAliased"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerContextWithAliasesForExpressions(@NotNull Map<JetExpression, JsExpression> aliases) {
        if (aliases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliases", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerContextWithAliasesForExpressions"));
        }
        TranslationContext translationContext = this.innerWithAliasingContext(this.aliasingContext.withExpressionsAliased(aliases));
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerContextWithAliasesForExpressions"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerContextWithDescriptorsAliased(@NotNull Map<DeclarationDescriptor, JsExpression> aliases) {
        if (aliases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliases", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerContextWithDescriptorsAliased"));
        }
        TranslationContext translationContext = this.innerWithAliasingContext(this.aliasingContext.withDescriptorsAliased(aliases));
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerContextWithDescriptorsAliased"));
        }
        return translationContext;
    }

    @NotNull
    public JsBlock getBlockForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getBlockForDescriptor"));
        }
        if (descriptor2 instanceof CallableDescriptor) {
            JsBlock jsBlock = this.getFunctionObject((CallableDescriptor)descriptor2).getBody();
            if (jsBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getBlockForDescriptor"));
            }
            return jsBlock;
        }
        JsBlock jsBlock = new JsBlock();
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getBlockForDescriptor"));
        }
        return jsBlock;
    }

    @NotNull
    public BindingContext bindingContext() {
        BindingContext bindingContext = this.staticContext.getBindingContext();
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "bindingContext"));
        }
        return bindingContext;
    }

    @NotNull
    public BindingTrace bindingTrace() {
        BindingTrace bindingTrace = this.staticContext.getBindingTrace();
        if (bindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "bindingTrace"));
        }
        return bindingTrace;
    }

    @NotNull
    public JsScope getScopeForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getScopeForDescriptor"));
        }
        JsScope jsScope = this.staticContext.getScopeForDescriptor(descriptor2);
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getScopeForDescriptor"));
        }
        return jsScope;
    }

    @NotNull
    public JsName getNameForElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getNameForElement"));
        }
        DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForElement(this.bindingContext(), element);
        JsName jsName = this.getNameForDescriptor(descriptor2);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getNameForElement"));
        }
        return jsName;
    }

    @NotNull
    public JsName getNameForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getNameForDescriptor"));
        }
        JsName jsName = this.staticContext.getNameForDescriptor(descriptor2);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getNameForDescriptor"));
        }
        return jsName;
    }

    @NotNull
    public JsName getNameForPackage(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getNameForPackage"));
        }
        JsName jsName = this.staticContext.getNameForPackage(fqName2);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getNameForPackage"));
        }
        return jsName;
    }

    @NotNull
    public JsName declarePropertyOrPropertyAccessorName(@NotNull DeclarationDescriptor descriptor2, @NotNull String name, boolean fresh) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "declarePropertyOrPropertyAccessorName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "declarePropertyOrPropertyAccessorName"));
        }
        JsName jsName = this.staticContext.declarePropertyOrPropertyAccessorName(descriptor2, name, fresh);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "declarePropertyOrPropertyAccessorName"));
        }
        return jsName;
    }

    @NotNull
    public JsNameRef getQualifiedReference(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getQualifiedReference"));
        }
        JsNameRef jsNameRef = this.staticContext.getQualifiedReference(descriptor2);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getQualifiedReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsNameRef getQualifiedReference(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getQualifiedReference"));
        }
        JsNameRef jsNameRef = this.staticContext.getQualifiedReference(packageFqName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getQualifiedReference"));
        }
        return jsNameRef;
    }

    @Nullable
    public JsExpression getQualifierForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getQualifierForDescriptor"));
        }
        return this.staticContext.getQualifierForDescriptor(descriptor2);
    }

    @NotNull
    public TemporaryVariable declareTemporary(@Nullable JsExpression initExpression) {
        TemporaryVariable temporaryVariable = this.dynamicContext.declareTemporary(initExpression);
        if (temporaryVariable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "declareTemporary"));
        }
        return temporaryVariable;
    }

    @NotNull
    public TemporaryConstVariable getOrDeclareTemporaryConstVariable(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getOrDeclareTemporaryConstVariable"));
        }
        TemporaryConstVariable tempVar = this.expressionToTempConstVariableCache.get(expression);
        if (tempVar == null) {
            TemporaryVariable tmpVar = this.declareTemporary(expression);
            tempVar = new TemporaryConstVariable(tmpVar.name(), tmpVar.assignmentExpression());
            this.expressionToTempConstVariableCache.put(expression, tempVar);
            this.expressionToTempConstVariableCache.put(tmpVar.assignmentExpression(), tempVar);
        }
        TemporaryConstVariable temporaryConstVariable = tempVar;
        if (temporaryConstVariable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getOrDeclareTemporaryConstVariable"));
        }
        return temporaryConstVariable;
    }

    public void associateExpressionToLazyValue(JsExpression expression, TemporaryConstVariable temporaryConstVariable) {
        assert (expression == temporaryConstVariable.assignmentExpression());
        this.expressionToTempConstVariableCache.put(expression, temporaryConstVariable);
    }

    @NotNull
    public Namer namer() {
        Namer namer = this.staticContext.getNamer();
        if (namer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "namer"));
        }
        return namer;
    }

    @NotNull
    public Intrinsics intrinsics() {
        Intrinsics intrinsics = this.staticContext.getIntrinsics();
        if (intrinsics == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "intrinsics"));
        }
        return intrinsics;
    }

    @NotNull
    public ReflectionTypes getReflectionTypes() {
        ReflectionTypes reflectionTypes = this.staticContext.getReflectionTypes();
        if (reflectionTypes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getReflectionTypes"));
        }
        return reflectionTypes;
    }

    @NotNull
    public JsProgram program() {
        JsProgram jsProgram = this.staticContext.getProgram();
        if (jsProgram == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "program"));
        }
        return jsProgram;
    }

    @NotNull
    public Config getConfig() {
        Config config = this.staticContext.getConfig();
        if (config == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getConfig"));
        }
        return config;
    }

    @NotNull
    public JsScope scope() {
        JsScope jsScope = this.dynamicContext.getScope();
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "scope"));
        }
        return jsScope;
    }

    @NotNull
    public AliasingContext aliasingContext() {
        AliasingContext aliasingContext = this.aliasingContext;
        if (aliasingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "aliasingContext"));
        }
        return aliasingContext;
    }

    @NotNull
    public JsFunction getFunctionObject(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getFunctionObject"));
        }
        JsFunction jsFunction = this.staticContext.getFunctionWithScope(descriptor2);
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getFunctionObject"));
        }
        return jsFunction;
    }

    public void addStatementToCurrentBlock(@NotNull JsStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "addStatementToCurrentBlock"));
        }
        this.dynamicContext.jsBlock().getStatements().add(statement);
    }

    public void addStatementsToCurrentBlockFrom(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "addStatementsToCurrentBlockFrom"));
        }
        this.addStatementsToCurrentBlockFrom(context.dynamicContext().jsBlock());
    }

    public void addStatementsToCurrentBlockFrom(@NotNull JsBlock block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "addStatementsToCurrentBlockFrom"));
        }
        this.dynamicContext.jsBlock().getStatements().addAll(block.getStatements());
    }

    public boolean currentBlockIsEmpty() {
        return this.dynamicContext.jsBlock().isEmpty();
    }

    public void moveVarsFrom(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "moveVarsFrom"));
        }
        this.dynamicContext.moveVarsFrom(context.dynamicContext());
    }

    @NotNull
    public JsBlock getCurrentBlock() {
        JsBlock jsBlock = this.dynamicContext.jsBlock();
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getCurrentBlock"));
        }
        return jsBlock;
    }

    @NotNull
    public JsExpression getEmptyExpression() {
        JsExpression jsExpression = this.program().getEmptyExpression();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getEmptyExpression"));
        }
        return jsExpression;
    }

    @Nullable
    public JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getAliasForDescriptor"));
        }
        JsNameRef nameRef = this.captureIfNeedAndGetCapturedName(descriptor2);
        if (nameRef != null) {
            return nameRef;
        }
        return this.aliasingContext.getAliasForDescriptor(descriptor2);
    }

    @NotNull
    public JsExpression getDispatchReceiver(@NotNull ReceiverParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getDispatchReceiver"));
        }
        JsExpression alias = this.getAliasForDescriptor(descriptor2);
        JsExpression jsExpression = alias == null ? JsLiteral.THIS : alias;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getDispatchReceiver"));
        }
        return jsExpression;
    }

    @NotNull
    private DefinitionPlace getDefinitionPlace() {
        if (this.definitionPlace != null) {
            DefinitionPlace definitionPlace = this.definitionPlace;
            if (definitionPlace == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getDefinitionPlace"));
            }
            return definitionPlace;
        }
        if (this.parent != null) {
            DefinitionPlace definitionPlace = this.parent.getDefinitionPlace();
            if (definitionPlace == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getDefinitionPlace"));
            }
            return definitionPlace;
        }
        throw new AssertionError((Object)"Can not find definition place from rootContext(definitionPlace and parent is null)");
    }

    @NotNull
    public JsNameRef define(DeclarationDescriptor descriptor2, JsExpression expression) {
        String suggestedName = TranslationUtils.getSuggestedNameForInnerDeclaration(this, descriptor2);
        JsNameRef jsNameRef = this.getDefinitionPlace().define(suggestedName, expression);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "define"));
        }
        return jsNameRef;
    }

    @Nullable
    private JsNameRef captureIfNeedAndGetCapturedName(DeclarationDescriptor descriptor2) {
        if (this.usageTracker != null) {
            this.usageTracker.used(descriptor2);
            JsName name = UsageTrackerKt.getNameForCapturedDescriptor(this.usageTracker, descriptor2);
            if (name != null) {
                return name.makeRef();
            }
        }
        return null;
    }
}

