/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.operation;

import gnu.trove.THashMap;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.CompareToBOIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.EqualsBOIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.LongCompareToBOIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.NO_INTRINSIC;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.lexer.JetToken;
import org.jetbrains.kotlin.psi.JetBinaryExpression;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"9\b)I\")\u001b8bef|\u0005/\u001a:bi&|g.\u00138ue&t7/[2t\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'B\u00016t\u0015%!(/\u00198tY\u0006$XMC\u0005j]R\u0014\u0018N\\:jG*Iq\u000e]3sCRLwN\u001c\u0006\u0004\u0003:L(B\u0002\u001fj]&$hHC\u0005gC\u000e$xN]5fg*!A*[:u\u0015}\u0011\u0015N\\1ss>\u0003XM]1uS>t\u0017J\u001c;sS:\u001c\u0018n\u0019$bGR|'/\u001f\u0006\u0005U\u00064\u0018M\u0003\u0003vi&d'BD5oiJLgn]5d\u0007\u0006\u001c\u0007.\u001a\u0006\t)\"\u000b7\u000f['ba*\u0019qM\\;\u000b\u000bQ\u0014xN^3\u000b\tA\u000b\u0017N\u001d\u0006\t\u0015\u0016$Hk\\6f]*)A.\u001a=fe*\u0011b)\u001e8di&|g\u000eR3tGJL\u0007\u000f^8s\u0015-!Wm]2sSB$xN]:\u000b1\tKg.\u0019:z\u001fB,'/\u0019;j_:Le\u000e\u001e:j]NL7M\u0003\rd_6\u0004X\u000f^3B]\u0012\u001c\u0015m\u00195f\u0013:$(/\u001b8tS\u000eTQ\u0001^8lK:T!\u0002Z3tGJL\u0007\u000f^8s\u0015A\u0019w.\u001c9vi\u0016Le\u000e\u001e:j]NL7M\u0003\u0007hKRLe\u000e\u001e:j]NL7M\u0003\u0006fqB\u0014Xm]:j_:T1CS3u\u0005&t\u0017M]=FqB\u0014Xm]:j_:T1\u0001]:j\u0015\u001d\u0019wN\u001c;fqRT!\u0003\u0016:b]Nd\u0017\r^5p]\u000e{g\u000e^3yi*YAn\\8l+B\u001c\u0015m\u00195f5\bQ!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015QA\u0001\u0003\u0003\u0011\r)!\u0001\"\u0002\t\b\u0015\u0019Aa\u0001\u0005\u0001\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u0011!\u0001\u0002\u0002\u0007\u0001\u000b\r!A\u0001c\u0003\r\u0001\u0015\u0019Aa\u0001\u0005\u0007\u0019\u0001)\u0011\u0001#\u0004\u0006\u0005\u00111\u0001bB\u0003\u0003\t\u001bAY!B\u0001\t\u0012\u0015\u0011Aq\u0002\u0005\n\u000b\r!\u0001\u0002\u0003\u0005\r\u0001\u0015\u0019A\u0001\u0002E\n\u0019\u0001)!\u0001B\u0001\t\u0016\u0015\u0019A1\u0003\u0005\u000b\u0019\u0001)!\u0001B\u0001\t\u0018\u0015\u0019AQ\u0003\u0005\f\u0019\u0001)1\u0001B\u0002\t\u00191\u0001QA\u0001\u0003\t\u0011!)!\u0001B\u0002\t\u0019\u0015\u0011A1\u0003\u0005\u000b\u000b\t!)\u0002C\u0006\u0006\u0005\u0011\t\u0001\u0002E\u0003\u0004\t9Ay\u0002\u0004\u0001\u0006\u0005\u0011\u0011\u0001\u0012E\u0003\u0004\t=A\u0011\u0003\u0004\u0001\u0006\u0005\u0011q\u0001rD\u0003\u0003\t=A\u0011\u0003B\u0002\r\be\u0019Q!\u0001E\u00051\u0013i\u0013\u0003B1\u00051\u0015\t\u0003\"B\u0001\t\u000b%!\u0011bA\u0003\u0002\u0011\u0017AZ\u0001G\u0003V\u0007\u0011)1\u0001B\u0003\n\u0003!9Q\u0006\t\u0003b\ta=\u0011eF\u0003\u0002\u0011#Ia\"C\u0007\u0006\u0003!I\u0011\u0002B\u0005\u0004\u000b\u0005A!\u0002\u0007\u0006\n\t%\u0019Q!\u0001\u0005\f1-A\u0012\"\u0003\u0003\n\u0007\u0015\t\u0001r\u0003M\f1#)6\u0001B\u0003\u0004\t\u001fI\u0011\u0001\u0003\u0007.@\u0011\t\u0001\u0014DO\b\t\u0001AQ\"D\u0002\u0006\u0003!Q\u0001D\u0003)\u0004\u0001u=A\u0001\u0001E\u000e\u001b\r)\u0011\u0001C\u0006\u0019\u0017A\u001b\t!I\u0002\u0006\u0003!]\u0001tC)\u0004\u000f\u0011e\u0011\"\u0001E\r\u001b\u0005AQ\"D\u0001\t\u001c5~B!\u0001\r\u000f;\u001f!\u0001\u0001C\u0007\u000e\u0007\u0015\t\u0001B\u0003\r\u000b!\u000e\u0001Qt\u0002\u0003\u0001\u00117i1!B\u0001\t\u0017aY\u0001k!\u0001\"\u0007\u0015\t\u0001r\u0003M\f#\u000e9AAD\u0005\u0002\u00113i\u0011\u0001C\u0007\u000e\u0003!mQv\b\u0003\u00041;iz\u0001\u0002\u0001\t\u001f5\u0019Q!\u0001E\u000f1;\u00016\u0001AO\b\t\u0001A\t#D\u0002\u0006\u0003!}\u0001t\u0004)\u0004\u0002\u0005\u001aQ!\u0001E\f1/\t6a\u0002C\u000f\u0013\u0005AI\"D\u0001\t!5\t\u0001\u0012EW!\t\u0005A\u001a#h\u0004\u0005\u0001!iQbA\u0003\u0002\u0011)A\"\u0002U\u0002\u0001;\u001f!\u0001\u0001c\u0007\u000e\u0007\u0015\t\u0001b\u0003\r\f!\u000e\u0005\u0011\u0005B\u0003\u0002\u0011/a\t\u0001g\u0006R\u0007\u001d!\u0019#C\u0001\t\u001a5\t\u0001\"D\u0007\u0002\u00117)D\"B\u0006\u0005G\u0004AJ!I\u0002\u0006\u0003!\u001d\u0001tA)\u0004\u0007\u0011%\u0011\"\u0001\u0003\u0001"})
public final class BinaryOperationIntrinsics {
    public static final /* synthetic */ KClass $kotlinClass;
    private final THashMap<Pair<? extends JetToken, ? extends FunctionDescriptor>, BinaryOperationIntrinsic> intrinsicCache = new THashMap();
    private final List<? extends BinaryOperationIntrinsicFactory> factories = KotlinPackage.listOf(LongCompareToBOIF.INSTANCE$, EqualsBOIF.INSTANCE$, CompareToBOIF.INSTANCE$);

    static {
        $kotlinClass = Reflection.createKotlinClass(BinaryOperationIntrinsics.class);
    }

    @NotNull
    public final BinaryOperationIntrinsic getIntrinsic(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JetToken token = PsiUtils.getOperationToken(expression);
        CallableDescriptor descriptor2 = BindingUtils.getCallableDescriptorForOperationExpression(context.bindingContext(), expression);
        if (descriptor2 == null || !(descriptor2 instanceof FunctionDescriptor)) {
            return NO_INTRINSIC.INSTANCE$;
        }
        JetToken jetToken = token;
        Intrinsics.checkExpressionValueIsNotNull(jetToken, "token");
        BinaryOperationIntrinsic binaryOperationIntrinsic = this.lookUpCache(jetToken, (FunctionDescriptor)descriptor2);
        if (binaryOperationIntrinsic == null) {
            JetToken jetToken2 = token;
            Intrinsics.checkExpressionValueIsNotNull(jetToken2, "token");
            binaryOperationIntrinsic = this.computeAndCacheIntrinsic(jetToken2, (FunctionDescriptor)descriptor2);
        }
        return binaryOperationIntrinsic;
    }

    private final BinaryOperationIntrinsic lookUpCache(JetToken token, FunctionDescriptor descriptor2) {
        return this.intrinsicCache.get(new Pair<JetToken, FunctionDescriptor>(token, descriptor2));
    }

    private final BinaryOperationIntrinsic computeAndCacheIntrinsic(JetToken token, FunctionDescriptor descriptor2) {
        BinaryOperationIntrinsic result2 = this.computeIntrinsic(token, descriptor2);
        this.intrinsicCache.put(new Pair<JetToken, FunctionDescriptor>(token, descriptor2), result2);
        return result2;
    }

    private final BinaryOperationIntrinsic computeIntrinsic(JetToken token, FunctionDescriptor descriptor2) {
        for (BinaryOperationIntrinsicFactory binaryOperationIntrinsicFactory : this.factories) {
            BinaryOperationIntrinsic intrinsic;
            if (!binaryOperationIntrinsicFactory.getSupportTokens().contains(token) || (intrinsic = binaryOperationIntrinsicFactory.getIntrinsic(descriptor2)) == null) continue;
            return intrinsic;
        }
        return NO_INTRINSIC.INSTANCE$;
    }
}

