/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.LazyFileScope;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"d\n)\u0019B)Z2mCJ\fG/[8o%\u0016\u001cx\u000e\u001c<fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0004sKN|GN^3\u000b\u0007\u0005s\u0017P\u0003\u0004=S:LGO\u0010\u0006\u0013C:tw\u000e^1uS>t'+Z:pYZ,'O\u0003\nB]:|G/\u0019;j_:\u0014Vm]8mm\u0016\u0014(\"\u0002;sC\u000e,'\u0002\u0004\"j]\u0012Lgn\u001a+sC\u000e,'bE2iK\u000e\\'+\u001a3fG2\f'/\u0019;j_:\u001c(\"A2\u000b-Q{\u0007\u000fR8x]\u0006s\u0017\r\\=tSN\u001cuN\u001c;fqRTA!\u00168ji*i2\r[3dWJ+G-Z2mCJ\fG/[8og&s\u0007+Y2lC\u001e,7O\u0003\u000eu_BdUM^3m\t\u0016\u001c8M]5qi>\u0014\bK]8wS\u0012,'O\u0003\u000eU_BdUM^3m\t\u0016\u001c8M]5qi>\u0014\bK]8wS\u0012,'O\u0003\u0003mCjL(b\u0004;pa2+g/\u001a7Gc:\u000bW.Z:\u000b\u00115+H\u000e^5nCBT1aY8n\u0015\u00199wn\\4mK*11m\\7n_:TqaY8mY\u0016\u001cGO\u0003\u0004Gc:\u000bW.\u001a\u0006\u0005]\u0006lWM\u0003\u0006KKR,E.Z7f]RT1\u0001]:j\u0015y9W\r\u001e+pa2+g/\u001a7EKN\u001c'/\u001b9u_J\u001c()\u001f$r\u001d\u0006lWM\u0003\u0004gc:\u000bW.\u001a\u0006\tY>\u001c\u0017\r^5p]*qAj\\8lkBdunY1uS>t'bC5oGJ,W.\u001a8uC2T!bY8na>tWM\u001c;t\u0015\r\u0019V\r\u001e\u0006\u0016\t\u0016\u001cG.\u0019:bi&|g\u000eR3tGJL\u0007\u000f^8s\u0015-!Wm]2sSB$xN]:\u000b\t)\fg/\u0019\u0006\u0005kRLGN\u0003\u000bsKB|'\u000f\u001e*fI\u0016\u001cG.\u0019:bi&|gn\u001d\u0006\u000eI\u0016\u001c8M]5qi>\u0014X*\u00199\u000b\t9\u000bW.\u001a\u0006\u001ae\u0016\u001cx\u000e\u001c<f\u0003:tw\u000e^1uS>t7o\u00148GS2,7OC\u0007tG>\u0004X\r\u0015:pm&$WM\u001d\u0006\u0012\r&dWmU2pa\u0016\u0004&o\u001c<jI\u0016\u0014HR\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\r!\u0019\u0001\u0003\u0001\r\u0001\u0015\t\u00012A\u0003\u0004\t\u000bA)\u0001\u0004\u0001\u0006\u0007\u0011\r\u0001\u0002\u0002\u0007\u0001\u000b\r!\u0019\u0001C\u0003\r\u0001\u0015\u0011A1\u0001\u0005\u0005\u000b\t!\u0019\u0001C\u0003\u0006\u0007\u0011\r\u0001R\u0002\u0007\u0001\u000b\r!)\u0001C\u0004\r\u0001\u0015\u0011A1\u0001E\u0007\u000b\t!\u0019\u0001C\u0005\u0006\u0007\u00119\u0001\u0012\u0003\u0007\u0001\u000b\u0005A)\"\u0002\u0002\u0005\u0011!YQA\u0001C\t\u0011/)!\u0001B\u0005\t\u0019\u0015\u0019A1\u0003\u0005\u000b\u0019\u0001)!\u0001B\u0001\t\u001b\u0015\u0019AQ\u0003E\r\u0019\u0001)!\u0001B\u0001\t\u001d\u0015\u0019Aq\u0003E\u000e\u0019\u0001)!\u0001B\u0004\t\u0012\u0015\u0011A1\u0003\u0005\u000b\u000b\t!\u0011\u0001#\t\u0006\u0005\u0011m\u0001\"E\u0003\u0004\t9A\u0001\u0003\u0004\u0001\u0006\u0007\u0011\u0015\u00012\u0005\u0007\u0001\u000b\t!\u0011\u0001#\n\u0006\u0007\u0011}\u0001B\u0005\u0007\u0001\u000b\u0005A1#\u0002\u0002\u0005\"!\u001dRA\u0001\u0003\u0012\u0011G)!\u0001\"\u0006\t\u001a\u0015\u0011AA\u0004\u0005\u0011\u000b\r!)\u0002C\u000b\r\u0001\u0015\u0019Aa\u0002E\u0017\u0019\u0001)!\u0001B\u0004\t.\u0011\u0019ABA\r\u0004\u000b\u0005A1\u0001G\u0002.\u0019\u0011\tG\u0001g\u0002\"\u0007\u0015\t\u0001r\u0001M\u0004+\u000e!Qa\u0001C\u0004\u0013\u0005AI!\f\u0007\u0005C\u0012AJ!I\u0002\u0006\u0003!!\u0001\u0004B+\u0004\t\u0015\u0019A\u0011B\u0005\u0002\u0011\u0015iS\u0003B\u0002\u0019\fu=A\u0001\u0001\u0005\u0007\u001b\r)\u0011\u0001c\u0003\u0019\fA\u001b\u0001!I\u0002\u0006\u0003!1\u0001DB)\u0004\u000b\u0011-\u0011\"\u0001\u0003\u0001\u001b\u0005Ai!l\u0015\u0005\u0007a=Qt\u0002\u0003\u0001\u0011!i1!B\u0001\t\u0010a=\u0001k\u0001\u0001\u001e$\u0011\u0001\u00012C\u0007\u000e\u000b\u0005A!\"\u0003\u0003\n\u0007\u0015\t\u0001b\u0003\r\f\u0013\u0011I1!B\u0001\t\u0019aa\u0001D\u0003)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u00071\u0019\t6a\u0002C\b\u0013\u0005!\u0001!D\u0001\t\u001a5\t\u0001\"D\u00170\t\u0005Aj\"h\u0004\u0005\u0001!AQbA\u0003\u0002\u0011\u001fAz\u0001U\u0002\u0001;\u001f!\u0001\u0001C\b\u000e\u0007\u0015\t\u0001b\u0003\r\f!\u000e\u0005Qt\u0002\u0003\u0001\u0011?i1!B\u0001\t\u001eau\u0001kA\u0001\"\u0011\u0015\t\u0001bD\u0005\u0005\u0013\r)\u0011\u0001\u0003\t\u0019!ay\u0011kA\u0005\u0005\u001e%\t\u00012E\u0007\u0002\u00113i\u0011\u0001\u0003\n\u000e\u0003!\u0015Rf\b\u0003\u00021Qi\u001a\u0003\u0002\u0001\t*5iQ!\u0001\u0005\u000b\u0013\u0011I1!B\u0001\t'a\u0019\u0012\u0002B\u0005\u0004\u000b\u0005A\u0001\u0003\u0007\t\u0019\u0015A\u001b\u0001!I\u0002\u0006\u0003!1\u0001DB)\u0004\u000b\u0011!\u0012\"\u0001\u0003\u0001\u001b\u0005AQ\"l\u0010\u0005\u0007a-Rt\u0002\u0003\u0001\u0011\u0019i1!B\u0001\t\fa-\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001BF\u0007\u0004\u000b\u0005A9\u0003g\nQ\u0007\u0003\t3!B\u0001\t\ra1\u0011kA\u0004\u0005,%\tA\u0001A\u0007\u0002\u0011\u001bi\u0011\u0001\u0003\u000b6C\u0015\u0001Ca9\u0001\u0019\u0007u=A\u0001\u0001E\u0004\u001b\r)\u0011\u0001c\u0002\u0019\bA\u001b\u0001!h\u0004\u0005\u0001!%QbA\u0003\u0002\u0011\u0011AB\u0001UB\u0001C\r)\u0011\u0001\u0003\u0002\u0019\u0005E\u001bq\u0001B\u0002\n\u0003\u0011\u0001Q\"\u0001E\u0005\u001b\u0005AQ\u0001"})
public final class DeclarationResolver {
    public static final /* synthetic */ KClass $kotlinClass;
    private final AnnotationResolver annotationResolver;
    private final BindingTrace trace;

    static {
        $kotlinClass = Reflection.createKotlinClass(DeclarationResolver.class);
    }

    public final void resolveAnnotationsOnFiles(@NotNull TopDownAnalysisContext c, @NotNull FileScopeProvider scopeProvider) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(scopeProvider, "scopeProvider");
        Map filesToScope2 = CollectionsKt.keysToMap((Iterable)c.getFiles(), (Function1)new Function1<JetFile, LazyFileScope>(scopeProvider){
            final /* synthetic */ FileScopeProvider $scopeProvider;

            @NotNull
            public final LazyFileScope invoke(JetFile it2) {
                JetFile jetFile = it2;
                Intrinsics.checkExpressionValueIsNotNull(jetFile, "it");
                return this.$scopeProvider.getFileScope(jetFile);
            }
            {
                this.$scopeProvider = fileScopeProvider;
                super(1);
            }
        });
        Iterator iterator2 = KotlinPackage.iterator(filesToScope2);
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            JetFile file = (JetFile)KotlinPackage.component1(entry);
            LazyFileScope fileScope = (LazyFileScope)KotlinPackage.component2(entry);
            this.annotationResolver.resolveAnnotationsWithArguments((LexicalScope)fileScope, file.getAnnotationEntries(), this.trace);
            this.annotationResolver.resolveAnnotationsWithArguments((LexicalScope)fileScope, file.getDanglingAnnotations(), this.trace);
        }
    }

    public final void checkRedeclarations(@NotNull TopDownAnalysisContext c) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        for (ClassDescriptorWithResolutionScopes classDescriptor : c.getDeclaredClasses().values()) {
            HashMultimap descriptorMap = HashMultimap.create();
            for (DeclarationDescriptor desc : classDescriptor.getUnsubstitutedMemberScope().getOwnDeclaredDescriptors()) {
                if (!(desc instanceof ClassDescriptor) && !(desc instanceof PropertyDescriptor)) continue;
                descriptorMap.put(desc.getName(), desc);
            }
            Multimap multimap = descriptorMap;
            Intrinsics.checkExpressionValueIsNotNull(multimap, "descriptorMap");
            this.reportRedeclarations(multimap);
        }
    }

    private final void reportRedeclarations(Multimap<Name, DeclarationDescriptor> descriptorMap) {
        HashSet<Pair<PsiElement, Name>> redeclarations = Sets.newHashSet();
        for (Name pair : descriptorMap.keySet()) {
            Collection<DeclarationDescriptor> descriptors = descriptorMap.get(pair);
            if (descriptors.size() <= 1) continue;
            for (DeclarationDescriptor descriptor2 : descriptors) {
                if (!(descriptor2 instanceof ClassDescriptor)) continue;
                for (DeclarationDescriptor descriptor22 : descriptors) {
                    if (descriptor2 == descriptor22) continue;
                    PsiElement psiElement = DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2);
                    if (psiElement == null) {
                        Intrinsics.throwNpe();
                    }
                    redeclarations.add(new Pair<PsiElement, Name>(psiElement, ((ClassDescriptor)descriptor2).getName()));
                    if (!(descriptor22 instanceof PropertyDescriptor)) continue;
                    PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(descriptor22);
                    if (psiElement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    redeclarations.add(new Pair<PsiElement, Name>(psiElement2, ((PropertyDescriptor)descriptor22).getName()));
                }
            }
        }
        for (Pair pair : redeclarations) {
            PsiElement first = (PsiElement)pair.component1();
            Name second = (Name)pair.component2();
            this.trace.report(Errors.REDECLARATION.on(first, second.asString()));
        }
    }

    public final void checkRedeclarationsInPackages(@NotNull TopLevelDescriptorProvider topLevelDescriptorProvider, @NotNull Multimap<FqName, JetElement> topLevelFqNames) {
        Intrinsics.checkParameterIsNotNull(topLevelDescriptorProvider, "topLevelDescriptorProvider");
        Intrinsics.checkParameterIsNotNull(topLevelFqNames, "topLevelFqNames");
        Iterator<Map.Entry<FqName, Collection<JetElement>>> iterator2 = KotlinPackage.iterator(topLevelFqNames.asMap());
        while (iterator2.hasNext()) {
            Map.Entry<FqName, Collection<JetElement>> entry = iterator2.next();
            FqName fqName2 = KotlinPackage.component1(entry);
            Collection<JetElement> declarationsOrPackageDirectives = KotlinPackage.component2(entry);
            if (fqName2.isRoot()) continue;
            FqName fqName3 = fqName2;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "fqName");
            Set<DeclarationDescriptor> descriptors = this.getTopLevelDescriptorsByFqName(topLevelDescriptorProvider, fqName3, NoLookupLocation.WHEN_CHECK_REDECLARATIONS);
            if (descriptors.size() <= 1) continue;
            for (JetElement declarationOrPackageDirective : declarationsOrPackageDirectives) {
                PsiElement reportAt = declarationOrPackageDirective instanceof JetPackageDirective ? ((JetPackageDirective)declarationOrPackageDirective).getNameIdentifier() : (PsiElement)declarationOrPackageDirective;
                this.trace.report(Errors.REDECLARATION.on(reportAt, fqName2.shortName().asString()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<DeclarationDescriptor> getTopLevelDescriptorsByFqName(TopLevelDescriptorProvider topLevelDescriptorProvider, FqName fqName2, LookupLocation location) {
        FqName parentFqName = fqName2.parent();
        HashSet<ClassDescriptor> descriptors = new HashSet<ClassDescriptor>();
        FqName fqName3 = parentFqName;
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "parentFqName");
        LazyPackageDescriptor parentFragment = topLevelDescriptorProvider.getPackageFragment(fqName3);
        if (parentFragment != null) {
            void destination;
            void $receiver;
            void $receiver2;
            JetScope jetScope = parentFragment.getMemberScope();
            Name name = fqName2.shortName();
            Intrinsics.checkExpressionValueIsNotNull(name, "fqName.shortName()");
            Iterable iterable = jetScope.getProperties(name, location);
            HashSet<ClassDescriptor> hashSet = descriptors;
            void var8_9 = $receiver2;
            Collection collection = new ArrayList();
            for (Object element : $receiver) {
                VariableDescriptor it2 = (VariableDescriptor)element;
                if (!(it2.getExtensionReceiverParameter() == null)) continue;
                destination.add(element);
            }
            List list = (List)destination;
            hashSet.addAll(list);
        }
        CollectionsKt.addIfNotNull((Collection)descriptors, topLevelDescriptorProvider.getPackageFragment(fqName2));
        descriptors.addAll(topLevelDescriptorProvider.getTopLevelClassDescriptors(fqName2, location));
        return descriptors;
    }

    public DeclarationResolver(@NotNull AnnotationResolver annotationResolver, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(annotationResolver, "annotationResolver");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.annotationResolver = annotationResolver;
        this.trace = trace;
    }
}

