/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.EqualityPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorEquivalenceForOverrides;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilPackage;
import org.jetbrains.kotlin.resolve.dataClassUtils.DataClassUtilsPackage;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.IndexedParametersSubstitution;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.utils.HashSetUtil;

public class OverrideResolver {
    @NotNull
    private final BindingTrace trace;

    public OverrideResolver(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/OverrideResolver", "<init>"));
        }
        this.trace = trace;
    }

    public void check(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/OverrideResolver", "check"));
        }
        this.checkVisibility(c);
        this.checkOverrides(c);
        this.checkParameterOverridesForAllClasses(c);
    }

    public static void generateOverridesInAClass(@NotNull ClassDescriptor classDescriptor, @NotNull Collection<CallableMemberDescriptor> membersFromCurrent, @NotNull OverridingUtil.DescriptorSink sink) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "generateOverridesInAClass"));
        }
        if (membersFromCurrent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersFromCurrent", "org/jetbrains/kotlin/resolve/OverrideResolver", "generateOverridesInAClass"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/kotlin/resolve/OverrideResolver", "generateOverridesInAClass"));
        }
        List<CallableMemberDescriptor> membersFromSupertypes = OverrideResolver.getCallableMembersFromSupertypes(classDescriptor);
        MultiMap<Name, CallableMemberDescriptor> membersFromCurrentByName = OverrideResolver.groupDescriptorsByName(membersFromCurrent);
        MultiMap<Name, CallableMemberDescriptor> membersFromSupertypesByName = OverrideResolver.groupDescriptorsByName(membersFromSupertypes);
        LinkedHashSet<Name> memberNames = new LinkedHashSet<Name>();
        memberNames.addAll(membersFromSupertypesByName.keySet());
        memberNames.addAll(membersFromCurrentByName.keySet());
        for (Name memberName : memberNames) {
            Collection<CallableMemberDescriptor> fromSupertypes = membersFromSupertypesByName.get(memberName);
            Collection<CallableMemberDescriptor> fromCurrent = membersFromCurrentByName.get(memberName);
            OverridingUtil.generateOverridesInFunctionGroup(memberName, fromSupertypes, fromCurrent, classDescriptor, sink);
        }
    }

    public static void resolveUnknownVisibilities(@NotNull Collection<? extends CallableMemberDescriptor> descriptors, @NotNull BindingTrace trace) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/resolve/OverrideResolver", "resolveUnknownVisibilities"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/OverrideResolver", "resolveUnknownVisibilities"));
        }
        for (CallableMemberDescriptor callableMemberDescriptor : descriptors) {
            OverridingUtil.resolveUnknownVisibilityForMember(callableMemberDescriptor, OverrideResolver.createCannotInferVisibilityReporter(trace));
        }
    }

    @NotNull
    public static Function1<CallableMemberDescriptor, Unit> createCannotInferVisibilityReporter(final @NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/OverrideResolver", "createCannotInferVisibilityReporter"));
        }
        Function1<CallableMemberDescriptor, Unit> function1 = new Function1<CallableMemberDescriptor, Unit>(){

            @Override
            public Unit invoke(@NotNull CallableMemberDescriptor descriptor2) {
                if (descriptor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/OverrideResolver$1", "invoke"));
                }
                MemberDescriptor reportOn = descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE || descriptor2.getKind() == CallableMemberDescriptor.Kind.DELEGATION ? DescriptorUtils.getParentOfType(descriptor2, ClassDescriptor.class) : (descriptor2 instanceof PropertyAccessorDescriptor && ((PropertyAccessorDescriptor)descriptor2).isDefault() ? ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty() : descriptor2);
                PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(reportOn);
                if (element instanceof JetDeclaration) {
                    trace.report(Errors.CANNOT_INFER_VISIBILITY.on((JetDeclaration)element, descriptor2));
                }
                return Unit.INSTANCE$;
            }
        };
        if (function1 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "createCannotInferVisibilityReporter"));
        }
        return function1;
    }

    @NotNull
    public static <D extends CallableDescriptor> Set<D> filterOutOverridden(@NotNull Set<D> candidateSet) {
        if (candidateSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateSet", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOutOverridden"));
        }
        Set<D> set = OverrideResolver.filterOverrides(candidateSet, Function.ID, Filtering.RETAIN_OVERRIDING);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOutOverridden"));
        }
        return set;
    }

    @NotNull
    public static <D> Set<D> filterOutOverriding(@NotNull Set<D> candidateSet) {
        if (candidateSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateSet", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOutOverriding"));
        }
        Set<D> set = OverrideResolver.filterOverrides(candidateSet, Function.ID, Filtering.RETAIN_OVERRIDDEN);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOutOverriding"));
        }
        return set;
    }

    @NotNull
    public static <D> Set<D> filterOutOverridden(@NotNull Set<D> candidateSet, @NotNull Function<? super D, ? extends CallableDescriptor> transform) {
        if (candidateSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateSet", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOutOverridden"));
        }
        if (transform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transform", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOutOverridden"));
        }
        Set<? super D> set = OverrideResolver.filterOverrides(candidateSet, transform, Filtering.RETAIN_OVERRIDING);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOutOverridden"));
        }
        return set;
    }

    @NotNull
    private static <D> Set<D> filterOverrides(@NotNull Set<D> candidateSet, final @NotNull Function<? super D, ? extends CallableDescriptor> transform, @NotNull Filtering filtering) {
        if (candidateSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateSet", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOverrides"));
        }
        if (transform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transform", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOverrides"));
        }
        if (filtering == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filtering", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOverrides"));
        }
        if (candidateSet.size() <= 1) {
            Set<D> set = candidateSet;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOverrides"));
            }
            return set;
        }
        Set<D> noDuplicates = HashSetUtil.linkedHashSet(candidateSet, new EqualityPolicy<D>(){

            @Override
            public int getHashCode(D d) {
                return DescriptorUtils.getFqName(((CallableDescriptor)transform.fun(d)).getContainingDeclaration()).hashCode();
            }

            @Override
            public boolean isEqual(D d1, D d2) {
                CallableDescriptor f = (CallableDescriptor)transform.fun(d1);
                CallableDescriptor g = (CallableDescriptor)transform.fun(d2);
                return DescriptorEquivalenceForOverrides.INSTANCE$.areEquivalent(f.getOriginal(), g.getOriginal());
            }
        });
        LinkedHashSet<D> candidates = Sets.newLinkedHashSet();
        block0: for (D meD : noDuplicates) {
            CallableDescriptor other;
            CallableDescriptor me = transform.fun(meD);
            for (Object otherD : noDuplicates) {
                other = transform.fun(otherD);
                if (me == other) continue;
                if (filtering == Filtering.RETAIN_OVERRIDING) {
                    if (!OverrideResolver.overrides(other, me)) continue;
                    continue block0;
                }
                if (filtering == Filtering.RETAIN_OVERRIDDEN) {
                    if (!OverrideResolver.overrides(me, other)) continue;
                    continue block0;
                }
                throw new AssertionError((Object)("Unexpected Filtering object: " + (Object)((Object)filtering)));
            }
            for (Object otherD : candidates) {
                other = transform.fun(otherD);
                if (me.getOriginal() != other.getOriginal() || OverridingUtil.DEFAULT.isOverridableBy(other, me).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE || OverridingUtil.DEFAULT.isOverridableBy(me, other).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
                continue block0;
            }
            candidates.add(meD);
        }
        assert (!candidates.isEmpty()) : "All candidates filtered out from " + candidateSet;
        LinkedHashSet<D> linkedHashSet = candidates;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOverrides"));
        }
        return linkedHashSet;
    }

    public static <D extends CallableDescriptor> boolean overrides(@NotNull D f, @NotNull D g) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/resolve/OverrideResolver", "overrides"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "org/jetbrains/kotlin/resolve/OverrideResolver", "overrides"));
        }
        if (!f.equals(g) && DescriptorEquivalenceForOverrides.INSTANCE$.areEquivalent(f.getOriginal(), g.getOriginal())) {
            return true;
        }
        CallableDescriptor originalG = g.getOriginal();
        for (D overriddenFunction : DescriptorUtils.getAllOverriddenDescriptors(f)) {
            if (!DescriptorEquivalenceForOverrides.INSTANCE$.areEquivalent(originalG, overriddenFunction.getOriginal())) continue;
            return true;
        }
        return false;
    }

    private static <T extends DeclarationDescriptor> MultiMap<Name, T> groupDescriptorsByName(Collection<T> properties2) {
        LinkedMultiMap<Name, DeclarationDescriptor> r = new LinkedMultiMap<Name, DeclarationDescriptor>();
        for (DeclarationDescriptor property : properties2) {
            r.putValue(property.getName(), property);
        }
        return r;
    }

    private static List<CallableMemberDescriptor> getCallableMembersFromSupertypes(ClassDescriptor classDescriptor) {
        LinkedHashSet<CallableMemberDescriptor> r = Sets.newLinkedHashSet();
        for (JetType supertype : classDescriptor.getTypeConstructor().getSupertypes()) {
            r.addAll(OverrideResolver.getCallableMembersFromType(supertype));
        }
        return new ArrayList<CallableMemberDescriptor>(r);
    }

    private static List<CallableMemberDescriptor> getCallableMembersFromType(JetType type2) {
        ArrayList<CallableMemberDescriptor> r = Lists.newArrayList();
        for (DeclarationDescriptor decl : type2.getMemberScope().getAllDescriptors()) {
            if (!(decl instanceof PropertyDescriptor) && !(decl instanceof SimpleFunctionDescriptor)) continue;
            r.add((CallableMemberDescriptor)decl);
        }
        return r;
    }

    private void checkOverrides(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkOverrides"));
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            this.checkOverridesInAClass(entry.getValue(), entry.getKey());
        }
    }

    private void checkOverridesInAClass(@NotNull ClassDescriptorWithResolutionScopes classDescriptor, @NotNull JetClassOrObject klass) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkOverridesInAClass"));
        }
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkOverridesInAClass"));
        }
        for (CallableMemberDescriptor member : classDescriptor.getDeclaredCallableMembers()) {
            this.checkOverrideForMember(member);
        }
        LinkedHashSet<CallableMemberDescriptor> abstractNoImpl = Sets.newLinkedHashSet();
        LinkedHashSet<CallableMemberDescriptor> manyImpl = Sets.newLinkedHashSet();
        OverrideResolver.collectMissingImplementations(classDescriptor, abstractNoImpl, manyImpl);
        if (!manyImpl.isEmpty()) {
            this.trace.report(Errors.MANY_IMPL_MEMBER_NOT_IMPLEMENTED.on(klass, klass, (CallableMemberDescriptor)manyImpl.iterator().next()));
        }
        if (!DescriptorUtils.classCanHaveAbstractMembers(classDescriptor) && !abstractNoImpl.isEmpty()) {
            this.trace.report(Errors.ABSTRACT_MEMBER_NOT_IMPLEMENTED.on(klass, klass, (CallableMemberDescriptor)abstractNoImpl.iterator().next()));
        }
    }

    @NotNull
    public static Set<CallableMemberDescriptor> getMissingImplementations(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "getMissingImplementations"));
        }
        LinkedHashSet<CallableMemberDescriptor> result2 = new LinkedHashSet<CallableMemberDescriptor>();
        OverrideResolver.collectMissingImplementations(classDescriptor, result2, result2);
        LinkedHashSet<CallableMemberDescriptor> linkedHashSet = result2;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "getMissingImplementations"));
        }
        return linkedHashSet;
    }

    private static void collectMissingImplementations(@NotNull ClassDescriptor classDescriptor, @NotNull Set<CallableMemberDescriptor> abstractNoImpl, @NotNull Set<CallableMemberDescriptor> manyImpl) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (abstractNoImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abstractNoImpl", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (manyImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manyImpl", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        for (DeclarationDescriptor member : classDescriptor.getDefaultType().getMemberScope().getAllDescriptors()) {
            if (!(member instanceof CallableMemberDescriptor)) continue;
            OverrideResolver.collectMissingImplementations((CallableMemberDescriptor)member, abstractNoImpl, manyImpl);
        }
    }

    private static void collectMissingImplementations(@NotNull CallableMemberDescriptor descriptor2, @NotNull Set<CallableMemberDescriptor> abstractNoImpl, @NotNull Set<CallableMemberDescriptor> manyImpl) {
        List<CallableMemberDescriptor> allOverriddenDeclarations;
        Set<CallableMemberDescriptor> allFilteredOverriddenDeclarations;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (abstractNoImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abstractNoImpl", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (manyImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manyImpl", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (descriptor2.getKind().isReal()) {
            return;
        }
        if (descriptor2.getVisibility() == Visibilities.INVISIBLE_FAKE) {
            return;
        }
        Collection<? extends CallableMemberDescriptor> directOverridden = descriptor2.getOverriddenDescriptors();
        if (directOverridden.size() == 0) {
            throw new IllegalStateException("A 'fake override' must override something");
        }
        Map<CallableMemberDescriptor, Set<CallableMemberDescriptor>> overriddenDeclarationsByDirectParent = OverrideResolver.collectOverriddenDeclarations(directOverridden);
        Set<CallableMemberDescriptor> relevantDirectlyOverridden = OverrideResolver.getRelevantDirectlyOverridden(overriddenDeclarationsByDirectParent, allFilteredOverriddenDeclarations = OverrideResolver.filterOutOverridden(Sets.newLinkedHashSet(allOverriddenDeclarations = ContainerUtil.flatten(overriddenDeclarationsByDirectParent.values()))));
        List<CallableMemberDescriptor> implementations = OverrideResolver.collectImplementations(relevantDirectlyOverridden);
        if (implementations.size() == 1 && OverrideResolver.isReturnTypeOkForOverride(descriptor2, implementations.get(0))) {
            return;
        }
        ArrayList<CallableMemberDescriptor> abstractOverridden = new ArrayList<CallableMemberDescriptor>(allFilteredOverriddenDeclarations.size());
        ArrayList<CallableMemberDescriptor> concreteOverridden = new ArrayList<CallableMemberDescriptor>(allFilteredOverriddenDeclarations.size());
        OverrideResolver.filterNotSynthesizedDescriptorsByModality(allFilteredOverriddenDeclarations, abstractOverridden, concreteOverridden);
        if (implementations.isEmpty()) {
            abstractNoImpl.addAll(abstractOverridden);
        } else if (implementations.size() > 1) {
            manyImpl.addAll(concreteOverridden);
        } else {
            abstractNoImpl.addAll(OverrideResolver.collectAbstractMethodsWithMoreSpecificReturnType(abstractOverridden, implementations.get(0)));
        }
    }

    @NotNull
    private static List<CallableMemberDescriptor> collectImplementations(@NotNull Set<CallableMemberDescriptor> relevantDirectlyOverridden) {
        if (relevantDirectlyOverridden == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relevantDirectlyOverridden", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectImplementations"));
        }
        ArrayList<CallableMemberDescriptor> result2 = new ArrayList<CallableMemberDescriptor>(relevantDirectlyOverridden.size());
        for (CallableMemberDescriptor overriddenDescriptor : relevantDirectlyOverridden) {
            if (overriddenDescriptor.getModality() == Modality.ABSTRACT) continue;
            result2.add(overriddenDescriptor);
        }
        ArrayList<CallableMemberDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectImplementations"));
        }
        return arrayList;
    }

    private static void filterNotSynthesizedDescriptorsByModality(@NotNull Set<CallableMemberDescriptor> allOverriddenDeclarations, @NotNull List<CallableMemberDescriptor> abstractOverridden, @NotNull List<CallableMemberDescriptor> concreteOverridden) {
        if (allOverriddenDeclarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allOverriddenDeclarations", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterNotSynthesizedDescriptorsByModality"));
        }
        if (abstractOverridden == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abstractOverridden", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterNotSynthesizedDescriptorsByModality"));
        }
        if (concreteOverridden == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "concreteOverridden", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterNotSynthesizedDescriptorsByModality"));
        }
        for (CallableMemberDescriptor overridden : allOverriddenDeclarations) {
            if (CallResolverUtilPackage.isOrOverridesSynthesized(overridden)) continue;
            if (overridden.getModality() == Modality.ABSTRACT) {
                abstractOverridden.add(overridden);
                continue;
            }
            concreteOverridden.add(overridden);
        }
    }

    @NotNull
    private static List<CallableMemberDescriptor> collectAbstractMethodsWithMoreSpecificReturnType(@NotNull List<CallableMemberDescriptor> abstractOverridden, @NotNull CallableMemberDescriptor implementation) {
        if (abstractOverridden == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abstractOverridden", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectAbstractMethodsWithMoreSpecificReturnType"));
        }
        if (implementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementation", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectAbstractMethodsWithMoreSpecificReturnType"));
        }
        ArrayList<CallableMemberDescriptor> result2 = new ArrayList<CallableMemberDescriptor>(abstractOverridden.size());
        for (CallableMemberDescriptor abstractMember : abstractOverridden) {
            if (OverrideResolver.isReturnTypeOkForOverride(abstractMember, implementation)) continue;
            result2.add(abstractMember);
        }
        assert (!result2.isEmpty()) : "Implementation (" + implementation + ") doesn't have the most specific type, " + "but none of the other overridden methods does either: " + abstractOverridden;
        ArrayList<CallableMemberDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectAbstractMethodsWithMoreSpecificReturnType"));
        }
        return arrayList;
    }

    @NotNull
    private static Set<CallableMemberDescriptor> getRelevantDirectlyOverridden(@NotNull Map<CallableMemberDescriptor, Set<CallableMemberDescriptor>> overriddenByParent, @NotNull Set<CallableMemberDescriptor> allFilteredOverriddenDeclarations) {
        if (overriddenByParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overriddenByParent", "org/jetbrains/kotlin/resolve/OverrideResolver", "getRelevantDirectlyOverridden"));
        }
        if (allFilteredOverriddenDeclarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allFilteredOverriddenDeclarations", "org/jetbrains/kotlin/resolve/OverrideResolver", "getRelevantDirectlyOverridden"));
        }
        Iterator<Map.Entry<CallableMemberDescriptor, Set<CallableMemberDescriptor>>> iterator2 = overriddenByParent.entrySet().iterator();
        while (iterator2.hasNext()) {
            if (OverrideResolver.isRelevant(iterator2.next().getValue(), overriddenByParent.values(), allFilteredOverriddenDeclarations)) continue;
            iterator2.remove();
        }
        Set<CallableMemberDescriptor> set = overriddenByParent.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "getRelevantDirectlyOverridden"));
        }
        return set;
    }

    private static boolean isRelevant(@NotNull Set<CallableMemberDescriptor> declarationSet, @NotNull Collection<Set<CallableMemberDescriptor>> allDeclarationSets, @NotNull Set<CallableMemberDescriptor> allFilteredOverriddenDeclarations) {
        if (declarationSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationSet", "org/jetbrains/kotlin/resolve/OverrideResolver", "isRelevant"));
        }
        if (allDeclarationSets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allDeclarationSets", "org/jetbrains/kotlin/resolve/OverrideResolver", "isRelevant"));
        }
        if (allFilteredOverriddenDeclarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allFilteredOverriddenDeclarations", "org/jetbrains/kotlin/resolve/OverrideResolver", "isRelevant"));
        }
        for (Set<CallableMemberDescriptor> otherSet : allDeclarationSets) {
            if (otherSet == declarationSet) continue;
            if (otherSet.containsAll(declarationSet)) {
                return false;
            }
            if (!Collections.disjoint(allFilteredOverriddenDeclarations, declarationSet)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Map<CallableMemberDescriptor, Set<CallableMemberDescriptor>> collectOverriddenDeclarations(@NotNull Collection<? extends CallableMemberDescriptor> directOverriddenDescriptors) {
        if (directOverriddenDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directOverriddenDescriptors", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectOverriddenDeclarations"));
        }
        LinkedHashMap<CallableMemberDescriptor, Set<CallableMemberDescriptor>> overriddenDeclarationsByDirectParent = Maps.newLinkedHashMap();
        for (CallableMemberDescriptor callableMemberDescriptor : directOverriddenDescriptors) {
            Set<CallableMemberDescriptor> overriddenDeclarations = OverrideResolver.getOverriddenDeclarations(callableMemberDescriptor);
            Set<CallableMemberDescriptor> filteredOverrides = OverrideResolver.filterOutOverridden(overriddenDeclarations);
            overriddenDeclarationsByDirectParent.put(callableMemberDescriptor, new LinkedHashSet<CallableMemberDescriptor>(filteredOverrides));
        }
        LinkedHashMap<CallableMemberDescriptor, Set<CallableMemberDescriptor>> linkedHashMap = overriddenDeclarationsByDirectParent;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectOverriddenDeclarations"));
        }
        return linkedHashMap;
    }

    @NotNull
    public static Set<CallableMemberDescriptor> getOverriddenDeclarations(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "getOverriddenDeclarations"));
        }
        LinkedHashSet<CallableMemberDescriptor> result2 = new LinkedHashSet<CallableMemberDescriptor>();
        OverrideResolver.getOverriddenDeclarations(descriptor2, result2);
        LinkedHashSet<CallableMemberDescriptor> linkedHashSet = result2;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "getOverriddenDeclarations"));
        }
        return linkedHashSet;
    }

    private static void getOverriddenDeclarations(@NotNull CallableMemberDescriptor descriptor2, @NotNull Set<CallableMemberDescriptor> result2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "getOverriddenDeclarations"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/resolve/OverrideResolver", "getOverriddenDeclarations"));
        }
        if (descriptor2.getKind().isReal()) {
            result2.add(descriptor2);
        } else {
            if (descriptor2.getOverriddenDescriptors().isEmpty()) {
                throw new IllegalStateException("No overridden descriptors found for (fake override) " + descriptor2);
            }
            for (CallableMemberDescriptor callableMemberDescriptor : descriptor2.getOverriddenDescriptors()) {
                OverrideResolver.getOverriddenDeclarations(callableMemberDescriptor, result2);
            }
        }
    }

    private void checkOverrideForMember(final @NotNull CallableMemberDescriptor declared) {
        if (declared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declared", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkOverrideForMember"));
        }
        if (declared.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            if (DataClassUtilsPackage.isComponentLike(declared.getName())) {
                this.checkOverrideForComponentFunction(declared);
            }
            return;
        }
        if (declared.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            return;
        }
        final JetNamedDeclaration member = (JetNamedDeclaration)DescriptorToSourceUtils.descriptorToDeclaration(declared);
        if (member == null) {
            throw new IllegalStateException("declared descriptor is not resolved to declaration: " + declared);
        }
        JetModifierList modifierList = member.getModifierList();
        boolean hasOverrideNode = modifierList != null && modifierList.hasModifier(JetTokens.OVERRIDE_KEYWORD);
        Collection<? extends CallableMemberDescriptor> overriddenDescriptors = declared.getOverriddenDescriptors();
        if (hasOverrideNode) {
            OverrideResolver.checkOverridesForMemberMarkedOverride(declared, true, new CheckOverrideReportStrategy(){
                private boolean finalOverriddenError = false;
                private boolean typeMismatchError = false;
                private boolean kindMismatchError = false;

                @Override
                public void overridingFinalMember(@NotNull CallableMemberDescriptor overridden) {
                    if (overridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/kotlin/resolve/OverrideResolver$3", "overridingFinalMember"));
                    }
                    if (!this.finalOverriddenError) {
                        this.finalOverriddenError = true;
                        OverrideResolver.this.trace.report(Errors.OVERRIDING_FINAL_MEMBER.on(member, overridden, overridden.getContainingDeclaration()));
                    }
                }

                @Override
                public void returnTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overridden) {
                    if (overridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/kotlin/resolve/OverrideResolver$3", "returnTypeMismatchOnOverride"));
                    }
                    if (!this.typeMismatchError) {
                        this.typeMismatchError = true;
                        OverrideResolver.this.trace.report(Errors.RETURN_TYPE_MISMATCH_ON_OVERRIDE.on(member, declared, overridden));
                    }
                }

                @Override
                public void propertyTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overridden) {
                    if (overridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/kotlin/resolve/OverrideResolver$3", "propertyTypeMismatchOnOverride"));
                    }
                    if (!this.typeMismatchError) {
                        this.typeMismatchError = true;
                        OverrideResolver.this.trace.report(Errors.PROPERTY_TYPE_MISMATCH_ON_OVERRIDE.on(member, declared, overridden));
                    }
                }

                @Override
                public void varOverriddenByVal(@NotNull CallableMemberDescriptor overridden) {
                    if (overridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/kotlin/resolve/OverrideResolver$3", "varOverriddenByVal"));
                    }
                    if (!this.kindMismatchError) {
                        this.kindMismatchError = true;
                        OverrideResolver.this.trace.report(Errors.VAR_OVERRIDDEN_BY_VAL.on(member, (PropertyDescriptor)declared, (PropertyDescriptor)overridden));
                    }
                }

                @Override
                public void cannotOverrideInvisibleMember(@NotNull CallableMemberDescriptor invisibleOverridden) {
                    if (invisibleOverridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invisibleOverridden", "org/jetbrains/kotlin/resolve/OverrideResolver$3", "cannotOverrideInvisibleMember"));
                    }
                    OverrideResolver.this.trace.report(Errors.CANNOT_OVERRIDE_INVISIBLE_MEMBER.on(member, declared, invisibleOverridden));
                }

                @Override
                public void nothingToOverride() {
                    OverrideResolver.this.trace.report(Errors.NOTHING_TO_OVERRIDE.on(member, declared));
                }
            });
        } else if (!overriddenDescriptors.isEmpty()) {
            CallableMemberDescriptor overridden = overriddenDescriptors.iterator().next();
            this.trace.report(Errors.VIRTUAL_MEMBER_HIDDEN.on(member, declared, overridden, overridden.getContainingDeclaration()));
        }
    }

    private static void checkOverridesForMemberMarkedOverride(@NotNull CallableMemberDescriptor declared, boolean checkIfOverridesNothing, @NotNull CheckOverrideReportStrategy reportError2) {
        if (declared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declared", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkOverridesForMemberMarkedOverride"));
        }
        if (reportError2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportError", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkOverridesForMemberMarkedOverride"));
        }
        Collection<? extends CallableMemberDescriptor> overriddenDescriptors = declared.getOverriddenDescriptors();
        for (CallableMemberDescriptor callableMemberDescriptor : overriddenDescriptors) {
            if (callableMemberDescriptor == null) continue;
            if (!callableMemberDescriptor.getModality().isOverridable()) {
                reportError2.overridingFinalMember(callableMemberDescriptor);
            }
            if (declared instanceof PropertyDescriptor && !OverrideResolver.isPropertyTypeOkForOverride((PropertyDescriptor)callableMemberDescriptor, (PropertyDescriptor)declared)) {
                reportError2.propertyTypeMismatchOnOverride(callableMemberDescriptor);
            } else if (!OverrideResolver.isReturnTypeOkForOverride(callableMemberDescriptor, declared)) {
                reportError2.returnTypeMismatchOnOverride(callableMemberDescriptor);
            }
            if (!OverrideResolver.checkPropertyKind(callableMemberDescriptor, true) || !OverrideResolver.checkPropertyKind(declared, false)) continue;
            reportError2.varOverriddenByVal(callableMemberDescriptor);
        }
        if (checkIfOverridesNothing && overriddenDescriptors.isEmpty()) {
            DeclarationDescriptor containingDeclaration = declared.getContainingDeclaration();
            assert (containingDeclaration instanceof ClassDescriptor) : "Overrides may only be resolved in a class, but " + declared + " comes from " + containingDeclaration;
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            CallableMemberDescriptor invisibleOverriddenDescriptor = OverrideResolver.findInvisibleOverriddenDescriptor(declared, classDescriptor);
            if (invisibleOverriddenDescriptor != null) {
                reportError2.cannotOverrideInvisibleMember(invisibleOverriddenDescriptor);
            } else {
                reportError2.nothingToOverride();
            }
        }
    }

    public static boolean isReturnTypeOkForOverride(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
        if (superDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "isReturnTypeOkForOverride"));
        }
        if (subDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "isReturnTypeOkForOverride"));
        }
        TypeSubstitutor typeSubstitutor2 = OverrideResolver.prepareTypeSubstitutor(superDescriptor, subDescriptor);
        if (typeSubstitutor2 == null) {
            return false;
        }
        JetType superReturnType = superDescriptor.getReturnType();
        assert (superReturnType != null);
        JetType subReturnType = subDescriptor.getReturnType();
        assert (subReturnType != null);
        JetType substitutedSuperReturnType = typeSubstitutor2.substitute(superReturnType, Variance.OUT_VARIANCE);
        assert (substitutedSuperReturnType != null);
        return JetTypeChecker.DEFAULT.isSubtypeOf(subReturnType, substitutedSuperReturnType);
    }

    @Nullable
    private static TypeSubstitutor prepareTypeSubstitutor(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
        if (superDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "prepareTypeSubstitutor"));
        }
        if (subDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "prepareTypeSubstitutor"));
        }
        List<TypeParameterDescriptor> superTypeParameters = superDescriptor.getTypeParameters();
        List<TypeParameterDescriptor> subTypeParameters = subDescriptor.getTypeParameters();
        if (subTypeParameters.size() != superTypeParameters.size()) {
            return null;
        }
        ArrayList<TypeProjectionImpl> arguments2 = new ArrayList<TypeProjectionImpl>(subTypeParameters.size());
        for (int i = 0; i < superTypeParameters.size(); ++i) {
            arguments2.add(new TypeProjectionImpl(subTypeParameters.get(i).getDefaultType()));
        }
        return new IndexedParametersSubstitution(superTypeParameters, arguments2).buildSubstitutor();
    }

    public static boolean isPropertyTypeOkForOverride(@NotNull PropertyDescriptor superDescriptor, @NotNull PropertyDescriptor subDescriptor) {
        if (superDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "isPropertyTypeOkForOverride"));
        }
        if (subDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "isPropertyTypeOkForOverride"));
        }
        TypeSubstitutor typeSubstitutor2 = OverrideResolver.prepareTypeSubstitutor(superDescriptor, subDescriptor);
        if (typeSubstitutor2 == null) {
            return false;
        }
        if (!superDescriptor.isVar()) {
            return true;
        }
        JetType substitutedSuperReturnType = typeSubstitutor2.substitute(superDescriptor.getType(), Variance.OUT_VARIANCE);
        assert (substitutedSuperReturnType != null);
        return JetTypeChecker.DEFAULT.equalTypes(subDescriptor.getType(), substitutedSuperReturnType);
    }

    private void checkOverrideForComponentFunction(final @NotNull CallableMemberDescriptor componentFunction) {
        if (componentFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentFunction", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkOverrideForComponentFunction"));
        }
        final PsiElement dataAnnotation = OverrideResolver.findDataAnnotationForDataClass(componentFunction.getContainingDeclaration());
        OverrideResolver.checkOverridesForMemberMarkedOverride(componentFunction, false, new CheckOverrideReportStrategy(){
            private boolean overrideConflict = false;

            @Override
            public void overridingFinalMember(@NotNull CallableMemberDescriptor overridden) {
                if (overridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/kotlin/resolve/OverrideResolver$4", "overridingFinalMember"));
                }
                if (!this.overrideConflict) {
                    this.overrideConflict = true;
                    OverrideResolver.this.trace.report(Errors.DATA_CLASS_OVERRIDE_CONFLICT.on(dataAnnotation, componentFunction, overridden.getContainingDeclaration()));
                }
            }

            @Override
            public void returnTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overridden) {
                if (overridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/kotlin/resolve/OverrideResolver$4", "returnTypeMismatchOnOverride"));
                }
                if (!this.overrideConflict) {
                    this.overrideConflict = true;
                    OverrideResolver.this.trace.report(Errors.DATA_CLASS_OVERRIDE_CONFLICT.on(dataAnnotation, componentFunction, overridden.getContainingDeclaration()));
                }
            }

            @Override
            public void propertyTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overridden) {
                if (overridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/kotlin/resolve/OverrideResolver$4", "propertyTypeMismatchOnOverride"));
                }
                throw new IllegalStateException("Component functions are not properties");
            }

            @Override
            public void varOverriddenByVal(@NotNull CallableMemberDescriptor overridden) {
                if (overridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/kotlin/resolve/OverrideResolver$4", "varOverriddenByVal"));
                }
                throw new IllegalStateException("Component functions are not properties");
            }

            @Override
            public void cannotOverrideInvisibleMember(@NotNull CallableMemberDescriptor invisibleOverridden) {
                if (invisibleOverridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invisibleOverridden", "org/jetbrains/kotlin/resolve/OverrideResolver$4", "cannotOverrideInvisibleMember"));
                }
                throw new IllegalStateException("CANNOT_OVERRIDE_INVISIBLE_MEMBER should be reported on the corresponding property");
            }

            @Override
            public void nothingToOverride() {
                throw new IllegalStateException("Component functions are OK to override nothing");
            }
        });
    }

    @NotNull
    private static PsiElement findDataAnnotationForDataClass(@NotNull DeclarationDescriptor dataClass) {
        PsiElement modifier;
        JetAnnotationEntry entry;
        if (dataClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataClass", "org/jetbrains/kotlin/resolve/OverrideResolver", "findDataAnnotationForDataClass"));
        }
        AnnotationDescriptor annotation2 = dataClass.getAnnotations().findAnnotation(KotlinBuiltIns.FQ_NAMES.data);
        if (annotation2 != null && (entry = DescriptorToSourceUtils.getSourceFromAnnotation(annotation2)) != null) {
            JetAnnotationEntry jetAnnotationEntry = entry;
            if (jetAnnotationEntry == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "findDataAnnotationForDataClass"));
            }
            return jetAnnotationEntry;
        }
        JetClass classDeclaration = (JetClass)DescriptorToSourceUtils.getSourceFromDescriptor(dataClass);
        if (classDeclaration != null && classDeclaration.getModifierList() != null && (modifier = classDeclaration.getModifierList().getModifier(JetTokens.DATA_KEYWORD)) != null) {
            PsiElement psiElement = modifier;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "findDataAnnotationForDataClass"));
            }
            return psiElement;
        }
        throw new IllegalStateException("No data annotation is found for data class " + dataClass);
    }

    @Nullable
    private static CallableMemberDescriptor findInvisibleOverriddenDescriptor(@NotNull CallableMemberDescriptor declared, @NotNull ClassDescriptor declaringClass) {
        if (declared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declared", "org/jetbrains/kotlin/resolve/OverrideResolver", "findInvisibleOverriddenDescriptor"));
        }
        if (declaringClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaringClass", "org/jetbrains/kotlin/resolve/OverrideResolver", "findInvisibleOverriddenDescriptor"));
        }
        for (JetType supertype : declaringClass.getTypeConstructor().getSupertypes()) {
            LinkedHashSet<CallableDescriptor> all = Sets.newLinkedHashSet();
            all.addAll(supertype.getMemberScope().getFunctions(declared.getName(), NoLookupLocation.UNSORTED));
            all.addAll(supertype.getMemberScope().getProperties(declared.getName(), NoLookupLocation.UNSORTED));
            for (CallableMemberDescriptor callableMemberDescriptor : all) {
                if (OverridingUtil.DEFAULT.isOverridableBy(callableMemberDescriptor, declared).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
                if (Visibilities.isVisible(ReceiverValue.IRRELEVANT_RECEIVER, callableMemberDescriptor, declared)) {
                    throw new IllegalStateException("Descriptor " + callableMemberDescriptor + " is overridable by " + declared + " and visible but does not appear in its getOverriddenDescriptors()");
                }
                return callableMemberDescriptor;
            }
        }
        return null;
    }

    private void checkParameterOverridesForAllClasses(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkParameterOverridesForAllClasses"));
        }
        for (ClassDescriptorWithResolutionScopes classDescriptor : c.getDeclaredClasses().values()) {
            for (DeclarationDescriptor member : classDescriptor.getDefaultType().getMemberScope().getAllDescriptors()) {
                if (!(member instanceof CallableMemberDescriptor)) continue;
                this.checkOverridesForParameters((CallableMemberDescriptor)member);
            }
        }
    }

    private void checkOverridesForParameters(@NotNull CallableMemberDescriptor declared) {
        JetModifierListOwner declaration;
        boolean isDeclaration;
        if (declared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declared", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkOverridesForParameters"));
        }
        boolean bl = isDeclaration = declared.getKind() == CallableMemberDescriptor.Kind.DECLARATION;
        if (isDeclaration && (declaration = (JetModifierListOwner)DescriptorToSourceUtils.descriptorToDeclaration(declared)) != null && !declaration.hasModifier(JetTokens.OVERRIDE_KEYWORD)) {
            return;
        }
        for (ValueParameterDescriptor parameterFromSubclass : declared.getValueParameters()) {
            boolean multipleDefaultsInSuper;
            int defaultsInSuper = 0;
            for (ValueParameterDescriptor valueParameterDescriptor : parameterFromSubclass.getOverriddenDescriptors()) {
                if (!valueParameterDescriptor.declaresDefaultValue()) continue;
                ++defaultsInSuper;
            }
            boolean bl2 = multipleDefaultsInSuper = defaultsInSuper > 1;
            if (isDeclaration) {
                this.checkNameAndDefaultForDeclaredParameter(parameterFromSubclass, multipleDefaultsInSuper);
                continue;
            }
            this.checkNameAndDefaultForFakeOverrideParameter(declared, parameterFromSubclass, multipleDefaultsInSuper);
        }
    }

    private void checkNameAndDefaultForDeclaredParameter(@NotNull ValueParameterDescriptor descriptor2, boolean multipleDefaultsInSuper) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkNameAndDefaultForDeclaredParameter"));
        }
        JetParameter parameter = (JetParameter)DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        assert (parameter != null) : "Declaration not found for parameter: " + descriptor2;
        if (descriptor2.declaresDefaultValue()) {
            this.trace.report(Errors.DEFAULT_VALUE_NOT_ALLOWED_IN_OVERRIDE.on(parameter));
        }
        if (multipleDefaultsInSuper) {
            this.trace.report(Errors.MULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES.on(parameter, descriptor2));
        }
        for (ValueParameterDescriptor valueParameterDescriptor : descriptor2.getOverriddenDescriptors()) {
            if (!OverrideResolver.shouldReportParameterNameOverrideWarning(descriptor2, valueParameterDescriptor)) continue;
            this.trace.report(Errors.PARAMETER_NAME_CHANGED_ON_OVERRIDE.on(parameter, (ClassDescriptor)valueParameterDescriptor.getContainingDeclaration().getContainingDeclaration(), valueParameterDescriptor));
        }
    }

    private void checkNameAndDefaultForFakeOverrideParameter(@NotNull CallableMemberDescriptor containingFunction, @NotNull ValueParameterDescriptor descriptor2, boolean multipleDefaultsInSuper) {
        if (containingFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFunction", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkNameAndDefaultForFakeOverrideParameter"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkNameAndDefaultForFakeOverrideParameter"));
        }
        DeclarationDescriptor containingClass = containingFunction.getContainingDeclaration();
        JetClassOrObject classElement = (JetClassOrObject)DescriptorToSourceUtils.descriptorToDeclaration(containingClass);
        assert (classElement != null) : "Declaration not found for class: " + containingClass;
        if (multipleDefaultsInSuper) {
            this.trace.report(Errors.MULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES_WHEN_NO_EXPLICIT_OVERRIDE.on(classElement, descriptor2));
        }
        for (ValueParameterDescriptor valueParameterDescriptor : descriptor2.getOverriddenDescriptors()) {
            if (!OverrideResolver.shouldReportParameterNameOverrideWarning(descriptor2, valueParameterDescriptor)) continue;
            this.trace.report(Errors.DIFFERENT_NAMES_FOR_THE_SAME_PARAMETER_IN_SUPERTYPES.on(classElement, containingFunction.getOverriddenDescriptors(), valueParameterDescriptor.getIndex() + 1));
        }
    }

    public static boolean shouldReportParameterNameOverrideWarning(@NotNull ValueParameterDescriptor parameterFromSubclass, @NotNull ValueParameterDescriptor parameterFromSuperclass) {
        if (parameterFromSubclass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterFromSubclass", "org/jetbrains/kotlin/resolve/OverrideResolver", "shouldReportParameterNameOverrideWarning"));
        }
        if (parameterFromSuperclass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterFromSuperclass", "org/jetbrains/kotlin/resolve/OverrideResolver", "shouldReportParameterNameOverrideWarning"));
        }
        return parameterFromSubclass.getContainingDeclaration().hasStableParameterNames() && parameterFromSuperclass.getContainingDeclaration().hasStableParameterNames() && !parameterFromSuperclass.getName().equals(parameterFromSubclass.getName());
    }

    private static boolean checkPropertyKind(@NotNull CallableMemberDescriptor descriptor2, boolean isVar) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkPropertyKind"));
        }
        return descriptor2 instanceof PropertyDescriptor && ((PropertyDescriptor)descriptor2).isVar() == isVar;
    }

    private void checkVisibility(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkVisibility"));
        }
        for (Map.Entry<JetCallableDeclaration, CallableMemberDescriptor> entry : c.getMembers().entrySet()) {
            this.checkVisibilityForMember(entry.getKey(), entry.getValue());
        }
    }

    private void checkVisibilityForMember(@NotNull JetDeclaration declaration, @NotNull CallableMemberDescriptor memberDescriptor) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkVisibilityForMember"));
        }
        if (memberDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkVisibilityForMember"));
        }
        Visibility visibility = memberDescriptor.getVisibility();
        for (CallableMemberDescriptor callableMemberDescriptor : memberDescriptor.getOverriddenDescriptors()) {
            Integer compare = Visibilities.compare(visibility, callableMemberDescriptor.getVisibility());
            if (compare == null) {
                this.trace.report(Errors.CANNOT_CHANGE_ACCESS_PRIVILEGE.on(declaration, callableMemberDescriptor.getVisibility(), callableMemberDescriptor, callableMemberDescriptor.getContainingDeclaration()));
                return;
            }
            if (compare >= 0) continue;
            this.trace.report(Errors.CANNOT_WEAKEN_ACCESS_PRIVILEGE.on(declaration, callableMemberDescriptor.getVisibility(), callableMemberDescriptor, callableMemberDescriptor.getContainingDeclaration()));
            return;
        }
    }

    @NotNull
    public static <D extends CallableMemberDescriptor> Collection<D> getDirectlyOverriddenDeclarations(@NotNull D descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "getDirectlyOverriddenDeclarations"));
        }
        LinkedHashSet<CallableMemberDescriptor> result2 = new LinkedHashSet<CallableMemberDescriptor>();
        for (CallableMemberDescriptor callableMemberDescriptor : descriptor2.getOverriddenDescriptors()) {
            CallableMemberDescriptor.Kind kind = callableMemberDescriptor.getKind();
            if (kind == CallableMemberDescriptor.Kind.DECLARATION) {
                result2.add(callableMemberDescriptor);
                continue;
            }
            if (kind == CallableMemberDescriptor.Kind.FAKE_OVERRIDE || kind == CallableMemberDescriptor.Kind.DELEGATION) {
                result2.addAll(OverrideResolver.getDirectlyOverriddenDeclarations(callableMemberDescriptor));
                continue;
            }
            if (kind != CallableMemberDescriptor.Kind.SYNTHESIZED) {
                throw new AssertionError((Object)("Unexpected callable kind " + (Object)((Object)kind)));
            }
        }
        Set set = OverrideResolver.filterOutOverridden(result2);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "getDirectlyOverriddenDeclarations"));
        }
        return set;
    }

    @NotNull
    @ReadOnly
    public static <D extends CallableMemberDescriptor> Set<D> getDeepestSuperDeclarations(@NotNull D functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "getDeepestSuperDeclarations"));
        }
        Set<D> overriddenDeclarations = DescriptorUtils.getAllOverriddenDeclarations(functionDescriptor);
        if (overriddenDeclarations.isEmpty()) {
            Set<D> set = Collections.singleton(functionDescriptor);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "getDeepestSuperDeclarations"));
            }
            return set;
        }
        Set<D> set = OverrideResolver.filterOutOverriding(overriddenDeclarations);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "getDeepestSuperDeclarations"));
        }
        return set;
    }

    private static interface CheckOverrideReportStrategy {
        public void overridingFinalMember(@NotNull CallableMemberDescriptor var1);

        public void returnTypeMismatchOnOverride(@NotNull CallableMemberDescriptor var1);

        public void propertyTypeMismatchOnOverride(@NotNull CallableMemberDescriptor var1);

        public void varOverriddenByVal(@NotNull CallableMemberDescriptor var1);

        public void cannotOverrideInvisibleMember(@NotNull CallableMemberDescriptor var1);

        public void nothingToOverride();
    }

    private static enum Filtering {
        RETAIN_OVERRIDING,
        RETAIN_OVERRIDDEN;

    }
}

