/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.varianceChecker;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.Map;
import kotlin.KotlinPackage;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.platform.platformStatic;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyAccessorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetTypeConstraint;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeParameterListOwner;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.resolve.typeBinding.TypeArgumentBinding;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBinding;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBindingKt;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"U\u0004)ya+\u0019:jC:\u001cWm\u00115fG.,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u001d\u0011Xm]8mm\u0016TqB^1sS\u0006t7-Z\"iK\u000e\\WM\u001d\u0006\u0004\u0003:L(B\u0002\u001fj]&$hHC\u0003ue\u0006\u001cWM\u0003\u0007CS:$\u0017N\\4Ue\u0006\u001cWMC\u0003dQ\u0016\u001c7NC\u0001d\u0015Y!v\u000e\u001d#po:\fe.\u00197zg&\u001c8i\u001c8uKb$(\u0002B+oSRTAb\u00195fG.\u001cE.Y:tKNTAb\u00195fG.lU-\u001c2feNT\u0011bQ8na\u0006t\u0017n\u001c8\u000b=Y\u000b'/[1oG\u0016\u001cuN\u001c4mS\u000e$H)[1h]>\u001cH/[2ECR\fGK\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0003!\rQa\u0001\u0003\u0004\u0011\ra\u0001!B\u0002\u0005\u0004!%A\u0002A\u0003\u0003\t\u0007AI!B\u0002\u0005\u0004!1A\u0002A\u0003\u0004\t\rAi\u0001\u0004\u0001\u0006\u0005\u0011\r\u0001B\u0002\u0003\u0004\u0019\u000b\u0001\u0002\"G\u0002\u0006\u0003!\u001d\u0001tA\u000f\u0002\u0011#iC\u0002B1\u00051\u0011\t3!B\u0001\t\ta!Qk\u0001\u0003\u0006\u0007\u0011!\u0011\"\u0001E\u0005[U!1\u0001G\u0003\u001e\u0010\u0011\u0001\u00012B\u0007\u0004\u000b\u0005AQ\u0001G\u0003Q\u0007\u0001\t3!B\u0001\t\fa-\u0011kA\u0003\u0005\u000b%\tA\u0001A\u0007\u0002\u0011\u0019iS\u0003B\u0001\u0019\u000fu=A\u0001\u0001E\u0006\u001b\r)\u0011\u0001C\u0003\u0019\u000bA\u001b\u0001!I\u0002\u0006\u0003!-\u00014B)\u0004\u000b\u00119\u0011\"\u0001\u0003\u0001\u001b\u0005Aa!L\u000b\u0005\u0003a=Qt\u0002\u0003\u0001\u0011\u0017i1!B\u0001\t\u000ba)\u0001k\u0001\u0001\"\u0007\u0015\t\u00012\u0002M\u0006#\u000e)AqB\u0005\u0002\t\u0001i\u0011\u0001\u0003\u00046.\u0015-Ba9\u0001\u0019\bu=A\u0001\u0001\u0005\u0005\u001b\r)\u0011\u0001\u0003\u0003\u0019\tA\u001b\u0001!I\u0002\u0006\u0003!\u0015\u0001TA)\u0004\u000b\u0011\u001d\u0011\"\u0001\u0003\u0001\u001b\u0005AI\u0001"})
public final class VarianceChecker {
    public static final /* synthetic */ KClass $kotlinClass;
    private final BindingTrace trace;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(VarianceChecker.class);
        Companion companion = Companion = new Companion(null);
    }

    public final void check(@NotNull TopDownAnalysisContext c) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        this.checkClasses(c);
        this.checkMembers(c);
    }

    private final void checkClasses(TopDownAnalysisContext c) {
        Map<JetClassOrObject, ClassDescriptorWithResolutionScopes> map2 = c.getDeclaredClasses();
        if (map2 == null) {
            Intrinsics.throwNpe();
        }
        for (JetClassOrObject jetClassOrObject : map2.keySet()) {
            if (!(jetClassOrObject instanceof JetClass)) continue;
            for (JetDelegationSpecifier specifier : ((JetClass)jetClassOrObject).getDelegationSpecifiers()) {
                Boolean bl;
                JetTypeReference jetTypeReference = specifier.getTypeReference();
                if (jetTypeReference != null) {
                    BindingContext bindingContext = this.trace.getBindingContext();
                    Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
                    bl = VarianceChecker.Companion.checkTypePosition(jetTypeReference, bindingContext, Variance.OUT_VARIANCE, this.trace);
                    continue;
                }
                bl = null;
            }
            JetTypeParameterListOwner jetTypeParameterListOwner = jetClassOrObject;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
            VarianceChecker.Companion.checkTypeParameters(jetTypeParameterListOwner, bindingContext, Variance.OUT_VARIANCE, this.trace);
        }
    }

    private final void checkMembers(TopDownAnalysisContext c) {
        Iterator<Map.Entry<JetCallableDeclaration, CallableMemberDescriptor>> iterator2 = KotlinPackage.iterator(c.getMembers());
        while (iterator2.hasNext()) {
            Map.Entry<JetCallableDeclaration, CallableMemberDescriptor> entry = iterator2.next();
            JetCallableDeclaration declaration = KotlinPackage.component1(entry);
            CallableMemberDescriptor descriptor2 = KotlinPackage.component2(entry);
            if (Visibilities.isPrivate(descriptor2.getVisibility())) continue;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
            JetCallableDeclaration jetCallableDeclaration = declaration;
            Intrinsics.checkExpressionValueIsNotNull(jetCallableDeclaration, "declaration");
            CallableDescriptor callableDescriptor = descriptor2;
            Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "descriptor");
            VarianceChecker.Companion.checkCallableDeclaration(bindingContext, jetCallableDeclaration, callableDescriptor, this.trace);
        }
    }

    public VarianceChecker(@NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.trace = trace;
    }

    @platformStatic
    public static final void recordPrivateToThisIfNeeded(@NotNull BindingTrace trace, @NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Companion.recordPrivateToThisIfNeeded(trace, descriptor2);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={" \u0006)qb+\u0019:jC:\u001cWmQ8oM2L7\r\u001e#jC\u001etwn\u001d;jG\u0012\u000bG/\u0019\u0006\u0010-\u0006\u0014\u0018.\u00198dK\u000eCWmY6fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0004sKN|GN^3\u000b\u001fY\f'/[1oG\u0016\u001c\u0005.Z2lKJT1!\u00118z\u0015\u0019a\u0014N\\5u})q1m\u001c8uC&t\u0017N\\4UsB,'b\u0002&fiRK\b/\u001a\u0006\u0006if\u0004Xm\u001d\u0006\u000eif\u0004X\rU1sC6,G/\u001a:\u000b/QK\b/\u001a)be\u0006lW\r^3s\t\u0016\u001c8M]5qi>\u0014(b\u00033fg\u000e\u0014\u0018\u000e\u001d;peNT!c\\2dkJ\u0014XM\\2f!>\u001c\u0018\u000e^5p]*Aa+\u0019:jC:\u001cWMC\thKR\u001cuN\u001c;bS:Lgn\u001a+za\u0016TQcZ3u\u001f\u000e\u001cWO\u001d:f]\u000e,\u0007k\\:ji&|gN\u0003\thKR$\u0016\u0010]3QCJ\fW.\u001a;fe:T!\u0001\u0005\u0002\u000b\t!\u0001\u0001c\u0001\u0006\u0005\u0011\u0005\u0001BA\u0003\u0003\t\u0005A)!\u0002\u0002\u0005\u0004!\u0019Qa\u0001\u0003\u0003\u0011\u0003a\u0001!B\u0002\u0005\u0006!\u0001A\u0002A\u0003\u0002\u0011\t)1\u0001b\u0002\t\b1\u0001QA\u0001\u0003\u0002\u0011\u0017)1\u0001\"\u0003\t\u000b1\u0001QA\u0001\u0003\u0002\u0011\u001d)1\u0001b\u0003\t\u000e1\u0001Qa\u0001C\u0005\u0011!a\u0001!\u0002\u0002\u0005\n!)QA\u0001C\u0006\u0011\u001b)!\u0001\"\u0003\t\u0011\u0011\u0019AbA\r\u0004\u000b\u0005AA\u0001\u0007\u0003.!\u0011\u0019G\u0001'\u0003\"\u0007\u0015\t\u0001\"\u0002\r\u0006+\u000eAQa\u0001C\u0005\u0013\u0005Aq!D\u0002\u0005\u0012%\t\u0001bB\u0017\u0011\t\r$\u0001tB\u0011\u0004\u000b\u0005Ai\u0001'\u0004V\u0007!)1\u0001b\u0004\n\u0003!AQb\u0001\u0003\n\u0013\u0005A\u0001\"\f\t\u0005G\u0012Ab!I\u0002\u0006\u0003!1\u0001DB+\u0004\u0011\u0015\u0019AAB\u0005\u0002\u0011\u001fi1\u0001b\u0005\n\u0003!=QwKC+\t\r\b\u0001\u0004BO\b\t\u0001AI!D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0001u=A\u0001\u0001\u0005\u0007\u001b\r)\u0011\u0001\u0003\u0004\u0019\rA\u001b\t!h\u0004\u0005\u0001!=QbA\u0003\u0002\u0011\u001bAj\u0001U\u0002\u0002C\r)\u0011\u0001C\u0002\u0019\u0007E\u001b\u0011\u0002\u0002\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\b\u001b\u0005Ay!D\u0001\t\u0011\u0001"})
    public static final class VarianceConflictDiagnosticData {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final JetType containingType;
        @NotNull
        private final TypeParameterDescriptor typeParameter;
        @NotNull
        private final Variance occurrencePosition;

        static {
            $kotlinClass = Reflection.createKotlinClass(VarianceConflictDiagnosticData.class);
        }

        @NotNull
        public final JetType getContainingType() {
            return this.containingType;
        }

        @NotNull
        public final TypeParameterDescriptor getTypeParameter() {
            return this.typeParameter;
        }

        @NotNull
        public final Variance getOccurrencePosition() {
            return this.occurrencePosition;
        }

        public VarianceConflictDiagnosticData(@NotNull JetType containingType, @NotNull TypeParameterDescriptor typeParameter, @NotNull Variance occurrencePosition) {
            Intrinsics.checkParameterIsNotNull(containingType, "containingType");
            Intrinsics.checkParameterIsNotNull(typeParameter, "typeParameter");
            Intrinsics.checkParameterIsNotNull((Object)occurrencePosition, "occurrencePosition");
            this.containingType = containingType;
            this.typeParameter = typeParameter;
            this.occurrencePosition = occurrencePosition;
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"d\n)I1i\\7qC:LwN\u001c\u0006\u0010-\u0006\u0014\u0018.\u00198dK\u000eCWmY6fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0004sKN|GN^3\u000b\u001fY\f'/[1oG\u0016\u001c\u0005.Z2lKJT1!\u00118z\u0015a\u0019\u0007.Z2l\u0007\u0006dG.\u00192mK\u0012+7\r\\1sCRLwN\u001c\u0006\u0006iJ\f7-\u001a\u0006\u000f\u0005&tG-\u001b8h\u0007>tG/\u001a=u\u0015-!Wm\u00197be\u0006$\u0018n\u001c8\u000b-)+GoQ1mY\u0006\u0014G.\u001a#fG2\f'/\u0019;j_:T1\u0001]:j\u0015)!Wm]2sSB$xN\u001d\u0006\u0013\u0007\u0006dG.\u00192mK\u0012+7o\u0019:jaR|'OC\u0006eKN\u001c'/\u001b9u_J\u001c(B\u00043jC\u001etwn\u001d;jGNKgn\u001b\u0006\u000f\t&\fwM\\8ti&\u001c7+\u001b8l\u0015-!\u0017.Y4o_N$\u0018nY:\u000b\u000f\t{w\u000e\\3b]*a\u0011n]%se\u0016dWM^1oi*\u0019\"/Z2pe\u0012\u0004&/\u001b<bi\u0016$v\u000e\u00165jg*A2)\u00197mC\ndW-T3nE\u0016\u0014H)Z:de&\u0004Ho\u001c:\u000b\tUs\u0017\u000e\u001e\u0006\u001ce\u0016\u001cwN\u001d3Qe&4\u0018\r^3U_RC\u0017n]%g\u001d\u0016,G-\u001a3\u000b\u0019\tKg\u000eZ5oOR\u0013\u0018mY3\u000b\u0007\u0005tGMC\u0003pi\",'O\u0003\u0003kCZ\f'\u0002\u00027b]\u001eT\u0011DS3u)f\u0004X\rU1sC6,G/\u001a:MSN$xj\u001e8fe*\u00192\r[3dWRK\b/\u001a)be\u0006lW\r^3sg*aA/\u001f9f!>\u001c\u0018\u000e^5p]*Aa+\u0019:jC:\u001cWMC\u0003usB,7O\u0003\tKKR$\u0016\u0010]3SK\u001a,'/\u001a8dK*\t2\r[3dWRK\b/\u001a)pg&$\u0018n\u001c8\u000b\u0011A|7/\u001b;j_:T1\u0002V=qK\nKg\u000eZ5oO*YA/\u001f9f\u0005&tG-\u001b8h\u0015)\u00016/[#mK6,g\u000e\u001e\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u001d\r|g\u000e^1j]&tw\rV=qK*9!*\u001a;UsB,\u0007V\u0001\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\t!\u0019\u0001C\u0002\u0006\u0007\u0011\u0011\u0001\u0012\u0001\u0007\u0001\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\t\u0001BA\u0003\u0004\t\u000fA9\u0001\u0004\u0001\u0006\u0007\u0011\r\u0001\"\u0002\u0007\u0001\u000b\t!\u0011\u0001#\u0004\u0006\u0007\u0011)\u0001B\u0002\u0007\u0001\u000b\t!\u0011\u0001\u0003\u0005\u0006\u0007\u00111\u0001r\u0002\u0007\u0001\u000b\t!\u0011\u0001c\u0005\u0006\u0007\u00119\u0001\"\u0003\u0007\u0001\u000b\r!9\u0001\u0003\u0006\r\u0001\u0015\u0011A1\u0001\u0005\u0006\u000b\t!Q\u0001\u0003\u0004\u0006\u0005\u00111\u0001rB\u0003\u0003\t\u001dA\u0011\"B\u0002\u0005\r!]A\u0002A\u0003\u0004\t\u000fAA\u0002\u0004\u0001\u0006\u0005\u00111\u0001rC\u0003\u0004\t\u0007AQ\u0002\u0004\u0001\u0006\u0005\u0011\r\u0001\"D\u0003\u0002\u0011;)!\u0001B\u0007\t\u001f\u0015\u0011A1\u0004\u0005\u000b\u000b\r!Q\u0001c\b\r\u0001\u0015\u0011A!\u0001E\u0012\u000b\r!q\u0002C\t\r\u0001\u0015\u0011A!\u0002E\u0010\u000b\t!q\u0002C\t\u0006\u0007\u0011)\u0001B\u0005\u0007\u0001\u000b\t!Q\u0001\u0003\n\u0006\u0005\u0011\r\u0001\u0002F\u0003\u0004\tIA9\u0003\u0004\u0001\u0006\u0003!)RA\u0001\u0003\u0014\u0011W)!\u0001b\n\t\u000e\u0015\u0019A\u0001\u0006E\u0015\u0019\u0001)1\u0001B\b\t.1\u0001QA\u0001\u0003\u0013\u0011O)!\u0001B\b\t.\u0011\u0019\u001d\u0001D\u0002\u001a\u0007\u0015\t\u0001\u0002\u0002\r\u0005[S\"\u0011\u0001\u0007\u0003\u001e\u0010\u0011\u0001\u0001\u0012B\u0007\u0004\u000b\u0005AI\u0001'\u0003Q\u0007\u0001iz\u0001\u0002\u0001\t\f5\u0019Q!\u0001E\u00061\u0017\u00016\u0011AO\b\t\u0001Aq!D\u0002\u0006\u0003!5\u0001T\u0002)\u0004\u0003u=A\u0001\u0001E\t\u001b\r)\u0011\u0001c\u0004\u0019\u0010A\u001b\u0019!I\u0002\u0006\u0003!A\u0001\u0004C)\u0004\u0017\u0011!\u0011\"\u0001C\u0001\u001b\u0005A\t\"D\u0001\t\u00135\t\u00012C\u0007\u0002\u0011)iS\u0003B\u0001\u0019\u0016u=A\u0001\u0001\u0005\b\u001b\r)\u0011\u0001#\u0004\u0019\u000eA\u001b\u0001!I\u0002\u0006\u0003!A\u0001\u0004C)\u0004\u000b\u0011U\u0011\"\u0001C\u0001\u001b\u0005A\u0019\"L\u000b\u0005\u0003aYQt\u0002\u0003\u0001\u0011\u001di1!B\u0001\t\u0016aU\u0001k\u0001\u0001\"\u0007\u0015\t\u0001b\u0003\r\f#\u000e)AaC\u0005\u0002\t\u0001i\u0011\u0001c\u0006.@\u0011\u001d\u0001\u0014DO\b\t\u0001AI!D\u0002\u0006\u0003!a\u0001\u0004\u0004)\u0004\u0001u=A\u0001\u0001\u0005\b\u001b\r)\u0011\u0001#\u0006\u0019\u0016A\u001b\t!I\u0002\u0006\u0003!Y\u0001dC)\u0004\u000f\u0011e\u0011\"\u0001\u0003\u0001\u001b\u0005AI\"D\u0001\t\u00185bB!A\u000b\u0004\u000b\u0005A\u0001\u0002\u0007\u0005\u0019\u001cuEA\u0001\u0001\u0005\u000f\u001b\u0011)\u0011\u0001\u0003\u0005\r\u0002aA\u0001k!\u0001\"\u0007\u0015\t\u0001\u0002\u0003\r\t#\u000e9A1D\u0005\u0002\t\u0003i\u0011\u0001\"\u0001\u000e\u0003!qQ\u0006\r\u0003\u0002+\r)\u0011\u0001#\b\u0019\u001ea\u0001Rt\u0002\u0003\u0001\u0011\u0013i1!B\u0001\t\na%\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001\u0012E\u0007\u0004\u000b\u0005Ay\u0002g\bQ\u0007\u0005iz\u0001\u0002\u0001\t\u00125\u0019Q!\u0001E\b1\u001f\u000161A\u0011\u0004\u000b\u0005A\u0001\u0002\u0007\u0005R\u0007-!\u0001#C\u0001\u0005\u00025\t\u0001\u0002E\u0007\u0002\u0011#i\u0011\u0001#\t\u000e\u0003!QQ&\r\u0003\u0002+\r)\u0011\u0001C\t\u0019#a\u0015Rt\u0002\u0003\u0001\u0011\u0013i1!B\u0001\t\na%\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001bE\u0007\u0004\u000b\u0005Ay\u0002g\bQ\u0007\u0005iz\u0001\u0002\u0001\t\u00125\u0019Q!\u0001E\b1\u001f\u000161A\u0011\u0005\u000b\u0005A\u0001\u0002$\u0001\u0019\u0011E\u001b1\u0002\"\n\n\u0003!qQ\"\u0001E\u0012\u001b\u0005A\t\"D\u0001\t\"5\t\u0001BC\u00176\t\u0005)\u0002\"B\u0001\t&%!\u0011bA\u0003\u0002\u0011SAJ\u0003'\n\u0019&u=A\u0001\u0001\u0005\u0017\u001b\r)\u0011\u0001C\u000b\u0019+A\u001b\t!h\u0004\u0005\u0001!\u0019RbA\u0003\u0002\u0011?Az\u0002U\u0002\u0002;\u001f!\u0001\u0001#\u0005\u000e\u0007\u0015\t\u0001r\u0002M\b!\u000e\r\u0011eA\u0003\u0002\u0011!A\u0002\"U\u0002\f\tKI\u0011\u0001\"\u0001\u000e\u0003!-R\"\u0001\u0005\u0017\u001b\u0005A\t#D\u0001\t\u00155VC!A\u000b\t\u000b\u0005A)#\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0006M\u00151KA*#h\u0004\u0005\u0001!\u0019RbA\u0003\u0002\u0011?Az\u0002UB\u0001;\u001f!\u0001\u0001#\u0005\u000e\u0007\u0015\t\u0001r\u0002M\b!\u000e\t\u0011eA\u0003\u0002\u0011!A\u0002\"U\u0002\n\tKI\u0011\u0001\"\u0001\u000e\u0003!-R\"\u0001E\u0011\u001b\u0005A!\"\u000e\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @platformStatic
        public final void recordPrivateToThisIfNeeded(@NotNull BindingTrace trace, @NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            if (this.isIrrelevant(descriptor2) || Intrinsics.areEqual(descriptor2.getVisibility(), Visibilities.PRIVATE) ^ true) {
                return;
            }
            PsiElement psiElement = KotlinSourceElementKt.getPsi(descriptor2.getSource());
            if (!(psiElement instanceof JetCallableDeclaration)) {
                return;
            }
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
            JetCallableDeclaration jetCallableDeclaration = (JetCallableDeclaration)psiElement;
            CallableDescriptor callableDescriptor = descriptor2;
            DiagnosticSink diagnosticSink = DiagnosticSink.DO_NOTHING;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticSink, "DiagnosticSink.DO_NOTHING");
            if (!this.checkCallableDeclaration(bindingContext, jetCallableDeclaration, callableDescriptor, diagnosticSink)) {
                this.recordPrivateToThis(descriptor2);
            }
        }

        private final boolean isIrrelevant(CallableDescriptor descriptor2) {
            boolean bl;
            block2: {
                DeclarationDescriptor containingClass = descriptor2.getContainingDeclaration();
                if (!(containingClass instanceof ClassDescriptor)) {
                    return true;
                }
                Iterable $receiver = ((ClassDescriptor)containingClass).getTypeConstructor().getParameters();
                for (Object element : $receiver) {
                    TypeParameterDescriptor it2 = (TypeParameterDescriptor)element;
                    if (Intrinsics.areEqual((Object)it2.getVariance(), (Object)Variance.INVARIANT)) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            return bl;
        }

        private final void recordPrivateToThis(CallableMemberDescriptor descriptor2) {
            if (descriptor2 instanceof FunctionDescriptorImpl) {
                ((FunctionDescriptorImpl)descriptor2).setVisibility(Visibilities.PRIVATE_TO_THIS);
            } else if (descriptor2 instanceof PropertyDescriptorImpl) {
                ((PropertyDescriptorImpl)descriptor2).setVisibility(Visibilities.PRIVATE_TO_THIS);
                Iterator<PropertyAccessorDescriptor> iterator2 = ((PropertyDescriptorImpl)descriptor2).getAccessors().iterator();
                while (iterator2.hasNext()) {
                    PropertyAccessorDescriptor accessor;
                    PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = iterator2.next();
                    if (propertyAccessorDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.impl.PropertyAccessorDescriptorImpl");
                    }
                    ((PropertyAccessorDescriptorImpl)propertyAccessorDescriptor).setVisibility(Visibilities.PRIVATE_TO_THIS);
                }
            } else {
                throw (Throwable)new IllegalStateException("Unexpected descriptor type: " + descriptor2.getClass().getName());
            }
        }

        private final boolean checkCallableDeclaration(BindingContext trace, JetCallableDeclaration declaration, CallableDescriptor descriptor2, DiagnosticSink diagnosticSink) {
            if (this.isIrrelevant(descriptor2)) {
                return true;
            }
            boolean noError = true;
            noError &= this.checkTypeParameters(declaration, trace, Variance.IN_VARIANCE, diagnosticSink);
            JetTypeReference jetTypeReference = declaration.getReceiverTypeReference();
            noError = this.and(noError, jetTypeReference != null ? this.checkTypePosition(jetTypeReference, trace, Variance.IN_VARIANCE, diagnosticSink) : null);
            for (JetParameter parameter : declaration.getValueParameters()) {
                JetTypeReference jetTypeReference2 = parameter.getTypeReference();
                noError = this.and(noError, jetTypeReference2 != null ? this.checkTypePosition(jetTypeReference2, trace, Variance.IN_VARIANCE, diagnosticSink) : null);
            }
            Variance returnTypePosition = descriptor2 instanceof VariableDescriptor && ((VariableDescriptor)descriptor2).isVar() ? Variance.INVARIANT : Variance.OUT_VARIANCE;
            TypeBinding<PsiElement> typeBinding = TypeBindingKt.createTypeBindingForReturnType(declaration, trace);
            noError = this.and(noError, typeBinding != null ? Boolean.valueOf(this.checkTypePosition(typeBinding, returnTypePosition, diagnosticSink)) : null);
            return noError;
        }

        private final boolean checkTypeParameters(JetTypeParameterListOwner $receiver, BindingContext trace, Variance typePosition, DiagnosticSink diagnosticSink) {
            boolean noError = true;
            for (JetTypeParameter typeParameter : $receiver.getTypeParameters()) {
                JetTypeReference jetTypeReference = typeParameter.getExtendsBound();
                noError = this.and(noError, jetTypeReference != null ? this.checkTypePosition(jetTypeReference, trace, typePosition, diagnosticSink) : null);
            }
            for (JetTypeConstraint typeConstraint : $receiver.getTypeConstraints()) {
                JetTypeReference jetTypeReference = typeConstraint.getBoundTypeReference();
                noError = this.and(noError, jetTypeReference != null ? this.checkTypePosition(jetTypeReference, trace, typePosition, diagnosticSink) : null);
            }
            return noError;
        }

        private final Boolean checkTypePosition(JetTypeReference $receiver, BindingContext trace, Variance position, DiagnosticSink diagnosticSink) {
            TypeBinding<JetTypeElement> typeBinding = TypeBindingKt.createTypeBinding($receiver, trace);
            return typeBinding != null ? Boolean.valueOf(this.checkTypePosition(typeBinding, position, diagnosticSink)) : null;
        }

        private final boolean checkTypePosition(TypeBinding<? extends PsiElement> $receiver, Variance position, DiagnosticSink diagnosticSink) {
            return this.checkTypePosition($receiver, $receiver.getJetType(), position, diagnosticSink);
        }

        private final boolean checkTypePosition(TypeBinding<? extends PsiElement> $receiver, JetType containingType, Variance position, DiagnosticSink diagnosticSink) {
            ClassifierDescriptor classifierDescriptor = $receiver.getJetType().getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor instanceof TypeParameterDescriptor) {
                Variance declarationVariance = ((TypeParameterDescriptor)classifierDescriptor).getVariance();
                if (!declarationVariance.allowsPosition(position)) {
                    diagnosticSink.report(Errors.TYPE_VARIANCE_CONFLICT.on($receiver.getPsiElement(), new VarianceConflictDiagnosticData(containingType, (TypeParameterDescriptor)classifierDescriptor, position)));
                }
                return declarationVariance.allowsPosition(position);
            }
            boolean noError = true;
            for (TypeArgumentBinding<? extends PsiElement> argumentBinding : $receiver.getArgumentBindings()) {
                Variance newPosition;
                Variance variance;
                TypeCheckingProcedure.EnrichedProjectionKind projectionKind;
                TypeCheckingProcedure.EnrichedProjectionKind enrichedProjectionKind;
                if (argumentBinding == null || argumentBinding.getTypeParameterDescriptor() == null) continue;
                TypeParameterDescriptor typeParameterDescriptor = argumentBinding.getTypeParameterDescriptor();
                if (typeParameterDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                if (TypeCheckingProcedure.getEffectiveProjectionKind(typeParameterDescriptor, argumentBinding.getTypeProjection()) == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)(enrichedProjectionKind = projectionKind), (Object)TypeCheckingProcedure.EnrichedProjectionKind.OUT)) {
                    variance = position;
                } else if (Intrinsics.areEqual((Object)enrichedProjectionKind, (Object)TypeCheckingProcedure.EnrichedProjectionKind.IN)) {
                    variance = position.opposite();
                } else if (Intrinsics.areEqual((Object)enrichedProjectionKind, (Object)TypeCheckingProcedure.EnrichedProjectionKind.INV)) {
                    variance = Variance.INVARIANT;
                } else if (Intrinsics.areEqual((Object)enrichedProjectionKind, (Object)TypeCheckingProcedure.EnrichedProjectionKind.STAR)) {
                    variance = null;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if ((newPosition = variance) == null) continue;
                noError &= this.checkTypePosition(argumentBinding.getTypeBinding(), containingType, newPosition, diagnosticSink);
            }
            return noError;
        }

        private final boolean and(boolean $receiver, Boolean other) {
            return other == null ? $receiver : $receiver & other;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

