/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"6\u0006)Aa+\u0019:jC:\u001cWMC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0015!\u0018\u0010]3t\u0015\u0011)e.^7\u000b\rqJg.\u001b;?\u0015\u0015a\u0017MY3m\u0015\u0019\u0019FO]5oO*\u0001\u0012\r\u001c7poNLe\u000eU8tSRLwN\u001c\u0006\b\u0005>|G.Z1o\u0015E\tG\u000e\\8xg>+H\u000fU8tSRLwN\u001c\u0006\u0014gV\u0004XM\u001d9pg&$\u0018n\u001c8GC\u000e$xN\u001d\u0006\u0004\u0013:$(\u0002\u00026bm\u0006TA\u0001\\1oO*\u0019r-\u001a;BY2|wo]%o!>\u001c\u0018\u000e^5p]*!r-\u001a;BY2|wo](viB{7/\u001b;j_:T\u0001bZ3u\u0019\u0006\u0014W\r\u001c\u0006\u000fC2dwn^:Q_NLG/[8o\u0015!\u0001xn]5uS>t'\u0002C8qa>\u001c\u0018\u000e^3\u000b\u0013M,\b/\u001a:q_N,'\"B8uQ\u0016\u0014(\u0002\u0003;p'R\u0014\u0018N\\4\u000b\u0013%se+\u0011*J\u0003:#&bC%O?Z\u000b%+S!O\u0007\u0016SAbT+U?Z\u000b%+S!O\u0007\u0016C&B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0004\t\u0007A\u0001\u0001\u0004\u0001\u0006\u0003!\rQa\u0001C\u0003\u0011\u000ba\u0001!B\u0002\u0005\u0006!!A\u0002A\u0003\u0004\t\u000bAQ\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001R\u0002\u0007\u0001\u000b\u0005Aq!\u0002\u0002\u0005\u000b!=QA\u0001C\u0006\u0011\u0011)!\u0001b\u0001\t\u0001\u0011\u0019\r\u0001\u0004\u0002\u001a\u0011\u0015\t\u0001bA\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0002\u0019\u0005a\u0019Q\u0006\u0005\u0003d\ta%\u0011eA\u0003\u0002\u0011\u0011AB!V\u0002\t\u000b\r!I!C\u0001\u0005\u00025\u0019A\u0001C\u0005\u0002\t\u0003i\u0003\u0003B2\u00051\u0017\t3!B\u0001\t\ta!Qk\u0001\u0005\u0006\u0007\u0011-\u0011\"\u0001C\u0001\u001b\r!\t\"C\u0001\u0005\u00025\u0002Ba\u0019\u0003\u0019\b\u0005\u001aQ!\u0001E\u00041\u000f)6\u0001C\u0003\u0004\t\u000fI\u0011\u0001\u0003\u0004\u000e\u0007\u0011I\u0011\"\u0001\u0005\u0007[1!\u0011\r\u0002\r\u0007C\r)\u0011\u0001#\u0003\u0019\nU\u001bA!B\u0002\u0005\r%\tAQA\u0017\u0016\t\rA\u001a\"h\u0004\u0005\u0001!QQbA\u0003\u0002\u0011\tA\"\u0001U\u0002\u0001C\r)\u0011\u0001\u0003\u0003\u0019\tE\u001bQ\u0001b\u0005\n\u0003\u0011\u0005Q\"\u0001E\u0007[+!1\u0001'\u0006\"\u0007\u0015\t\u0001B\u0001\r\u0003#\u000e\u0019AQC\u0005\u0002\u0011\u001biS\u0003B\u0002\u0019\u0017u=A\u0001\u0001E\f\u001b\r)\u0011\u0001\u0003\u0002\u0019\u0005A\u001b\u0001!I\u0002\u0006\u0003!\u0011\u0001DA)\u0004\u000b\u0011Y\u0011\"\u0001E\u0007\u001b\u0005Ai!,\u0006\u0005\u0017aa\u0011eA\u0003\u0002\u0011\u000fA:!U\u0002\u0004\t1I\u0011\u0001\u0003\u00042\u00043iY\"\u000e\u001e\u0006s\u0011\t\u000f\u0001G\u0002\u001e\u0010\u0011\u0001\u0001rA\u0007\u0004\u000b\u0005A9\u0001g\u0002Q\u0007\u0005iz\u0001\u0002\u0001\t\n5\u0019Q!\u0001\u0005\u00051\u0011\u000161AO\b\t\u0001AY!D\u0002\u0006\u0003!!\u0001\u0004\u0002)\u0004\u0005u=A\u0001\u0001\u0005\u0007\u001b\r)\u0011\u0001#\u0003\u0019\nA\u001b)!I\u0002\u0006\u0003!\u0011\u0001DA)\u0004\u001f\u0011\u0019\u0011\"\u0001\u0003\u0001\u001b\u0005Aa!D\u0001\u0005\u00065\t\u0001BB\u0007\u0002\t\u0003i\u0011\u0001\"\u0001\u000e\u0003\u0011\u0015\u0001"})
public final class Variance
extends Enum<Variance> {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final /* enum */ Variance INVARIANT;
    public static final /* enum */ Variance IN_VARIANCE;
    public static final /* enum */ Variance OUT_VARIANCE;
    private static final /* synthetic */ Variance[] $VALUES;
    @NotNull
    private final String label;
    private final boolean allowsInPosition;
    private final boolean allowsOutPosition;
    private final int superpositionFactor;

    static {
        $kotlinClass = Reflection.createKotlinClass(Variance.class);
        Variance[] varianceArray = new Variance[3];
        Variance[] varianceArray2 = varianceArray;
        varianceArray[0] = INVARIANT = new Variance("", true, true, 0);
        varianceArray[1] = IN_VARIANCE = new Variance("in", true, false, -1);
        varianceArray[2] = OUT_VARIANCE = new Variance("out", false, true, 1);
        $VALUES = varianceArray;
    }

    public final boolean allowsPosition(@NotNull Variance position) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)position, "position");
        Variance variance = position;
        if (Intrinsics.areEqual((Object)variance, (Object)IN_VARIANCE)) {
            bl = this.allowsInPosition;
        } else if (Intrinsics.areEqual((Object)variance, (Object)OUT_VARIANCE)) {
            bl = this.allowsOutPosition;
        } else if (Intrinsics.areEqual((Object)variance, (Object)INVARIANT)) {
            bl = this.allowsInPosition && this.allowsOutPosition;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @NotNull
    public final Variance superpose(@NotNull Variance other) {
        Variance variance;
        Intrinsics.checkParameterIsNotNull((Object)other, "other");
        int r = this.superpositionFactor * other.superpositionFactor;
        switch (r) {
            case 0: {
                variance = INVARIANT;
                break;
            }
            case -1: {
                variance = IN_VARIANCE;
                break;
            }
            case 1: {
                variance = OUT_VARIANCE;
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Illegal factor: " + r);
            }
        }
        return variance;
    }

    @NotNull
    public final Variance opposite() {
        Variance variance;
        Variance variance2 = this;
        if (Intrinsics.areEqual((Object)variance2, (Object)INVARIANT)) {
            variance = INVARIANT;
        } else if (Intrinsics.areEqual((Object)variance2, (Object)IN_VARIANCE)) {
            variance = OUT_VARIANCE;
        } else if (Intrinsics.areEqual((Object)variance2, (Object)OUT_VARIANCE)) {
            variance = IN_VARIANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return variance;
    }

    @NotNull
    public String toString() {
        return this.label;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final boolean getAllowsInPosition() {
        return this.allowsInPosition;
    }

    public final boolean getAllowsOutPosition() {
        return this.allowsOutPosition;
    }

    protected Variance(@NotNull String label, boolean allowsInPosition, boolean allowsOutPosition, int superpositionFactor) {
        Intrinsics.checkParameterIsNotNull(label, "label");
        this.label = label;
        this.allowsInPosition = allowsInPosition;
        this.allowsOutPosition = allowsOutPosition;
        this.superpositionFactor = superpositionFactor;
    }

    public static Variance[] values() {
        return (Variance[])$VALUES.clone();
    }

    public static Variance valueOf(String string) {
        return Enum.valueOf(Variance.class, string);
    }
}

