/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.psi.PsiField;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFieldStubImpl
extends StubBase<PsiField>
implements PsiFieldStub {
    private final StringRef myName;
    private final TypeInfo myType;
    private final StringRef myInitializer;
    private final byte myFlags;

    public PsiFieldStubImpl(StubElement parent, String name, @NotNull TypeInfo type2, @Nullable String initializer, byte flags) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/java/stubs/impl/PsiFieldStubImpl", "<init>"));
        }
        this(parent, StringRef.fromString(name), type2, StringRef.fromString(initializer), flags);
    }

    public PsiFieldStubImpl(StubElement parent, StringRef name, @NotNull TypeInfo type2, @Nullable StringRef initializer, byte flags) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/java/stubs/impl/PsiFieldStubImpl", "<init>"));
        }
        super(parent, PsiFieldStubImpl.isEnumConst(flags) ? JavaStubElementTypes.ENUM_CONSTANT : JavaStubElementTypes.FIELD);
        this.myName = name;
        this.myType = type2;
        this.myInitializer = initializer;
        this.myFlags = flags;
    }

    @Override
    @NotNull
    public TypeInfo getType(boolean doResolve) {
        TypeInfo typeInfo = doResolve ? this.myType.applyAnnotations(this) : this.myType;
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiFieldStubImpl", "getType"));
        }
        return typeInfo;
    }

    @Override
    public String getInitializerText() {
        return StringRef.toString(this.myInitializer);
    }

    public byte getFlags() {
        return this.myFlags;
    }

    @Override
    public boolean isEnumConstant() {
        return PsiFieldStubImpl.isEnumConst(this.myFlags);
    }

    private static boolean isEnumConst(byte flags) {
        return (flags & 1) != 0;
    }

    @Override
    public boolean isDeprecated() {
        return (this.myFlags & 2) != 0;
    }

    @Override
    public boolean hasDeprecatedAnnotation() {
        return (this.myFlags & 4) != 0;
    }

    @Override
    public boolean hasDocComment() {
        return (this.myFlags & 8) != 0;
    }

    @Override
    public String getName() {
        return StringRef.toString(this.myName);
    }

    public static byte packFlags(boolean isEnumConst, boolean isDeprecated, boolean hasDeprecatedAnnotation, boolean hasDocComment) {
        byte flags = 0;
        if (isEnumConst) {
            flags = (byte)(flags | 1);
        }
        if (isDeprecated) {
            flags = (byte)(flags | 2);
        }
        if (hasDeprecatedAnnotation) {
            flags = (byte)(flags | 4);
        }
        if (hasDocComment) {
            flags = (byte)(flags | 8);
        }
        return flags;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiFieldStub[");
        if (this.isDeprecated() || this.hasDeprecatedAnnotation()) {
            builder.append("deprecated ");
        }
        if (this.isEnumConstant()) {
            builder.append("enumconst ");
        }
        builder.append(this.myName).append(':').append(this.myType);
        if (this.myInitializer != null) {
            builder.append('=').append(this.myInitializer);
        }
        builder.append("]");
        return builder.toString();
    }
}

