/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DirElementInfo
extends SmartPointerElementInfo {
    private final VirtualFile myVirtualFile;
    private final Project myProject;

    public DirElementInfo(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/psi/impl/smartPointers/DirElementInfo", "<init>"));
        }
        this.myProject = directory.getProject();
        this.myVirtualFile = directory.getVirtualFile();
    }

    @Override
    public PsiElement restoreElement() {
        return SelfElementInfo.restoreDirectoryFromVirtual(this.myVirtualFile, this.myProject);
    }

    @Override
    public PsiFile restoreFile() {
        return null;
    }

    @Override
    public int elementHashCode() {
        return this.myVirtualFile.hashCode();
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/smartPointers/DirElementInfo", "pointsToTheSameElementAs"));
        }
        if (other instanceof DirElementInfo) {
            return Comparing.equal(this.myVirtualFile, ((DirElementInfo)other).myVirtualFile);
        }
        return Comparing.equal(this.restoreElement(), other.restoreElement());
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Override
    public Segment getRange() {
        return null;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/DirElementInfo", "getProject"));
        }
        return project;
    }

    @Override
    @Nullable
    public Segment getPsiRange() {
        return null;
    }
}

